/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ReconciliactionOrgType;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationToleranceSettingFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ReconciliationToleranceSettingFilterUI
extends AbstractReconciliationToleranceSettingFilterUI {
    private static final long serialVersionUID = 1261039127182099278L;
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationToleranceSettingFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCombOrgType();
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.initCombItemType(selectAll);
        this.initCombElimType(selectAll);
        this.initToleranceType(selectAll);
    }

    private void initCombOrgType() {
        this.combOrgType.addItems(ReconciliactionOrgType.getEnumList().toArray());
    }

    private void initCombItemType(String selectAll) {
        this.combItemType.addItem((Object)selectAll);
        this.combItemType.addItems(ItemTypeEnum.getEnumList().toArray());
        this.combItemType.addItem((Object)"");
    }

    private void initCombElimType(String selectAll) {
        this.combElimType.addItem((Object)selectAll);
        this.combElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.combElimType.addItem((Object)ElimTypeEnum.exchange);
        this.combElimType.addItem((Object)"");
    }

    private void initToleranceType(String selectAll) {
        this.combToleranceDefine.addItem((Object)selectAll);
        this.combToleranceDefine.addItems(ToleranceTypeEnum.getEnumList().toArray());
    }

    public FilterInfo getFilterInfo() {
        int toleranceDefineIndex;
        int elimTypeIndex;
        int itemTypeIndex;
        String mappingNumber;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        String orgName = this.txtOrgName.getText();
        if (!StringUtils.isEmpty((String)orgName)) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.name", (Object)("%" + orgName + "%"), CompareType.LIKE));
            ++formulaIndex;
        }
        if (!StringUtils.isEmpty((String)(mappingNumber = this.txtMappingNumber.getText()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.number", (Object)("%" + mappingNumber + "%"), CompareType.LIKE));
            ++formulaIndex;
        }
        if ((itemTypeIndex = this.combItemType.getSelectedIndex()) != 0) {
            if (itemTypeIndex == 1) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.itemType", (Object)0));
                ++formulaIndex;
            } else if (itemTypeIndex == 2) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.itemType", (Object)1));
                ++formulaIndex;
            } else {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.itemType", null));
                ++formulaIndex;
            }
        }
        if ((elimTypeIndex = this.combElimType.getSelectedIndex()) != 0) {
            if (elimTypeIndex == 1) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.elimType", (Object)1));
                ++formulaIndex;
            } else if (elimTypeIndex == 2) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.elimType", (Object)3));
                ++formulaIndex;
            } else {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("accountMap.elimType", null));
                ++formulaIndex;
            }
        }
        if ((toleranceDefineIndex = this.combToleranceDefine.getSelectedIndex()) != 0) {
            if (toleranceDefineIndex == 1) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("toleranceType", (Object)0));
                ++formulaIndex;
            } else {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("toleranceType", (Object)1));
                ++formulaIndex;
            }
        }
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#0)");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        FilterItemCollection filterItems = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItems.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit.name")) {
                String orgName = (String)filterItemInfo.getCompareValue();
                this.txtOrgName.setText(orgName);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("accountMap.number")) {
                String mappingNumber = (String)filterItemInfo.getCompareValue();
                this.txtMappingNumber.setText(mappingNumber);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("accountMap.itemType")) {
                if (filterItemInfo.getCompareValue() == null) {
                    this.combItemType.setSelectedIndex(3);
                    continue;
                }
                if (filterItemInfo.getCompareValue() instanceof Integer) {
                    int itemType = (Integer)filterItemInfo.getCompareValue();
                    if (itemType == 0) {
                        this.combItemType.setSelectedIndex(1);
                        continue;
                    }
                    this.combItemType.setSelectedIndex(2);
                    continue;
                }
                this.combItemType.setSelectedIndex(0);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("accountMap.elimType")) {
                if (filterItemInfo.getCompareValue() == null) {
                    this.combElimType.setSelectedIndex(3);
                    continue;
                }
                if (filterItemInfo.getCompareValue() instanceof Integer) {
                    int elimType = (Integer)filterItemInfo.getCompareValue();
                    if (1 == elimType) {
                        this.combElimType.setSelectedIndex(1);
                        continue;
                    }
                    this.combElimType.setSelectedIndex(2);
                    continue;
                }
                this.combElimType.setSelectedIndex(0);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("toleranceType")) continue;
            int toleranceType = (Integer)filterItemInfo.getCompareValue();
            if (0 == toleranceType) {
                this.combToleranceDefine.setSelectedIndex(0);
                continue;
            }
            this.combToleranceDefine.setSelectedIndex(1);
        }
    }

    public void clear() {
        super.clear();
        this.txtOrgName.setText(null);
        this.txtMappingNumber.setText(null);
        this.combItemType.setSelectedIndex(0);
        this.combElimType.setSelectedIndex(0);
        this.combToleranceDefine.setSelectedIndex(0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

