/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractRowColChangeGuideUI;
import com.kingdee.eas.fi.newrpt.client.util.RowColChangeBasePoint;
import com.kingdee.eas.fi.newrpt.client.util.RowColChangeUtils;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RowColChangeGuideUI
extends AbstractRowColChangeGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(RowColChangeGuideUI.class);
    private boolean isCancel = false;
    private Book book = null;
    private Cell activeCell = null;
    private Cell basePointCell = null;

    public void onLoad() throws Exception {
        RowColChangeBasePoint pointInfo;
        super.onLoad();
        this.book = (Book)this.getUIContext().get("KEY_BOOK");
        this.basePointCell = RowColChangeUtils.getBasePoint(this.book.getActiveSheet());
        this.initSheets();
        if (this.basePointCell != null && (pointInfo = RowColChangeUtils.getPointInfo(this.basePointCell)) != null) {
            this.initThisUI(pointInfo);
        }
        this.setEnable(!OprtState.VIEW.equals(this.getOprtState()));
    }

    private void setEnable(boolean isEnable) {
        this.kDSheets.setEnabled(isEnable);
        this.kDBasePoint.setEnabled(isEnable);
        this.kDCol.setEnabled(isEnable);
        this.kDRptItemCol.setEnabled(isEnable);
        this.kDdataElementCol.setEnabled(isEnable);
        this.kDCompanyCol.setEnabled(isEnable);
        this.kDOwnCompany.setEnabled(isEnable);
        this.kDDyItemCol.setEnabled(isEnable);
        this.kDConfirm.setEnabled(isEnable);
        this.kDCancel.setEnabled(isEnable);
    }

    protected void initThisUI(RowColChangeBasePoint pointInfo) throws Exception {
        this.kDSheets.setSelectedItem((Object)pointInfo.getSrcSheetName());
        this.kDBasePoint.setSelectedIndex(pointInfo.getSrcBasePoint());
        this.kDCol.setText(pointInfo.getSrcChangeCols());
        this.kDRptItemCol.setText(pointInfo.getItemCol());
        this.kDdataElementCol.setText(pointInfo.getDataElementCol());
        this.kDCompanyCol.setText(pointInfo.getDirectCompanyCol());
        this.kDOwnCompany.setText(pointInfo.getOwnCompanyCol());
        this.kDDyItemCol.setText(pointInfo.getDyCompanyCol());
    }

    protected void initSheets() throws Exception {
        if (this.kDSheets.getItemCount() <= 0) {
            this.kDSheets.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        try {
                            String sheetName = (String)RowColChangeGuideUI.this.kDSheets.getSelectedItem();
                            Sheet sheet = RowColChangeGuideUI.this.book.getSheetByName(sheetName);
                            ArrayList points = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                            RowColChangeGuideUI.this.kDBasePoint.removeAllItems();
                            for (Object curPoint : points) {
                                String cellName = sheet.getCell(((Point)curPoint).y, ((Point)curPoint).x, true).getName(false, false);
                                RowColChangeGuideUI.this.kDBasePoint.addItem((Object)cellName);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"", (Throwable)ex);
                            RowColChangeGuideUI.this.handUIException(ex);
                        }
                    }
                }
            });
            for (int i = 0; i < this.book.getSheetCount(); ++i) {
                this.kDSheets.addItem((Object)this.book.getSheetName(i));
            }
            this.kDSheets.setSelectedIndex(0);
        }
    }

    public boolean check() throws Exception {
        Object sheetName = this.kDSheets.getSelectedItem();
        if (this.kDSheets.getSelectedIndex() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_fromSheet", null));
            return false;
        }
        if (this.kDBasePoint.getSelectedIndex() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_fromBasePoint", null));
            return false;
        }
        String cols = this.kDCol.getText();
        if (StringUtils.isEmpty((CharSequence)cols)) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_rptItemCol", null));
            return false;
        }
        String[] cells = cols.split(";");
        Sheet sheet = this.book.getSheetByName((String)sheetName);
        for (String cell : cells) {
            if (this.isCell(sheet, cell, this.kDLabelContainer1)) continue;
            return false;
        }
        Sheet activeSheet = this.book.getActiveSheet();
        this.activeCell = activeSheet.getCell(activeSheet.getActiveRow(), activeSheet.getActiveCol(), true);
        String rptCol = this.kDRptItemCol.getText();
        if (StringUtils.isEmpty((CharSequence)rptCol)) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_toItemCol", null));
            return false;
        }
        if (!this.isCell(activeSheet, rptCol, this.kDLabelContainer5)) {
            return false;
        }
        HashSet<Integer> checkCols = new HashSet<Integer>();
        int count = 0;
        checkCols.add(activeSheet.getRange(rptCol).getBlock(0).getCol());
        ++count;
        String dataElementCol = this.kDdataElementCol.getText();
        if (StringUtils.isEmpty((CharSequence)dataElementCol)) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_toDataElementCol", null));
            return false;
        }
        if (!this.isCell(activeSheet, dataElementCol, this.kDLabelContainer6)) {
            return false;
        }
        checkCols.add(activeSheet.getRange(dataElementCol).getBlock(0).getCol());
        ++count;
        if (!StringUtils.isEmpty((CharSequence)this.kDCompanyCol.getText())) {
            if (!this.isCell(activeSheet, this.kDCompanyCol.getText(), this.kDLabelContainer4)) {
                return false;
            }
            checkCols.add(activeSheet.getRange(this.kDCompanyCol.getText()).getBlock(0).getCol());
            ++count;
        }
        if (!StringUtils.isEmpty((CharSequence)this.kDOwnCompany.getText())) {
            if (!this.isCell(activeSheet, this.kDOwnCompany.getText(), this.kDLabelContainer7)) {
                return false;
            }
            checkCols.add(activeSheet.getRange(this.kDOwnCompany.getText()).getBlock(0).getCol());
            ++count;
        }
        if (!StringUtils.isEmpty((CharSequence)this.kDDyItemCol.getText())) {
            if (!this.isCell(activeSheet, this.kDDyItemCol.getText(), this.kDLabelContainer8)) {
                return false;
            }
            checkCols.add(activeSheet.getRange(this.kDDyItemCol.getText()).getBlock(0).getCol());
            ++count;
        }
        if (checkCols.size() < count) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_colIsDub", null));
            return false;
        }
        int basePointCol = -1;
        basePointCol = this.basePointCell == null ? activeSheet.getActiveCol() : this.basePointCell.getCol();
        Iterator iterator = checkCols.iterator();
        while (iterator.hasNext()) {
            int col = (Integer)iterator.next();
            if (basePointCol <= col) continue;
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "rowcolChange_colIsNotRange", null));
            return false;
        }
        return true;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.check()) {
            return;
        }
        Object sheetName = this.kDSheets.getSelectedItem();
        Sheet activeSheet = this.book.getActiveSheet();
        String cols = this.kDCol.getText();
        String rptCol = this.kDRptItemCol.getText();
        String dataElementCol = this.kDdataElementCol.getText();
        this.clearOld(activeSheet);
        RowColChangeBasePoint basePoint = new RowColChangeBasePoint();
        basePoint.setSrcSheetName((String)sheetName);
        basePoint.setSrcBasePoint(this.kDBasePoint.getSelectedIndex());
        basePoint.setSrcChangeCols(cols);
        basePoint.setItemCol(rptCol);
        basePoint.setDataElementCol(dataElementCol);
        basePoint.setDirectCompanyCol(this.kDCompanyCol.getText());
        basePoint.setOwnCompanyCol(this.kDOwnCompany.getText());
        basePoint.setDyCompanyCol(this.kDDyItemCol.getText());
        if (this.basePointCell == null) {
            this.basePointCell = this.activeCell;
        }
        UserObjectHelper.getUnprotectedRange((Range)activeSheet.getRange(this.basePointCell)).setUserObject("rowColChangePoint", (Object)basePoint.toSerialString());
        int activeRow = this.basePointCell.getRow();
        if (!StringUtils.isEmpty((CharSequence)rptCol)) {
            Cell rptItemCell = activeSheet.getCell(activeRow, activeSheet.getRange(rptCol).getBlock(0).getCol(), true);
            rptItemCell.setUserObject("rowColChangeItem", (Object)"1");
            rptItemCell.setValue(new Variant((Object)this.kDLabelContainer5.getBoundLabelText().substring(0, this.kDLabelContainer5.getBoundLabelText().length() - 1)));
        }
        if (!StringUtils.isEmpty((CharSequence)dataElementCol)) {
            Cell dataElementCell = activeSheet.getCell(activeRow, activeSheet.getRange(dataElementCol).getBlock(0).getCol(), true);
            dataElementCell.setUserObject("rowColDataElement", (Object)"1");
            dataElementCell.setValue(new Variant((Object)this.kDLabelContainer6.getBoundLabelText().substring(0, this.kDLabelContainer6.getBoundLabelText().length() - 1)));
        }
        if (!StringUtils.isEmpty((CharSequence)basePoint.getDirectCompanyCol())) {
            Cell directCompanyCell = activeSheet.getCell(activeRow, activeSheet.getRange(basePoint.getDirectCompanyCol()).getBlock(0).getCol(), true);
            directCompanyCell.setUserObject("rowColDirectCompany", (Object)"1");
            directCompanyCell.setValue(new Variant((Object)this.kDLabelContainer4.getBoundLabelText().substring(0, this.kDLabelContainer4.getBoundLabelText().length() - 1)));
        }
        if (!StringUtils.isEmpty((CharSequence)basePoint.getOwnCompanyCol())) {
            Cell ownCompanyCell = activeSheet.getCell(activeRow, activeSheet.getRange(basePoint.getOwnCompanyCol()).getBlock(0).getCol(), true);
            ownCompanyCell.setUserObject("rowColOwnCompany", (Object)"1");
            ownCompanyCell.setValue(new Variant((Object)this.kDLabelContainer7.getBoundLabelText().substring(0, this.kDLabelContainer7.getBoundLabelText().length() - 1)));
        }
        if (!StringUtils.isEmpty((CharSequence)basePoint.getDyCompanyCol())) {
            Cell dyCompanyCell = activeSheet.getCell(activeRow, activeSheet.getRange(basePoint.getDyCompanyCol()).getBlock(0).getCol(), true);
            dyCompanyCell.setUserObject("rowColDyCompany", (Object)"1");
            dyCompanyCell.setValue(new Variant((Object)this.kDLabelContainer8.getBoundLabelText().substring(0, this.kDLabelContainer8.getBoundLabelText().length() - 1)));
        }
        activeSheet.setUserObject("isRowColChangeSheet", (Object)"1");
        super.destroyWindow();
    }

    public void clearOld(Sheet sheet) {
        if (this.basePointCell != null) {
            sheet.getRange(this.basePointCell.getRow(), sheet.getMaxRowIndex(), this.basePointCell.getCol(), sheet.getMaxColIndex()).clear(true, true, true, new String[]{"rowColChangePoint", "rowColChangeItem", "rowColDataElement", "rowColDirectCompany", "rowColOwnCompany", "rowColDyCompany"});
        }
    }

    public boolean isCell(Sheet sheet, String cellName, KDLabelContainer colContainer) {
        Range range = null;
        try {
            range = sheet.getRange(cellName);
        }
        catch (Exception ex) {
            range = null;
        }
        if (range == null) {
            MsgBox.showInfo((Component)((Object)this), (String)(colContainer.getBoundLabelText() + AccountCheckUtil.getResourceString(null, "rowcolChange_SetError", null)));
            return false;
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionCancel_actionPerformed(e);
            super.destroyWindow();
        }
        finally {
            this.isCancel = true;
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

