/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractSelectCheckageCompanyUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SelectCheckageCompanyUI
extends AbstractSelectCheckageCompanyUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectCheckageCompanyUI.class);
    protected Set<String> selectCompanyIds = new HashSet<String>();
    protected String[] fields = new String[]{"company.number", "company.name", "contect", "cell", "email", "contect2", "cell2", "email2", "id"};
    protected boolean isCancle = false;
    protected List<String[]> selects = new ArrayList<String[]>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadCompanyTableDatas();
        this.initOrgTreeF7();
        this.kdSelectedOrgUnitTable.checkParsed();
        this.kdOrgUnitTable.setEditable(false);
        this.kdSelectedOrgUnitTable.setEditable(false);
        this.kdOrgUnitTable.getSelectManager().setSelectMode(10);
        this.kdSelectedOrgUnitTable.getSelectManager().setSelectMode(10);
        this.kdOrgUnitTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() == 2 && e.getButton() == 1 && e.getType() != 0) {
                        SelectCheckageCompanyUI.this.actionAdd_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    SelectCheckageCompanyUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initOrgTreeF7() throws EASBizException, BOSException {
        this.kdOrgTreeF7.setValue(null);
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        FilterInfo treeFilter = new FilterInfo();
        HashSet<Integer> values = new HashSet<Integer>();
        values.add(1);
        values.add(6);
        treeFilter.getFilterItems().add(new FilterItemInfo("layerType", values, CompareType.INCLUDE));
        f7.setTreeFilter(treeFilter);
        this.kdOrgTreeF7.setSelector((KDPromptSelector)f7);
        this.kdOrgTreeF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SelectCheckageCompanyUI.this.loadCompanyTableDatas();
                }
                catch (Exception exc) {
                    logger.error((Object)"", (Throwable)exc);
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
    }

    public void copyRow(IRow srcRow, IRow tarRow) throws Exception {
        for (String field : this.fields) {
            tarRow.getCell(field).setValue(srcRow.getCell(field).getValue());
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdOrgUnitTable);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                IRow row = this.kdOrgUnitTable.getRow(selectRow);
                String id = row.getCell("id").getValue().toString();
                if (this.selectCompanyIds.contains(id)) continue;
                this.copyRow(row, this.kdSelectedOrgUnitTable.addRow());
                this.selectCompanyIds.add(id);
            }
            this.refresh();
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdSelectedOrgUnitTable);
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                String id = this.kdSelectedOrgUnitTable.getRow(selectRows[i]).getCell("id").getValue().toString();
                this.selectCompanyIds.remove(id);
                this.kdSelectedOrgUnitTable.removeRow(selectRows[i]);
            }
            this.refresh();
        }
    }

    @Override
    public void actionAllAdd_actionPerformed(ActionEvent e) throws Exception {
        this.kdSelectedOrgUnitTable.removeRows();
        for (int i = 0; i < this.kdOrgUnitTable.getRowCount(); ++i) {
            IRow srcRow = this.kdOrgUnitTable.getRow(i);
            IRow tarRow = this.kdSelectedOrgUnitTable.addRow();
            this.copyRow(srcRow, tarRow);
            this.selectCompanyIds.add(srcRow.getCell("id").getValue().toString());
        }
        this.refresh();
    }

    @Override
    public void actionAllRemove_actionPerformed(ActionEvent e) throws Exception {
        this.selectCompanyIds.clear();
        this.kdSelectedOrgUnitTable.removeRows();
        this.refresh();
    }

    public void refresh() throws Exception {
        this.kdSelectedOrgUnitTable.setRefresh(true);
        this.kdSelectedOrgUnitTable.reLayoutAndPaint();
    }

    @Override
    public void actionConfrim_actionPerformed(ActionEvent e) throws Exception {
        this.isCancle = false;
        this.selects.clear();
        for (int i = 0; i < this.kdSelectedOrgUnitTable.getRowCount(); ++i) {
            IRow row = this.kdSelectedOrgUnitTable.getRow(i);
            this.selects.add(new String[]{row.getCell("id").getValue().toString(), row.getCell("company.number").getValue().toString(), row.getCell("company.name").getValue().toString()});
        }
        super.disposeUIWindow();
    }

    @Override
    public void actionCancle_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
        this.isCancle = true;
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        this.isCancle = true;
    }

    @Override
    public void actionLocal_actionPerformed(ActionEvent e) throws Exception {
        String text = this.kdLocalWord.getText();
        if (!StringUtils.isEmpty((CharSequence)text)) {
            int i;
            int index = this.kdLocalType.getSelectedIndex();
            String field = index == 0 ? "company.number" : "company.name";
            int rowCount = this.kdOrgUnitTable.getRowCount();
            int colCount = this.kdOrgUnitTable.getColumnCount();
            int startRow = this.kdOrgUnitTable.getSelectManager().getActiveRowIndex();
            startRow = startRow < 0 ? 0 : ++startRow;
            for (i = startRow; i < rowCount; ++i) {
                if (!this.isFind(i, colCount, field, text)) continue;
                return;
            }
            for (i = 0; i < startRow - 1; ++i) {
                if (!this.isFind(i, colCount, field, text)) continue;
                return;
            }
        }
    }

    protected boolean isFind(int rowIndex, int colCount, String field, String text) throws Exception {
        Object cellValue = this.kdOrgUnitTable.getRow(rowIndex).getCell(field).getValue();
        if (cellValue != null && cellValue.toString().indexOf(text) >= 0) {
            this.kdOrgUnitTable.getSelectManager().select(rowIndex, 0, rowIndex, colCount - 1);
            this.kdOrgUnitTable.scrollToVisible(rowIndex, 0);
            return true;
        }
        return false;
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public List<String[]> getSelectData() {
        return this.selects;
    }

    public void loadCompanyTableDatas() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("company.number");
        view.getSelector().add("company.name");
        view.getSelector().add("contect");
        view.getSelector().add("cell");
        view.getSelector().add("email");
        view.getSelector().add("contect2");
        view.getSelector().add("cell2");
        view.getSelector().add("email2");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        OrgTreeInfo selectOrgTree = (OrgTreeInfo)this.kdOrgTreeF7.getValue();
        if (selectOrgTree != null && selectOrgTree.getId() != null) {
            filter.mergeFilter(new FilterInfo("company.id in(select funitid FROM t_org_structure where ftreeid='" + selectOrgTree.getId().toString() + "')"), "and");
        }
        view.getSorter().add(new SorterItemInfo("company.number"));
        CheckageCompanyCollection coll = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        this.kdOrgUnitTable.checkParsed();
        this.kdOrgUnitTable.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            CheckageCompanyInfo info = coll.get(i);
            IRow row = this.kdOrgUnitTable.setRow(i);
            row.getCell("company.number").setValue((Object)info.getCompany().getNumber());
            row.getCell("company.name").setValue((Object)info.getCompany().getName());
            row.getCell("contect").setValue((Object)info.getContect());
            row.getCell("cell").setValue((Object)info.getCell());
            row.getCell("email").setValue((Object)info.getEmail());
            row.getCell("contect2").setValue((Object)info.getContect2());
            row.getCell("cell2").setValue((Object)info.getCell2());
            row.getCell("email2").setValue((Object)info.getEmail2());
            row.getCell("id").setValue((Object)info.getId().toString());
        }
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuBar.setVisible(false);
    }
}

