/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.check.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IHisCslReport;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.InterAndExchDiffHandleUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataCatcherListener;
import com.kingdee.eas.fi.gr.dynamic.client.GroupMultiRptProcessUI;
import com.kingdee.eas.fi.newrpt.check.BalanceDetailData;
import com.kingdee.eas.fi.newrpt.check.BalanceDetailFacadeFactory;
import com.kingdee.eas.fi.newrpt.check.IBalanceDetailFacade;
import com.kingdee.eas.fi.newrpt.check.client.AbstractBalanceDetailUI;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public class BalanceDetailUI
extends AbstractBalanceDetailUI
implements ICSLContextUI,
DataCatcherListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BalanceDetailUI.class);
    private static final int TEMPLATENAME = 0;
    private static final int TEMPLATENUM = 1;
    private static final int ITEMNUMBER = 2;
    private static final int ITEMNAME = 3;
    private static final int ROWCOMPANY = 4;
    private static final int COLCOMPANY = 5;
    private static final int DETAIL = 6;
    private static final int ELIMENTRYNUM = 7;
    private static final int REPORTID = 8;
    private static final int ELIMENTRYID = 9;
    private static final int CHECKAGEDATAID = 10;
    public final String RESOURCE_PATH = "com.kingdee.eas.fi.newrpt.check.CheckMatrixResource";
    private ICSLContext ctx = null;
    private int year = -1;
    private int period = -1;
    private int periodType = 3;
    private OrgTreeInfo orgTree = null;
    private OrgUnitInfo orgUnit = null;
    private OrgUnitInfo rowCompany = null;
    private OrgUnitInfo colCompany = null;
    private boolean isAdjustBefore = false;
    private List<String> tempIds = null;
    private IBalanceDetailFacade facade = BalanceDetailFacadeFactory.getRemoteInstance();
    private ElimTypeEnum matrixType = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().containsKey("cslCtx")) {
            this.ctx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"context_is_null"));
            SysUtil.abort();
        }
        this.year = this.ctx.getCurRptYear();
        this.period = this.ctx.getCurRptPeriod();
        this.orgTree = this.ctx.getCurOrgBound();
        this.orgUnit = this.ctx.getCurOrgGroup();
        this.rowCompany = (OrgUnitInfo)this.getUIContext().get("rowCompany");
        this.colCompany = (OrgUnitInfo)this.getUIContext().get("colCompany");
        this.isAdjustBefore = (Boolean)this.getUIContext().get("isAdjustBefore");
        this.matrixType = (ElimTypeEnum)this.getUIContext().get("matrixType");
        this.tempIds = (List)this.getUIContext().get("tempIds");
        Object[] headtitle = new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"template_name"), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"template_codes"), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"item_number"), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"item_name"), this.rowCompany, this.colCompany, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"detail_value"), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"Elimentry"), "reportid", "elimentryid", "checkageDataId"};
        this.setComponentValue();
        this.fillHeader(headtitle);
        this.fillData();
        this.getStatusBar().setVisible(false);
        this.getUIMenuBar().setVisible(false);
        this.getUIToolBar().setVisible(false);
    }

    private void fillData() throws BOSException {
        Map<String, Object> param = this.getDataCondition();
        Map result = this.facade.getBalanceDetail(param);
        List tempnumList = null;
        HashSet<String> checkageDataList = null;
        String elimEntId = null;
        List dataList = null;
        BigDecimal ZERO = new BigDecimal(0);
        BalanceDetailData data = null;
        String tempNum = null;
        int n = 0;
        if (result != null) {
            tempnumList = (List)result.get("templatenum");
            int sumtemp = tempnumList.size();
            BigDecimal sourceMoney = ZERO;
            BigDecimal targetMoney = ZERO;
            for (int j = 0; j < sumtemp; ++j) {
                int meger = 0;
                tempNum = (String)tempnumList.get(j);
                dataList = (List)result.get(tempNum);
                int size = dataList.size();
                this.kDTDetail.addRows(size + 1);
                checkageDataList = new HashSet<String>();
                meger = n;
                for (int t = 0; t < dataList.size(); ++t) {
                    data = (BalanceDetailData)dataList.get(t);
                    this.kDTDetail.getRow(n).getCell(0).setValue((Object)data.getTempletName());
                    this.kDTDetail.getRow(n).getCell(1).setValue((Object)data.getTempletNum());
                    this.kDTDetail.getRow(n).getCell(2).setValue((Object)data.getItemNum());
                    this.kDTDetail.getRow(n).getCell(3).setValue((Object)data.getItemName());
                    if ("positive".equals(data.getAmountType())) {
                        sourceMoney = sourceMoney.add(data.getItemMoney());
                        this.kDTDetail.getRow(n).getCell(4).setValue((Object)data.getItemMoney());
                        this.kDTDetail.getRow(n).getCell(5).setValue(null);
                        this.kDTDetail.getCell(n, 4).getStyleAttributes().setFontColor(Color.blue);
                    }
                    if ("opposite".equals(data.getAmountType())) {
                        this.kDTDetail.getRow(n).getCell(4).setValue(null);
                        targetMoney = targetMoney.add(data.getItemMoney());
                        this.kDTDetail.getRow(n).getCell(5).setValue((Object)data.getItemMoney());
                        this.kDTDetail.getCell(n, 5).getStyleAttributes().setFontColor(Color.blue);
                    }
                    this.kDTDetail.getRow(n).getCell(6).setValue(null);
                    this.kDTDetail.getRow(n).getCell(7).setValue((Object)data.getEleEntryNum());
                    this.kDTDetail.getRow(n).getCell(8).setValue((Object)data.getReportId());
                    if (data.getEleEntryId() != null) {
                        elimEntId = data.getEleEntryId();
                    }
                    if (data.getCheckageDataId() != null) {
                        checkageDataList.add(data.getCheckageDataId());
                    }
                    ++n;
                }
                this.kDTDetail.getRow(n).getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"subtotal"));
                this.kDTDetail.getRow(n).getCell(4).setValue((Object)sourceMoney);
                this.kDTDetail.getRow(n).getCell(5).setValue((Object)targetMoney);
                this.kDTDetail.getRow(n).getCell(6).setValue((Object)sourceMoney.add(targetMoney));
                this.kDTDetail.getRow(n).getCell(10).setValue(checkageDataList);
                this.kDTDetail.getRow(n).getCell(9).setValue(elimEntId);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 0, n - 1, 0, 4);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 1, n - 1, 1, 4);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 6, n, 6, 4);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 7, n, 7, 4);
                this.kDTDetail.getCell(n, 7).getStyleAttributes().setBackground(Color.blue);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 9, n, 9, 4);
                this.kDTDetail.getMergeManager().mergeBlock(meger, 10, n, 10, 4);
                this.kDTDetail.getRow(n).getStyleAttributes().setBackground(Color.YELLOW);
                this.kDTDetail.getMergeManager().getMergeBlockOfCell(n, 6);
                sourceMoney = ZERO;
                targetMoney = ZERO;
                ++n;
            }
            this.setTableAttr();
        }
    }

    private void setTableAttr() {
        this.kDTDetail.setEditable(false);
        this.kDTDetail.getColumn(4).getStyleAttributes().setNumberFormat("#,##0.00");
        this.kDTDetail.getColumn(5).getStyleAttributes().setNumberFormat("#,##0.00");
        this.kDTDetail.getColumn(6).getStyleAttributes().setNumberFormat("#,##0.00");
        this.kDTDetail.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTDetail.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTDetail.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTDetail.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.kDTDetail.getColumn(6).getStyleAttributes().setFontColor(Color.blue);
        this.kDTDetail.getColumn(7).getStyleAttributes().setFontColor(Color.blue);
        this.kDTDetail.getColumn(8).getStyleAttributes().setHided(true);
        this.kDTDetail.getColumn(9).getStyleAttributes().setHided(true);
        this.kDTDetail.getColumn(10).getStyleAttributes().setHided(true);
    }

    private Map<String, Object> getDataCondition() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rowCompany", this.rowCompany);
        param.put("colCompany", this.colCompany);
        param.put("year", this.year);
        param.put("period", this.period);
        param.put("orgTree", this.orgTree);
        param.put("orgUnit", this.orgUnit);
        param.put("periodType", this.periodType);
        param.put("matrixType", this.matrixType);
        param.put("tempIds", this.tempIds);
        param.put("isQueryHisBudget", Boolean.FALSE);
        param.put("isAdjustBefore", this.isAdjustBefore);
        return param;
    }

    private void fillHeader(Object[] headtitle) {
        int size = headtitle.length;
        this.kDTDetail.addColumns(size);
        IRow headRow = this.kDTDetail.addHeadRow();
        for (int i = 0; i < size; ++i) {
            headRow.getCell(i).setValue(headtitle[i]);
        }
        this.kDTDetail.getColumn(4).setWidth(110);
        this.kDTDetail.getColumn(5).setWidth(110);
    }

    private void setComponentValue() throws BOSException {
        this.orgTreeText.setText(this.orgTree.getName());
        if (this.orgUnit != null) {
            this.orgUnitBox.addItem((Object)this.orgUnit);
        }
        CslRptClientHelperUI.setCruYearAndPeriod((ICSLContext)this.ctx, (KDSpinner)this.yearSpinner, (KDSpinner)this.periodSpinner);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void update(Observable o, Object arg) {
        CSLContextHelper.update((Observable)o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject((ICSLContextUI)this);
        super.disposeUIWindow();
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        int rowIndex;
        if (e.getClickCount() == 2 && e.getType() != 0 && this.kDTDetail.getCell(rowIndex = this.kDTDetail.getSelectManager().getActiveRowIndex(), colIndex = this.kDTDetail.getSelectManager().getActiveColumnIndex()).getValue() != null) {
            ArrayList arr;
            if (colIndex == 6 && this.kDTDetail.getCell(rowIndex, 10).getValue() != null && (arr = new ArrayList((Collection)this.kDTDetail.getCell(rowIndex, 10).getValue())).size() != 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"myID", arr);
                uiContext.put((Object)"ID", arr);
                uiContext.put((Object)"param", this.getDataCondition());
                uiContext.put((Object)"idList", arr);
                uiContext.put((Object)"isByCompany", (Object)Boolean.FALSE);
                String precisionTemp = this.kDTDetail.getCell(rowIndex, colIndex).getValue().toString();
                int calPrecision = precisionTemp.substring(precisionTemp.indexOf(".") + 1).length();
                uiContext.put((Object)"currency.precision", (Object)calPrecision);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(InterAndExchDiffHandleUI.class.getName(), (Map)uiContext, null);
                uiWindow.show();
            }
            if (colIndex == 7) {
                String elimId = this.kDTDetail.getCell(rowIndex, 9).getValue().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("checkedStatus"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)elimId));
                EliminationInfo elimInfo = EliminationFactory.getRemoteInstance().getEliminationInfo((IObjectPK)pk, sic);
                if (elimInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                    this.openElimnation(OprtState.VIEW, elimId);
                } else {
                    this.openElimnation(OprtState.EDIT, elimId);
                }
            }
            if ((colIndex == 4 || colIndex == 5) && this.kDTDetail.getRowCount() != 0 && this.kDTDetail.getSelectManager().size() != 0) {
                this.checkSelected();
                String company = "";
                String selectId = this.getSelectedKeyValue();
                if (selectId == null || "".equals(selectId)) {
                    return;
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("sourceType"));
                CslReportInfo report = this.getReportInfo(selectId, sic);
                if (this.kDTDetail.getHeadRow(0).getCell(colIndex) != null && this.kDTDetail.getHeadRow(0).getCell(colIndex).getValue() != null) {
                    company = this.kDTDetail.getHeadRow(0).getCell(colIndex).getValue().toString();
                }
                if (report != null) {
                    this.openReport(OprtState.VIEW, company);
                }
            }
        }
    }

    private void openElimnation(String state, String elimId) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)elimId);
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"cslCtx", (Object)this.ctx);
        if (OprtState.VIEW.equals(state)) {
            uiContext.put((Object)"isEliminationViewListUI", (Object)Boolean.TRUE);
        }
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandEditUI", (Map)uiContext, null, state);
        window.show();
    }

    private void openReport(String state, String company) throws BOSException {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        StringBuffer UITitle = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceType"));
        Object report = null;
        try {
            report = this.ctx.isQueryBudget() ? this.getHisReportInfo(id, sic) : this.getReportInfo(id, sic);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        uiContext.put((Object)"cslArea", (Object)false);
        String processUI = null;
        if (report.getSourceType() == RptSrcTypeEnum.NORMAL || report.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || report.getSourceType() == RptSrcTypeEnum.COMMITREPORT) {
            processUI = GroupRptProcessUI.class.getName();
        } else if (report.getSourceType() == RptSrcTypeEnum.SUM || report.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT) {
            processUI = SumRptProcessUI.class.getName();
            uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        } else if (!this.ctx.isQueryBudget() && report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) {
            processUI = GroupMultiRptProcessUI.class.getName();
        } else {
            processUI = CslRptProcessUI.class.getName();
            uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        }
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, OprtState.VIEW);
            String uiTitle = "";
            if (window.getUIObject() != null && window.getUIObject().getUITitle() != null) {
                uiTitle = window.getUIObject().getUITitle();
            }
            window.getUIObject().setUITitle(UITitle.append(uiTitle).append("-").append(company).toString());
            window.show();
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    private String getSelectedKeyValue() {
        String reportId = null;
        int colIndex = this.kDTDetail.getSelectManager().getActiveColumnIndex();
        int rowIndex = this.kDTDetail.getSelectManager().getActiveRowIndex();
        if (colIndex != 4 && colIndex != 5) {
            return null;
        }
        String itemName = (String)this.kDTDetail.getRow(rowIndex).getCell(3).getValue();
        if (itemName == null || "".equals(itemName)) {
            return null;
        }
        Object obj = this.kDTDetail.getRow(rowIndex).getCell(colIndex).getValue();
        if (obj != null && (reportId = (String)this.kDTDetail.getRow(rowIndex).getCell(8).getValue()) != null && !"".equals(reportId)) {
            return reportId;
        }
        return null;
    }

    private void checkSelected() {
        if (this.kDTDetail.getRowCount() == 0 || this.kDTDetail.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (CSLContextHelper.getCSLContext().isQueryBudget()) {
            return HisCslReportFactory.getRemoteInstance();
        }
        return CslReportFactory.getRemoteInstance();
    }

    protected HisCslReportInfo getHisReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        IHisCslReport iReport = (IHisCslReport)this.getBizInterface();
        return (HisCslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void reloadCatchData(List container) {
    }
}

