/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.check.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.newrpt.check.CheckMatrixFacadeFactory;
import com.kingdee.eas.fi.newrpt.check.ICheckMatrixFacade;
import com.kingdee.eas.fi.newrpt.check.client.AbstractCheckMatrixUI;
import com.kingdee.eas.fi.newrpt.check.client.BalanceDetailUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CheckMatrixUI
extends AbstractCheckMatrixUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CheckMatrixUI.class);
    private static final int Asynchronous_Threshold = 100;
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    public final String RESOURCE_PATH = "com.kingdee.eas.fi.newrpt.check.CheckMatrixResource";
    private ICSLContext ctx = null;
    private int year = -1;
    private int period = -1;
    private int periodType = 3;
    private OrgTreeInfo orgTree = null;
    private OrgUnitInfo orgUnit = null;
    private Object[] companys = null;
    private ICheckMatrixFacade facade = CheckMatrixFacadeFactory.getRemoteInstance();
    protected boolean isInited = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().containsKey("cslCtx")) {
            this.ctx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"context_is_null"));
            SysUtil.abort();
        }
        this.year = this.ctx.getCurRptYear();
        this.period = this.ctx.getCurRptPeriod();
        this.orgTree = this.ctx.getCurOrgBound();
        this.orgUnit = this.ctx.getCurOrgGroup();
        this.periodType = this.ctx.getCurRptPeriodType().getValue();
        this.cmbMatrixType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.cmbMatrixType.addItem((Object)ElimTypeEnum.exchange);
        this.initControl();
        new Thread(){

            @Override
            public void run() {
                try {
                    CheckMatrixUI.this.query();
                }
                catch (Exception e) {
                    logger.error((Object)"getOrgTreeCollection error", (Throwable)e);
                }
                finally {
                    CheckMatrixUI.this.isInited = true;
                }
            }
        }.start();
    }

    protected void initControl() throws BOSException {
        this.txtOrgBound.setText(this.orgTree.getName());
        this.comboBoxCompany.addItem((Object)this.orgUnit);
        if (this.year > 0) {
            this.spCurYear.setValue((Object)new Integer(this.year));
        }
        if (this.period > 0) {
            this.spCurPeriod.setValue((Object)new Integer(this.period));
        }
        this.txtOrgBound.setEnabled(false);
        this.comboBoxCompany.setEnabled(false);
        this.spCurYear.setEnabled(false);
        this.spCurPeriod.setEnabled(false);
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1){

            public void show() {
                this.setSelectedOrgIds(CheckMatrixUI.this.getSetCompanyId());
                super.show();
            }
        };
        f7.setTreeID(this.orgTree.getId().toString());
        f7.setSelectedOrgIds(null);
        f7.setMultiSelect(true);
        this.pmptCompanys.setSelector((KDPromptSelector)f7);
        this.pmptCompanys.setEditable(false);
        this.pmptCompanys.setDisplayFormat("$name$");
        this.pmptTemplate.setQueryInfo("com.kingdee.eas.fi.newrpt.check.ElimTemplateF7Query");
        this.pmptTemplate.setEnabledMultiSelection(true);
        this.pmptTemplate.setDisplayFormat("$name$");
        this.pmptTemplate.setEditable(false);
        this.pmptTemplate.setEntityViewInfo(this.getElimTemplateView());
        this.cmbMatrixType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CheckMatrixUI.this.pmptCompanys.setValue(null);
                CheckMatrixUI.this.pmptTemplate.setValue(null);
                try {
                    CheckMatrixUI.this.pmptTemplate.setEntityViewInfo(CheckMatrixUI.this.getElimTemplateView());
                }
                catch (BOSException e1) {
                    CheckMatrixUI.this.handleException((Exception)((Object)e1));
                }
            }
        });
    }

    public Set getSetCompanyId() {
        HashSet<String> setCompanyId = null;
        OrgUnitInfo[] selected = (OrgUnitInfo[])this.pmptCompanys.getData();
        if (selected != null) {
            setCompanyId = new HashSet<String>();
            for (int i = 0; i < selected.length; ++i) {
                setCompanyId.add(selected[i].getId().toString());
            }
        }
        return setCompanyId;
    }

    public EntityViewInfo getElimTemplateView() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        if (this.cmbMatrixType.getSelectedItem().equals(ElimTypeEnum.ComeAndGo)) {
            sql.append("select a.Fid").append(" from t_csl_ElimTemplet a Inner join t_csl_templetdispense b on a.FelimGroupid = b.FdispenseSrcID");
            sql.append(" where b.FsourceType = ").append(2);
            sql.append(" and b.ForgBoundid = '").append(this.orgTree.getId().toString()).append("'");
            sql.append(" AND a.FCheckedStatus = ").append(2);
            sql.append(" and a.FelimType= ").append(1);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        } else {
            sql.append("select a.Fid").append(" from t_csl_ElimTemplet a Inner join t_csl_templetdispense b on a.FelimGroupid = b.FdispenseSrcID");
            sql.append(" where b.FsourceType = ").append(2);
            sql.append(" and b.ForgBoundid = '").append(this.orgTree.getId().toString()).append("'");
            sql.append(" AND a.FCheckedStatus = ").append(2);
            sql.append(" and a.FelimType= ").append(3);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        }
        view.setFilter(filter);
        return view;
    }

    protected void checkTableParsed() {
        this.tblSum.checkParsed();
        this.tblDif.checkParsed();
    }

    private void query() throws Exception {
        if (this.cmbMatrixType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.check.CheckMatrixResource", (String)"select_matrix_type"));
            SysUtil.abort();
        }
        this.companys = (Object[])this.pmptCompanys.getData();
        this.clearTable();
        Map result = this.facade.getCheckMatrix(this.getCheckMatrixParam(this.companys));
        if (result == null || ((Object[])result.get("companys")).length <= 0) {
            return;
        }
        this.fillColAndRow(this.tblSum, (Object[])result.get("companys"));
        this.fillColAndRow(this.tblDif, (Object[])result.get("companys"));
        this.fillData(this.tblSum, result);
        this.fillData(this.tblDif, result);
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        while (!this.isInited) {
            Thread.sleep(20L);
        }
        this.query();
    }

    private void fillColAndRow(KDTable table, Object[] companys) {
        int i;
        if (companys == null) {
            return;
        }
        int size = companys.length;
        table.getStyleAttributes().setLocked(true);
        table.addColumns(size + 1);
        IRow headRow = table.addHeadRow();
        headRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"92_CheckMatrixUI"));
        for (i = 0; i < size; ++i) {
            headRow.getCell(i + 1).setValue(companys[i]);
        }
        table.addRows(size);
        for (i = 0; i < size; ++i) {
            table.getCell(i, 0).setValue(companys[i]);
        }
        table.getViewManager().setFreezeView(0, 1);
        for (i = 0; i < size; ++i) {
            table.getColumn(i + 1).setWidth(110);
            table.getColumn(i + 1).getStyleAttributes().setNumberFormat("#,##0.00");
            table.getColumn(i + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getColumn(i + 1).getStyleAttributes().setFontColor(Color.blue);
        }
    }

    private void fillData(KDTable table, Map result) {
        if (result == null) {
            return;
        }
        Map data = null;
        if (table.getName().equals("tblSum")) {
            data = (Map)result.get("sumData");
        } else if (table.getName().equals("tblDif")) {
            data = (Map)result.get("difData");
        }
        Object[] companys = (Object[])result.get("companys");
        if (data == null || companys == null) {
            return;
        }
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            Object obj = table.getCell(r, 0).getValue();
            if (!(obj instanceof OrgUnitInfo)) continue;
            String id = ((OrgUnitInfo)obj).getId().toString();
            for (int c = 1; c < colCount; ++c) {
                obj = table.getCell(c - 1, 0).getValue();
                if (!(obj instanceof OrgUnitInfo)) continue;
                String tid = ((OrgUnitInfo)obj).getId().toString();
                if (tid.equals(id)) {
                    table.getCell(r, c).setValue((Object)"--");
                    continue;
                }
                String key = id + "_" + tid;
                if (data.get(key) != null) {
                    table.getCell(r, c).setValue(data.get(key));
                    continue;
                }
                table.getCell(r, c).setValue(null);
            }
        }
        PopupMenuManager mgr = this.getPopupMenuManager((JComponent)table);
        if (mgr != null) {
            mgr.removeMenuSection("table");
            mgr.removeMenuSection("edit");
        }
    }

    private void clearTable() {
        this.tblSum.removeRows();
        this.tblSum.removeColumns();
        this.tblDif.removeRows();
        this.tblDif.removeColumns();
    }

    private Map getCheckMatrixParam(Object[] companys) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("year", this.year);
        param.put("period", this.period);
        param.put("periodType", this.periodType);
        param.put("orgTree", this.orgTree);
        param.put("orgUnit", this.orgUnit);
        param.put("companys", companys);
        param.put("matrixType", this.cmbMatrixType.getSelectedItem());
        param.put("templates", this.pmptTemplate.getData());
        param.put("isAdjustBefore", this.kdAdjustBefore.isSelected());
        return param;
    }

    @Override
    protected void tblSum_tableClick(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            OrgUnitInfo colCompany;
            OrgUnitInfo rowCompany;
            int colIndex = this.tblSum.getSelectManager().getActiveColumnIndex();
            int rowIndex = this.tblSum.getSelectManager().getActiveRowIndex();
            if (colIndex > 0 && !(rowCompany = (OrgUnitInfo)this.tblSum.getCell(rowIndex, 0).getValue()).equals((Object)(colCompany = (OrgUnitInfo)this.tblSum.getCell(colIndex - 1, 0).getValue())) && this.tblSum.getRow(rowIndex).getCell(colIndex).getValue() != null) {
                this.openDetailReport(rowCompany, colCompany, OprtState.VIEW);
            }
        }
    }

    private void openDetailReport(OrgUnitInfo rowCompany, OrgUnitInfo colCompany, String state) throws Exception {
        ArrayList<String> tempIds = new ArrayList<String>();
        Object[] elimTempletInfos = (Object[])this.pmptTemplate.getData();
        ElimTempletInfo elimTempletInfo = null;
        if (elimTempletInfos != null && elimTempletInfos.length > 0) {
            for (int i = 0; i < elimTempletInfos.length; ++i) {
                elimTempletInfo = (ElimTempletInfo)elimTempletInfos[i];
                if (elimTempletInfo == null || elimTempletInfo.getEntries() == null) continue;
                tempIds.add(elimTempletInfo.getEntries().get(0).getTemplet().getId().toString());
            }
        }
        String processUI = null;
        processUI = BalanceDetailUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"matrixType", this.cmbMatrixType.getSelectedItem());
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        uiContext.put((Object)"periodType", (Object)this.periodType);
        uiContext.put((Object)"rowCompany", (Object)rowCompany);
        uiContext.put((Object)"colCompany", (Object)colCompany);
        uiContext.put((Object)"tempIds", tempIds);
        uiContext.put((Object)"cslCtx", (Object)this.ctx);
        uiContext.put((Object)"isAdjustBefore", (Object)this.kdAdjustBefore.isSelected());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, state);
        window.show();
    }

    @Override
    protected void tblDif_tableClick(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            OrgUnitInfo colCompany;
            OrgUnitInfo rowCompany;
            int colIndex = this.tblDif.getSelectManager().getActiveColumnIndex();
            int rowIndex = this.tblDif.getSelectManager().getActiveRowIndex();
            if (colIndex > 0 && !(rowCompany = (OrgUnitInfo)this.tblDif.getCell(rowIndex, 0).getValue()).equals((Object)(colCompany = (OrgUnitInfo)this.tblDif.getCell(colIndex - 1, 0).getValue())) && this.tblDif.getRow(rowIndex).getCell(colIndex).getValue() != null) {
                this.openDetailReport(rowCompany, colCompany, OprtState.VIEW);
            }
        }
    }
}

