/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.cell.notify;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.fi.rpt.util.ReportVariables;

public class CellStopEditingListener
implements SheetChangeListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_Content)) {
            Sheet sheet = e.getSheet();
            Book book = sheet.getBook();
            boolean autoCalculate = false;
            if (this.getVariables(book).get("autoCalculateState", book.getName()) != null) {
                autoCalculate = Boolean.valueOf(this.getVariables(book).get("autoCalculateState", book.getName()).getValue());
            }
            if (!autoCalculate) {
                return;
            }
            try {
                book.getUndoManager().startGroup();
                book.getUndoManager().enable(false);
                SortedCellBlockArray cells = e.getChangedBlocks();
                book.setSkipListeners(true);
                Dependents deps = sheet.getBook().getDeps();
                Cell cell = null;
                book.setAutoCalculate(autoCalculate);
                for (int i = 0; i < cells.size(); ++i) {
                    CellBlock block = cells.getBlock(i);
                    Range range = sheet.getRange(block);
                    for (int row = block.getRow(); row <= block.getRow2(); ++row) {
                        for (int col = block.getCol(); col <= block.getCol2(); ++col) {
                            cell = sheet.getCell(row, col, false);
                            if (cell == null) continue;
                            cell.queue(deps, true);
                            deps.calc();
                        }
                    }
                    range.calc(true);
                }
                deps.clearCalcList();
            }
            finally {
                book.setAutoCalculate(false);
                book.setSkipListeners(false);
                book.getUndoManager().endGroup();
                book.getUndoManager().enable(true);
            }
        }
    }

    protected ReportVariables getVariables(Book book) {
        ReportVariables v = ReportVariables.loadFromBook((Book)book);
        if (v == null) {
            v = new ReportVariables();
            v.storeToBook(book);
        }
        return v;
    }
}

