/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.awt.Component;

public abstract class BaseReportMenuManager
extends IMenuStrategy {
    @Override
    public void applyMenuState(ReportMenuState state) {
        if (ReportMenuState.EDIT.equals(state.getEditState())) {
            this.edit(state);
            this.audit(state);
        } else if (ReportMenuState.ADDNEW.equals(state.getEditState())) {
            this.edit(state);
        } else if (ReportMenuState.VIEW.equals(state.getEditState())) {
            this.view(state);
            this.audit(state);
        }
    }

    protected void view(ReportMenuState state) {
        this.applyCommonMenu(state);
    }

    protected void edit(ReportMenuState state) {
        this.applyCommonMenu(state);
    }

    protected void audit(ReportMenuState state) {
        this.refreshAuditMenu(state);
    }

    protected void applyCommonMenu(ReportMenuState state) {
        boolean canSave = ReportMenuState.ADDNEW.equals(state.getEditState()) || ReportMenuState.EDIT.equals(state.getEditState());
        this.enableVisibleMenu("menuFile/menuItemSave", true, canSave);
        this.enableVisibleMenu("menuFile/menuItemImport", true, canSave);
        this.enableVisibleMenu("menuFile/menuItemSaveAs", false, false);
        this.enableVisibleMenu("menuTool/menuConvert", false, false, true);
        this.enableVisibleMenu("menuEdit/menuSumRange", false, false, true);
        this.enableVisibleMenu("menuView/menuItemViewSumRange", false, false);
        this.enableVisibleMenu("menuFind/findSubReport", false, false, false);
        this.enableVisibleMenu("menuFind/findSubReportCell", false, false, false);
        this.enableVisibleMenu("menuFind/findAccount/itemFindIndexData", false, false, false);
        this.enableVisibleMenu("menuFind/findAccount/cashItem", false, false, false);
        this.enableVisibleMenu("menuView/menuItemReportVariables", false, false);
        ReportBaseInfo baseReport = (ReportBaseInfo)state.getBookProvider().getEditValue();
        int rptType = baseReport == null ? 1 : baseReport.getSourceType().getValue();
        boolean isDyReport = (rptType == 10 || rptType == 11 || rptType == 13 || rptType == 14) && baseReport != null && baseReport.getTemplate().getDynaRptType() == DynaEnumRptTypeEnum.DYNAMIC;
        boolean enableAction = ReportMenuState.EDIT.equals(state.getEditState()) || ReportMenuState.ADDNEW.equals(state.getEditState());
        this.enableVisibleMenu("menuTool/itemDynaItemFillWizard", isDyReport, enableAction);
        this.enableVisibleMenu("menuTool/itemWorkflow", false, false);
        this.enableVisibleMenu("menuStyle/menuCoverReport", false, false);
        this.enableVisibleMenu("menuData/sepDataAnalysis", false, false);
        this.enableVisibleMenu("menuData/menuItemAnalysisCell", false, false);
        this.enableVisibleMenu("menuData/menuItemAnalysisItem", false, false);
        this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisCell", false, false);
        this.enableVisibleMenu("menuRangeContext/menuItemRCAnalysisItem", false, false);
        this.enableVisibleMenu("menuRangeContext/menuItemPerspectivity", false, false);
        this.enableVisibleMenu("menuRangeContext/menuDyItemPerspectivity", false, false);
        this.enableVisibleMenu("menuData/menuItemPerspectivity_data", false, false);
        this.enableVisibleMenu("menuData/menuDyItemPerspectivity_data", false, false);
        this.enableVisibleMenu("menuData/menuDynaItemAnalysisItem", false, false);
        this.enableVisibleMenu("menuRangeContext/menuDynaItemRCAnalysisItem", false, false);
        if (rptType == 10 || rptType == 11 || rptType == 12) {
            this.enableVisibleMenu("menuData/menuItemRemoveZeroBook", true, true);
            this.enableVisibleMenu("menuData/menuItemRemoveCurSheet", true, true);
        } else {
            this.enableVisibleMenu("menuData/menuItemRemoveZeroBook", false, false);
            this.enableVisibleMenu("menuData/menuItemRemoveCurSheet", false, false);
        }
    }

    protected void refreshAuditMenu(ReportMenuState state) {
        boolean isMns;
        ReportBaseInfo baseReport = (ReportBaseInfo)state.getBookProvider().getEditValue();
        boolean bl = isMns = baseReport.getSourceType().getValue() == 4;
        if (isMns) {
            return;
        }
        int auditValue = baseReport.getAuditedStatus().getValue();
        String meunText = auditValue == 2 ? RptUtil.getRptMenuResource((String)"miUnAudit") : RptUtil.getRptMenuResource((String)"miAudit");
        this.setMenuText("menuTool/menuItemAudit", meunText);
    }

    protected void changeMenuStatus(String path, boolean enable) {
        Component component = this.findMenuUsingPath(path);
        if (component != null) {
            component.setEnabled(enable);
        }
    }
}

