/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.AbstractCalculateOptionUI;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class CalculateOptionUI
extends AbstractCalculateOptionUI {
    private static final Logger logger = CoreUIObject.getLogger(CalculateOptionUI.class);
    public static final int OPTION_ALL = 0;
    public static final int OPTION_CALCULATE = 1;
    public static final int OPTION_FORMULA_INFO = 2;
    public static final int OPTION_DIV0_INFO = 4;
    private int option;
    public static final String COMMON_VALUE = "1";
    public static final String RIGHT_BENEFIT_VALUE = "30";
    private int result = 0;
    private Book book = null;

    public void onLoad() {
        this.kDButtonGroup1.add((AbstractButton)this.btnAutoCalculate);
        this.kDButtonGroup1.add((AbstractButton)this.btnManaulCalculate);
        MyAction act = new MyAction();
        String o = this.btnUsingErrorDefine.getText();
        this.btnUsingErrorDefine.setAction((Action)act);
        this.btnUsingErrorDefine.setText(o);
        o = this.btnCheckDiv0.getText();
        this.btnCheckDiv0.setAction((Action)act);
        this.btnCheckDiv0.setText(o);
        o = this.kDCheckBox1.getText();
        this.kDCheckBox1.setAction((Action)act);
        this.kDCheckBox1.setText(o);
        o = this.btnOK.getText();
        this.btnOK.setAction((Action)act);
        this.btnOK.setText(o);
        o = this.btnCancel.getText();
        this.btnCancel.setAction((Action)act);
        this.btnCancel.setText(o);
        this.kDCheckBox1.setEnabled(false);
        this.kDCheckBox1.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setEnabledForBudget(String budget) {
        if (budget != null && budget.equalsIgnoreCase("BUDGET")) {
            this.kdlabel5.setEnabled(false);
            this.chkIncludeGroupUnit.setEnabled(false);
            this.chkRemoveException.setEnabled(false);
            this.chkAutoFillDigit.setEnabled(false);
        }
    }

    public static IUIWindow createUI(Object parent) throws UIException {
        UIContext c = new UIContext(parent);
        return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CalculateOptionUI.class.getName(), (Map)c);
    }

    public void setAutoCalculate(boolean b) {
        if (b) {
            this.btnAutoCalculate.setSelected(true);
        } else {
            this.btnManaulCalculate.setSelected(true);
        }
    }

    public boolean getIsAutoCalculate() {
        return this.btnAutoCalculate.isSelected();
    }

    public void setIncludeGroupUnit(boolean b) {
        if (b) {
            this.chkIncludeGroupUnit.setSelected(true);
        } else {
            this.chkIncludeGroupUnit.setSelected(false);
        }
    }

    public boolean getIncludeGroupUnit() {
        return this.chkIncludeGroupUnit.isSelected();
    }

    public void setRemoveException(boolean b) {
        if (b) {
            this.chkRemoveException.setSelected(true);
        } else {
            this.chkRemoveException.setSelected(false);
        }
    }

    public boolean getRemoveException() {
        return this.chkRemoveException.isSelected();
    }

    public void setAutoFillDigit(boolean b) {
        if (b) {
            this.chkAutoFillDigit.setSelected(true);
        } else {
            this.chkAutoFillDigit.setSelected(false);
        }
    }

    public boolean getAutoFillDigit() {
        return this.chkAutoFillDigit.isSelected();
    }

    public void setErrorProvider(ReportCalculateErrorProvider errorProvider) {
        if (errorProvider == null) {
            errorProvider = new ReportCalculateErrorProvider();
            errorProvider.setDealException(false);
            errorProvider.setDealDiv0Error(false);
            errorProvider.setHandleShowZero(false);
        }
        if (errorProvider.isDealException()) {
            this.btnUsingErrorDefine.setSelected(true);
        } else {
            this.txtError.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)((String)((Object)errorProvider.getExceptionReplacer())))) {
            this.txtError.setText((String)((Object)errorProvider.getExceptionReplacer()));
        }
        if (errorProvider.isDealDiv0Error()) {
            this.btnCheckDiv0.setSelected(true);
        } else {
            this.txtDiv0.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)errorProvider.getZeroDivDisplayAs())) {
            this.txtDiv0.setText(errorProvider.getZeroDivDisplayAs());
        }
        if (errorProvider.isHandleShowZero()) {
            this.kDCheckBox1.setSelected(true);
        } else {
            this.kDTextField1.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)errorProvider.getZeroShowAs())) {
            this.kDTextField1.setText(errorProvider.getZeroShowAs());
        }
    }

    public ReportCalculateErrorProvider getErrorProvider() {
        ReportCalculateErrorProvider e = new ReportCalculateErrorProvider();
        if (this.btnUsingErrorDefine.isSelected()) {
            e.setDealException(true);
        }
        e.setExceptionReplacer(this.txtError.getText());
        if (this.btnCheckDiv0.isSelected()) {
            e.setDealDiv0Error(true);
        }
        e.setZeroDivDisplayAs(this.txtDiv0.getText());
        if (this.kDCheckBox1.isSelected()) {
            e.setHandleShowZero(true);
        }
        e.setZeroShowAs(this.kDTextField1.getText());
        return e;
    }

    private void checkUsingError() {
        if (this.btnUsingErrorDefine.isSelected()) {
            this.txtError.setEnabled(true);
        } else {
            this.txtError.setEnabled(false);
        }
    }

    private void cancel() {
        this.result = 2;
        this.destroyWindow();
    }

    public void setBook(Book book) {
        this.book = book;
    }

    private void ok() {
        this.result = 0;
        try {
            VariableEntry entry = new VariableEntry("autoCalculateState", this.book.getName());
            entry.setValue(new Boolean(this.btnAutoCalculate.isSelected()).toString());
            entry.setVisible(false);
            ((ReportVariables)this.book.getUserObjectValue("VARIABLES")).addOrReplace(entry);
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        this.destroyWindow();
    }

    private void checkZeroShowAs() {
        if (this.kDCheckBox1.isSelected()) {
            this.kDTextField1.setEnabled(true);
        } else {
            this.kDTextField1.setEnabled(false);
        }
    }

    private void checkDiv0() {
        if (this.btnCheckDiv0.isSelected()) {
            this.txtDiv0.setEnabled(true);
        } else {
            this.txtDiv0.setEnabled(false);
        }
    }

    public int getResult() {
        return this.result;
    }

    public void setUIOption(int option) {
        this.option = option;
        this.setComponent();
    }

    private void setComponent() {
        if (this.option < 1) {
            return;
        }
        boolean enableCalculate = (this.option & 1) == 1;
        this.btnAutoCalculate.setEnabled(enableCalculate);
        this.btnManaulCalculate.setEnabled(enableCalculate);
        boolean enableFormula_Info = (this.option & 2) == 2;
        this.btnUsingErrorDefine.setEnabled(enableFormula_Info);
        this.txtError.setEnabled(enableFormula_Info && this.btnUsingErrorDefine.isSelected());
        boolean enableDiv0_Info = (this.option & 4) == 4;
        this.btnCheckDiv0.setEnabled(enableDiv0_Info);
        this.txtDiv0.setEnabled(enableDiv0_Info && this.btnCheckDiv0.isSelected());
        if (null == this.book) {
            return;
        }
        ReportVariables reportVariables = (ReportVariables)this.book.getUserObjectValue("VARIABLES");
        VariableEntry variableEntry = reportVariables.get("SheetClass", this.book.getActiveSheet().getSheetName());
        String sheetType = variableEntry.getValue();
        if (COMMON_VALUE.equals(sheetType) || RIGHT_BENEFIT_VALUE.equals(sheetType)) {
            this.chkIncludeGroupUnit.setEnabled(false);
            this.chkRemoveException.setEnabled(false);
            this.chkAutoFillDigit.setEnabled(false);
        }
    }

    class MyAction
    extends AbstractAction {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CalculateOptionUI.this.btnUsingErrorDefine) {
                CalculateOptionUI.this.checkUsingError();
            } else if (e.getSource() == CalculateOptionUI.this.btnCheckDiv0) {
                CalculateOptionUI.this.checkDiv0();
            } else if (e.getSource() == CalculateOptionUI.this.kDCheckBox1) {
                CalculateOptionUI.this.checkZeroShowAs();
            } else if (e.getSource() == CalculateOptionUI.this.btnOK) {
                CalculateOptionUI.this.ok();
            } else if (e.getSource() == CalculateOptionUI.this.btnCancel) {
                CalculateOptionUI.this.cancel();
            }
        }
    }
}

