/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IWizzardComment;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptCellCmtEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class CommentEditUI
extends RptCellCmtEditUI
implements IWizzardComment {
    public static final String COMMENT_PERMISSION = "CommentPermission";
    public static final String COMMENT_PERMISSION_ERROR_MSG = "CommentPermissionErrorMsg";
    private SpreadContext _context = null;
    private int _mode;
    private boolean _isCancel;

    public static CommentEditUI createCommentUI(Object parent, SpreadContext context) throws UIException {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CommentEditUI.class.getName(), (Map)new UIContext(parent), null, OprtState.ADDNEW);
        CommentEditUI ui = (CommentEditUI)window.getUIObject();
        ui._context = context;
        ui.loadComments(new RptCommentTank());
        ui.addSimpleDialogListener((ISimpleDialogListener)new EditorListener());
        ui.setEditMode(true);
        return ui;
    }

    public boolean prepare() {
        RptCommentTank comment;
        this._context.getStateManager().stop();
        if (this._mode == 2) {
            Comment cm = this._context.getBook().getComment();
            if (cm != null) {
                cm = cm.getCopy();
            }
            comment = CommentUtil.convertComment(cm, null);
        } else if (this._mode == 1) {
            Comment cm = this._context.getBook().getActiveSheet().getComment();
            if (cm != null) {
                cm = cm.getCopy();
            }
            comment = CommentUtil.convertComment(cm, null);
        } else {
            Comment cm = this._context.getRangeManager().getActiveCellRange().getComment();
            if (cm != null) {
                cm = cm.getCopy();
            }
            comment = CommentUtil.convertComment(cm, null);
        }
        if (comment == null) {
            comment = new RptCommentTank();
        }
        this.setComments(comment);
        this.getComments().setTable(this.tblEntrys);
        this.getComments().refresh();
        this.setEditMode(true);
        return true;
    }

    public void show() {
        CoreUI ownerCoreUI;
        Map parentUIContext;
        Object ownerUI = this.getUIContext().get("Owner");
        if (ownerUI instanceof CoreUI && (parentUIContext = (ownerCoreUI = (CoreUI)ownerUI).getUIContext()) != null && Boolean.FALSE.equals(parentUIContext.get(COMMENT_PERMISSION))) {
            Object errorMsg = parentUIContext.get(COMMENT_PERMISSION_ERROR_MSG);
            if (errorMsg != null && errorMsg instanceof String) {
                MsgBox.showError((Component)((Object)this), (String)((String)errorMsg));
            }
            return;
        }
        if (this.getUIWindow() instanceof KDDialog && !((KDDialog)this.getUIWindow()).isVisible()) {
            IRow row = this.tblEntrys.getRow(0);
            if (row != null && row.getCell(1) != null && row.getCell(1).getValue() != null) {
                this.txtComment.setText(row.getCell(1).getValue().toString());
                this.tblEntrys.getSelectManager().select(this.getComments().indexOf(this.getComments().getFreshEntry()), 1, 2);
            } else {
                this.txtComment.setText("");
            }
            this.getUIWindow().show();
        } else {
            super.show();
        }
    }

    public void setComments(RptCommentTank comments) {
        super.setComments(comments);
        this.updateComps();
    }

    private void updateComps() {
        if (this.getComments() == null) {
            // empty if block
        }
    }

    public boolean isModal() {
        return true;
    }

    public void commit() {
        if (!this.isCancel()) {
            this._context.getStateManager().stop();
            Sheet sheet = this._context.getBook().getActiveSheet();
            RptCommentTank nc = this.getComments();
            if (nc == null || nc.getSize() < 1) {
                nc = null;
            }
            if (nc == null || nc.isModify()) {
                if (this._mode == 2) {
                    this._context.getBook().setComment((Comment)nc);
                } else if (this._mode == 1) {
                    sheet.setComment((Comment)nc);
                } else {
                    this._context.getRangeManager().getActiveCellRange().setComment((Comment)nc);
                }
            }
        }
    }

    private boolean isCancel() {
        return this._isCancel;
    }

    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this._isCancel = true;
        super.actionBtnCancel_actionPerformed(e);
    }

    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this._isCancel = false;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    private static class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        public Object getTrueController() {
            return new RptComment();
        }

        public void pilotSetout(ISimpleDialog source) {
        }

        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                // empty if block
            }
        }
    }
}

