/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaBatchFill;
import java.util.List;

public class FillFormulaToSpread
implements FormulaBatchFill.IFormulaBatchFill {
    private Book book;

    public FillFormulaToSpread(Book book) {
        this.book = book;
    }

    public String getCurrentPoint() {
        if (this.book == null) {
            return "A1";
        }
        Range activeCellRange = this.book.getActiveSheet().getActiveCellRange();
        if (activeCellRange == null) {
            return "A1";
        }
        int row = this.book.getActiveSheet().getActiveRow();
        int col = this.book.getActiveSheet().getActiveCol();
        return TableToolkit.xy2range((int)col, (int)row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(int startRow, int startCol, List matrix, int type) {
        boolean isBookAutoCalc = this.book.isAutoCalculate();
        this.book.setCalculate(false);
        this.book.getUndoManager().startGroup();
        try {
            if (type == 1) {
                this.fill1(startRow, startCol, matrix);
            } else {
                this.fill2(startRow, startCol, matrix);
            }
        }
        finally {
            this.book.getUndoManager().endGroup();
        }
        this.book.setCalculate(isBookAutoCalc);
    }

    private void fill1(int startRow, int startCol, List matrix) {
        for (int i = 0; i < matrix.size(); ++i) {
            List mrow = (List)matrix.get(i);
            for (int j = 0; j < mrow.size(); ++j) {
                String value = (String)mrow.get(j);
                Range range = this.book.getActiveSheet().getRange(i + startRow, startCol + j);
                if (value != null && value.startsWith("=")) {
                    range.setFormula(value);
                    continue;
                }
                range.setValue(new Variant((Object)value));
            }
        }
    }

    private void fill2(int startRow, int startCol, List matrix) {
        if (matrix.size() < 1) {
            return;
        }
        List list = (List)matrix.get(0);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < matrix.size(); ++j) {
                List mrow = (List)matrix.get(j);
                String value = (String)mrow.get(i);
                Range range = this.book.getActiveSheet().getRange(i + startRow, startCol + j);
                if (value != null && value.startsWith("=")) {
                    range.setFormula(value);
                    continue;
                }
                range.setValue(new Variant((Object)value));
            }
        }
    }
}

