/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLTemplateRptProcessUI;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.TempReportProcessUI;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FormulaPicker
implements ISpreadWizzard {
    private static final Logger logger = Logger.getLogger(FormulaPicker.class);
    private FormulaPickerUI realWizard;
    private FormulaPickListener pickListener;
    private Component parentUI;
    private boolean isK3 = false;
    private String formulaFilter = "exclude:formulas{BgItem,Item,BgItemM,FpItem,DItem,keyWord,bgact};exclude:categorys{fm_fp}";
    private static final long serialVersionUID = 4883244161798888803L;
    private RptContextManager rptContextManager;

    public FormulaPicker(Component owner) throws Exception {
        this.parentUI = owner;
        if (this.parentUI.getParent() instanceof RptReportProcessUI) {
            this.isK3 = ((RptReportProcessUI)this.parentUI.getParent()).isK3();
        } else if (this.parentUI.getParent() instanceof TempReportProcessUI) {
            this.isK3 = ((TempReportProcessUI)this.parentUI.getParent()).isK3();
        } else if (this.parentUI.getParent() instanceof CSLTemplateRptProcessUI) {
            this.isK3 = true;
        } else {
            Window window = SwingUtilities.getWindowAncestor(owner);
            if (window instanceof UINewFrame && ((UINewFrame)window).getUIObject() instanceof RptReportProcessUI) {
                this.isK3 = ((RptReportProcessUI)((UINewFrame)window).getUIObject()).isK3();
            }
        }
    }

    private void initWizard() throws Exception {
        this.realWizard = FormulaPicker.getFormulaPicker(this.parentUI);
        this.realWizard.addFormulaPickerListener(new IFormulaPickerListener(){

            public void pickerSetout(FormulaPickerUI picker) {
            }

            public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
                if (isOk) {
                    FormulaPicker.this.pickListener.setFormulaLine(formulaLine);
                }
            }
        });
    }

    public static FormulaPickerUI getFormulaPicker(Component c) throws Exception {
        Window realOwner = SwingUtilities.getWindowAncestor(c);
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(FormulaPickerUI.class.getName(), (Map)new UIContext((Object)realOwner));
        FormulaPickerUI wzd = wnd != null ? (FormulaPickerUI)wnd.getUIObject() : null;
        return wzd;
    }

    public void setFormulaPickListener(FormulaPickListener l) {
        this.pickListener = l;
    }

    private void pick(String line) throws Exception {
        Expression exp;
        RptFormula fm = null;
        FunctionExpr function = null;
        if (!StringUtils.isEmpty((String)line) && (exp = ExcelFormulaPaserHelper.parse((String)line)) instanceof FunctionExpr) {
            function = (FunctionExpr)exp;
        }
        if (function != null) {
            RptFormulaComp comp = RptFormulaComp.getInstance();
            comp.setK3(this.isK3);
            comp.load();
            fm = RptFormulaComp.getInstance().getFormula(function.funcionName);
        }
        if (this.parentUI instanceof SpreadContext) {
            this.rptContextManager.put(SpreadContext.class, (Object)this.parentUI);
        }
        if (function != null && fm != null) {
            FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.getWizard(), (Object)this.parentUI);
            wizard.setRptContext((IRptContextManager)this.rptContextManager);
            wizard.addFormulaWizardListener(new IFormulaWizardListener(){

                public void wizardSetout(FormulaWizardUI wizard) {
                }

                public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
                    if (isOk && FormulaPicker.this.pickListener != null) {
                        FormulaPicker.this.pickListener.setFormulaLine(formulaLine);
                    }
                }
            });
            wizard.setUserObject((Object)line);
            FormulaHint hint = new FormulaHint();
            hint.params = new String[function.parameters.size()];
            for (int i = 0; i < function.parameters.size(); ++i) {
                Expression e = (Expression)function.parameters.get(i);
                hint.params[i] = e instanceof StringExpr ? ((StringExpr)e).value : e.toString();
            }
            hint.name = function.funcionName;
            hint.text = line;
            wizard.setLoadOnce(true);
            wizard.setFocusCycleRoot(true);
            wizard.open(function.funcionName, hint);
        } else {
            boolean showAdvn = !StringUtils.isEmpty((String)line);
            this.realWizard.setUserObject((Object)line);
            this.realWizard.setRptContext(this.rptContextManager);
            this.realWizard.setFormulaLine(line);
            this.realWizard.setK3(this.isK3);
            this.realWizard.open(this.formulaFilter, showAdvn, null);
        }
    }

    public String getFormulaFilter() {
        return this.formulaFilter;
    }

    public void setFormulaFilter(String formulaFilter) {
        this.formulaFilter = formulaFilter;
    }

    public void commit() {
    }

    public boolean prepare() {
        return true;
    }

    public void show() {
        try {
            if (this.realWizard == null) {
                this.initWizard();
            }
            if (this.pickListener != null) {
                this.realWizard.setFormulaLine(this.pickListener.pickFormulaLine());
            } else {
                this.realWizard.setFormulaLine(null);
            }
            this.pick(this.realWizard.getFormulaLine());
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
    }

    public boolean isModal() {
        return true;
    }

    public void setRptContextManager(RptContextManager context) {
        this.rptContextManager = context;
    }
}

