/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;

public abstract class IBookProvider {
    private IObjectValue editData;
    private int isQueryBudget = 0;
    private OrgType orgType = null;

    public abstract Book loadBook() throws Exception;

    public abstract void restoreBook(Book var1) throws Exception;

    public IObjectValue getEditValue() {
        return this.editData;
    }

    public void setEditValue(IObjectValue vo) {
        this.editData = vo;
    }

    public abstract IObjectValue createNewReport() throws Exception;

    public abstract ICoreBase getBizInterface() throws Exception;

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getSelectors());
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        return sic;
    }

    public String getZipDataField() {
        return "data";
    }

    public void updateBook(Book destBook) throws Exception {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(this.getZipDataField());
        this.editData.setBytes(this.getZipDataField(), IOHelper.packBook((Book)destBook));
        this.getBizInterface().updatePartial((CoreBaseInfo)this.editData, sc);
    }

    public void saveReportCheckSolution(RptOperationSchemaComp operationSchema) throws Exception {
        byte[] zippedData = this.getEditValue().getBytes(this.getZipDataField());
        Book destBook = IOHelper.unpackBook((byte[])zippedData);
        if (operationSchema != null) {
            destBook.setUserObject("operationSchemas", (Object)operationSchema);
            this.updateBook(destBook);
        }
    }

    public void updateBookPrintSetting(Book srcBook) throws Exception {
        byte[] zippedData = this.getEditValue().getBytes(this.getZipDataField());
        Book destBook = IOHelper.unpackBook((byte[])zippedData);
        boolean needSave = false;
        for (int i = 0; i < destBook.getSheetCount(); ++i) {
            Sheet destSheet = destBook.getSheet(i);
            Sheet srcSheet = srcBook.getSheetByID(destSheet.getID());
            if (srcSheet == null) continue;
            PrintSetup src_setting = srcSheet.getSheetOption().getPrintSetup(false);
            NamedObjectNode node = srcSheet.getNamedObject("Print_Area", false);
            NamedObjectNode namedObjectNode = destSheet.getNamedObject("Print_Area", false);
            if (node != null) {
                if (namedObjectNode != null) {
                    namedObjectNode.setExpr(node.getExpr());
                } else {
                    destSheet.getNames().append((Object)node);
                }
                needSave = true;
            } else if (namedObjectNode != null) {
                namedObjectNode.setExpr(null);
                needSave = true;
            }
            node = srcSheet.getNames().searchByName("Print_Titles");
            namedObjectNode = destSheet.getNames().searchByName("Print_Titles");
            if (node != null) {
                if (namedObjectNode != null) {
                    namedObjectNode.setExpr(node.getExpr());
                } else {
                    destSheet.getNames().append((Object)node);
                }
                needSave = true;
            } else if (namedObjectNode != null) {
                namedObjectNode.setExpr(null);
                needSave = true;
            }
            if (src_setting == null && !needSave || src_setting == null) continue;
            needSave = true;
            destSheet.getSheetOption().getPrintSetup(true).copyFrom(src_setting);
        }
        if (needSave) {
            this.updateBook(destBook);
        }
    }

    public abstract String getBizFactoryName();

    public String getBizInterfaceName() {
        return null;
    }

    public int getIsQueryBudget() {
        return this.isQueryBudget;
    }

    public void setIsQueryBudget(int isQueryBudget) {
        this.isQueryBudget = isQueryBudget;
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }
}

