/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuManager;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import java.awt.Component;
import javax.swing.AbstractButton;

public abstract class IMenuStrategy {
    private ReportMenuManager menuManager;
    private String oldEditState;

    public void refreshMenu(ReportMenuState state) {
        this.refreshMenu(state, false);
    }

    public void refreshMenu(ReportMenuState state, boolean forceRefesh) {
        if (state.getType() == 0) {
            if (forceRefesh || !state.getEditState().equals(this.oldEditState)) {
                this.oldEditState = state.getEditState();
                this.applyMenuState(state);
            }
        } else if (state.getType() == 1) {
            this.applySheetRelatedMenu(state);
        }
    }

    protected abstract void applyMenuState(ReportMenuState var1);

    protected void applySheetRelatedMenu(ReportMenuState state) {
    }

    protected void setMenuText(String menuPath, String text) {
        Component component = this.findMenuUsingPath(menuPath);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setText(text);
        }
    }

    public void setReportMenuManager(ReportMenuManager menuManager) {
        this.menuManager = menuManager;
    }

    public ReportMenuManager getReportMenuManager() {
        return this.menuManager;
    }

    public Component enableVisibleMenu(String path, boolean visibleMenu, boolean enableAction) {
        return this.menuManager.enableVisibleMenu(path, visibleMenu, enableAction);
    }

    public Component enableVisibleMenu(String path, boolean visibleMenu, boolean enableAction, boolean applyToChildren) {
        if (applyToChildren) {
            return this.menuManager.enableVisibleAllMenu(path, visibleMenu, enableAction);
        }
        return this.menuManager.enableVisibleMenu(path, visibleMenu, enableAction);
    }

    public Component findMenuUsingPath(String path) {
        return this.menuManager.findMenuUsingPath(path);
    }
}

