/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaChangeEvent;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.client.designer.event.ItemFormulaChangeListener;
import com.kingdee.eas.fi.newrpt.formula.NewRptContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ItemFormulaPanel
extends KDPanel {
    private static final long serialVersionUID = -4911153025073003176L;
    private KDWorkButton btnItem;
    private KDTextField txtItemFormula;
    private KDWorkButton btnOption;
    private KDButtonGroup grpOption;
    private boolean showGrpOption = true;
    private int state = 1;
    private boolean showItem = true;
    private KDPopupMenu popupOptionMenu = null;
    private KDCheckBoxMenuItem menuAlwaysShow = null;
    private KDCheckBoxMenuItem menuShowAsNeeded = null;
    private KDCheckBoxMenuItem menuNeverShow = null;
    private ItemPanelStateChangeListener itemPanelStateChangeListener;
    private IItemFormulaProvider formulaProvider;
    private int width = 1;
    private ItemFormulaChangeListener itemFormulaChangeListener;
    private FormulaPicker wizard;
    private SpreadContext spreadContext;
    private ItemFormulaChangeEvent itemFormulaChangeEvent = new ItemFormulaChangeEvent((Object)this, null);
    private Set managingFocusForwardTraversalKeys;
    private boolean isEditable = true;

    public ItemFormulaPanel(SpreadContext container) {
        this.spreadContext = container;
        this.setLayout(new ItemPanelLayout());
        this.initComponents();
        this.initCompActions();
    }

    public ItemFormulaPanel(SpreadContext container, boolean showGrpOption) {
        this.showGrpOption = showGrpOption;
        this.spreadContext = container;
        this.setLayout(new ItemPanelLayout());
        this.initComponents();
        this.initCompActions();
    }

    private void initComponents() {
        this.btnItem = new KDWorkButton();
        this.txtItemFormula = new KDTextField();
        this.btnOption = new KDWorkButton();
        this.add((Component)this.btnItem);
        this.btnItem.setToolTipText(DesignerResource.getString("itemFormulaPanel_formula"));
        this.btnItem.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        this.add((Component)this.txtItemFormula);
        this.btnOption.setToolTipText(DesignerResource.getString("notShowItemFormula"));
        this.btnOption.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        if (this.showGrpOption) {
            this.add((Component)this.btnOption);
        }
        this.menuAlwaysShow = new KDCheckBoxMenuItem(DesignerResource.getString("alwaysShowItemFormula"));
        this.menuShowAsNeeded = new KDCheckBoxMenuItem(DesignerResource.getString("ShowItemFormulaAsNeeded"));
        this.menuNeverShow = new KDCheckBoxMenuItem(DesignerResource.getString("NeverShowItemFormula"));
        this.grpOption = new KDButtonGroup();
        this.grpOption.add((AbstractButton)this.menuAlwaysShow);
        this.grpOption.add((AbstractButton)this.menuShowAsNeeded);
        this.grpOption.add((AbstractButton)this.menuNeverShow);
        this.popupOptionMenu = new KDPopupMenu();
        this.popupOptionMenu.add((JMenuItem)this.menuAlwaysShow);
        this.popupOptionMenu.add((JMenuItem)this.menuShowAsNeeded);
        this.popupOptionMenu.add((JMenuItem)this.menuNeverShow);
        this.grpOption.setSelected(this.menuShowAsNeeded.getModel(), true);
        this.btnOption.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"2_ItemFormulaPanel"));
        this.txtItemFormula.setSelectAllOnFocus(false);
    }

    public void addItemFormulaChangeListener(ItemFormulaChangeListener l) {
        this.itemFormulaChangeListener = l;
        this.txtItemFormula.setFocusTraversalKeys(0, this.getManagingFocusForwardTraversalKeys());
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        String strKey = "FORMULA_ENTER";
        this.txtItemFormula.getInputMap().put(ks, strKey);
        this.txtItemFormula.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ItemFormulaPanel.this.update();
                ItemFormulaPanel.this.spreadContext.requestFocus();
            }
        });
    }

    private void update() {
        if (this.txtItemFormula.isFocusOwner()) {
            String text = this.txtItemFormula.getText();
            this.itemFormulaChangeEvent.setFormula(text);
            this.itemFormulaChangeListener.formulaChanged(this.itemFormulaChangeEvent);
        }
    }

    Set getManagingFocusForwardTraversalKeys() {
        if (this.managingFocusForwardTraversalKeys == null) {
            this.managingFocusForwardTraversalKeys = new HashSet();
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return this.managingFocusForwardTraversalKeys;
    }

    private void setShowState(int s) {
        this.state = s;
        this.setItemFormulaLine(this.txtItemFormula.getText());
    }

    protected void setShowMode(int s) {
        if (s == 0) {
            this.showItem = true;
            this.menuAlwaysShow.doClick();
        } else if (s == 1) {
            this.menuShowAsNeeded.doClick();
        } else if (s == 2) {
            this.menuNeverShow.doClick();
        }
    }

    public void refreshItemFormula(Range range, int viewMode) {
        if (range == null) {
            this.setItemFormulaLine(null);
        }
        if (this.formulaProvider != null) {
            this.setItemFormulaLine(this.formulaProvider.getDisplayingItemFormula(range, viewMode));
            if (this.isEditable) {
                this.setEditable(this.formulaProvider.editable());
            }
        }
    }

    public void setItemFormulaLine(String formula) {
        if (formula == null) {
            formula = "";
        }
        this.txtItemFormula.setText(formula);
        if (this.state == 1) {
            this.setPanelVisible(!StringUtils.isEmpty((String)formula));
        } else if (this.state == 0) {
            this.setPanelVisible(true);
        } else {
            this.setPanelVisible(false);
        }
    }

    private void initCompActions() {
        this.btnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.initWizard();
                ItemFormulaPanel.this.wizard.show();
            }
        });
        this.btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = ItemFormulaPanel.this.btnOption.getBounds();
                ItemFormulaPanel.this.popupOptionMenu.show((Component)ItemFormulaPanel.this.btnOption, bounds.x, bounds.y + bounds.height);
            }
        });
        this.menuAlwaysShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(0);
            }
        });
        this.menuShowAsNeeded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(1);
            }
        });
        this.menuNeverShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(2);
            }
        });
    }

    public void setPanelVisible(boolean visible) {
        if (visible && this.showItem && this.txtItemFormula.isVisible() && this.btnItem.isVisible()) {
            return;
        }
        this.showItem = visible;
        this.txtItemFormula.setVisible(visible);
        this.btnItem.setVisible(visible);
        this.doLayout();
    }

    public void setStateChangeListener(ItemPanelStateChangeListener l) {
        this.itemPanelStateChangeListener = l;
    }

    public IItemFormulaProvider getFormulaProvider() {
        return this.formulaProvider;
    }

    public void setFormulaProvider(IItemFormulaProvider formulaProvider) {
        this.formulaProvider = formulaProvider;
    }

    public void setEnabled(boolean enabled) {
        this.isEditable = enabled;
        this.setEditable(enabled);
    }

    private void setEditable(boolean bEdit) {
        this.txtItemFormula.setEditable(bEdit);
        this.btnItem.setEnabled(bEdit);
    }

    private void initWizard() {
        try {
            if (this.wizard != null) {
                return;
            }
            this.wizard = new FormulaPicker((Component)((Object)this));
            this.wizard.setRptContextManager(new NewRptContextManager());
            this.wizard.setFormulaPickListener(new FormulaPickListener(){

                @Override
                public String pickFormulaLine() {
                    String s = ItemFormulaPanel.this.txtItemFormula.getText();
                    if (s == null || s.trim().length() < 1 || s.charAt(0) != '=') {
                        return ItemFormulaPanel.this.formulaProvider.defaultItemFormula();
                    }
                    return s;
                }

                @Override
                public void setFormulaLine(String line) {
                    String string = '=' + line;
                    ItemFormulaPanel.this.txtItemFormula.setText(string);
                    if (ItemFormulaPanel.this.itemFormulaChangeListener != null) {
                        ItemFormulaChangeEvent e = new ItemFormulaChangeEvent(ItemFormulaPanel.this.wizard);
                        e.setFormula(string);
                        ItemFormulaPanel.this.itemFormulaChangeListener.formulaChanged(e);
                    }
                }
            });
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
    }

    public void doPickItemFormula() {
        this.btnItem.doClick();
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.width, 20);
        return dim;
    }

    public KDButtonGroup getGrpOption() {
        return this.grpOption;
    }

    private class ItemPanelLayout
    implements LayoutManager {
        private static final int PANEL_HEIGHT = 20;
        private int itemFormulaWidth = 300;

        private ItemPanelLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = ItemFormulaPanel.this.getHeight();
            Insets insets = ItemFormulaPanel.this.getInsets();
            int left = insets.left;
            int top = insets.top;
            int bottom = insets.bottom;
            int compH = h - top - bottom;
            int x = left;
            int y = top;
            x += 2;
            if (ItemFormulaPanel.this.showItem) {
                int total = ItemFormulaPanel.this.getBounds().width;
                ItemFormulaPanel.this.btnItem.setBounds(x, y, compH + 2, compH);
                ItemFormulaPanel.this.txtItemFormula.setLocation(x += compH + 2, y);
                int itemWidth = total - x - 16 - 1;
                if (itemWidth < 0 && total < x + 16 + 2) {
                    itemWidth = this.itemFormulaWidth;
                } else {
                    this.itemFormulaWidth = itemWidth;
                }
                ItemFormulaPanel.this.txtItemFormula.setSize(itemWidth, compH);
                ItemFormulaPanel.this.txtItemFormula.setBounds(x, y, itemWidth, compH);
                x += itemWidth + 1;
            }
            ItemFormulaPanel.this.btnOption.setBounds(x, y, 16, compH);
            int newWidth = x + ((ItemFormulaPanel)ItemFormulaPanel.this).btnOption.getBounds().width;
            if (ItemFormulaPanel.this.itemPanelStateChangeListener != null && newWidth != ItemFormulaPanel.this.width) {
                ItemFormulaPanel.this.width = newWidth;
                ItemFormulaPanel.this.itemPanelStateChangeListener.changeWidth(ItemFormulaPanel.this.width);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }
    }

    public static interface ItemPanelStateChangeListener {
        public void changeWidth(int var1);
    }
}

