/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.client.designer.AbstractPreNParamSetUI;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.designer.NewItem;
import com.kingdee.eas.fi.newrpt.client.designer.NewValue;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PreNParamSetUI
extends AbstractPreNParamSetUI {
    private static final long serialVersionUID = -4911279793504944185L;
    private static final Logger logger = CoreUIObject.getLogger(PreNParamSetUI.class);
    private Book book = null;
    private KDComboBox sortRule = null;
    private KDTextField txtFillLine = null;
    private KDTDefaultCellEditor sortRuleDec = null;
    private KDTDefaultCellEditor fillLineNumberdce = null;
    private Map tempSaveValue = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.initCtrl();
        this.initTblMain();
    }

    private void initTblMain() throws SyntaxErrorException {
        this.tblMain.getColumn("subtotalRows").getStyleAttributes().setLocked(true);
    }

    private String convertPointTo(Point point) {
        return TableToolkit.xy2range((int)point.x, (int)point.y);
    }

    private Rect convertRangeTo(String range) {
        return TableToolkit.range2xy((String)range);
    }

    protected NewItem[] getColumnNameByBasePoint(Sheet sheet, Point basePoint) {
        Range cell;
        int i;
        int left = basePoint.x;
        int top = basePoint.y;
        String text = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"35_PreNParamSetUI");
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        ArrayList<NewItem> itemList = new ArrayList<NewItem>();
        if (param.getSpreadStyle() == 0) {
            int colCount = this.getColCount(sheet, top, left);
            i = 1;
            while (i <= colCount) {
                cell = sheet.getRange(top, i + left);
                if (cell == null) continue;
                if (this.hasFormula(cell)) {
                    text = StringUtils.isEmpty((String)cell.getText()) ? text : cell.getText();
                    itemList.add(new NewItem(i, text));
                }
                ++i;
            }
        } else if (param.getSpreadStyle() == 1) {
            int rowCount = this.getRowCount(sheet, top, left);
            i = 1;
            while (i <= rowCount) {
                cell = sheet.getRange(i + top, left);
                if (cell == null) continue;
                if (this.hasFormula(cell)) {
                    text = StringUtils.isEmpty((String)cell.getText()) ? text : cell.getText();
                    itemList.add(new NewItem(i, text));
                }
                ++i;
            }
        }
        NewItem[] returnValue = new NewItem[itemList.size()];
        for (i = 0; i < returnValue.length; ++i) {
            returnValue[i] = (NewItem)itemList.get(i);
        }
        return returnValue;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initCtrl() {
        this.book = (Book)this.getUIContext().get("book");
        this.btnSave.setVisible(false);
        this.tblMain.getColumn("sheetName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("basePointPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("listItems").getStyleAttributes().setLocked(true);
        this.tblMain.addBeforeActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 7) {
                    e.setCancel(true);
                }
            }
        });
        this.tblMain.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                IRow currentRow = PreNParamSetUI.this.tblMain.getRow(rowIndex);
                if (colIndex == 5 && (e.getValue() == null || e.getValue().toString().trim().equals(""))) {
                    currentRow.getCell("fillLineNumber").setValue((Object)"");
                    e.setValue((Object)"");
                } else if (e.getValue() != null && e.getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                    currentRow.getCell("sortBy").setValue((Object)new NewItem(0, ""));
                    ((KDComboBox)currentRow.getCell("sortBy").getEditor().getComponent()).setSelectedIndex(0);
                    currentRow.getCell("sortBy").getStyleAttributes().setLocked(true);
                    currentRow.getCell("fillLineNumber").setValue((Object)"");
                    currentRow.getCell("fillLineNumber").getStyleAttributes().setLocked(true);
                    currentRow.getCell("subtotalRows").setValue((Object)"");
                    currentRow.getCell("subtotalRows").getStyleAttributes().setLocked(true);
                } else if (e.getValue() != null && (e.getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"28_PreNParamSetUI")) || e.getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"29_PreNParamSetUI")))) {
                    currentRow.getCell("sortBy").getStyleAttributes().setLocked(false);
                    currentRow.getCell("fillLineNumber").getStyleAttributes().setLocked(false);
                    currentRow.getCell("subtotalRows").getStyleAttributes().setLocked(false);
                }
                String mapKey = currentRow.getCell("sheetName").getValue().toString() + ":;:" + currentRow.getCell("basePointPosition").getValue().toString();
                NewValue mapValue = new NewValue((String)currentRow.getCell("sortRule").getValue(), (NewItem)currentRow.getCell("sortBy").getValue(), (String)currentRow.getCell("fillLineNumber").getValue(), (String)currentRow.getCell("subtotalRows").getValue(), (String)currentRow.getCell("listItems").getValue());
                if (PreNParamSetUI.this.tempSaveValue.get(mapKey).equals(mapValue)) {
                    return;
                }
                PreNParamSetUI.this.tempSaveValue.put(mapKey, mapValue);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.sortRule = new KDComboBox();
        this.sortRule.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"));
        this.sortRule.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"28_PreNParamSetUI"));
        this.sortRule.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"29_PreNParamSetUI"));
        this.sortRule.setSelectedIndex(1);
        this.txtFillLine = new KDTextField("");
        this.fillLineNumberdce = new KDTDefaultCellEditor((JTextField)this.txtFillLine);
        this.cmbSelectSheet.removeAllItems();
        this.cmbSelectSheet.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"30_PreNParamSetUI"));
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            this.cmbSelectSheet.addItem((Object)this.book.getSheetName(i));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionKdBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionKdBtnConfirm_actionPerformed(e);
        BaseReportDesignerUI owner = (BaseReportDesignerUI)((Object)this.getUIContext().get("Owner"));
        this.saveData();
        owner.getUIContext().put("fillNLineOK", null);
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    public void actionKdBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionKdBtnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    @Override
    public void actionBtnSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnSave_actionPerformed(e);
        this.verifySortBy();
        int isPass = 0;
        try {
            isPass = this.saveData();
        }
        catch (Exception e2) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"31_PreNParamSetUI"));
            return;
        }
        if (isPass == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"32_PreNParamSetUI"));
        } else if (isPass == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"31_PreNParamSetUI"));
        }
    }

    private void verifySortBy() {
        int rowCount = this.tblMain.getRowCount();
        ICell cellSortRule = null;
        ICell cellSoryBy = null;
        NewItem newItem = null;
        String sortRuleValue = "";
        boolean isNoOrder = false;
        for (int i = 0; i < rowCount; ++i) {
            cellSoryBy = this.tblMain.getCell(i, "sortBy");
            cellSortRule = this.tblMain.getCell(i, "sortRule");
            sortRuleValue = (String)cellSortRule.getValue();
            newItem = (NewItem)cellSoryBy.getValue();
            if (sortRuleValue == null || sortRuleValue.equals("") || sortRuleValue.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                isNoOrder = true;
            }
            if (isNoOrder || (newItem == null || newItem.getIndex() != 0 || !newItem.getDisplayName().equals("")) && newItem != null) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"33_PreNParamSetUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionBtnOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOK_actionPerformed(e);
    }

    private int saveData() throws SyntaxErrorException {
        if (this.tempSaveValue != null && !this.tempSaveValue.isEmpty()) {
            Iterator it = this.tempSaveValue.entrySet().iterator();
            DynaRptBasePointIndexHandle indexHandle = null;
            Sheet sheet = null;
            while (it.hasNext()) {
                Range cell;
                int i;
                Map.Entry e = it.next();
                String mapKey = (String)e.getKey();
                NewValue mapValue = (NewValue)e.getValue();
                String[] splitKey = mapKey.split(":;:");
                Rect rect = this.convertRangeTo(splitKey[1]);
                Point basePoint = new Point(rect.x1, rect.y1);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)this.book.getSheetByName(splitKey[0]), (Point)basePoint);
                String sortRule = mapValue.getSortRule();
                if (sortRule.equals("")) {
                    sortRule = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI");
                }
                OrderByEnum orderRule = OrderByEnum.NONE;
                orderRule = sortRule.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI")) ? OrderByEnum.NONE : (sortRule.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"28_PreNParamSetUI")) ? OrderByEnum.ASC : (sortRule.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"29_PreNParamSetUI")) ? OrderByEnum.DESC : OrderByEnum.NONE));
                param.setOrderBy(orderRule);
                if (mapValue.getSortBy() != null) {
                    int index = mapValue.getSortBy().getIndex();
                    if (param.getSpreadStyle() == 0) {
                        param.setOrderRow(index);
                    } else if (param.getSpreadStyle() == 1) {
                        param.setOrderRow(index);
                    }
                } else {
                    param.setOrderRow(-1);
                }
                if (mapValue.getFillLineNumber().equals("")) {
                    param.setFillLineNumber(-1);
                } else {
                    param.setFillLineNumber(Integer.parseInt(mapValue.getFillLineNumber()));
                }
                sheet = this.book.getSheetByName(splitKey[0]);
                indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
                int[] indexs = indexHandle.getSumRangeIncreaseIndexs();
                if (param.getSpreadStyle() == 0) {
                    int colCount = this.getColCount(sheet, basePoint.y, basePoint.x);
                    i = 0;
                    while (i < colCount) {
                        cell = sheet.getRange(basePoint.y, i + 1 + basePoint.x);
                        if (cell == null) continue;
                        if (this.hasFormula(cell)) {
                            indexHandle.setSumFormula(indexs, true, i, 0);
                        }
                        ++i;
                    }
                } else {
                    int rowCount = this.getRowCount(sheet, basePoint.y, basePoint.x);
                    i = 0;
                    while (i < rowCount) {
                        cell = sheet.getRange(i + 1 + basePoint.y, basePoint.x);
                        if (cell == null) continue;
                        if (this.hasFormula(cell)) {
                            indexHandle.setSumFormula(indexs, false, i, 0);
                        }
                        ++i;
                    }
                }
                DynamicTemplateUtility.saveParametersToCell((Range)UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(basePoint.y, basePoint.x)), (DynaParameters)param);
            }
            return 0;
        }
        return 1;
    }

    private boolean verifyFillLineNumber() {
        boolean isRight = true;
        String fillLineNumberValue = "";
        if (this.tempSaveValue != null && !this.tempSaveValue.isEmpty()) {
            for (Map.Entry e : this.tempSaveValue.entrySet()) {
                NewValue mapValue = (NewValue)e.getValue();
                fillLineNumberValue = mapValue.getFillLineNumber();
                if (fillLineNumberValue == null) {
                    fillLineNumberValue = "";
                }
                if (fillLineNumberValue.equals("")) continue;
                if (PreNParamSetUI.isNumeric(fillLineNumberValue.toString())) {
                    int intFillLineNumberValue = Integer.parseInt(fillLineNumberValue);
                    if (intFillLineNumberValue > 0) continue;
                    isRight = false;
                    break;
                }
                isRight = false;
                break;
            }
        }
        if (!isRight) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"34_PreNParamSetUI"));
        }
        return isRight;
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void cmbSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        super.cmbSelectSheet_actionPerformed(e);
        String selectItem = (String)this.cmbSelectSheet.getSelectedItem();
        if (selectItem == null) {
            return;
        }
        this.showItems(selectItem);
    }

    private void showItems(String sheetName) throws SyntaxErrorException {
        this.tblMain.removeRows();
        this.fillData(sheetName);
    }

    private void fillData(String sheetName) throws SyntaxErrorException {
        if (!sheetName.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"30_PreNParamSetUI"))) {
            Sheet sheet = this.book.getSheet(sheetName);
            this.doFillData(sheet);
            return;
        }
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            Sheet sheet = this.book.getSheet(i);
            this.doFillData(sheet);
        }
    }

    private void doFillData(Sheet sheet) {
        if (this.tempSaveValue == null) {
            this.tempSaveValue = new HashMap();
        }
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        for (int j = 0; j < basePointList.size(); ++j) {
            Point basePoint = (Point)basePointList.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            IRow newRow = this.tblMain.addRow();
            newRow.getCell("sheetName").setValue((Object)sheet.getSheetName());
            newRow.getCell("basePointPosition").setValue((Object)this.convertPointTo(basePoint));
            newRow.getCell("sortRule").getStyleAttributes().setLocked(param.isGrade() || param.getDynaItemSource() == 0);
            Object[] colNames = this.getColumnNameByBasePoint(sheet, basePoint);
            KDTDefaultCellEditor sortBydce = new KDTDefaultCellEditor((JComboBox)new KDComboBox(colNames));
            newRow.getCell("sortBy").setEditor((ICellEditor)sortBydce);
            newRow.getCell("fillLineNumber").setEditor((ICellEditor)this.fillLineNumberdce);
            this.sortRuleDec = new KDTDefaultCellEditor((JComboBox)this.sortRule);
            newRow.getCell("sortRule").setEditor((ICellEditor)this.sortRuleDec);
            if (this.tempSaveValue.get(sheet.getSheetName() + ":;:" + this.convertPointTo(basePoint)) != null) {
                NewValue newValue = (NewValue)this.tempSaveValue.get(sheet.getSheetName() + ":;:" + this.convertPointTo(basePoint));
                if (newValue.getSortRule() != null) {
                    newRow.getCell("sortRule").setValue((Object)newValue.getSortRule());
                }
                if (newValue.getSortBy() != null) {
                    newRow.getCell("sortBy").setValue((Object)newValue.getSortBy());
                }
                if (newValue.getFillLineNumber() != null) {
                    newRow.getCell("fillLineNumber").setValue((Object)newValue.getFillLineNumber());
                }
                if (newValue.getSortRule().equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                    newRow.getCell("sortBy").setValue(null);
                    newRow.getCell("sortBy").getStyleAttributes().setLocked(true);
                    newRow.getCell("fillLineNumber").getStyleAttributes().setLocked(true);
                }
                if (newValue.getSubtotal() != null) {
                    newRow.getCell("subtotalRows").setValue((Object)newValue.getSubtotal());
                }
                if (newValue.getListItems() != null) {
                    newRow.getCell("listItems").setValue((Object)newValue.getListItems());
                }
            } else {
                int index;
                if (param.getFillLineNumber() == -1) {
                    newRow.getCell("fillLineNumber").setValue((Object)"");
                } else {
                    newRow.getCell("fillLineNumber").setValue((Object)String.valueOf(param.getFillLineNumber()));
                }
                if (param.getTopNSubtotal() == -1) {
                    newRow.getCell("subtotalRows").setValue((Object)"");
                } else {
                    newRow.getCell("subtotalRows").setValue((Object)String.valueOf(param.getTopNSubtotal()));
                }
                if (param.getDynaItemSource() == 0) {
                    newRow.getCell("listItems").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"DynaItemConfig_MANUAL"));
                } else if (param.getDynaItemSource() == 1) {
                    newRow.getCell("listItems").setValue((Object)param.getAssistantType().getProperityAlias());
                }
                String sortRuleString = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI");
                if (param.getOrderBy() != null) {
                    OrderByEnum orderRule = param.getOrderBy();
                    int value = orderRule.getValue();
                    switch (value) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            sortRuleString = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"28_PreNParamSetUI");
                            break;
                        }
                        case 3: {
                            sortRuleString = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"29_PreNParamSetUI");
                            break;
                        }
                    }
                }
                newRow.getCell("sortRule").setValue((Object)sortRuleString);
                if (sortRuleString.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                    newRow.getCell("sortBy").setValue(null);
                    newRow.getCell("sortBy").getStyleAttributes().setLocked(true);
                    newRow.getCell("fillLineNumber").getStyleAttributes().setLocked(true);
                    newRow.getCell("subtotalRows").getStyleAttributes().setLocked(true);
                }
                if ((index = param.getOrderRow() - 1) < 0) {
                    index = 0;
                } else if (index > colNames.length - 1) {
                    index = colNames.length - 1;
                }
                if (param.getSpreadStyle() == 0) {
                    ((KDComboBox)newRow.getCell("sortBy").getEditor().getComponent()).setSelectedIndex(((NewItem)colNames[index]).getIndex() - 1);
                    if (sortRuleString.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                        newRow.getCell("sortBy").setValue(null);
                    } else {
                        newRow.getCell("sortBy").setValue(colNames[index]);
                    }
                } else if (param.getSpreadStyle() == 1) {
                    if (sortRuleString.equals(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"27_PreNParamSetUI"))) {
                        newRow.getCell("sortBy").setValue(null);
                    } else if (index > 0) {
                        ((KDComboBox)newRow.getCell("sortBy").getEditor().getComponent()).setSelectedIndex(((NewItem)colNames[index]).getIndex() - 1);
                        newRow.getCell("sortBy").setValue(colNames[index]);
                    } else {
                        newRow.getCell("sortBy").setValue(colNames[0]);
                    }
                }
            }
            String mapKey = sheet.getSheetName() + ":;:" + this.convertPointTo(basePoint);
            NewValue mapValue = new NewValue((String)newRow.getCell("sortRule").getValue(), (NewItem)newRow.getCell("sortBy").getValue(), (String)newRow.getCell("fillLineNumber").getValue(), (String)newRow.getCell("subtotalRows").getValue(), (String)newRow.getCell("listItems").getValue());
            this.tempSaveValue.put(mapKey, mapValue);
        }
    }

    private int getRowCount(Sheet sheet, int top, int left) {
        int count = 0;
        int height = sheet.getRows().getMaxIntMark() + 1;
        for (int i = height - 1; i > top; --i) {
            Range range = sheet.getRange(i, left);
            if (!this.hasFormula(range)) continue;
            ++count;
        }
        return count;
    }

    private int getColCount(Sheet sheet, int top, int left) {
        int count = 0;
        int width = sheet.getCols().getMaxIntMark() + 1;
        for (int i = width - 1; i > left; --i) {
            Range range = sheet.getRange(top, i);
            if (!this.hasFormula(range)) continue;
            ++count;
        }
        return count;
    }

    private boolean hasFormula(Range range) {
        ItemFormula formula = (ItemFormula)range.getUserObject("ITEM");
        return formula != null;
    }
}

