/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.rpt.BalanceHint;
import com.kingdee.eas.fi.rpt.ConvertHint;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptBalanceFullHint;
import com.kingdee.eas.fi.rpt.RptConvertFullHint;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptBalanceWizardUI;
import com.kingdee.eas.fi.rpt.client.RptConvertWizardUI;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.FormulaConvertUtil;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportConverter {
    private final RptOperationSchemaComp schema;
    private final Book book;
    static HashMap tempRemoveSheet = new HashMap();
    static HashMap removeSheets = new HashMap();

    public ReportConverter(Book book, RptOperationSchemaComp schema) {
        this.book = book;
        this.schema = schema;
    }

    public static RptBalanceWizardUI getReportBalanceWizardUI(CoreUIObject parent, final RptOperationSchemaComp operationSchema) throws Exception {
        RptBalanceWizardUI wizard = RptBalanceWizardUI.getInstance((CoreUIObject)parent);
        wizard.addSimpleDialogListener((ISimpleDialogListener)new IControlledDialogListener(){

            public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
                if (!isOk || result == null) {
                    return;
                }
                operationSchema.setBlHints((RptBalanceFullHint)result);
            }

            public Object getTrueController() {
                return null;
            }

            public void pilotSetout(ISimpleDialog source) {
            }
        });
        return wizard;
    }

    public static void doReportBalance(IUIObject owner, Book theBook, String designUI) throws Exception {
        removeSheets = new HashMap();
        tempRemoveSheet = new HashMap();
        BookProperties properties = BookProperties.loadFromBook((Book)theBook);
        ReportVariables oldVariables = properties.getVariables().copy();
        RptOperationSchemaComp operationSchema = properties.getOperationSchema();
        Book book = null;
        if (operationSchema == null || operationSchema.getBlHints() == null) {
            return;
        }
        book = operationSchema.getBlHints().cvMode == 2 ? SpreadHelper.copyBook(theBook) : theBook;
        if (operationSchema.getBlHints().cvMode == 2) {
            ReportDesignerUI reportDesignerUI;
            IObjectValue editValue = null;
            Object savepointForNewRpt = null;
            if (owner instanceof ReportDesignerUI && (reportDesignerUI = (ReportDesignerUI)owner).getBookProvider() != null) {
                IObjectValue cloneEditValue = reportDesignerUI.getBookProvider().getEditValue();
                reportDesignerUI.getBookProvider().setEditValue(null);
                editValue = reportDesignerUI.getBookProvider().createNewReport();
                if (((ReportBaseInfo)editValue).getCurrency() == null && cloneEditValue != null) {
                    ((ReportBaseInfo)editValue).setCurrency(((ReportBaseInfo)cloneEditValue).getCurrency());
                }
                if (cloneEditValue instanceof ReportBaseInfo) {
                    if (((ReportBaseInfo)cloneEditValue).getCompany() != null) {
                        ((ReportBaseInfo)editValue).setCompany(((ReportBaseInfo)cloneEditValue).getCompany());
                    }
                    ((ReportBaseInfo)editValue).setPeriodType(((ReportBaseInfo)cloneEditValue).getPeriodType());
                    ((ReportBaseInfo)editValue).setPeriod(((ReportBaseInfo)cloneEditValue).getPeriod());
                    ((ReportBaseInfo)editValue).setYear(((ReportBaseInfo)cloneEditValue).getYear());
                }
                reportDesignerUI.getBookProvider().setEditValue(cloneEditValue);
                editValue.put("savepoint", cloneEditValue.get("savepoint"));
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("Owner", owner);
            context.put("INIT_BOOK", book);
            context.put("InitDataObject", editValue);
            context.put("isFromBalance", true);
            if (savepointForNewRpt != null) {
                context.put("savepoint", savepointForNewRpt);
            }
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(designUI, context, null, OprtState.COPYADDNEW);
            ReportConverter cr = new ReportConverter(book, operationSchema);
            book.calc();
            cr.doReportBalance();
            window.show();
        } else {
            ReportConverter cr = new ReportConverter(book, operationSchema);
            cr.doReportBalance();
            book.calc();
        }
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        variables.addAll(oldVariables, false);
        variables.storeToBook(book);
    }

    public static void doReportConvert(IUIObject owner, Book theBook, String designUI) throws Exception {
        BookProperties properties = BookProperties.loadFromBook((Book)theBook);
        ReportVariables oldVariables = properties.getVariables().copy();
        RptOperationSchemaComp operationSchema = properties.getOperationSchema();
        Book book = null;
        if (operationSchema == null || operationSchema.getCvHints() == null) {
            return;
        }
        book = operationSchema.getCvHints().cvMode == 2 ? SpreadHelper.copyBook(theBook, null, false, true) : theBook;
        if (operationSchema.getCvHints().cvMode == 2) {
            ReportDesignerUI reportDesignerUI;
            IObjectValue editValue = null;
            if (owner instanceof ReportDesignerUI && (reportDesignerUI = (ReportDesignerUI)owner).getBookProvider() != null) {
                editValue = reportDesignerUI.getBookProvider().getEditValue();
                IObjectValue cloneObj = (IObjectValue)editValue.getClass().newInstance();
                cloneObj.putAll(editValue);
                cloneObj.put("id", null);
                cloneObj.put("number", null);
                cloneObj.put("cslReport", null);
                String desCurrencyNum = operationSchema.getCvHints().desAbbrNumber;
                CoreBaseInfo desCurrency = CurrencyFactory.getRemoteInstance().getValue(" where number = '" + desCurrencyNum + "'");
                cloneObj.put("currency", (Object)desCurrency);
                cloneObj.put("convertStatus", (Object)ConvertStatusEnum.Converted);
                editValue = cloneObj;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("Owner", owner);
            context.put("INIT_BOOK", book);
            context.put("InitDataObject", editValue);
            context.put("isFromConvt", Boolean.TRUE);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(designUI, context, null, OprtState.COPYADDNEW);
            ReportConverter cr = new ReportConverter(book, operationSchema);
            cr.doReportConvert();
            window.show();
        } else {
            ReportConverter cr = new ReportConverter(book, operationSchema);
            cr.doReportConvert();
            book.calc();
        }
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        variables.addAll(oldVariables, false);
        variables.storeToBook(book);
    }

    public static RptConvertWizardUI getReportConvertWizardUI(CoreUIObject parent, final RptOperationSchemaComp operationSchema) throws Exception {
        IObjectValue editValue;
        ReportDesignerUI reportDesignerUI;
        if (parent instanceof ReportDesignerUI && (reportDesignerUI = (ReportDesignerUI)parent).getBookProvider() != null && (editValue = reportDesignerUI.getBookProvider().getEditValue()) != null && editValue.containsKey("currency")) {
            parent.getUIContext().put("Convert.SrcCurrency", editValue.get("currency"));
        }
        RptConvertWizardUI wizard = RptConvertWizardUI.getInstance((CoreUIObject)parent);
        wizard.addSimpleDialogListener((ISimpleDialogListener)new IControlledDialogListener(){

            public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
                if (!isOk || result == null) {
                    return;
                }
                operationSchema.setCvHints((RptConvertFullHint)result);
            }

            public Object getTrueController() {
                return null;
            }

            public void pilotSetout(ISimpleDialog source) {
            }
        });
        return wizard;
    }

    public void doReportConvert() throws Exception {
        RptConvertFullHint blHints = this.schema.getCvHints();
        this.convert((RptBalanceFullHint)blHints);
        this.balance(blHints.baHint, blHints.cvMode);
    }

    public void doReportBalance() throws Exception {
        RptBalanceFullHint blHints = this.schema.getBlHints();
        this.convert(blHints);
        this.balance(blHints.baHint, blHints.cvMode);
    }

    private void convert(RptBalanceFullHint blHints) throws Exception {
        if (blHints == null || blHints.cvHint == null || blHints.cvHint.size() < 1) {
            return;
        }
        Iterator ht = blHints.cvHint.iterator();
        HashMap<String, Sheet> convertedSheets = null;
        if (blHints.cvMode == 0) {
            convertedSheets = new HashMap<String, Sheet>();
        }
        String srcSheetName = null;
        Sheet activeSheet = this.book.getActiveSheet();
        String currentSheetName = activeSheet.getSheetName();
        Locale locale = SysContext.getSysContext().getLocale();
        while (ht.hasNext()) {
            ConvertHint h = (ConvertHint)ht.next();
            if (h.sheetName != null && h.sheetName.size() > 0) {
                Iterator it = h.sheetName.iterator();
                while (it.hasNext()) {
                    if (!StringUtils.isEmpty((String)((String)it.next()))) continue;
                    it.remove();
                }
            }
            boolean hasDefinedSheet = h.sheetName != null && h.sheetName.size() >= 1;
            int j = hasDefinedSheet ? h.sheetName.size() : 1;
            for (int i = 0; i < j; ++i) {
                srcSheetName = hasDefinedSheet ? (String)h.sheetName.get(i) : currentSheetName;
                Sheet sheet = null;
                if (blHints.cvMode == 0) {
                    sheet = (Sheet)convertedSheets.get(srcSheetName);
                }
                if (sheet == null) {
                    sheet = this.prepareSheetForConvert(activeSheet, hasDefinedSheet, blHints.cvMode, srcSheetName);
                }
                if (sheet == null) continue;
                this.convertTable(sheet, h, blHints.cvMode, locale);
                if (blHints.cvMode != 0) continue;
                convertedSheets.put(srcSheetName, sheet);
            }
        }
    }

    private void balance(Collection hints, int t) throws Exception {
        if (hints == null) {
            return;
        }
        Iterator it = hints.iterator();
        while (it.hasNext()) {
            this.initSheet((BalanceHint)it.next(), t);
        }
        it = hints.iterator();
        Locale locale = SysContext.getSysContext().getLocale();
        while (it.hasNext()) {
            this.balanceOneExpression((BalanceHint)it.next(), t, locale);
        }
    }

    private String exp(String exp, int t, Locale locale) {
        if (t == 0) {
            String newName;
            Sheet s;
            for (String oldName : removeSheets.keySet()) {
                s = (Sheet)removeSheets.get(oldName);
                newName = s.getSheetName();
                exp = this.replaceexp(exp, oldName + "!", "'" + newName + "'!", locale);
            }
            for (String oldName : tempRemoveSheet.keySet()) {
                s = (Sheet)tempRemoveSheet.get(oldName);
                newName = s.getSheetName();
                exp = this.replaceexp(exp, oldName + "!", "'" + newName + "'!", locale);
            }
        }
        return exp;
    }

    private String replaceexp(String exp, String old, String newS, Locale locale) {
        String src = exp.toUpperCase(locale);
        int curIndex = 0;
        int copyIndex = src.indexOf(old.toUpperCase(locale));
        if (copyIndex == -1) {
            return exp;
        }
        StringBuffer buf = new StringBuffer();
        while (curIndex < exp.length()) {
            if (copyIndex != -1) {
                if (curIndex < copyIndex) {
                    buf.append(exp.charAt(curIndex));
                    ++curIndex;
                    continue;
                }
                curIndex += old.length();
                buf.append(newS);
                copyIndex = src.indexOf(old.toUpperCase(locale), copyIndex + 1);
                continue;
            }
            buf.append(exp.charAt(curIndex));
            ++curIndex;
        }
        return buf.toString();
    }

    private Sheet getSheet(String name, HashMap map) {
        Sheet res = null;
        for (String sheetName : map.keySet()) {
            if (!sheetName.equalsIgnoreCase(name)) continue;
            res = (Sheet)map.get(sheetName);
            break;
        }
        return res;
    }

    void initSheet(BalanceHint hint, int t) throws Exception {
        if (hint.base.sheetName != null && hint.base.sheetName.trim().length() > 0) {
            Sheet res = this.getSheet(hint.base.sheetName, removeSheets);
            if (res != null) {
                return;
            }
            if (t == 0) {
                res = this.book.getSheet(hint.base.sheetName);
                if (res == null) {
                    return;
                }
                res = SpreadHelper.copySheet(this.book, res);
                String sheetName = res.getSheetName();
                this.book.addSheet(res, false);
                tempRemoveSheet.put(sheetName, res);
            }
        }
    }

    Sheet[] getBlanceSheet(BalanceHint hint, int t) throws Exception {
        ArrayList<Sheet> sheets;
        block5: {
            block6: {
                block2: {
                    block3: {
                        Sheet s;
                        block4: {
                            sheets = new ArrayList<Sheet>();
                            if (t != 0) break block2;
                            if (hint.base.sheetName == null || hint.base.sheetName.trim().length() <= 0) break block3;
                            s = this.getSheet(hint.base.sheetName, removeSheets);
                            if (s == null) break block4;
                            sheets.add(s);
                            break block5;
                        }
                        s = this.getSheet(hint.base.sheetName, tempRemoveSheet);
                        if (s == null) break block5;
                        sheets.add(s);
                        break block5;
                    }
                    for (Sheet s : removeSheets.values()) {
                        sheets.add(s);
                    }
                    break block5;
                }
                if (hint.base.sheetName == null || hint.base.sheetName.trim().length() <= 0) break block6;
                Sheet s = this.book.getSheet(hint.base.sheetName);
                if (s == null) break block5;
                sheets.add(s);
                break block5;
            }
            for (Sheet s : removeSheets.values()) {
                sheets.add(s);
            }
        }
        return sheets.toArray(new Sheet[sheets.size()]);
    }

    private void balanceOneExpression(BalanceHint hint, int t, Locale locale) throws Exception {
        if (hint == null || hint.base == null || hint.base.region == null || hint.expression == null) {
            return;
        }
        Sheet[] sheets = this.getBlanceSheet(hint, t);
        if (sheets == null || sheets.length == 0) {
            return;
        }
        for (int i = 0; i < sheets.length; ++i) {
            Sheet sheet = sheets[i];
            if (sheet == null) continue;
            Rect rt = hint.base.region.normalize();
            int x = rt.x1 >= 0 ? rt.x1 : rt.x2;
            int y = rt.y1 >= 0 ? rt.y1 : rt.y2;
            String expr = "=" + this.exp(hint.expression, t, locale);
            Variant variant = sheet.calcFormula(expr);
            Cell cell = sheet.getCell(y, x, true);
            cell.setFormula(expr);
            cell.setValue(variant);
        }
    }

    private String parseFormula(Sheet sheet, String bfConvertFm, char OPER, String rt) {
        if (!StringUtils.isEmpty((String)bfConvertFm)) {
            if (bfConvertFm.charAt(0) != '=') {
                bfConvertFm = "=" + bfConvertFm;
            }
            if (BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)bfConvertFm)) {
                return bfConvertFm;
            }
        }
        String[] formulas1 = bfConvertFm.substring(1).split("-");
        String[] formulas2 = null;
        StringBuffer newFormula = new StringBuffer("=");
        String formulaStr = null;
        for (int i = 0; i < formulas1.length; ++i) {
            formulas2 = formulas1[i].split("\\+");
            boolean isNull = true;
            for (int j = 0; j < formulas2.length; ++j) {
                formulaStr = formulas2[j];
                if (formulaStr == null || StringUtils.isEmpty((String)formulaStr)) continue;
                isNull = false;
                if (BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)("=" + formulaStr))) {
                    newFormula.append(formulaStr);
                } else {
                    newFormula.append(formulaStr + OPER + rt);
                }
                if (j == formulas2.length - 1) continue;
                newFormula.append("+");
            }
            if (i == formulas1.length - 1 || isNull) continue;
            newFormula.append("-");
        }
        if (newFormula.charAt(newFormula.length() - 1) == '-') {
            return newFormula.substring(0, newFormula.length() - 1);
        }
        return newFormula.toString();
    }

    private void convertTable(Sheet sheet, ConvertHint h, int mode, Locale locale) {
        BigDecimal rt;
        if (sheet == null || h.region == null || h.rate == 0.0) {
            return;
        }
        int rateScale = (rt = new BigDecimal(Double.toString(h.rate))).scale();
        rt = rt.setScale(rateScale > h.decimal ? rateScale : h.decimal, 4);
        int max_x = sheet.getMaxColIndex();
        int max_y = sheet.getMaxRowIndex();
        Rect rect = new Rect(h.region);
        if (h.isAllTable) {
            rect.x1 = 0;
            rect.y1 = 0;
            rect.x2 = max_x;
            rect.y2 = max_y;
        } else {
            rect.format(0, 0, max_x, max_y);
        }
        Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(rect.y1, rect.x1, rect.y2, rect.x2, false, true);
        while (cellsIterator.hasNext()) {
            Variant value;
            String fm;
            String bfConvertFm;
            Cell cell;
            try {
                cell = cellsIterator.next();
            }
            catch (NullPointerException e1) {
                break;
            }
            boolean hasProtected = false;
            try {
                Protection protection = cell.getSheet().getSheetOption().getProtection(false);
                if (protection != null) {
                    hasProtected = protection.isProtected();
                }
            }
            catch (Exception protection) {
                // empty catch block
            }
            if (cell.isLocked() && hasProtected && mode == 1) continue;
            char OPER = '*';
            if (h.operation == 0) {
                OPER = '/';
            }
            if ((bfConvertFm = this.beforeConvertFormula(fm = cell.getFormula())) != null && bfConvertFm.length() > 1 && bfConvertFm.charAt(0) == '=') {
                block27: {
                    try {
                        bfConvertFm = FormulaConvertUtil.convert((String)bfConvertFm, (char)OPER, (String)rt.toString());
                    }
                    catch (Exception e) {
                        if (bfConvertFm.toUpperCase().startsWith("=ROUND(")) break block27;
                        bfConvertFm = this.parseFormula(sheet, bfConvertFm, OPER, rt.toString());
                    }
                }
                String afterTreatFm = this.afterTreatFormula(fm, bfConvertFm);
                if (!Variant.isNull((Variant)cell.getValue()) && cell.getValue().isNumber()) {
                    StringBuffer newFormula = new StringBuffer();
                    if (afterTreatFm.toUpperCase(locale).startsWith("=ROUND(")) {
                        newFormula.append(afterTreatFm.toString().substring(0, afterTreatFm.toString().lastIndexOf(",") + 1)).append(h.decimal).append(")");
                    } else {
                        newFormula.append(afterTreatFm.replaceFirst("=", "=ROUND(")).append(",").append(h.decimal).append(")");
                    }
                    afterTreatFm = newFormula.toString();
                }
                cell.setFormula(afterTreatFm);
            }
            if (Variant.isNull((Variant)(value = cell.getValue())) || value == null) continue;
            BigDecimal val = null;
            try {
                val = value.toBigDecimal();
            }
            catch (SyntaxErrorException e) {
                continue;
            }
            int sc = val.scale();
            if (sc < h.decimal) {
                sc = h.decimal;
                val = val.setScale(sc);
            }
            if (h.operation == 0) {
                val = val.divide(rt, 4);
                val = val.setScale(h.decimal, 4);
            } else {
                val = val.multiply(rt);
                val = val.setScale(h.decimal, 4);
            }
            cell.setValue(new Variant((Object)val));
            StringBuffer decimaString = new StringBuffer("0");
            for (int i = 0; i < h.decimal; ++i) {
                if (i == 0) {
                    decimaString.append(".");
                }
                decimaString.append("0");
            }
            StyleAttributes sa = Styles.getEmptySA();
            String oldFormat = cell.getSSA().getNumberFormat();
            if (!StringUtils.isEmpty((String)oldFormat) && oldFormat.indexOf("0.") > 0) {
                this.setNewNumberFormat(oldFormat, "0.", sa, decimaString);
            } else if (!StringUtils.isEmpty((String)oldFormat) && oldFormat.indexOf("#.") > 0) {
                this.setNewNumberFormat(oldFormat, "#.", sa, decimaString);
            } else {
                sa.setNumberFormat(decimaString.toString() + ";-" + decimaString.toString());
            }
            sheet.getRange(cell).setStyle(sa, Styles.getEmptySA());
        }
    }

    private void setNewNumberFormat(String oldFormat, String splitSign, StyleAttributes sa, StringBuffer decimaString) {
        int index = oldFormat.indexOf(splitSign);
        index += 2;
        int length = oldFormat.length();
        String sub = splitSign;
        while (index < length && oldFormat.charAt(index) == '0') {
            ++index;
            sub = sub + "0";
        }
        oldFormat = oldFormat.replaceAll(sub, decimaString.toString());
        sa.setNumberFormat(oldFormat);
    }

    private String beforeConvertFormula(String fm) {
        String result = null;
        String regEx = "=\\(*-\\(*([a-z]|[A-Z])";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(fm);
        boolean rs = mat.find();
        if (rs) {
            String prepareFormularForHandle;
            String firstPartBeforeReplace = mat.group(0);
            String secondPart = fm.split(regEx)[1];
            String firstPartAfterReplacee = mat.group(0).replace("-", "");
            result = prepareFormularForHandle = firstPartAfterReplacee + secondPart;
        } else {
            result = fm.substring(0, fm.length());
        }
        return result;
    }

    private String afterTreatFormula(String fm, String fmAfterPrepare) {
        String result = null;
        String regEx = "=\\(*-\\(*([a-z]|[A-Z])";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(fm);
        boolean rs = mat.find();
        result = rs ? fmAfterPrepare.substring(0, fmAfterPrepare.indexOf(61) + 1) + "-" + fmAfterPrepare.substring(fmAfterPrepare.indexOf(61) + 1, fmAfterPrepare.length()) : fmAfterPrepare;
        return result;
    }

    private Sheet prepareSheetForConvert(Sheet base, boolean hasDefinedSheet, int outputMode, String srcSheetName) throws Exception {
        if (base == null) {
            return null;
        }
        boolean holder = this.schema.isNotifyOnSheetChanged();
        this.schema.setNotifyOnSheetChanged(false);
        Sheet res = this.book.getSheet(srcSheetName);
        if (res != null && outputMode == 0) {
            res = SpreadHelper.copySheet(this.book, res, true);
            String newName = this.book.getNewSheetName(res.getSheetName(), true);
            res.setName(newName);
            this.book.addSheet(res, false);
            for (int i = 0; i < this.book.getSheetCount(); ++i) {
                this.book.getSheet(i).getSheetOption().setSelected(false);
            }
            this.book.activeSheet(res);
        }
        removeSheets.put(srcSheetName, res);
        this.schema.setNotifyOnSheetChanged(holder);
        return res;
    }

    int getSheetIndex(Sheet sheet, Book b) {
        for (int i = 0; i < b.getSheetCount(); ++i) {
            if (!b.getSheet(i).getSheetName().equals(sheet.getSheetName())) continue;
            return i;
        }
        return 0;
    }
}

