/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class ReportMenuManager {
    private List menuBars = new ArrayList(2);
    private Map menus = new HashMap(2);

    public void addMenuBar(JMenuBar mbar) {
        this.menuBars.add(mbar);
    }

    public void addMenu(JMenu menu) {
        this.menus.put(menu.getName(), menu);
    }

    public Component findMenuUsingPath(String path) {
        Component menu = null;
        String[] paths = path.split("/");
        for (int x = 0; x < this.menuBars.size(); ++x) {
            menu = (Component)this.menuBars.get(x);
            for (int i = 0; i < paths.length; ++i) {
                menu = this.match(paths[i], menu);
            }
            if (menu != null) break;
        }
        if (menu == null) {
            menu = (Component)this.menus.get(paths[0]);
            for (int i = 1; i < paths.length; ++i) {
                menu = this.match(paths[i], menu);
            }
        }
        return menu;
    }

    public Action findActionUsingMenuPath(String path) {
        Component comp = this.findMenuUsingPath(path);
        if (comp instanceof AbstractButton) {
            return ((AbstractButton)comp).getAction();
        }
        return null;
    }

    public Component enableVisibleMenu(String path, boolean visibleMenu, boolean enableAction) {
        Component comp = this.findMenuUsingPath(path);
        if (comp == null) {
            return null;
        }
        if (comp instanceof AbstractButton) {
            this.enableMenu(comp, enableAction);
        }
        if (comp.isVisible() != visibleMenu) {
            comp.setVisible(visibleMenu);
        }
        return comp;
    }

    private Component match(String name, Component menu) {
        try {
            if (menu == null) {
                return null;
            }
            if (menu instanceof JMenuBar) {
                JMenuBar menuBar = (JMenuBar)menu;
                for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                    if (!name.equalsIgnoreCase(menuBar.getMenu(i).getName())) continue;
                    return menuBar.getMenu(i);
                }
            } else if (menu instanceof JMenu) {
                JMenu m = (JMenu)menu;
                for (int i = 0; i < m.getMenuComponentCount(); ++i) {
                    if (!name.equalsIgnoreCase(m.getMenuComponent(i).getName())) continue;
                    return m.getMenuComponent(i);
                }
            } else if (name.equalsIgnoreCase(menu.getName())) {
                return menu;
            }
            return null;
        }
        catch (Throwable a) {
            return null;
        }
    }

    public Component enableVisibleAllMenu(String path, boolean visibleMenu, boolean enableAction) {
        Component comp = this.findMenuUsingPath(path);
        this.enableVisibleChild(comp, visibleMenu, enableAction);
        return comp;
    }

    private void enableVisibleChild(Component menu, boolean visibleMenu, boolean enableAction) {
        if (menu instanceof JMenu) {
            JMenu m = (JMenu)menu;
            for (int i = 0; i < m.getMenuComponentCount(); ++i) {
                Component sub = m.getMenuComponent(i);
                this.enableVisibleChild(sub, visibleMenu, enableAction);
            }
        } else if (menu instanceof AbstractButton) {
            this.enableMenu(menu, enableAction);
        }
        if (menu != null && menu.isVisible() != visibleMenu) {
            menu.setVisible(visibleMenu);
        }
    }

    private void enableMenu(Component menu, boolean enableAction) {
        Action action = ((AbstractButton)menu).getAction();
        if (action != null && action.isEnabled() != enableAction) {
            action.setEnabled(enableAction);
        } else if (menu.isEnabled() != enableAction && !(menu instanceof JMenu)) {
            menu.setEnabled(enableAction);
        }
    }
}

