/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.newrpt.client.designer.SheetManagerListener;
import com.kingdee.eas.fi.newrpt.client.designer.SheetManagerUI;
import com.kingdee.eas.fi.newrpt.client.designer.event.VariableChangeEvent;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportSheetManagerListener
implements SheetManagerListener {
    private Book _book;
    private BookProperties properties;
    private List sheets;

    public ReportSheetManagerListener(Book book) {
        this._book = book;
        this.properties = BookProperties.loadFromBook((Book)this._book);
    }

    protected Book getBook() {
        return this._book;
    }

    protected void applySheets(List sheets) {
        this.sheets = sheets;
        this._book.startGroup();
        try {
            this.doRemove(sheets);
            this.preProcessSheetReName(sheets);
            this.doInsert(sheets);
            this.doEdit(sheets);
            this.doSheetSort(sheets);
        }
        finally {
            this._book.endGroup();
        }
    }

    private void preProcessSheetReName(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            if (e.inserted() || !e.edited()) continue;
            e.setEdit();
            String old = e.getOriginalSheetName();
            String nwe = e.getSheetName();
            if (!old.equals(nwe)) {
                if (this._book.getSheet(nwe) != null) {
                    return;
                }
                this._book.getSheet(old).setName(nwe);
                e.setOriginalSheetName(nwe);
            }
            e.setDummy(false);
            e.setUnEdit();
        }
    }

    private void doSheetSort(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            Sheet sheet;
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            e.setNone();
            if (e.getSheetName().equalsIgnoreCase(this._book.getSheet(i).getSheetName()) || (sheet = this._book.getSheet(e.getSheetName())) == null) continue;
            int target = sheet.getIntMark();
            this._book.exchangeSheetIndex(i, target);
        }
    }

    private void doInsert(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            if (e.isDummy() || !e.inserted()) continue;
            e.setOriginalSheetName(e.getSheetName());
            this._book.addSheet(new Sheet(this._book, e.getSheetName()), false);
        }
    }

    private void doEdit(List sheets) {
        HashMap<String, SheetManagerUI.SheetPropertyEntry> appending = new HashMap<String, SheetManagerUI.SheetPropertyEntry>(sheets.size());
        for (int i = 0; i < sheets.size(); ++i) {
            Sheet exists;
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            boolean ok = this.editSheet(e);
            if (ok || (exists = this._book.getSheet(e.getOriginalSheetName())) == null) continue;
            String tempName = e.getOriginalSheetName() + e.getSheetName() + i;
            exists.setName(tempName);
            appending.put(tempName, e);
        }
        for (Map.Entry en : appending.entrySet()) {
            String name = (String)en.getKey();
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)en.getValue();
            e.setOriginalSheetName(name);
            this.editSheet(e);
        }
    }

    private boolean editSheet(SheetManagerUI.SheetPropertyEntry e) {
        String nwe;
        String old;
        if (e.isDummy() || e.deleted()) {
            return true;
        }
        if (!e.inserted() && e.edited() && !(old = e.getOriginalSheetName()).equals(nwe = e.getSheetName())) {
            if (this._book.getSheet(nwe) != null) {
                return false;
            }
            this._book.getSheet(old).setName(nwe);
            e.setOriginalSheetName(nwe);
        }
        if (e.isHidden()) {
            this._book.hideSheet(e.getSheetName());
        } else {
            this._book.unhideSheet(e.getSheetName());
        }
        return true;
    }

    private SheetManagerUI.SheetPropertyEntry findOrig(String origName) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)this.sheets.get(i);
            if (e.isDummy() || e.deleted() || !origName.equalsIgnoreCase(e.getOriginalSheetName())) continue;
            return e;
        }
        return null;
    }

    private void doRemove(List sheets) {
        Iterator iter = sheets.iterator();
        while (iter.hasNext()) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)iter.next();
            if (e.isDummy() || !e.deleted()) continue;
            if (!e.inserted()) {
                this._book.removeSheet(e.getSheetName());
                this.properties.notifyDeleteSheet(e.getSheetName());
            }
            iter.remove();
        }
    }

    protected void applyVariables(VariableChangeEvent e, ReportVariables variables) {
        ReportVariables tempReportVariables = new ReportVariables();
        for (int i = 0; i < variables.size(); ++i) {
            VariableEntry ve = variables.get(i);
            VariableEntry entry = tempReportVariables.get(ve.getName(), ve.getSheetName());
            if (entry != null && entry != ve) {
                if (ve.isReserved()) {
                    variables.remove(ve);
                    continue;
                }
                e.setMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.rptVar"));
                e.setCancel(true);
                return;
            }
            tempReportVariables.add(ve);
        }
        variables.storeToBook(this._book);
    }

    @Override
    public void applyChange(VariableChangeEvent e) {
        this.applySheets(e.getSheets());
        this.applyVariables(e, e.getReportVariables());
    }
}

