/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.dynamic.client.DynaItemWizardUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateCoverUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.TemplateRenewableReport;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.RptCompanyFillWizard;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.awt.Point;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class ReportStyleCover {
    private static final Logger logger = CoreUIObject.getLogger(ReportStyleCover.class);
    private TemplateRenewableReport report;
    private TemplateInfo oldTemplate;
    private TemplateCollection availableTemplates;
    private Boolean canUpdate;
    private boolean isInitialized = false;
    private boolean isGroupRpt;
    private IMenuStrategy menuStrategy;
    private BOSUuid oldTemplateId;
    private SpreadContext ctx;
    ReportDesignerUI ui;
    private boolean isSupportUpdate = true;

    public void setGroupRpt(boolean isGroupRpt) {
        this.isGroupRpt = isGroupRpt;
    }

    public void initialize(TemplateRenewableReport report, SpreadContext _ctx, ReportDesignerUI _ui) throws Exception {
        this.oldTemplateId = report.getOldTemplate().getId();
        this.refreshOldTemplate(report);
        this.report = report;
        this.isInitialized = true;
        this.ctx = _ctx;
        this.ui = _ui;
    }

    public void refresh(TemplateRenewableReport report, SpreadContext _ctx, ReportDesignerUI _ui) throws Exception {
        this.report = report;
        this.refreshOldTemplate();
        this.ctx = _ctx;
        this.ui = _ui;
        this.availableTemplates = null;
        this.setCanUpdate(null);
        boolean enable = this.enableCover();
        this.canUpdate = new Boolean(enable);
        if (this.menuStrategy == null) {
            throw new NullPointerException();
        }
        this.menuStrategy.enableVisibleMenu("menuStyle/menuCoverReport", true, enable);
    }

    private void refreshOldTemplate() throws Exception {
        TemplateInfo template = new TemplateInfo();
        template.setId(this.oldTemplateId);
        TemplateCollection effectedTemplateCollection = new TemplateCollection();
        effectedTemplateCollection.add(template);
        effectedTemplateCollection = this.SelectNeedFields(effectedTemplateCollection);
        if (effectedTemplateCollection == null || effectedTemplateCollection.size() == 0) {
            throw new Exception("template deleted!");
        }
        this.oldTemplate = effectedTemplateCollection.get(0);
    }

    private Book lockBookExpTank(Book book, TemplateInfo template) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)RptUtilForClient.getCurrentCompany().getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)template.getId().toString()));
        SorterItemInfo sorti = new SorterItemInfo("createTime");
        sorti.setSortType(SortType.DESCEND);
        view.getSorter().add(sorti);
        CoreBaseCollection c = TempletDispenseFactory.getRemoteInstance().getCollection(view);
        if (c != null && c.size() > 0) {
            if (!((TempletDispenseInfo)c.get(0)).isIsAllwChgCheckSol()) {
                return RptUtilForClient.LockBookExpTank((Book)book);
            }
        } else {
            return RptUtilForClient.LockBookExpTank((Book)book);
        }
        return book;
    }

    private void refreshOldTemplate(TemplateRenewableReport report) throws Exception {
        TemplateCollection effectedTemplateCollection = new TemplateCollection();
        if (report.getOldTemplate() == null) {
            this.canUpdate = new Boolean(false);
            return;
        }
        effectedTemplateCollection.add(report.getOldTemplate());
        effectedTemplateCollection = this.SelectNeedFields(effectedTemplateCollection);
        if (effectedTemplateCollection == null || effectedTemplateCollection.size() == 0) {
            throw new Exception("template deleted!");
        }
        this.oldTemplate = effectedTemplateCollection.get(0);
    }

    public abstract TemplateCollection GetCanUseTemplateSet() throws Exception;

    public void doCoverStyle(boolean isCoverformula) throws Exception {
        if (!this.enableCover()) {
            return;
        }
        TemplateCollection templates = this.getAvailableTemplates();
        if (templates == null || templates.size() == 0) {
            return;
        }
        if (this.hasNewTemplate()) {
            this.changeToNewestTemplate(this.getNewTemplate(), isCoverformula);
            if (this.menuStrategy == null) {
                throw new NullPointerException();
            }
            this.canUpdate = new Boolean(false);
        }
    }

    public boolean enableCover() throws Exception {
        if (this.canUpdate == null) {
            AuditedStatusEnum ad;
            RptSrcTypeEnum st = this.report.getReportSourceType();
            int dynaRptType = -1;
            try {
                dynaRptType = this.oldTemplate.getDynaRptType().getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (st.getValue() == 1 && this.report instanceof ReportInfo && !this.isGroupRpt || st.getValue() == 6 || (st.getValue() == 11 || st.getValue() == 12 || st.getValue() == 8) && dynaRptType == 2 || st.getValue() == 4) {
                this.canUpdate = new Boolean(false);
                if (dynaRptType == 2) {
                    this.setSupportUpdate(false);
                }
                if (st.getValue() == 1 && this.report instanceof ReportInfo && !this.oldTemplate.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE)) {
                    this.setSupportUpdate(false);
                }
                if (!this.oldTemplate.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE)) {
                    return false;
                }
            }
            if ((ad = this.report.getReportAuditedStatus()).getValue() == 2) {
                this.canUpdate = new Boolean(false);
                return false;
            }
            TemplateCollection list = this.getAvailableTemplates();
            if (list == null || list.size() == 0) {
                this.canUpdate = new Boolean(false);
                return false;
            }
            if (this.hasNewTemplate()) {
                this.canUpdate = new Boolean(true);
                return true;
            }
            this.canUpdate = new Boolean(false);
            return false;
        }
        return this.canUpdate;
    }

    private TemplateCollection SelectNeedFields(TemplateCollection list) throws BOSException {
        if (list == null || list.size() == 0) {
            return list;
        }
        if (!StringUtils.isEmpty((String)list.get(0).getVersionNumber())) {
            return list;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("versionNumber"));
        view.getSelector().add(new SelectorItemInfo("dynaRptType"));
        view.getSelector().add(new SelectorItemInfo("group"));
        view.getSelector().add(new SelectorItemInfo("templateType"));
        view.setFilter(new FilterInfo());
        if (list.size() == 1) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)list.get(0).getId().toString()));
        } else {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < list.size(); ++i) {
                set.add(list.get(i).getId().toString());
            }
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return TemplateFactory.getRemoteInstance().getTemplateCollection(view);
    }

    private boolean hasNewTemplate() throws Exception {
        TemplateInfo oldTemp = this.getOldTemplate();
        TemplateInfo newestTemplate = this.getSameGroupTemplate();
        if (newestTemplate != null) {
            String[] v2;
            if (newestTemplate.getId().equals((Object)oldTemp.getId())) {
                return false;
            }
            String[] v1 = newestTemplate.getVersionNumber().split("\\.");
            int count = v1.length < (v2 = oldTemp.getVersionNumber().split("\\.")).length ? v1.length : v2.length;
            for (int i = 0; i < count; ++i) {
                if (Integer.parseInt(v1[i]) <= Integer.parseInt(v2[i])) continue;
                return true;
            }
            return v1.length > v2.length;
        }
        return false;
    }

    private TemplateInfo getSameGroupTemplate() throws Exception {
        TemplateInfo oldRptTemplate = this.getOldTemplate();
        if (oldRptTemplate.getGroup() == null) {
            return null;
        }
        for (int i = 0; i < this.getAvailableTemplates().size(); ++i) {
            TemplateInfo temp = this.getAvailableTemplates().get(i);
            if (!oldRptTemplate.getGroup().equals(temp.getGroup())) continue;
            return temp;
        }
        return null;
    }

    private TemplateInfo getNewTemplate() throws Exception {
        TemplateInfo temp = this.getSameGroupTemplate();
        if (temp == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)temp.getId().toString()));
        TemplateCollection c = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
        return c.get(0);
    }

    private void changeToNewestTemplate(TemplateInfo newestTemplate, boolean isCoverformula) throws Exception {
        Book reportBook = this.ctx.getBook();
        if (newestTemplate == null) {
            throw new NullPointerException();
        }
        Book tempBook = newestTemplate.getBook();
        boolean isAutoCal = reportBook.isAutoCalculate();
        tempBook.setCalculate(false);
        BookProperties bookProperties = BookProperties.loadFromBook((Book)tempBook);
        ReportVariables vb = bookProperties.getVariables();
        this.ui.setBook(tempBook);
        for (int i = 0; i < reportBook.getSheetCount(); ++i) {
            Sheet rep = reportBook.getSheet(i);
            Sheet temp = tempBook.getSheet(rep.getSheetName());
            if (temp == null) continue;
            int sheetType = vb.getIntValue("SheetClass", temp.getSheetName(), 1);
            this.CoverSheet(temp, rep, isCoverformula, sheetType);
        }
        ReportVariables VARIABLES = (ReportVariables)reportBook.getUserObjectValue("VARIABLES");
        ReportVariables VARIABLES2 = (ReportVariables)tempBook.getUserObjectValue("VARIABLES");
        for (int i = 0; i < reportBook.getSheetCount(); ++i) {
            VariableEntry[] var;
            if (tempBook.getSheet(reportBook.getSheetName(i)) == null || (var = VARIABLES.getSheetVart(reportBook.getSheetName(i))) == null || var.length <= 0) continue;
            VARIABLES2.onDeleteSheet(reportBook.getSheetName(i));
            VARIABLES2.add(var);
        }
        this.report.setNewBook(this.lockBookExpTank(tempBook, newestTemplate));
        this.report.setNewTemplateO(newestTemplate);
        Timestamp tms = new Timestamp(new Date().getTime());
        if (this.report instanceof CslReportInfo) {
            CslReportInfo info = (CslReportInfo)this.report;
            info.setCreateTime(tms);
            if (info.getSourceType().getValue() == 2 || info.getSourceType().getValue() == 11 || info.getSourceType().getValue() == 8) {
                SumRptRelaFactory.getRemoteInstance().delete(" where sumReportId = '" + info.getId().toString() + "'");
            }
        }
        if (this.report instanceof ReportInfo) {
            ((ReportInfo)this.report).setCreateTime(tms);
        }
        this.ui.getSpreadManager().getSpreadContainer().repaint();
        if (isAutoCal) {
            tempBook.calc();
            tempBook.setCalculate(true);
        }
    }

    private void CoverSheet(Sheet temp, Sheet rep, boolean isCoverformula, int sheetType) {
        if (rep.getUserObjects() != null) {
            for (int j = 0; j < rep.getUserObjects().size(); ++j) {
                String key = rep.getUserObjects().getUserObject(j).getKey();
                if ("SUMCALCZONE".equals(key) || "DYNAMICSUMKEYZONE".equals(key) || "DYNAMICSUMVALUEZONE".equals(key)) continue;
                temp.setUserObject(key, rep.getUserObjects().getUserObject(j).getValue());
            }
        }
        if (this.oldTemplate.getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC)) {
            this.dynaCoverSheet(temp, rep);
            this.fillHandNum(temp, rep, true);
        } else if (sheetType != 0 && (10 == sheetType || 20 == sheetType)) {
            this.fixedCoverSheet(temp, rep, sheetType);
        } else {
            this.fillHandNum(temp, rep, false);
        }
    }

    private void fillHandNum(Sheet temp, Sheet rep, boolean isDynaRpt) {
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        HashMap<String, Variant> numMap = new HashMap<String, Variant>();
        this.getNumMap(temp, rep, numMap, formulaMap, isDynaRpt);
        if (numMap.size() == 0 && formulaMap.size() == 0) {
            return;
        }
        this.fillNumber(numMap, formulaMap, temp);
    }

    private void fillNumber(Map<String, Variant> numMap, Map<String, String> formulaMap, Sheet temp) {
        int maxColIndex = temp.getMaxColIndex();
        int maxRowIndex = temp.getMaxRowIndex();
        HashMap<String, List<Point>> basePoints = new HashMap<String, List<Point>>();
        for (int i = 0; i <= maxRowIndex; ++i) {
            for (int j = 0; j <= maxColIndex; ++j) {
                Cell cell = temp.getCell(i, j, false);
                if (cell == null) continue;
                ItemFormula itemFormula = NewRptUtil.getItemFormula(cell, basePoints);
                String formula = cell.getFormula();
                if (itemFormula == null || cell.getValue() != null && cell.getValue().toString().length() > 0 || formula != null && formula.startsWith("=")) continue;
                Variant numValue = numMap.get(itemFormula.toString());
                String newFormula = formulaMap.get(itemFormula.toString());
                if (numValue == null && newFormula == null) continue;
                cell.setFormula(newFormula);
                cell.setValue(numValue);
            }
        }
    }

    private void getNumMap(Sheet temp, Sheet rep, Map<String, Variant> numMap, Map<String, String> formulaMap, boolean isDynaRpt) {
        int maxColIndex = rep.getMaxColIndex();
        int maxRowIndex = rep.getMaxRowIndex();
        HashMap<String, List<Point>> basePoints = new HashMap<String, List<Point>>();
        for (int i = 0; i <= maxRowIndex; ++i) {
            for (int j = 0; j <= maxColIndex; ++j) {
                Cell cell = rep.getCell(i, j, false);
                if (cell == null) continue;
                ItemFormula itemFormula = NewRptUtil.getItemFormula(cell, basePoints);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)rep, (Point)new Point(j, i));
                Variant value = cell.getValue();
                String formula = cell.getFormula();
                Cell tempCell = temp.getCell(i, j, false);
                if (!isDynaRpt && value != null && itemFormula == null && param == null && (tempCell == null || tempCell != null && tempCell.getValue().toString().length() == 0 && tempCell.getFormula() == null)) {
                    tempCell = temp.getCell(i, j, true);
                    if (formula != null) {
                        tempCell.setFormula(formula);
                    } else {
                        tempCell.setValue(value);
                    }
                }
                if (value == null || value.toString().length() == 0 || itemFormula == null || itemFormula.toString() == null) continue;
                if (formula != null && formula.startsWith("=")) {
                    formulaMap.put(itemFormula.toString(), formula);
                    continue;
                }
                numMap.put(itemFormula.toString(), cell.getValue());
            }
        }
    }

    private void dynaCoverSheet(Sheet temp, Sheet rep) {
        try {
            this.autoFillDynamicItems(temp, rep);
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
    }

    private void autoFillDynamicItems(Sheet temp, Sheet rep) throws UIException, Exception {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)rep);
        if (basePointList != null && basePointList.size() > 0) {
            DynaItemWizardUI dynaitemWizard = new DynaItemWizardUI();
            dynaitemWizard.getUIContext().put("spreadContext", this.ui.getSpreadManager().getSpreadContainer());
            for (int i = 0; i < basePointList.size(); ++i) {
                Point basepoint = (Point)basePointList.get(i);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)rep, (Point)basepoint);
                if (param.isGrade() && param.getDynaItemSource() == 0) continue;
                if (param.getDynaItemSource() != 0) {
                    if (dynaitemWizard.getUIContext().containsKey("KEY_KDTABLE")) {
                        dynaitemWizard.getUIContext().remove("KEY_KDTABLE");
                    }
                    if (dynaitemWizard.getUIContext().containsKey("autoExe")) {
                        dynaitemWizard.getUIContext().remove("autoExe");
                    }
                    if (dynaitemWizard.getUIContext().containsKey("Active_Point")) {
                        dynaitemWizard.getUIContext().remove("Active_Point");
                    }
                    if (dynaitemWizard.getUIContext().containsKey("Company")) {
                        dynaitemWizard.getUIContext().remove("Company");
                    }
                    if (dynaitemWizard.getUIContext().containsKey("tempTable")) {
                        dynaitemWizard.getUIContext().remove("tempTable");
                    }
                    if (dynaitemWizard.getUIContext().containsKey("Company")) {
                        dynaitemWizard.getUIContext().remove("Company");
                    }
                    dynaitemWizard.getUIContext().put("KEY_KDTABLE", rep);
                    dynaitemWizard.getUIContext().put("autoExe", Boolean.FALSE);
                    dynaitemWizard.getUIContext().put("Active_Point", basepoint);
                    dynaitemWizard.getUIContext().put("Company", this.getReportInfo().getCompany());
                    dynaitemWizard.getUIContext().put("tempTable", temp);
                    IReportPropertyAdapter adapt = this.ui.getReportAdapter();
                    dynaitemWizard.getUIContext().put("ReportPropertyAdapter", adapt);
                    dynaitemWizard.initReportCover();
                    continue;
                }
                this.autoManualRCFill(temp, rep, basepoint);
            }
            Point basepoint = (Point)basePointList.get(0);
            int spreadStyle = DynamicTemplateUtility.getDynaParameters((Sheet)rep, (Point)basepoint).getSpreadStyle();
            this.afterFill(temp, spreadStyle);
        }
    }

    private void autoManualRCFill(Sheet temp, Sheet rep, Point basepoint) throws Exception {
        ArrayList newBPointList = DynamicTemplateUtility.getBasePointList((Sheet)temp);
        Point newBasePoint = DynamicTemplateCoverUtil.findBasePoint((Sheet)temp, (Sheet)rep, (List)newBPointList, (Point)basepoint);
        if (newBasePoint == null) {
            return;
        }
        DynaParameters oldParam = DynamicTemplateCoverUtil.getParameters((Sheet)rep, (Point)basepoint);
        DynaParameters newParam = DynamicTemplateCoverUtil.getParameters((Sheet)temp, (Point)newBasePoint);
        int outCount = oldParam.getDefaultCounter() - newParam.getDefaultCounter();
        boolean isHorizon = DynamicTemplateCoverUtil.isHorizon((DynaParameters)newParam);
        if (outCount > 0) {
            this.insertRowRange(temp, newBasePoint, newParam, outCount - 1, isHorizon);
            newParam.setDefaultCounter(newParam.getDefaultCounter() + outCount);
            Range range = temp.getRange(newBasePoint.y, newBasePoint.x);
            DynamicTemplateUtility.saveParametersToCell((Range)range, (DynaParameters)newParam);
        }
        newBPointList = DynamicTemplateUtility.getBasePointList((Sheet)temp);
        List dataList = this.getHeadList(rep, oldParam, basepoint);
        for (int i = 0; i < dataList.size(); ++i) {
            Range range = null;
            if (isHorizon) {
                range = temp.getRange(newBasePoint.y, newBasePoint.x + i + 1);
                range.setValue((Variant)dataList.get(i));
                DynaItemListener.autoFillFormula((Sheet)temp, (int)newBasePoint.y, (int)(newBasePoint.x + i + 1), (String)dataList.get(i).toString(), null, (int)0, null, (boolean)false, (ArrayList)newBPointList);
                continue;
            }
            range = temp.getRange(newBasePoint.y + i + 1, newBasePoint.x);
            range.setValue((Variant)dataList.get(i));
            DynaItemListener.autoFillFormula((Sheet)temp, (int)(newBasePoint.y + i + 1), (int)newBasePoint.x, (String)dataList.get(i).toString(), null, (int)0, null, (boolean)false, (ArrayList)newBPointList);
        }
    }

    private void insertRowRange(Sheet temp, Point newBasePoint, DynaParameters newParam, int range, boolean isHorization) {
        int size = newParam.getDefaultCounter() - 1;
        if (isHorization) {
            UserObjectHelper.getUnprotectedRange((Range)temp.getColRange(newBasePoint.x + size, newBasePoint.x + size + range)).insert(false);
        } else {
            UserObjectHelper.getUnprotectedRange((Range)temp.getRowRange(newBasePoint.y + size, newBasePoint.y + size + range)).insert(true);
        }
    }

    private List getHeadList(Sheet rep, DynaParameters oldParam, Point oldBasePoint) {
        ArrayList<Variant> headList = new ArrayList<Variant>();
        boolean isHorizon = DynamicTemplateCoverUtil.isHorizon((DynaParameters)oldParam);
        for (int i = 1; i <= oldParam.getDefaultCounter(); ++i) {
            Range cell = null;
            cell = isHorizon ? rep.getRange(oldBasePoint.y, oldBasePoint.x + i) : rep.getRange(oldBasePoint.y + i, oldBasePoint.x);
            if (cell.getValue() == null || cell.getValue().toString() == null) continue;
            headList.add(cell.getValue());
        }
        return headList;
    }

    private void afterFill(Sheet temp, int spreadStyle) {
        ArrayList newBPList = DynamicTemplateUtility.getBasePointList((Sheet)temp);
        if (newBPList == null || newBPList.size() == 0) {
            return;
        }
        for (int i = 0; i < newBPList.size(); ++i) {
            Point basePoint = (Point)newBPList.get(i);
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)temp, (int)basePoint.y, (int)basePoint.x);
            param.setFilled(false);
            DynamicTemplateUtility.saveParametersToCell((Range)temp.getRange(basePoint.y, basePoint.x), (DynaParameters)param);
        }
    }

    private ReportBaseInfo getReportInfo() {
        Object info = null;
        info = this.ui.getBookProvider().getIsQueryBudget() == 1 ? this.getHisCslReportEditData() : this.getCslReportEditData();
        if (info == null) {
            info = (ReportBaseInfo)this.ui.getBookProvider().getEditValue();
        }
        return info;
    }

    private HisCslReportInfo getHisCslReportEditData() {
        IBookProvider provider = this.ui.getBookProvider();
        if (provider instanceof CslReportProvider) {
            return ((CslReportProvider)provider).getHisCSLlReportInfo();
        }
        return null;
    }

    private CslReportInfo getCslReportEditData() {
        IBookProvider provider = this.ui.getBookProvider();
        if (provider instanceof CslReportProvider) {
            return ((CslReportProvider)provider).getCSLlReportInfo();
        }
        return null;
    }

    private void fixedCoverSheet(Sheet temp, Sheet rep, int sheetType) {
        List companyList = new ArrayList();
        companyList = this.getFilledCompanyInfo(rep, 0, 0, true);
        if (companyList.size() == 0) {
            return;
        }
        this.setFirstLineFormula(temp);
        RptCompanyFillWizard.fillSheet((Sheet)temp, (int)0, (int)0, (boolean)true, companyList);
    }

    public void setFirstLineFormula(Sheet sheet) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        int extX = sheet.getMaxColIndex() + 1;
        String exp = "";
        for (int i = iPosLeft + 1; i < extX; ++i) {
            Range range1 = sheet.getRange(iPosTop + 1, i);
            exp = CslRptUtil.resetAndGetFormula((Range)range1);
            if (StringUtils.isEmpty((String)exp) || !exp.contains("@")) continue;
            Range r = sheet.getRange(iPosTop, i);
            r.setUserObject("FormulaExp", (Object)exp);
        }
    }

    private List getFilledCompanyInfo(Sheet sheet, int x, int y, boolean isVertical) {
        ArrayList<OrgUnitInfo> companyData = new ArrayList<OrgUnitInfo>();
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0) {
            iPosLeft = x;
        } else {
            x = iPosLeft;
        }
        if (iPosTop < 0) {
            iPosTop = y;
        } else {
            y = iPosTop;
        }
        int offset = 0;
        int maxVaildLines = sheet.getMaxColIndex() - iPosLeft;
        if (isVertical) {
            maxVaildLines = sheet.getMaxRowIndex() - iPosTop;
        }
        while (offset < maxVaildLines) {
            Range range = null;
            OrgUnitInfo ouInfo = new OrgUnitInfo();
            range = isVertical ? sheet.getRange(iPosTop + 1 + offset, iPosLeft) : sheet.getRange(iPosLeft + 1 + offset, iPosTop);
            ItemFormula itemFormula = (ItemFormula)range.getUserObject("ITEM");
            String tmpCompanyId = null;
            String orgNumber = null;
            if (itemFormula != null) {
                tmpCompanyId = itemFormula.getExt("16");
                orgNumber = itemFormula.getExt("26");
                ouInfo.setId(BOSUuid.read((String)tmpCompanyId));
                if (StringUtils.isEmpty((String)orgNumber)) {
                    orgNumber = this.getOrgNumber(range);
                }
                String orgName = this.getOrgName(range, orgNumber);
                ouInfo.setName(orgName);
                ouInfo.setNumber(orgNumber);
                companyData.add(ouInfo);
            }
            ++offset;
        }
        return companyData;
    }

    private String getOrgNumber(Range range) {
        String value = range.getValue().toString();
        int index = value.indexOf("-");
        if (index == -1) {
            return null;
        }
        return value.substring(0, index);
    }

    private String getOrgName(Range range, String orgNumber) {
        String value = range.getValue().toString();
        int index = value.indexOf("-", orgNumber.length() - 1);
        if (index == -1) {
            return null;
        }
        return value.substring(index + 1);
    }

    private int getDynaHeadItemCount(Sheet sheet, int bassicX, int basicY, int maxColIndex) {
        int result = 0;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(basicY, bassicX, basicY, maxColIndex, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell == null || !this.isDynaHeadItemCell(sheet, basicY, cell.getCol())) continue;
            result = cell.getCol() - bassicX;
            return result;
        }
        return result;
    }

    private boolean isDynaHeadItemCell(Sheet sheet, int r, int c) {
        ItemFormula f = (ItemFormula)sheet.getRange(r, c).getUserObject("ITEM");
        return f != null && !StringUtils.isEmpty((String)f.getFormula());
    }

    private int getGroupVersion(String currentVersionNumber) {
        return new Integer(currentVersionNumber.substring(0, currentVersionNumber.indexOf(".")));
    }

    public Boolean getCanUpdate() {
        return this.canUpdate;
    }

    public void setCanUpdate(Boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    public TemplateRenewableReport getReport() {
        return this.report;
    }

    public void setReport(TemplateRenewableReport report) {
        this.report = report;
    }

    public TemplateCollection getAvailableTemplates() throws Exception {
        if (this.availableTemplates == null) {
            this.availableTemplates = this.SelectNeedFields(this.GetCanUseTemplateSet());
        }
        return this.availableTemplates;
    }

    public void setAvailableTemplates(TemplateCollection availableTemplates) {
        this.availableTemplates = availableTemplates;
    }

    public TemplateInfo getOldTemplate() {
        return this.oldTemplate;
    }

    public void setOldTemplate(TemplateInfo oldTemplate) {
        this.oldTemplate = oldTemplate;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setMenuStrategy(IMenuStrategy menuStrategy) {
        this.menuStrategy = menuStrategy;
    }

    public boolean isGroupRpt() {
        return this.isGroupRpt;
    }

    public void setOldTemplateId(BOSUuid oldTemplateId) {
        this.oldTemplateId = oldTemplateId;
    }

    public boolean isSupportUpdate() {
        return this.isSupportUpdate;
    }

    public void setSupportUpdate(boolean isSupportUpdate) {
        this.isSupportUpdate = isSupportUpdate;
    }
}

