/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RptItemFormulaProvider
implements IItemFormulaProvider {
    private RptTmpTypeEnum type = null;
    private boolean isEditable = true;
    private Map<String, List<Point>> basePoints = new HashMap<String, List<Point>>();
    private static final String ITEM = "=Item()";
    private static final String DITEM = "=DItem()";

    public RptItemFormulaProvider() {
    }

    public RptItemFormulaProvider(RptTmpTypeEnum t) {
        this.setType(t);
    }

    @Override
    public String getDisplayingItemFormula(Range range, int viewMode) {
        this.isEditable = true;
        if (range == null) {
            return null;
        }
        ItemFormula v = (ItemFormula)range.getUserObject("ITEM");
        if (v == null) {
            SortedSheetArray sheetArray = range.getRangeSheets();
            if (sheetArray != null && sheetArray.size() > 0 && sheetArray.getSheet(0) != null) {
                Book book = sheetArray.getSheet(0).getBook();
                v = NewRptUtil.generateCellDyItemFormula(book.getActiveSheet().getCell(range.getBlock(0).getRow(), range.getBlock(0).getCol(), false), this.basePoints, null);
            }
            if (v == null) {
                return null;
            }
        }
        String toString = v.toString();
        return toString;
    }

    @Override
    public String defaultItemFormula() {
        if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)this.type) || RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)this.type) || RptTmpTypeEnum.DYNAMICCSLREPORT.equals((Object)this.type) || RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)this.type) || RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.equals((Object)this.type) || RptTmpTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)this.type) || RptTmpTypeEnum.MULTIDYNAMICCSLPORT.equals((Object)this.type) || RptTmpTypeEnum.MULTIDYNAMICMNSPORT.equals((Object)this.type)) {
            return DITEM;
        }
        return ITEM;
    }

    public RptTmpTypeEnum getType() {
        return this.type;
    }

    public void setType(RptTmpTypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean editable() {
        return this.isEditable;
    }
}

