/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.client.designer.AbstractSheetManagerUI;
import com.kingdee.eas.fi.newrpt.client.designer.ReportSheetManagerListener;
import com.kingdee.eas.fi.newrpt.client.designer.SheetManagerListener;
import com.kingdee.eas.fi.newrpt.client.designer.event.VariableChangeEvent;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.client.NameEditUI;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SheetManagerUI
extends AbstractSheetManagerUI
implements ActionListener {
    private static final long serialVersionUID = 5986139307794401264L;
    private ReportVariables variables;
    private List sheets = new ArrayList(3);
    private int newSheetSuffix = 0;
    private int activeSheetIndex = 0;
    private KingdeeListModel sheetListModel = new KingdeeListModel();
    private List<String> sheetNames = new ArrayList<String>();
    private SheetManagerListener maintainListener;
    private IReportVariableProvider variableProvider;
    private boolean isAllowModifyEditable = false;
    private static Set includeSet = new HashSet<String>(Arrays.asList("IncludeSub", "IncludeSubAccount", "IncludeLeaf", "IncludeLeafAccount"));
    public static final int NONE = 0;
    public static final int INSERT_SHEET = 1;
    public static final int EDIT_SHEET = 2;
    public static final int DELETE_SHEET = 4;
    public static final int AJUST_SITE = 8;
    private static final String ADD_COMMAND = "add";
    private static final String REMOVE_COMMAND = "remove";
    private static final String RENAME_COMMAND = "rename";
    private static final String MOVEUP_COMMAND = "moveup";
    private static final String MOVEDOWN_COMMAND = "movedown";
    private static final String HIDE_COMMAND = "hide";
    private static final String LOCK_COMMAND = "lock";
    private static final String INSERTVAR_COMMAND = "insertvar";
    private static final String REMOVEVAR_COMMAND = "removevar";
    private static final String OK_COMMAND = "ok";
    private static final String CANCEL_COMMAND = "cancel";
    private static final String APPLY_COMMAND = "apply";

    public static IUIWindow createUI(Object owner, Book book, String operatState, IReportVariableProvider variableProvider, ReportSheetManagerListener listener) throws UIException {
        UIContext uiContext = new UIContext(owner);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SheetManagerUI.class.getName(), (Map)uiContext, null, operatState);
        SheetManagerUI ui = (SheetManagerUI)uiWindow.getUIObject();
        int s = book.getSheetCount();
        BookProperties bookProperties = BookProperties.loadFromBook((Book)book);
        ui.setVariables(bookProperties.getVariables().copy());
        for (int i = 0; i < s; ++i) {
            Sheet sheet = book.getSheet(i);
            SheetPropertyEntry e = new SheetPropertyEntry(sheet.getSheetName());
            e.setHidden(sheet.getSheetOption().isHide());
            int type = ui.variables.getIntValue("SheetClass", sheet.getSheetName(), 1);
            e.setSheetType((Enum)CSLReportGroupEnum.getEnum((int)type));
            ui.sheets.add(e);
        }
        ui.activeSheetIndex = book.getActiveSheetIndex();
        ui.variableProvider = variableProvider;
        ui.maintainListener = listener;
        ui.initUI();
        if (book.getProtection().isProtected()) {
            ui.btnDown.setEnabled(false);
            ui.btnEdit.setEnabled(false);
            ui.btnInsert.setEnabled(false);
            ui.btnDelete.setEnabled(false);
            ui.btnUp.setEnabled(false);
            ui.cbxHide.setEnabled(false);
        }
        if (book.getUserObject("orgType") != null && OrgType.ProfitCenter.equals(book.getUserObject("orgType").getValue())) {
            ui.cmbSheetType.removeItem((Object)CSLReportGroupEnum.GEN_VOUCHER);
        }
        return uiWindow;
    }

    private void setVariables(ReportVariables variables) {
        this.variables = variables;
    }

    private void initUI() {
        this.cmbSheetType.addItems((Object[])CSLReportGroupEnum.getEnumList().toArray(new CSLReportGroupEnum[0]));
        this.initSheets();
        this.initEditButtons();
        this.lstSheets.setSelectedIndex(this.activeSheetIndex);
        this.initVariables();
    }

    private void initVariables() {
        this.pnlContent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SheetManagerUI.this.pnlVariables == SheetManagerUI.this.pnlContent.getSelectedComponent()) {
                    SheetManagerUI.this.refreshViewType();
                    SheetPropertyEntry obj = SheetManagerUI.this.getSelectedSheet();
                    if (obj != null) {
                        SheetManagerUI.this.cmbViewType.setSelectedItem((Object)obj);
                    }
                }
            }
        });
        this.cmbViewType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SheetPropertyEntry ea = (SheetPropertyEntry)e.getItem();
                    SheetManagerUI.this.filterVariables(ea);
                }
            }
        });
        this.tblVariables.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                SheetManagerUI.this.OnValueSeted(SheetManagerUI.this.tblVariables, e);
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                IRow row = SheetManagerUI.this.tblVariables.getRow(e.getRowIndex());
                VariableEntry ve = (VariableEntry)row.getUserObject();
                if (e.getColIndex() == 2) {
                    ve.setDescription((String)e.getValue());
                } else if (e.getColIndex() == 3) {
                    ve.setName((String)e.getValue());
                } else if (e.getColIndex() == 4) {
                    if (e.getValue() == null) {
                        ve.setValue("");
                    } else if (e.getValue() instanceof IObjectValue) {
                        ve.setValue(((IObjectValue)e.getValue()).getString("number"));
                    } else if (e.getValue() instanceof Date) {
                        SimpleDateFormat s = new SimpleDateFormat();
                        s.applyPattern("yyyy-MM-dd");
                        ve.setValue(s.format((Date)e.getValue()));
                    } else {
                        ve.setValue(e.getValue().toString());
                    }
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        SheetPropertyEntry ex = this.getSelectedSheet();
        this.filterVariables(ex);
    }

    private void OnValueSeted(KDTable tblVariables, KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        IRow row = tblVariables.getRow(rowIndex);
        Object value = row.getCell(3).getValue();
        if (value == null) {
            return;
        }
        if (includeSet.contains(value.toString())) {
            Object value2 = e.getValue();
            if (value2 == null) {
                return;
            }
            Object varSheet = row.getCell(1).getValue();
            Object sheet = null;
            if (RptUtil.isTrue((Object)value2) && e.getColIndex() == 4 || e.getColIndex() == 5) {
                for (int i = 0; i < tblVariables.getRowCount(); ++i) {
                    row = tblVariables.getRow(i);
                    value = row.getCell(3).getValue();
                    if (value == null || (sheet = row.getCell(1).getValue()) != null && !sheet.equals(varSheet) || !includeSet.contains(value.toString())) continue;
                    if (i != rowIndex && e.getColIndex() == 4) {
                        row.getCell(4).setValue((Object)Boolean.FALSE);
                        VariableEntry ve = (VariableEntry)row.getUserObject();
                        ve.setValue("0");
                    }
                    if (e.getColIndex() != 5) continue;
                    ICell cell = row.getCell(5);
                    cell.setValue(value2);
                    VariableEntry ve = (VariableEntry)row.getUserObject();
                    ve.setAllowModify(RptUtil.isTrue((Object)value2));
                    cell = row.getCell(4);
                    cell.getStyleAttributes().setLocked(!RptUtil.isTrue((Object)value2));
                }
            }
        } else if (e.getColIndex() == 5) {
            ICell cell = row.getCell(e.getColIndex());
            cell.setValue(e.getValue());
            VariableEntry ve = (VariableEntry)row.getUserObject();
            ve.setAllowModify(RptUtil.isTrue((Object)e.getValue()));
            cell = row.getCell(4);
            cell.getStyleAttributes().setLocked(!RptUtil.isTrue((Object)e.getValue()));
        }
    }

    protected void filterVariables(SheetPropertyEntry ea) {
        ArrayList l = this.variables.getAllVariables();
        this.tblVariables.removeRows();
        int type = 0;
        if (ea == null) {
            type = 0;
        } else if (ea.isDummy) {
            if (ea.getSheetName().equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.allVar"))) {
                type = 0;
            } else if (ea.getSheetName().equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.rvar"))) {
                type = 1;
            }
        } else {
            type = 2;
        }
        for (int i = 0; i < l.size(); ++i) {
            VariableEntry e = (VariableEntry)l.get(i);
            if (type != 1 && !this.sheetNames.contains(e.getSheetName()) || (type != 2 ? type == 1 && e.getScope() != 1 : !ea.getSheetName().equalsIgnoreCase(e.getSheetName()))) continue;
            if (!e.isVisible()) continue;
            IRow row = this.tblVariables.addRow();
            this.applyVariableEntryToRow(e, row);
        }
    }

    private void initSheets() {
        this.lstSheets.setModel((ListModel)this.sheetListModel);
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            this.sheetListModel.addElement((Object)e);
            this.sheetNames.add(e.getSheetName());
        }
        this.lstSheets.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SheetPropertyEntry ee = (SheetPropertyEntry)SheetManagerUI.this.lstSheets.getSelectedValue();
                if (ee == null) {
                    return;
                }
                SheetManagerUI.this.cmbSheetType.setSelectedItem((Object)ee.sheetType);
                SheetManagerUI.this.cbxHide.setSelected(ee.hidden);
                SheetManagerUI.this.cbxLock.setSelected(ee.locked);
            }
        });
        this.cmbSheetType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SheetPropertyEntry en = SheetManagerUI.this.getSelectedSheet();
                    en.sheetType = (Enum)e.getItem();
                    int reportClass = ((IntEnum)e.getItem()).getValue();
                    SheetManagerUI.this.variables.get("SheetClass", en.sheetName).setValue(String.valueOf(reportClass));
                    if (CslRptUtil.isInterOrExchSheet((int)reportClass)) {
                        NewRptUtil.addInterExchVariables(en.sheetName, SheetManagerUI.this.variables);
                    } else {
                        SheetManagerUI.this.variables.remove("IsOnlyFillHavingDataCompany", en.sheetName);
                    }
                }
            }
        });
        this.lstSheets.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.lstSheets.setFocusTraversalKeysEnabled(false);
    }

    private SheetPropertyEntry getSelectedSheet() {
        int idx = this.lstSheets.getSelectedIndex();
        if (idx < 0) {
            return null;
        }
        if (idx >= this.sheetListModel.size()) {
            return null;
        }
        SheetPropertyEntry ee = (SheetPropertyEntry)this.sheetListModel.getElementAt(idx);
        return ee;
    }

    private void initEditButtons() {
        this.btnInsert.setActionCommand(ADD_COMMAND);
        this.btnEdit.setActionCommand(RENAME_COMMAND);
        this.btnDelete.setActionCommand(REMOVE_COMMAND);
        this.btnUp.setActionCommand(MOVEUP_COMMAND);
        this.btnDown.setActionCommand(MOVEDOWN_COMMAND);
        this.cbxHide.setActionCommand(HIDE_COMMAND);
        this.cbxLock.setActionCommand(LOCK_COMMAND);
        this.btnInsertVar.setActionCommand(INSERTVAR_COMMAND);
        this.btnRemoveVar.setActionCommand(REMOVEVAR_COMMAND);
        this.btnOK.setActionCommand(OK_COMMAND);
        this.btnCancel.setActionCommand(CANCEL_COMMAND);
        this.btnApply.setActionCommand(APPLY_COMMAND);
        this.btnInsert.addActionListener((ActionListener)this);
        this.btnEdit.addActionListener((ActionListener)this);
        this.btnDelete.addActionListener((ActionListener)this);
        this.btnUp.addActionListener((ActionListener)this);
        this.btnDown.addActionListener((ActionListener)this);
        this.cbxHide.addActionListener((ActionListener)this);
        this.cbxLock.addActionListener((ActionListener)this);
        this.btnInsertVar.addActionListener((ActionListener)this);
        this.btnRemoveVar.addActionListener((ActionListener)this);
        this.btnOK.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnApply.addActionListener((ActionListener)this);
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnInsertVar.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnRemoveVar.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblVariables.getSelectManager().setSelectMode(1);
        this.tblVariables.addColumns(6);
        IRow row = this.tblVariables.addHeadRow();
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.range"));
        row.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.book"));
        row.getCell(2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.desc"));
        row.getCell(3).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.vName"));
        row.getCell(4).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.var"));
        row.getCell(5).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.allowModify"));
        this.tblVariables.getColumn(0).setWidth(50);
        this.tblVariables.getColumn(3).setWidth(80);
        this.tblVariables.getColumn(4).setWidth(100);
        this.tblVariables.getColumn(5).setWidth(80);
    }

    public void showFieldForAllowModify() {
        this.tblVariables.getColumn(5).getStyleAttributes().setHided(false);
    }

    private void initVariableTable(VariableEntry e, IRow row) {
        if (this.isAllowModifyEditable) {
            this.tblVariables.getColumn(5).getStyleAttributes().setLocked(false);
        } else {
            this.tblVariables.getColumn(5).getStyleAttributes().setLocked(true);
            ICell cell = row.getCell(5);
            Boolean isAllowModify = (Boolean)cell.getValue();
            if (isAllowModify != null && !isAllowModify.booleanValue()) {
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (ADD_COMMAND.equals(command)) {
            this.insertSheet();
        } else if (REMOVE_COMMAND.equals(command)) {
            this.removeSheet();
        } else if (RENAME_COMMAND.equals(command)) {
            this.renameSheet();
        } else if (HIDE_COMMAND.equals(command)) {
            SheetPropertyEntry selectedSheet = this.getSelectedSheet();
            if (!selectedSheet.isHidden() && this.isLastSheet()) {
                this.cbxHide.setSelected(false);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.m123Sg"));
                return;
            }
            selectedSheet.setEdit();
            selectedSheet.hidden = this.cbxHide.isSelected();
        } else if (LOCK_COMMAND.equals(command)) {
            SheetPropertyEntry selectedSheet = this.getSelectedSheet();
            selectedSheet.setEdit();
            selectedSheet.locked = this.cbxLock.isSelected();
        } else if (MOVEUP_COMMAND.equals(command)) {
            this.moveNode(-1);
        } else if (MOVEDOWN_COMMAND.equals(command)) {
            this.moveNode(1);
        } else if (INSERTVAR_COMMAND.equals(command)) {
            this.insertVar();
        } else if (REMOVEVAR_COMMAND.equals(command)) {
            this.removeVar();
        } else if (OK_COMMAND.equals(command)) {
            this.ok();
        } else if (CANCEL_COMMAND.equals(command)) {
            this.cancel();
        } else if (APPLY_COMMAND.equals(command)) {
            this.apply();
        }
    }

    private void apply() {
        if (this.maintainListener != null) {
            VariableChangeEvent e = new VariableChangeEvent(this.variables, this.sheets);
            this.maintainListener.applyChange(e);
            if (e.isCancel()) {
                MsgBox.showError((Component)((Object)this), (String)e.getMsg());
                SysUtil.abort();
            }
        }
    }

    private void cancel() {
        this.destroyWindow();
    }

    private void ok() {
        this.apply();
        this.destroyWindow();
    }

    private void removeVar() {
        int idx = this.tblVariables.getSelectManager().getActiveRowIndex();
        if (idx < 0) {
            return;
        }
        VariableEntry e = (VariableEntry)this.tblVariables.getRow(idx).getUserObject();
        if (e.isReserved()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.notDel"));
            return;
        }
        if (!e.isEditable()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.notEdit"));
            return;
        }
        this.variables.remove(e);
        this.tblVariables.removeRow(idx);
    }

    private void insertVar() {
        int idx = this.tblVariables.getSelectManager().getActiveRowIndex();
        VariableEntry oldValue = null;
        IRow row = null;
        if (idx < 0) {
            row = this.tblVariables.addRow();
        } else {
            oldValue = (VariableEntry)this.tblVariables.getRow(idx).getUserObject();
            row = this.tblVariables.addRow(++idx);
        }
        VariableEntry e = new VariableEntry();
        e.setReserved(false);
        e.setEditable(true);
        SheetPropertyEntry se = (SheetPropertyEntry)this.cmbViewType.getSelectedItem();
        if (se.isDummy) {
            e.setSheetName(null);
            e.setScope(1);
        } else {
            e.setSheetName(se.getSheetName());
            e.setScope(2);
        }
        this.applyVariableEntryToRow(e, row);
        if (oldValue != null) {
            int ix = this.variables.indexOf(oldValue);
            this.variables.add(ix, e);
        } else {
            this.variables.add(e);
        }
    }

    private void applyVariableEntryToRow(VariableEntry e, IRow row) {
        ICell cell = row.getCell(0);
        if (e.getScope() == 1) {
            cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.r00pt"));
        } else if (e.getScope() == 2) {
            cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.book"));
        }
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(1);
        cell.setValue((Object)e.getSheetName());
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(2);
        cell.setValue((Object)e.getDescription());
        cell = row.getCell(3);
        cell.setValue((Object)e.getName());
        if (e.isReserved()) {
            cell.getStyleAttributes().setLocked(true);
        }
        cell = row.getCell(4);
        this.initCellValueAndEditor(cell, e);
        cell.getStyleAttributes().setLocked(!e.isAllowModify());
        cell = row.getCell(5);
        cell.setValue((Object)new Boolean(e.isAllowModify()));
        row.setUserObject((Object)e);
        if (!e.isEditable()) {
            row.getStyleAttributes().setLocked(true);
        }
        this.initVariableTable(e, row);
    }

    private void initCellValueAndEditor(ICell cell, VariableEntry e) {
        if (e != null && !StringUtils.isEmpty((String)e.getName()) && (StringUtils.isEmpty((String)e.getQuery()) || e.getSelector() == null) && e.getName().equals("Currency")) {
            e.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        }
        if (1 == e.getType()) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
            cell.setValue((Object)e.getBoolValue(false));
        } else if (3 == e.getType()) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField()));
            cell.setValue((Object)e.getIntValue(0));
        } else if (2 == e.getType()) {
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setDatePattern("yyyy-MM-dd");
            datePicker.setTimeEnabled(false);
            datePicker.setMilliSecondEnable(false);
            datePicker.setSupportedEmpty(true);
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
            try {
                DateFormat df = DateFormat.getDateInstance();
                if (!StringUtils.isEmpty((String)e.getValue())) {
                    cell.setValue(df.parseObject(e.getValue()));
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        } else if (!StringUtils.isEmpty((String)e.getQuery()) || e.getSelector() != null) {
            KDBizPromptBox box = new KDBizPromptBox();
            box.setDisplayFormat("$number$");
            box.setEditFormat("$number$");
            if (e.getSelector() != null) {
                box.setSelector(e.getSelector());
            } else {
                box.setQueryInfo(e.getQuery());
            }
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
            cell.setValue((Object)e.getValue());
        } else if (4 == e.getType()) {
            KDComboBox kdComboBox = null;
            if (!StringUtils.isEmpty((String)e.getComboBoxEnum())) {
                try {
                    Class<?> comboBoxEnumClass = Class.forName(e.getComboBoxEnum());
                    Method method = comboBoxEnumClass.getDeclaredMethod("getEnumList", new Class[0]);
                    NewRptUtil.makeAccessible(method);
                    List enums = (List)method.invoke(comboBoxEnumClass, new Object[0]);
                    if (enums != null) {
                        kdComboBox = new KDComboBox();
                        for (Object obj : enums) {
                            kdComboBox.addItem((Object)((Enum)obj).getName());
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    this.handUIException(ex);
                }
            }
            if (kdComboBox != null) {
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor(kdComboBox));
                cell.setValue((Object)e.getValue());
            }
        } else {
            cell.setValue((Object)e.getValue());
        }
    }

    private void renameSheet() {
        String sUIName = "com.kingdee.eas.fi.rpt.client.NameEditUI";
        UIContext uiContext = new UIContext((Object)this);
        String oldName = this.getSelectedSheet().getSheetName();
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("title", RptUtil.getResourceSince51((String)"AddNewSheet"));
        ht.put("label", EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.RPTPARAM_SHEETNAME"));
        ht.put("edit", oldName);
        ht.put("verify", Boolean.TRUE);
        uiContext.put((Object)"para", ht);
        try {
            IUIWindow sheetNameEditUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(sUIName, (Map)uiContext);
            NameEditUI ui = (NameEditUI)sheetNameEditUI.getUIObject();
            ui.setVerifyListener(new NameEditUI.VerifyListener(){

                public boolean verify(JComponent source, String name) {
                    int rs = this.varlidateName(name);
                    if (rs == 0) {
                        return true;
                    }
                    if (rs == 1) {
                        MsgBox.showWarning((Component)source, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.msgiii"));
                    } else if (rs == 2) {
                        MsgBox.showWarning((Component)source, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.msgee"));
                    }
                    return false;
                }

                private int varlidateName(String name) {
                    if (name == null || name.length() < 1 || name.length() > 31) {
                        return 1;
                    }
                    String regex = "(.*\\*.*)|(.*\\\\.*)|(.*\\?.*)|(.*\\/.*)|(.*\\[.*)|(.*\\].*)|(.*\\:.*)";
                    if (name.matches(regex)) {
                        return 1;
                    }
                    SheetPropertyEntry currentSheet = SheetManagerUI.this.getSelectedSheet();
                    for (int i = 0; i < SheetManagerUI.this.sheets.size(); ++i) {
                        SheetPropertyEntry ee = (SheetPropertyEntry)SheetManagerUI.this.sheets.get(i);
                        if (currentSheet == ee || (ee.operation & 4) == 4 || !ee.getSheetName().equalsIgnoreCase(name)) continue;
                        return 2;
                    }
                    return 0;
                }
            });
            sheetNameEditUI.show();
            String action = (String)ht.get("action");
            if (action != null && action.equals(CANCEL_COMMAND) || action == null) {
                return;
            }
            SheetPropertyEntry selectedSheet = this.getSelectedSheet();
            this.variables.onRenameSheet(selectedSheet.getSheetName(), (String)ht.get("NoTrimed"));
            selectedSheet.setSheetName((String)ht.get("NoTrimed"));
            selectedSheet.setEdit();
            this.lstSheets.repaint();
        }
        catch (UIException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    private void insertSheet() {
        SheetPropertyEntry e = this.getSelectedSheet();
        int location = -1;
        location = e != null ? this.lstSheets.getIndexOfElement((Object)e) : 0;
        SheetPropertyEntry e2 = new SheetPropertyEntry(this.getAppropriateSheetName(), 1);
        int idx2 = this.getSheetIndex(e);
        if (++location >= this.sheetListModel.size()) {
            this.sheetListModel.addElement((Object)e2);
            this.sheets.add(e2);
        } else {
            this.sheetListModel.add(location, (Object)e2);
            this.sheets.add(++idx2, e2);
        }
        this.variableProvider.initSheetDefaultVariable(e2.getSheetName(), this.variables);
        this.lstSheets.setSelectedValue((Object)e2, true);
    }

    private void moveNode(int direction) {
        SheetPropertyEntry e = this.getSelectedSheet();
        int index = this.lstSheets.getIndexOfElement((Object)e);
        if (direction > 0 ? ++index >= this.sheetListModel.size() : --index < 0) {
            return;
        }
        this.sheetListModel.removeElement((Object)e);
        e.setAjust();
        this.sheetListModel.add(index, (Object)e);
        this.lstSheets.setSelectedValue((Object)e, true);
        int idx2 = this.getSheetIndex(e);
        if (direction > 0) {
            if (++idx2 >= this.sheets.size()) {
                return;
            }
            Object old = this.sheets.get(idx2);
            this.sheets.set(idx2, e);
            this.sheets.set(--idx2, old);
        } else {
            if (--idx2 < 0) {
                return;
            }
            Object old = this.sheets.get(idx2);
            this.sheets.set(idx2, e);
            this.sheets.set(++idx2, old);
        }
    }

    private SheetPropertyEntry removeSheet() {
        SheetPropertyEntry e = this.getSelectedSheet();
        if (this.isLastSheet() && (e == null || !e.hidden)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.msgjjj"));
            return null;
        }
        if (e == null) {
            return null;
        }
        e.setDelete();
        int i = this.lstSheets.getIndexOfElement((Object)e);
        this.sheetListModel.removeElement((Object)e);
        this.variables.onDeleteSheet(e.getSheetName());
        if (--i < 0) {
            i = 0;
        } else if (i >= this.sheetListModel.size()) {
            i = this.sheetListModel.size() - 1;
        }
        this.lstSheets.setSelectedIndex(i);
        return e;
    }

    private void refreshViewType() {
        this.cmbViewType.removeAllItems();
        SheetPropertyEntry sheetPropertyEntry = new SheetPropertyEntry(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.allVar"));
        sheetPropertyEntry.isDummy = true;
        this.cmbViewType.addItem((Object)sheetPropertyEntry);
        SheetPropertyEntry sheetPropertyEntry2 = new SheetPropertyEntry(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.rvar"));
        sheetPropertyEntry2.isDummy = true;
        this.cmbViewType.addItem((Object)sheetPropertyEntry2);
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4) continue;
            this.cmbViewType.addItem((Object)e);
        }
    }

    private boolean isLastSheet() {
        int count = 0;
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4 || e.hidden) continue;
            ++count;
        }
        return count < 2;
    }

    private int getSheetIndex(Object ee) {
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if (e != ee) continue;
            return i;
        }
        return -1;
    }

    private String getAppropriateSheetName() {
        String result = "Sheet" + ++this.newSheetSuffix;
        for (int i = 0; i < this.sheets.size(); ++i) {
            SheetPropertyEntry e = (SheetPropertyEntry)this.sheets.get(i);
            if ((e.operation & 4) == 4 || !result.equalsIgnoreCase(e.getSheetName())) continue;
            result = "Sheet" + ++this.newSheetSuffix;
            i = -1;
        }
        return result;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public SheetManagerListener getMaintainListener() {
        return this.maintainListener;
    }

    public void setMaintainListener(SheetManagerListener maintainListener) {
        this.maintainListener = maintainListener;
    }

    public void allowChangeSheetType(boolean allow) {
        this.cmbSheetType.enable(allow);
    }

    public boolean isAllowModifyEditable() {
        return this.isAllowModifyEditable;
    }

    public void setAllowModifyEditable(boolean isCreateOrg) {
        this.isAllowModifyEditable = isCreateOrg;
    }

    public static class SheetPropertyEntry {
        private Enum sheetType;
        private boolean locked = false;
        private boolean hidden = false;
        private String sheetName = null;
        private String originalSheetName = null;
        private int operation = 0;
        private boolean isDummy = false;

        SheetPropertyEntry(String n) {
            this.sheetName = n;
            this.originalSheetName = n;
            this.sheetType = CSLReportGroupEnum.COMMON;
        }

        SheetPropertyEntry(String n, int op) {
            this(n);
            this.operation = op;
        }

        public String toString() {
            return this.sheetName;
        }

        public void setUnEdit() {
            int i = 0;
            i |= 1;
            i |= 4;
            this.operation &= (i |= 8);
        }

        public void setEdit() {
            this.operation |= 2;
        }

        public void setDelete() {
            this.operation |= 4;
        }

        public void setAjust() {
            this.operation |= 8;
        }

        public void setInsert() {
            this.operation |= 1;
        }

        public void setNone() {
            this.operation = 0;
        }

        public boolean edited() {
            return (this.operation & 2) == 2;
        }

        public boolean deleted() {
            return (this.operation & 4) == 4;
        }

        public boolean inserted() {
            return (this.operation & 1) == 1;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public boolean isDummy() {
            return this.isDummy;
        }

        public void setDummy(boolean isDummy) {
            this.isDummy = isDummy;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public int getOperation() {
            return this.operation;
        }

        public void setOperation(int operation) {
            this.operation = operation;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public Enum getSheetType() {
            return this.sheetType;
        }

        public void setSheetType(Enum sheetType) {
            this.sheetType = sheetType;
        }

        public String getOriginalSheetName() {
            return this.originalSheetName;
        }

        public void setOriginalSheetName(String originalSheetName) {
            this.originalSheetName = originalSheetName;
        }
    }
}

