/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectReplacer;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaChangeEvent;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.ModifyManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.client.designer.event.ItemFormulaChangeListener;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.designer.wizard.FormulaAdapterDelegate;
import com.kingdee.eas.fi.newrpt.designer.wizard.IFormulaAdapter;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;

public class SpreadManager {
    public static final int ALWAYS_SHOW = 0;
    public static final int ASNEEDED_SHOW = 1;
    public static final int NEVER_SHOW = 2;
    private SpreadContext _spreadContainer;
    private ItemFormulaPanel itemFormulaPanel;
    private ModifyManager modifyManager = null;
    private FormulaAdapterDelegate formulaAdapters;

    public static void registerRenderProvider(IRenderProvider p) {
        UserCellDisplayProvider.addRenderProvider(p);
    }

    public SpreadManager() {
        if (this._spreadContainer == null) {
            this._spreadContainer = new SpreadContext();
            this.modifyManager = new ModifyManager(this._spreadContainer);
        }
    }

    public SpreadContext getSpreadContainer() {
        return this._spreadContainer;
    }

    KDSpread getSpread() {
        return this.getSpreadContainer().getSpread();
    }

    void setBook(Book book) {
        this._spreadContainer.setBook(book);
    }

    public RangeSelector createRangeSelector(String title) {
        return this.getSpreadContainer().getFacadeManager().createRangeSelector(title);
    }

    public void registerUserObjetFinder(Object serModes, ICellUserObjectMatcher finder, ICellUserObjectReplacer replacer) {
        this._spreadContainer.getUserObjectRegister().addUserObjectFinder(serModes, finder, replacer);
    }

    public void registerCustomFormulaWizzard(ISpreadWizzard wizzard) {
        this._spreadContainer.getFacadeManager().putWizzard(FacadeManager.WIZZARD_Formula, wizzard);
    }

    public void registerCellDisplayProvider(ICellDisplayProvider provider) {
        this._spreadContainer.getRenderManager().setUserCellDisplayProvider(provider);
    }

    public void setRightCompOnEditPanel(JComponent rightComp, boolean adjustable) {
        PromptPanel pp = this._spreadContainer.getFacadeManager().getPromptPanel();
        pp.setRightComponent(rightComp);
        pp.setAdjustable(adjustable);
        pp.setDependSecondSize(true);
    }

    public void setItemFormulaEnable(boolean nb) {
        this.itemFormulaPanel.setEnabled(nb);
    }

    public void setRightCompOnEditPanel(JComponent rightComp) {
        this.setRightCompOnEditPanel(rightComp, true);
    }

    public void setRightCompOnEditPanelWidth(int width) {
        PromptPanel pp = this._spreadContainer.getFacadeManager().getPromptPanel();
        pp.getRightComponent().setPreferredSize(new Dimension(width, 10));
        pp.getRightComponent().invalidate();
        pp.validate();
        pp.repaint();
    }

    public KDToolBar getToolBar(String toolBarName) {
        return this._spreadContainer.getToolBarManager().getToolBar(toolBarName);
    }

    public void setUserExtRender(IExtRender render) {
        this.getSpreadContainer().getRenderManager().setUserExtRender(render);
    }

    public List getAllSheetsName() {
        return SpreadHelper.getAllSheetsName(this._spreadContainer.getBook());
    }

    public void registerDefaultFormulaWizard(RptContextManager context) throws Exception {
        FormulaPicker wizard = new FormulaPicker((Component)this._spreadContainer);
        wizard.setRptContextManager(context);
        this.registerCustomFormulaWizzard(wizard);
        wizard.setFormulaPickListener(new FormulaPickListener(){

            @Override
            public String pickFormulaLine() {
                Range rg = SpreadManager.this._spreadContainer.getBook().getActiveCellRange();
                String formula = rg.getFormula();
                if (SpreadManager.this.formulaAdapters != null && !StringUtils.isEmpty((String)formula)) {
                    return SpreadManager.this.formulaAdapters.adapter(formula);
                }
                return formula;
            }

            @Override
            public void setFormulaLine(String line) {
                SpreadManager.this._spreadContainer.getRangeManager().getActiveCellRange().setFormula('=' + line);
            }
        });
    }

    public void registerDefaultItemFormulaWizard() throws Exception {
        this.itemFormulaPanel = new ItemFormulaPanel(this._spreadContainer);
        this.itemFormulaPanel.setStateChangeListener(new ItemFormulaPanel.ItemPanelStateChangeListener(){

            @Override
            public void changeWidth(int newWidth) {
                SpreadManager.this.setRightCompOnEditPanelWidth(newWidth);
            }
        });
        this.setRightCompOnEditPanel((JComponent)((Object)this.itemFormulaPanel));
        this.itemFormulaPanel.addItemFormulaChangeListener(new ItemFormulaChangeListener(){

            @Override
            public void formulaChanged(ItemFormulaChangeEvent e) {
                Range range = SpreadManager.this._spreadContainer.getRangeManager().getActiveCellRange();
                if (e.getNewFormula() == null || e.getNewFormula().trim().length() < 1) {
                    range.setUserObject("ITEM", null);
                    return;
                }
                ItemFormula formula = null;
                formula = new ItemFormula();
                formula.FormulaToObject(e.getNewFormula());
                range.setUserObject("ITEM", (Object)formula);
                String itemStr = e.getNewFormula();
                String itemSplit = itemStr.split("=")[1];
                String formulaName = itemSplit.split("\\(")[0];
                if ((formulaName.equals("Item") || formulaName.equals("DItem")) && (formula.getPeriodOffSet() != 0 || formula.getYearOffSet() != 0)) {
                    MsgBox.showWarning((String)DesignerResource.getString("ItemFormulaLimitTips"));
                }
            }
        });
        this.getSpreadContainer().addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (SpreadManager.this.getSpreadContainer().getBook().getActiveSheet() != e.getSheet()) {
                    return;
                }
                SpreadManager.this.itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
            }
        });
        this.getSpreadContainer().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    SpreadManager.this.itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
                }
            }
        });
    }

    public void registerDefaultItemFormulaChangeListener(ItemFormulaChangeListener listener) {
        if (this.itemFormulaPanel == null || listener == null) {
            return;
        }
        this.itemFormulaPanel.addItemFormulaChangeListener(listener);
    }

    public Sheet findSheetByID(String id) {
        Book book = this.getSpread().getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sh = book.getSheet(i);
            if (!id.equalsIgnoreCase(sh.getID())) continue;
            return sh;
        }
        return null;
    }

    public void setItemFormulaProvider(IItemFormulaProvider formulaProvider) {
        this.itemFormulaPanel.setFormulaProvider(formulaProvider);
    }

    public void addKDSBlockInvalidListener(SheetChangeListener l) {
        this._spreadContainer.addSheetChangeListener(l);
    }

    public void addKDSBookChangeListener(BookChangeListener l) {
        this._spreadContainer.addBookChangeListener(l);
    }

    public void setItemFormulaShowModel(int model) {
        this.itemFormulaPanel.setShowMode(model);
    }

    public void doPickItemFormulaAction() {
        this.itemFormulaPanel.doPickItemFormula();
    }

    public void addFormulaAdapter(String formulaName, IFormulaAdapter adapter) {
        if (this.formulaAdapters == null) {
            this.formulaAdapters = new FormulaAdapterDelegate();
        }
        this.formulaAdapters.addAdapter(formulaName, adapter);
    }

    public ModifyManager getModifyManager() {
        return this.modifyManager;
    }

    public void setModifyManager(ModifyManager modifyManager) {
        this.modifyManager = modifyManager;
    }

    public static SpreadManager getInstance() {
        return new SpreadManager();
    }
}

