/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.eas.fi.newrpt.client.designer.RowCompareWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TableSorter {
    private KDTable table;
    private Set columnFieldSet;
    private int order = 0;

    public TableSorter(KDTable table) {
        this.table = table;
        int colCount = table.getColumnCount();
        this.columnFieldSet = new HashSet();
        for (int i = 0; i < colCount; ++i) {
            this.columnFieldSet.add(table.getColumn(i).getKey());
        }
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                KDTable sortTable = (KDTable)e.getSource();
                if (e.getType() == 0) {
                    TableSorter.this.sort(sortTable.getColumnKey(e.getColIndex()));
                }
            }
        });
    }

    public void sort(String fieldName) {
        if (!this.columnFieldSet.contains(fieldName)) {
            return;
        }
        this.prepareSort(fieldName);
        ArrayList<RowCompareWrapper> list = new ArrayList<RowCompareWrapper>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            RowCompareWrapper rowCompareWrapper = new RowCompareWrapper(this.table.getRow(i), fieldName, this.order);
            list.add(rowCompareWrapper);
        }
        Collections.sort(list);
        this.table.removeRows();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IRow row = ((RowCompareWrapper)iterator.next()).getRow();
            IRow newRow = this.table.addRow();
            int colCount = this.table.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                newRow.getCell(i).setValue(row.getCell(i).getValue());
            }
        }
        this.afterSort();
    }

    private void prepareSort(String fieldName) {
        KDTSortManager sm = new KDTSortManager(this.table);
        int index = this.table.getColumnIndex(fieldName);
        sm.sort(index, this.order);
    }

    protected void afterSort() {
        this.setOrder();
    }

    private void setOrder() {
        this.order = this.order == 0 ? 1 : 0;
    }

    public KDTable getTable() {
        return this.table;
    }

    public Set getColumnFieldSet() {
        return this.columnFieldSet;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

