/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer.io;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.io.IConstants;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class WizzardIO
extends KDDialog
implements ISpreadWizzard,
IConstants {
    private static final Logger logger = CoreUIObject.getLogger(WizzardIO.class);
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTML = new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page"));
    private final SimpleFileFilter Filter_Excel2003 = new SimpleFileFilter("xls", "MS Excel2003" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_Excel2007 = new SimpleFileFilter("xlsx", "MS Excel2007" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDF = new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_XML = new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table"));
    private KDLabel _lbFile;
    private KDTextField _tfFile;
    private KDButton _btnFile;
    private KDLabel _lbImportMode;
    protected KDComboBox _cbImportMode;
    private KDButton _btnSelAll;
    private KDButton _btnUnSelAll;
    private ImportOptionPanel _pnlIm;
    private ExportOptionPanel _pnlEx;
    protected SheetListPanel _pnlSheet;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    protected SpreadContext _context;
    protected KDFileChooser _chsFile;
    protected boolean _isForImport;
    private File file = new File(FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "export.properties")));
    private File importFile = new File(FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "import.properties")));
    private String rptName;
    private boolean isOnline = false;
    private IObjectValue objectValue;
    boolean hasClueOn = false;
    boolean iscomplete = false;

    public WizzardIO(Dialog parent, SpreadContext context) {
        super(parent, true);
        this.initSpreadContext(context);
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    public WizzardIO(Frame parent, SpreadContext context) {
        super(parent, true);
        this.initSpreadContext(context);
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    public WizzardIO(Dialog parent, SpreadContext context, IObjectValue objectValue) {
        this(parent, context);
        this.objectValue = objectValue;
    }

    public WizzardIO(Frame parent, SpreadContext context, IObjectValue objectValue) {
        this(parent, context);
        this.objectValue = objectValue;
    }

    private void initSpreadContext(SpreadContext context) {
        this._context = context;
    }

    private void initDialog() {
        if (!this.isOnline) {
            this.setSize(500, 310);
        } else {
            this.setSize(470, 245);
        }
        this.setResizable(false);
        this._chsFile = this.createFileChooser();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WizzardIO.this._pnlSheet.setData(null);
            }
        });
    }

    private void initComps() {
        if (!this.isOnline) {
            this._lbFile = new KDLabel(this.getLocalText("Key_File"));
            this._tfFile = new KDTextField();
            this._tfFile.setEditable(false);
            this._btnFile = new KDButton(this.getLocalText("Key_Scan"));
            this._btnFile.addActionListener((ActionListener)new ChooseFileAction());
        }
        this._lbImportMode = new KDLabel(this.getLocalText("Key_ImportMode"));
        this._cbImportMode = new KDComboBox((Object[])new String[]{this.getLocalText("Key_ImportMode_Override"), this.getLocalText("Key_ImportMode_Append")});
        this._cbImportMode.setEditable(false);
        this._btnSelAll = new KDButton();
        this._btnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_SelectAll.gif"));
        this._btnSelAll.setBorder(null);
        this._btnSelAll.setLimitedSize(false);
        this._btnSelAll.setToolTipText(this.getLocalText("Key_SelectAllSheets"));
        this._btnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this._pnlSheet.setAllSelected(true);
            }
        });
        this._btnUnSelAll = new KDButton();
        this._btnUnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_deleteall.gif"));
        this._btnUnSelAll.setBorder(null);
        this._btnUnSelAll.setLimitedSize(false);
        this._btnUnSelAll.setToolTipText(this.getLocalText("Key_UnSelectAllSheets"));
        this._btnUnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this._pnlSheet.setAllSelected(false);
            }
        });
        this._pnlIm = new ImportOptionPanel();
        this._pnlEx = new ExportOptionPanel();
        this._pnlSheet = new SheetListPanel();
        this._btnOk = new KDButton(this.getLocalText("Key_Ok"));
        this._btnOk.addActionListener((ActionListener)new FinishAction());
        this.getRootPane().setDefaultButton((JButton)this._btnOk);
        this._btnCancel = new KDButton(this.getLocalText("Key_Cancel"));
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this.closeDialog();
            }
        });
    }

    private void initPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        if (!this.isOnline) {
            cp.add((Component)this._lbFile);
            cp.add((Component)this._tfFile);
            cp.add((Component)this._btnFile);
            this._lbFile.setBounds(10, 10, 460, 20);
            this._tfFile.setBounds(10, 35, 370, 20);
            this._btnFile.setBounds(390, 35, 80, 20);
        }
        cp.add((Component)this._lbImportMode);
        cp.add((Component)this._cbImportMode);
        cp.add((Component)this._btnSelAll);
        cp.add((Component)this._btnUnSelAll);
        int y = 65;
        if (this.isOnline) {
            y = 10;
        }
        this._lbImportMode.setBounds(10, y, 100, 20);
        this._cbImportMode.setBounds(120, y, 100, 20);
        this._btnSelAll.setBounds(415, y, 20, 20);
        this._btnUnSelAll.setBounds(440, y, 20, 20);
        cp.add((Component)((Object)this._pnlIm));
        cp.add((Component)((Object)this._pnlEx));
        cp.add((Component)((Object)this._pnlSheet));
        y = 90;
        if (this.isOnline) {
            y = 45;
        }
        this._pnlIm.setLocation(10, y);
        this._pnlEx.setLocation(10, y);
        this._pnlSheet.setLocation(240, y);
        y = 245;
        if (this.isOnline) {
            y = 195;
        }
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        this._btnOk.setBounds(300, y, 80, 20);
        this._btnCancel.setBounds(390, y, 80, 20);
    }

    private void closeDialog() {
        if (!this.isOnline) {
            this._tfFile.setText("");
        }
        this.setVisible(false);
        this.dispose();
        this._context.requestFocus();
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    private KDFileChooser createFileChooser() {
        KDFileChooser chsFile = new KDFileChooser();
        chsFile.setDialogTitle(this.getLocalText("Key_File"));
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_XML);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel2003);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel2007);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
        chsFile.setFileFilter((FileFilter)this.Filter_XML);
        return chsFile;
    }

    public void setForImport(boolean b) {
        this._isForImport = b;
    }

    public boolean prepare() {
        this.setTitle(this.getLocalText(this._isForImport ? "Key_ImportFile" : "Key_ExportFile"));
        this._pnlIm.setVisible(this._isForImport);
        this._pnlEx.setVisible(!this._isForImport);
        this._lbImportMode.setVisible(this._isForImport);
        this._cbImportMode.setVisible(this._isForImport);
        if (this._isForImport) {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_HTML);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
            if (ff != this.Filter_PDF && ff != this.Filter_HTML) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this.setDefaultFilePath(true);
        } else {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_KDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
            if (ff != this.Filter_KDF) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this._pnlSheet.setData(this._context.getBook());
            this.setDefaultFilePath(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultFilePath(boolean isImport) {
        InputStream is = null;
        try {
            File file;
            if (isImport ? this.importFile.exists() : this.file.exists()) {
                Properties properties = new Properties();
                is = new FileInputStream(isImport ? this.importFile : this.file);
                properties.load(is);
                String value = FilenameUtils.normalize((String)properties.getProperty(isImport ? "importPath" : "exportPath"));
                if (!StringUtils.isEmpty((String)value)) {
                    File tmp = new File(value);
                    String path = tmp.getParent();
                    String filename = tmp.getName();
                    String name = null;
                    name = !filename.contains(".") ? filename : filename.substring(0, filename.lastIndexOf("."));
                    String fileType = filename.substring(filename.lastIndexOf(".") + 1);
                    if ("xml".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                    } else if ("xls".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2003);
                    } else if ("xlsx".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2007);
                    } else if ("pdf".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_PDF);
                    } else if ("htm".equalsIgnoreCase(fileType) || "html".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_HTML);
                    }
                    String separator = File.separator;
                    if (isImport) {
                        this._tfFile.setText(path + separator + filename);
                        this._chsFile.setSelectedFile(new File(path + separator + name));
                        this.openSheetList();
                    } else {
                        this._tfFile.setText(path + separator + this.rptName + "." + fileType);
                        this._chsFile.setSelectedFile(new File(path + separator + this.rptName));
                    }
                }
            } else if (!isImport && !this.file.exists() && (file = this._chsFile.getCurrentDirectory()) != null) {
                file = new File(file, this.rptName);
                this._tfFile.setText(file.getPath() + "." + "xml");
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                this._chsFile.setSelectedFile(file);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setRptName(String rptName) {
        this.rptName = rptName;
    }

    public void commit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file, String filePath) {
        OutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.exists()) {
                Properties p = new Properties();
                String path = this._tfFile.getText();
                p.setProperty(filePath, path);
                os = new FileOutputStream(file);
                p.store(os, "");
            }
        }
        catch (IOException e1) {
            logger.error((Object)"save", (Throwable)e1);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)"os.close()", (Throwable)e1);
            }
        }
    }

    private void openSheetList() {
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        if (this.acceptExtension(sff, fileName, "xls")) {
            this._pnlSheet.setData(this.openSheetListFromXls(fileName));
        } else if (this.acceptExtension(sff, fileName, "xlsx")) {
            this._pnlSheet.setData(this.openSheetListFromXlsx(fileName));
        } else if (this.acceptExtension(sff, fileName, "pdf")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else if (this.acceptExtension(sff, fileName, "htm") || this.acceptExtension(sff, fileName, "html")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else {
            this._pnlSheet.setData(this.openSheetListFromXml(fileName));
        }
    }

    private Book openSheetListFromXml(String fileName) {
        try {
            return IOHelper.loadFile((String)fileName);
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
        }
        catch (Throwable e1) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"24_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
        }
        return null;
    }

    private Book openSheetListFromXls(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"25_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            logger.error((Object)"", (Throwable)e);
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate((KDSBook)kdsbook);
        }
        String str = this.getLocalText("Key_UnsupportedFileFormat");
        WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
        return null;
    }

    private Book openSheetListFromXlsx(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = new Excel2007Reader().parse(fileName);
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (Exception e) {
            if (e.getCause() instanceof FileNotFoundException) {
                WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            } else {
                WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"25_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            }
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate((KDSBook)kdsbook);
        }
        String str = this.getLocalText("Key_UnsupportedFileFormat");
        WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
        return null;
    }

    private void transBook() throws Exception {
        if (this._pnlSheet._book == null) {
            String str = this.getLocalText("Key_NeedOpenFile");
            WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
            return;
        }
        for (int i = 0; i < this._pnlSheet._book.getSheetCount(); ++i) {
            Sheet sheet = this._pnlSheet._book.getSheet(i);
            if (this.checkCanImport(sheet, this._pnlSheet._book)) continue;
            return;
        }
        if (this._cbImportMode.getSelectedIndex() == 0) {
            if (this._pnlSheet.getSelectedSheets().length == 0) {
                return;
            }
            this.overWriteImport();
        } else {
            int cellDisplayMode = this._context.getBook().getActiveSheet().getSheetOption().getCellDisplayMode();
            String[] sns = this._pnlSheet.getSelectedSheets();
            if (sns.length > 0) {
                int i;
                BookProperties bpSrc = BookProperties.loadFromBook((Book)this._pnlSheet._book);
                for (int i2 = 0; i2 < this._pnlSheet._book.getSheetCount(); ++i2) {
                    String name = this._pnlSheet._book.getSheet(i2).getSheetName();
                    boolean selected = false;
                    for (int j = 0; j < sns.length; ++j) {
                        if (!name.equals(sns[j])) continue;
                        selected = true;
                        break;
                    }
                    if (selected) continue;
                    bpSrc.notifyDeleteSheet(name);
                }
                Book book = this._context.getBook();
                BookProperties bpDest = BookProperties.loadFromBook((Book)book);
                byte[] data = bpDest.toByteData();
                boolean b = book.getUndoManager().isEnable();
                book.getUndoManager().discardAllEdits();
                book.getUndoManager().enable(false);
                book.startGroup();
                HashSet<String> names = new HashSet<String>(sns.length);
                for (i = 0; i < this._pnlSheet._book.getSheetCount(); ++i) {
                    String name = this._pnlSheet._book.getSheet(i).getSheetName();
                    names.add(name);
                }
                for (i = 0; i < sns.length; ++i) {
                    String srcName = sns[i];
                    Sheet sheet = this._pnlSheet._book.getSheet(sns[i]);
                    sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
                    String destName = this.getSheetName(srcName, book);
                    if (!srcName.equals(destName)) {
                        sheet.setName(destName);
                        bpSrc.notifyRenameSheet(srcName, destName);
                    }
                    book.addSheet(sheet, false);
                    this.croppSheet(sheet);
                    sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
                }
                for (i = 0; i < sns.length; ++i) {
                    if (names.contains(sns[i])) continue;
                    bpSrc.notifyDeleteSheet(sns[i]);
                }
                bpDest = bpDest.loadFromByteData(data);
                bpDest.merge(bpSrc);
                bpDest.restoreToBook(book);
                book.endGroup();
                book.getUndoManager().enable(b);
            }
        }
        this._context.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizzardIO.this._context.requestFocus();
            }
        });
        if (this._chsFile.getFileFilter().equals(this.Filter_XML)) {
            this._context.getBook().setUserObject("isFromXMLImport", (Object)Boolean.TRUE);
        }
        if (this.objectValue != null && this.objectValue instanceof TemplateInfo) {
            MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"template_import_success"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"report_import_success"));
        }
    }

    private boolean checkCanImport(Sheet sheet, Book book) throws Exception {
        int rptClass;
        RptTmpTypeEnum tmpType;
        if (!(this.objectValue == null || !(this.objectValue instanceof TemplateInfo) || (tmpType = ((TemplateInfo)this.objectValue).getTemplateType()) == null || tmpType.equals((Object)RptTmpTypeEnum.COMMONREPORT) || tmpType.equals((Object)RptTmpTypeEnum.GROUPREPORT) || tmpType.equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || !CslRptUtil.isInterOrExchSheet((int)(rptClass = CslRptUtil.getReportClass((Book)book, (Sheet)sheet))) && 40 != rptClass)) {
            MsgBox.showInfo((Component)((Object)this), (String)new MessageFormat(RptUtil.getReportResource((String)"474cantImport")).format(new Object[]{tmpType.getAlias(), CSLReportGroupEnum.getEnum((int)rptClass).getAlias()}));
            return false;
        }
        return true;
    }

    private String getSheetName(String name, Book book) {
        String src = name;
        int count = 1;
        while (book.getSheet(src) != null) {
            src = name + "(" + count + ")";
            ++count;
        }
        return src;
    }

    private void croppSheet(Sheet sheet) {
        int option = this._pnlIm.getImportOption();
        if (option == 0) {
            return;
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, false);
        while (it.hasNext()) {
            Cell cell = it.next();
            String formula = cell.getFormula();
            if (formula == null || formula.length() <= 0 || formula.charAt(0) != '=') continue;
            if (option == 2) {
                cell.setValue(Variant.nullVariant);
                cell.setFormula(formula);
                continue;
            }
            if (option != 1) continue;
            Variant value = cell.getValue();
            cell.setFormula(null);
            cell.setValue(value);
        }
    }

    private void filterSheets() {
        int i;
        String[] sheets = this._pnlSheet.getSelectedSheets();
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < sheets.length; ++i2) {
            list.add(sheets[i2]);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (i = 0; i < this._pnlSheet._book.getSheetCount(); ++i) {
            if (list.contains(this._pnlSheet._book.getSheet(i).getSheetName())) continue;
            list2.add(this._pnlSheet._book.getSheet(i).getSheetName());
        }
        for (i = 0; i < list2.size(); ++i) {
            this._pnlSheet._book.removeSheet((String)list2.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCanExport(File file) {
        FileOutputStream fis;
        block4: {
            fis = null;
            try {
                if (!file.exists()) break block4;
                fis = new FileOutputStream(file);
            }
            catch (Exception e) {
                try {
                    MsgBox.showConfirm2((String)e.getMessage());
                    SysUtil.abort();
                }
                catch (Throwable throwable) {
                    CslRptUtil.close(fis);
                    throw throwable;
                }
                CslRptUtil.close((Object)fis);
            }
        }
        CslRptUtil.close(fis);
    }

    private boolean saveToFile() {
        boolean isMkSuccess;
        File path;
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        if (fileName == null || fileName.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.client.designer.DesignerResource", (String)"Select_File_First"));
            return false;
        }
        File file = new File(fileName);
        this.checkCanExport(file);
        if (!this.hasClueOn && file.exists()) {
            int showConfirm3 = MsgBox.showConfirm3((Component)this._tfFile, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"file-overwrite-confirm", (Locale)SysContext.getSysContext().getLocale()));
            if (showConfirm3 == 2) {
                this.closeDialog();
                SysUtil.abort();
            } else if (showConfirm3 == 1) {
                return false;
            }
            this.checkCanExport(file);
        }
        if (!(path = new File(file.getParent())).exists() && !(isMkSuccess = path.mkdirs())) {
            MsgBox.showWarning((String)DesignerResource.getString("29_mkdirsFail"));
            return false;
        }
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        boolean is_success = false;
        is_success = this.acceptExtension(sff, fileName = this.addExtension2(fileName, sff), "xls") ? this.exportToXls(fileName) : (this.acceptExtension(sff, fileName, "xlsx") ? this.exportToExcel2007(fileName) : (this.acceptExtension(sff, fileName, "pdf") ? this.exportToPdf(fileName) : (this.acceptExtension(sff, fileName, "html") ? this.exportToHtml(fileName) : this.exportToXml(fileName))));
        if (is_success) {
            if (this.objectValue != null && this.objectValue instanceof TemplateInfo) {
                MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"template_export_success"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"report_export_success"));
            }
        }
        return is_success;
    }

    private String addExtension2(String fileName, SimpleFileFilter sff) {
        if (sff == null) {
            return fileName;
        }
        fileName = this.acceptExtension(sff, fileName, "xls") ? this.addExtension(fileName, "xls") : (this.acceptExtension(sff, fileName, "xlsx") ? this.addExtension(fileName, "xlsx") : (this.acceptExtension(sff, fileName, "pdf") ? this.addExtension(fileName, "pdf") : (this.acceptExtension(sff, fileName, "html") ? this.addExtension(fileName, "html") : (this.acceptExtension(sff, fileName, "kdf") ? this.addExtension(fileName, "kdf") : this.addExtension(fileName, "xml")))));
        return fileName;
    }

    private boolean acceptExtension(SimpleFileFilter sff, String fileName, String extension) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (sff != null) {
            return sff.acceptExtension(extension);
        }
        return fileName.toLowerCase(locale).endsWith(extension.toLowerCase(locale));
    }

    private boolean exportToHtml(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)this._pnlSheet._book, (String[])sns);
        PrintableBook prtbook = new PrintableBook(kdsbook);
        try {
            new ExportManager().exportToHtmlFile(prtbook, fileName);
            return true;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
    }

    private boolean exportToPdf(String fileName) {
        try {
            String[] sns = this._pnlSheet.getSelectedSheets();
            if (sns.length == 0) {
                WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                return false;
            }
            KDSBook kdsbook = BookToKDSBook.traslate((Book)this._pnlSheet._book, (String[])sns);
            PrintableBook prtbook = new PrintableBook(kdsbook);
            new ExportManager().exportToPdfFile(prtbook, fileName);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null && !StringUtils.isEmpty((String)e.getCause().getMessage())) {
                message = e.getCause().getMessage();
            }
            WindowUtil.msgboxError((Object)message, (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportToXls(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        Book tempBook = this._pnlSheet._book;
        boolean isConfirm = false;
        for (int i = 0; i < sns.length; ++i) {
            Sheet sheet = tempBook.getSheet(sns[i]);
            if (sheet.getMaxColIndex() <= 255 && sheet.getMaxRowIndex() <= 65535) continue;
            if (!isConfirm) {
                int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource", (String)"excel255_65535"));
                if (confirm != 0) {
                    return false;
                }
                isConfirm = true;
            }
            try {
                if (tempBook == this._pnlSheet._book) {
                    tempBook = SpreadHelper.copyBook(this._pnlSheet._book);
                    sheet = tempBook.getSheet(sns[i]);
                }
                if (sheet.getMaxColIndex() > 255) {
                    sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                }
                if (sheet.getMaxRowIndex() <= 65535) continue;
                sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                continue;
            }
            catch (Exception e) {
                WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                return false;
            }
        }
        if (this._pnlEx._rbValueAndItemNumOfItemFormula.isSelected() && this.needToConvert(tempBook, sns)) {
            this.convertItemFormula2ItemNumToExport(tempBook, sns);
        }
        boolean isAutoCalc = false;
        try {
            isAutoCalc = tempBook.isAutoCalculate();
            tempBook.setAutoCalculate(false);
            KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook, (String[])sns);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
            if (this._pnlEx._rbValueAndExcelFormula.isSelected() || this._pnlEx._rbValueAndItemNumOfItemFormula.isSelected()) {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            } else if (this._pnlEx._rbValueAndFormula.isSelected()) {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
            } else {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            }
            try {
                em.exportToExcel(kdsbook, fileName);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (e.getCause() != null && !StringUtils.isEmpty((String)e.getCause().getMessage())) {
                    message = e.getCause().getMessage();
                }
                WindowUtil.msgboxError((Object)message, (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                boolean bl = false;
                if (tempBook != null) {
                    tempBook.setAutoCalculate(isAutoCalc);
                }
                return bl;
            }
            finally {
                if (this._pnlEx._rbValueAndItemNumOfItemFormula.isSelected()) {
                    this.repairCellFormulaValue(tempBook, sns);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (tempBook != null) {
                tempBook.setAutoCalculate(isAutoCalc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportToExcel2007(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        Book tempBook = null;
        boolean isAutoCalc = false;
        try {
            ArrayList<Sheet> exportSheet = new ArrayList<Sheet>();
            if (sns.length == this._pnlSheet._book.getSheetCount()) {
                tempBook = this._pnlSheet._book;
            } else {
                tempBook = Book.Manager.getNewBook(null);
                int sheetCount = tempBook.getSheetCount();
                Sheet exportToExcelTempSheet = new Sheet(tempBook, "&exportToExcelTempSheet&");
                tempBook.addSheet(exportToExcelTempSheet);
                for (int i = sheetCount - 1; i >= 0; --i) {
                    tempBook.removeSheet(i);
                }
                for (int j = 0; j < sns.length; ++j) {
                    Sheet sheet = this._pnlSheet._book.getSheetByName(sns[j]);
                    tempBook.addSheet(sheet);
                    exportSheet.add(sheet);
                }
                tempBook.removeSheet(exportToExcelTempSheet);
            }
            if (this._pnlEx._rbValueAndItemNumOfItemFormula.isSelected() && this.needToConvert(tempBook, sns)) {
                this.convertItemFormula2ItemNumToExport(tempBook, null);
            }
            isAutoCalc = tempBook.isAutoCalculate();
            tempBook.setAutoCalculate(false);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(tempBook);
            if (this._pnlEx._rbValueAndExcelFormula.isSelected() || this._pnlEx._rbValueAndItemNumOfItemFormula.isSelected()) {
                bookDataWrapper.setExportFormula(true);
                bookDataWrapper.setExportCustomerFomulas(false);
            } else if (this._pnlEx._rbValueAndFormula.isSelected()) {
                bookDataWrapper.setExportFormula(true);
                bookDataWrapper.setExportCustomerFomulas(true);
            } else {
                bookDataWrapper.setExportFormula(false);
                bookDataWrapper.setExportCustomerFomulas(true);
                bookDataWrapper.setShowValue(true);
            }
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            Excel2007ExportController.export((String)fileName, (AbstractDataWrapper)bookDataWrapper, (boolean)false, (ExportListener[])new ExportListener[]{new ExportListener2007()});
            this.monitorExport();
            if (exportSheet.size() > 0) {
                Class[] paramTypes = new Class[]{Book.class};
                for (Sheet sheet : exportSheet) {
                    Method method = sheet.getClass().getDeclaredMethod("setBook", paramTypes);
                    NewRptUtil.makeAccessible(method);
                    method.invoke((Object)sheet, this._pnlSheet._book);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempBook != null) {
                tempBook.setAutoCalculate(isAutoCalc);
            }
        }
    }

    private boolean needToConvert(Book tempBook, String[] sns) {
        int size;
        boolean need = true;
        int n = size = sns != null ? sns.length : tempBook.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet;
            Sheet sheet2 = sheet = sns != null ? tempBook.getSheet(sns[i]) : tempBook.getSheet(i);
            if (sheet.getUserObject("columnCount") == null) continue;
            need = false;
        }
        return need;
    }

    private void convertItemFormula2ItemNumToExport(Book tempBook, String[] sns) {
        int size;
        ArrayList basePointList = null;
        DynaParameters Param2 = null;
        Boolean isHorizon = null;
        HashSet<Integer> basePointPosition = new HashSet<Integer>();
        int n = size = sns != null ? sns.length : tempBook.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = sns != null ? tempBook.getSheet(sns[i]) : tempBook.getSheet(i);
            basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            if (basePointList != null && !basePointList.isEmpty() && (Param2 = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)((Point)basePointList.get(0)))) != null) {
                isHorizon = Param2.getSpreadStyle() == 1;
                for (int index = 0; index < basePointList.size(); ++index) {
                    if (isHorizon.booleanValue()) {
                        basePointPosition.add(((Point)basePointList.get((int)index)).x);
                        continue;
                    }
                    basePointPosition.add(((Point)basePointList.get((int)index)).y);
                }
            }
            int row = sheet.getRows().getMaxIntMark() + 1;
            int col = sheet.getCols().getMaxIntMark() + 1;
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, false, true);
            while (iter.hasNext()) {
                ItemFormula item;
                Cell cell = iter.next();
                if (isHorizon != null && (isHorizon.booleanValue() && basePointPosition.contains(cell.getCol()) || !isHorizon.booleanValue() && basePointPosition.contains(cell.getRow())) || cell == null || (item = (ItemFormula)cell.getUserObjectValue("ITEM")) == null) continue;
                String obj = item.getExt("DynaParameters");
                String bp = item.getExt("CSL_TEMPLATE_BASEPOSITION");
                String caCom = item.getExt("16");
                if ("CSL_TEMPLATE_BASEPOSITION".equals(bp) || obj != null && obj instanceof String || caCom != null) continue;
                cell.setUserObject("formula", (Object)cell.getFormula());
                cell.setUserObject("value", (Object)cell.getValue());
                cell.setFormula(null);
                cell.setValue(new Variant((Object)item.getItemNumber()));
            }
            isHorizon = null;
            basePointPosition.clear();
        }
    }

    private void repairCellFormulaValue(Book tempBook, String[] sns) {
        if (tempBook.equals((Object)this._pnlSheet._book)) {
            int size;
            int n = size = sns == null ? tempBook.getSheetCount() : sns.length;
            for (int i = 0; i < size; ++i) {
                Sheet sheet = sns == null ? tempBook.getSheet(i) : tempBook.getSheet(sns[i]);
                int row = sheet.getRows().getMaxIntMark() + 1;
                int col = sheet.getCols().getMaxIntMark() + 1;
                Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, false, true);
                Object value = null;
                Object formula = null;
                while (iter.hasNext()) {
                    ItemFormula item;
                    Cell cell = iter.next();
                    if (cell == null || (item = (ItemFormula)cell.getUserObjectValue("ITEM")) == null) continue;
                    value = cell.getUserObjectValue("value");
                    formula = cell.getUserObjectValue("formula");
                    if (formula != null) {
                        cell.setFormula(formula.toString());
                        cell.removeUserObject("formula");
                    }
                    if (value == null) continue;
                    cell.setValue(new Variant(value));
                    cell.removeUserObject("value");
                }
            }
        }
    }

    private void monitorExport() {
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), true);
        dialog.run(false, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                monitor.setTaskName(WizzardIO.this.getLocalText("Key_ExportTitle"));
                monitor.subTaskBegin(WizzardIO.this.getLocalText("Key_ExportTips"));
                while (!WizzardIO.this.iscomplete) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Thread.sleep(200) error", (Throwable)e);
                    }
                }
                monitor.done();
            }
        });
    }

    private boolean exportToXml(String fileName) {
        try {
            IOHelper.saveToFile((Book)this._pnlSheet._book, (String)fileName, (String[])this._pnlSheet.getSelectedSheets());
            return true;
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        return false;
    }

    private String addExtension(String fileName, String extension) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (fileName.toLowerCase(locale).endsWith(extension.toLowerCase(locale))) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    protected void overWriteImport() {
        Collection expressions;
        RptCheckExpTank expTank;
        String[] sns = this._pnlSheet.getSelectedSheets();
        Book book = this._context.getBook();
        if (book.getProtection().isProtected()) {
            MsgBox.showWarning((Component)this._context, (String)DesignerResource.getString("protectedBook"));
            SysUtil.abort();
        }
        boolean b = book.getUndoManager().isEnable();
        book.getUndoManager().discardAllEdits();
        book.getUndoManager().enable(false);
        book.startGroup();
        int cellDisplayMode = this._context.getBook().getActiveSheet().getSheetOption().getCellDisplayMode();
        LinkedList<String> snsNameList = new LinkedList<String>();
        for (int i = 0; i < sns.length; ++i) {
            snsNameList.add(sns[i]);
        }
        int count = book.getSheetCount();
        ArrayList<String> deleteSheetNameList = new ArrayList<String>();
        block1: for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            boolean isExistSheet = false;
            for (String sheetName : snsNameList) {
                if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                isExistSheet = true;
                break;
            }
            if (!isExistSheet) continue;
            if (sheet.getSheetOption().getProtection(true).isProtected()) {
                if (this.hasLockedCell(sheet)) {
                    this.overWriterImportWithProtection(sheet, this._pnlSheet._book.getSheet(sheet.getSheetName()));
                    Iterator iterator = snsNameList.iterator();
                    while (iterator.hasNext()) {
                        String sheetName;
                        sheetName = (String)iterator.next();
                        if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                        iterator.remove();
                        continue block1;
                    }
                    continue;
                }
                deleteSheetNameList.add(sheet.getSheetName());
                continue;
            }
            deleteSheetNameList.add(sheet.getSheetName());
        }
        String tempRemoveStr = "tempRemove_";
        HashMap<String, HashSet<RptCheckExpression>> expressionsSheetMap = new HashMap<String, HashSet<RptCheckExpression>>();
        RptOperationSchemaComp schema = (RptOperationSchemaComp)book.getUserObjectValue("operationSchemas");
        if (schema != null && (expTank = schema.getExpTank()) != null && (expressions = expTank.getExpressions()) != null) {
            for (RptCheckExpression exp : expressions) {
                if (exp == null) continue;
                HashSet<RptCheckExpression> expressionSet = (HashSet<RptCheckExpression>)expressionsSheetMap.get(exp.getSheetName());
                if (expressionSet == null) {
                    expressionSet = new HashSet<RptCheckExpression>();
                    expressionsSheetMap.put(exp.getSheetName(), expressionSet);
                }
                expressionSet.add(exp);
            }
        }
        HashSet<RptCheckExpression> removeRptCheckExpressionSet = new HashSet<RptCheckExpression>();
        String[] ids = new String[deleteSheetNameList.size()];
        Set expressionSet = null;
        for (int i = deleteSheetNameList.size() - 1; i >= 0; --i) {
            String sheetName = (String)deleteSheetNameList.get(i);
            expressionSet = (Set)expressionsSheetMap.get(sheetName);
            if (expressionSet != null && !expressionSet.isEmpty()) {
                for (RptCheckExpression rptCheckExpression : expressionSet) {
                    rptCheckExpression.setSheetName(tempRemoveStr + sheetName);
                    removeRptCheckExpressionSet.add(rptCheckExpression);
                }
            }
            ids[i] = book.getSheet(sheetName).getID();
            book.removeSheet(sheetName);
        }
        BookProperties bpsrc = BookProperties.loadFromBook((Book)book);
        int index = 0;
        int i = 0;
        String firstImportSheetName = null;
        for (String sheetName : snsNameList) {
            Sheet sheet = this._pnlSheet._book.getSheet(sheetName);
            sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
            if (i == 0) {
                firstImportSheetName = sheetName;
            }
            book.addSheet(sheet, false);
            if (index < ids.length) {
                sheet.setID(ids[index++]);
            }
            this.croppSheet(sheet);
            sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
            ++i;
        }
        if (removeRptCheckExpressionSet.size() > 0) {
            for (RptCheckExpression checkExpression : removeRptCheckExpressionSet) {
                checkExpression.setSheetName(checkExpression.getSheetName().replaceFirst(tempRemoveStr, ""));
            }
        }
        BookProperties bp = BookProperties.loadFromBook((Book)this._pnlSheet._book);
        bp.merge(bpsrc);
        bp.restoreToBook(this._context.getBook());
        if (firstImportSheetName != null) {
            if (book.getActiveSheet() != null) {
                book.getActiveSheet().setSelected(false);
            }
            book.setActiveSheet(firstImportSheetName);
        }
        book.endGroup();
        book.getUndoManager().enable(b);
    }

    private boolean hasLockedCell(Sheet sheet) {
        if (!sheet.getSheetOption().getProtection(true).isProtected()) {
            return false;
        }
        Sheet.ICellsIterator iterator = sheet.getCellsIterator(sheet.getSheetRange().getBlock(0), false, false);
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (!cell.isLocked()) continue;
            return true;
        }
        return false;
    }

    protected void overWriterImportWithProtection(Sheet sourceSheet, Sheet targetSheet) {
        int targetRowIndex = targetSheet.getMaxRowIndex();
        int targetColIndex = targetSheet.getMaxColIndex();
        int sourceRowIndex = sourceSheet.getMaxRowIndex();
        int sourceColIndex = sourceSheet.getMaxColIndex();
        int rowCount = Math.max(targetRowIndex, sourceRowIndex);
        int colCount = Math.max(targetColIndex, sourceColIndex);
        int option = this._pnlIm.getImportOption();
        for (int row = 0; row <= rowCount; ++row) {
            for (int col = 0; col <= colCount; ++col) {
                Cell targetCell = targetSheet.getCell(row, col, true);
                Cell sourceCell = sourceSheet.getCell(row, col, true);
                if (sourceCell.isLocked()) continue;
                if (option == 2) {
                    sourceCell.setValue(Variant.nullVariant);
                    sourceCell.setFormula(targetCell.getFormula());
                } else if (option == 1) {
                    sourceCell.setFormula(null);
                    sourceCell.setValue(targetCell.getValue());
                } else {
                    sourceCell.setValue(targetCell.getValue());
                    sourceCell.setFormula(targetCell.getFormula());
                }
                sourceCell.setComment((Comment)CommentUtil.getReportComment(targetCell));
                if (!targetCell.isLocked()) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(true);
                sourceSheet.getRange(sourceCell).setStyle(sa, Styles.getEmptySA());
            }
        }
        if (targetSheet.getUserObjects() != null && targetSheet.getUserObjects().size() > 0) {
            if (sourceSheet.getUserObjects() != null) {
                sourceSheet.getUserObjects().clear();
            }
            for (int i = 0; i < targetSheet.getUserObjects().size(); ++i) {
                sourceSheet.setUserObject(targetSheet.getUserObjects().getUserObject(i).getKey(), targetSheet.getUserObjects().getUserObject(i).getValue());
            }
        } else if (sourceSheet.getUserObjects() != null) {
            sourceSheet.getUserObjects().clear();
        }
    }

    public WizzardIO(Frame parent, SpreadContext context, String savePath, Book book) {
        super(parent, true);
        this.isOnline = true;
        this.initSpreadContext(context);
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
        this.setForImport(true);
        this.onLineOpenSheetList(book);
    }

    private void onLineOpenSheetList(Book book) {
        this._pnlSheet.setData(book);
    }

    class ExportListener2007
    implements ExportListener {
        ExportListener2007() {
        }

        public void complete(ExportEvent e) {
            WizzardIO.this.iscomplete = true;
        }

        public void delEvent(ExportEvent e) {
        }
    }

    private class FinishAction
    extends AbstractAction {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WizzardIO.this._isForImport) {
                try {
                    WizzardIO.this.transBook();
                    WizzardIO.this.save(WizzardIO.this.importFile, "importPath");
                }
                catch (Exception ed) {
                    ExceptionHandler.handle((Component)((Object)WizzardIO.this), (Throwable)ed);
                }
            } else {
                boolean isDeployed = WizzardIO.this.saveToFile();
                if (!isDeployed) {
                    return;
                }
                WizzardIO.this.save(WizzardIO.this.file, "exportPath");
            }
            WizzardIO.this.closeDialog();
        }
    }

    private class ChooseFileAction
    extends AbstractAction {
        private ChooseFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret;
            String fileName;
            block11: {
                fileName = "";
                ret = 0;
                while ((ret = WizzardIO.this._chsFile.showOpenDialog((Component)((Object)WizzardIO.this))) == 0) {
                    String name;
                    File file = WizzardIO.this._chsFile.getSelectedFile();
                    fileName = file.getAbsolutePath();
                    SimpleFileFilter sff = null;
                    FileFilter fileFilter = WizzardIO.this._chsFile.getFileFilter();
                    if (fileFilter instanceof SimpleFileFilter) {
                        sff = (SimpleFileFilter)fileFilter;
                    }
                    if ((name = (file = new File(fileName = WizzardIO.this.addExtension2(fileName, sff))).getName()).matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                        MsgBox.showWarning((String)(name + "\n" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"invalidFileName", (Locale)SysContext.getSysContext().getLocale())));
                        continue;
                    }
                    if (!WizzardIO.this._isForImport && file.exists()) {
                        WizzardIO.this.hasClueOn = true;
                        int showConfirm3 = MsgBox.showConfirm3((Component)WizzardIO.this._tfFile, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"file-overwrite-confirm", (Locale)SysContext.getSysContext().getLocale()));
                        if (showConfirm3 == 2) {
                            WizzardIO.this.closeDialog();
                            SysUtil.abort();
                        } else if (showConfirm3 != 0 && showConfirm3 == 1) {
                            continue;
                        }
                    } else if (WizzardIO.this._isForImport && !file.isFile()) {
                        MsgBox.showWarning((String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError", (Locale)SysContext.getSysContext().getLocale()));
                        continue;
                    }
                    break block11;
                }
                return;
            }
            if (ret == 0) {
                WizzardIO.this._tfFile.setText(fileName);
                if (WizzardIO.this._isForImport && !StringUtils.isEmpty((String)fileName)) {
                    WizzardIO.this.openSheetList();
                }
            }
        }
    }

    private class SheetListPanel
    extends KDScrollPane {
        private KDPanel _pnlList;
        private Book _book;

        SheetListPanel() {
            this.setSize(230, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_Sheet")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._pnlList = new KDPanel();
            this.setViewportView((Component)this._pnlList);
        }

        void setData(Book book) {
            this._book = book;
            WizzardIO.this._btnOk.setEnabled(this._book != null);
            this._pnlList.removeAll();
            if (book != null && book.getSheetCount() > 0) {
                int count = book.getSheetCount();
                this._pnlList.setLayout((LayoutManager)new GridLayout(count, 1, 5, 0));
                for (int i = 0; i < count; ++i) {
                    KDCheckBox ck = new KDCheckBox(book.getSheet(i).getSheetName());
                    this._pnlList.add((Component)ck);
                    ck.setLocation(0, i * 25 + 25);
                    ck.setSelected(true);
                }
                this._pnlList.doLayout();
                this._pnlList.revalidate();
            }
        }

        void setAllSelected(boolean b) {
            int count = this._pnlList.getComponentCount();
            for (int i = 0; i < count; ++i) {
                ((KDCheckBox)this._pnlList.getComponent(i)).setSelected(b);
            }
        }

        String[] getSelectedSheets() {
            int count = this._pnlList.getComponentCount();
            ArrayList<String> al = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                if (!((KDCheckBox)this._pnlList.getComponent(i)).isSelected()) continue;
                al.add(this._book.getSheet(i).getSheetName());
            }
            if (al.size() == 0) {
                return new String[0];
            }
            String[] str = new String[al.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)al.get(i);
            }
            return str;
        }
    }

    private class ExportOptionPanel
    extends KDScrollPane {
        private KDRadioButton _rbValueAndFormula;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbValueAndExcelFormula;
        private KDRadioButton _rbValueAndItemNumOfItemFormula;

        ExportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_ExportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbValueAndFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_ValueAndFormula"));
            this._rbValueAndFormula.setSelected(true);
            this._rbValueAndExcelFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_ValueAndExcelformula"));
            this._rbValue = new KDRadioButton(WizzardIO.this.getLocalText("Key_Value"));
            this._rbValueAndItemNumOfItemFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_ValueAndItemNum"));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbValueAndFormula);
            bg.add((AbstractButton)this._rbValueAndExcelFormula);
            bg.add((AbstractButton)this._rbValue);
            bg.add((AbstractButton)this._rbValueAndItemNumOfItemFormula);
            KDPanel pnl = new KDPanel();
            pnl.setLayout((LayoutManager)new GridLayout(4, 1, 5, 0));
            pnl.add((Component)this._rbValueAndFormula);
            this._rbValueAndExcelFormula.setLocation(0, 0);
            pnl.add((Component)this._rbValueAndExcelFormula);
            this._rbValueAndExcelFormula.setLocation(0, 25);
            pnl.add((Component)this._rbValue);
            this._rbValue.setLocation(0, 50);
            pnl.add((Component)this._rbValueAndItemNumOfItemFormula);
            this._rbValueAndItemNumOfItemFormula.setLocation(0, 75);
            this.setViewportView((Component)pnl);
        }
    }

    private class ImportOptionPanel
    extends KDScrollPane {
        static final int IMPORT_ALL = 0;
        static final int IMPORT_VALUE = 1;
        static final int IMPORT_FORMULA = 2;
        private KDRadioButton _rbAll;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbFormula;

        ImportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_ImportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbAll = new KDRadioButton(WizzardIO.this.getLocalText("Key_AllContent"));
            this._rbAll.setSelected(true);
            this._rbValue = new KDRadioButton(WizzardIO.this.getLocalText("Key_Value"));
            this._rbFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_Formula"));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbAll);
            bg.add((AbstractButton)this._rbFormula);
            bg.add((AbstractButton)this._rbValue);
            KDPanel pnlOption = new KDPanel();
            pnlOption.setLayout((LayoutManager)new GridLayout(3, 1, 5, 0));
            pnlOption.add((Component)this._rbAll);
            this._rbFormula.setLocation(0, 0);
            pnlOption.add((Component)this._rbValue);
            this._rbValue.setLocation(0, 25);
            pnlOption.add((Component)this._rbFormula);
            this._rbFormula.setLocation(0, 50);
            this.setViewportView((Component)pnlOption);
        }

        int getImportOption() {
            if (this._rbFormula.isSelected()) {
                return 2;
            }
            if (this._rbValue.isSelected()) {
                return 1;
            }
            return 0;
        }
    }
}

