/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer.render;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.util.RowColChangeUtils;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultItemRenderProvider
implements IRenderProvider {
    public static final int LEFT_TOP = 0;
    public static final int RIGHT_TOP = 1;
    public static final int RIGHT_BOTTOM = 2;
    public static final int LEFT_BOTTOM = 3;
    private static final ItemFormulaRender lrt = new ItemFormulaRender();
    private static final IBasicRender bst = new BasePointRender();
    private Map<String, List<Point>> basePoints = new HashMap<String, List<Point>>();

    @Override
    public IBasicRender getRender(Cell cell, int viewMode) {
        ItemFormula obj = (ItemFormula)cell.getUserObjectValue("ITEM");
        if (obj == null) {
            if (RowColChangeUtils.isRowColChangeBasePoint(cell)) {
                return bst;
            }
            obj = NewRptUtil.generateCellDyItemFormula(cell, this.basePoints, null);
            if (obj == null) {
                return null;
            }
        }
        if (obj.isBasePoint()) {
            return bst;
        }
        DefaultItemRenderProvider.lrt.formulaInvalid = false;
        DefaultItemRenderProvider.lrt.isFormulaDuplicate = false;
        DefaultItemRenderProvider.lrt.itemNotExists = false;
        if (obj != null && obj.getExt("20") != null) {
            if (obj.getExt("20").equals("22")) {
                DefaultItemRenderProvider.lrt.formulaInvalid = true;
            } else if (obj.getExt("20").equals("24")) {
                DefaultItemRenderProvider.lrt.isFormulaDuplicate = true;
            } else {
                DefaultItemRenderProvider.lrt.itemNotExists = true;
            }
        }
        if (StringUtils.isEmpty((String)obj.getFormula())) {
            return null;
        }
        return lrt;
    }

    public static IBasicRender getLeftTopRender(Color c) {
        return new TriangleRender(c, 0, true);
    }

    public static IBasicRender getRightTopRender(Color c) {
        return lrt;
    }

    public static IBasicRender getRightBottomRender(Color c) {
        return new TriangleRender(c, 2, true);
    }

    public static IBasicRender getLeftBottomRender(Color c) {
        return new TriangleRender(c, 3, true);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(0).append(1).append(2).append(3);
        sb.append(DefaultItemRenderProvider.lrt.formulaInvalid).append(DefaultItemRenderProvider.lrt.isFormulaDuplicate).append(DefaultItemRenderProvider.lrt.itemNotExists);
        sb.append(DefaultItemRenderProvider.lrt.dx).append(DefaultItemRenderProvider.lrt.dy);
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected static final class ItemFormulaRender
    implements IBasicRender {
        boolean formulaInvalid = false;
        boolean itemNotExists = false;
        boolean isFormulaDuplicate = false;
        int[] dx = new int[]{0, 0, 0};
        int[] dy = new int[]{0, 0, 0};

        protected ItemFormulaRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 7;
            this.dx[0] = x - offset;
            this.dx[1] = x;
            this.dx[2] = x;
            this.dy[0] = y;
            this.dy[1] = y;
            this.dy[2] = y + offset;
            graphics.setColor(Color.GRAY);
            graphics.drawPolygon(this.dx, this.dy, 3);
            x = bd.x;
            y = bd.y;
            if (this.formulaInvalid) {
                this.dx[0] = x + 5;
                this.dx[1] = x;
                this.dx[2] = x;
                this.dy[0] = y;
                this.dy[1] = y;
                this.dy[2] = y + 5;
                graphics.setColor(Color.magenta);
                graphics.fillPolygon(this.dx, this.dy, 3);
            }
            if (this.itemNotExists) {
                graphics.setColor(Color.magenta);
                graphics.drawLine(x + 7, y, x, y + 7);
            }
            if (this.isFormulaDuplicate) {
                graphics.setColor(Color.magenta);
                graphics.drawLine(x + 7, y, x, y + 7);
                graphics.drawLine(x + 5, y, x, y + 5);
            }
            graphics.setColor(cl);
        }
    }

    protected static final class BasePointRender
    implements IBasicRender {
        protected BasePointRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            Object oldhint = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(Color.blue);
            graphics.fillOval(bd.x + bd.width - 6, bd.y, 6, 6);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldhint);
            graphics.setColor(cl);
        }
    }

    protected static final class TriangleRender
    implements IBasicRender {
        private final Color c;
        private final boolean isFill;
        private final int type;

        public TriangleRender(Color c, int type, boolean isFill) {
            this.c = c;
            this.type = type;
            this.isFill = isFill;
        }

        public void draw(Graphics graphics, Shape clip, Object arg2, Style arg3) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            switch (this.type) {
                case 0: {
                    this.drawLTCorner(graphics, this.c, bd);
                    break;
                }
                case 1: {
                    this.drawRTCorner(graphics, this.c, bd);
                    break;
                }
                case 2: {
                    this.drawRBCorner(graphics, this.c, bd);
                    break;
                }
                case 3: {
                    this.drawLBCorner(graphics, this.c, bd);
                }
            }
            graphics.setColor(cl);
        }

        private void drawLTCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x;
            int y = bd.y;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x, x + offset, x};
            int[] dy = new int[]{y, y, y + offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawRTCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x - offset, x, x};
            int[] dy = new int[]{y, y, y + offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawRBCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y + bd.height;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x - offset, x, x};
            int[] dy = new int[]{y, y, y - offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawLBCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y;
            int offset = 6;
            if (this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x, x + offset, x};
            int[] dy = new int[]{y, y, y - offset};
            graphics.setColor(color);
            if (!this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }
    }
}

