/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.designer.render;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class DynamicSumZoneCellRender
implements IRenderProvider {
    private static final KeySumZoneRender renderKey = new KeySumZoneRender(new Color(0, 128, 0));
    private static final KeySumZoneRender renderValue = new KeySumZoneRender(Color.BLUE);

    @Override
    public IBasicRender getRender(Cell cell, int viewMode) {
        CellBlock c;
        SumcalcRange obj = (SumcalcRange)cell.getSheet().getUserObjectValue("DYNAMICSUMKEYZONE");
        SumcalcRange objValue = (SumcalcRange)cell.getSheet().getUserObjectValue("DYNAMICSUMVALUEZONE");
        if (obj == null && objValue == null) {
            return null;
        }
        if (obj != null && obj.contains(c = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol()))) {
            return renderKey;
        }
        if (objValue != null && objValue.contains(c = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol()))) {
            return renderValue;
        }
        return null;
    }

    protected static final class KeySumZoneRender
    implements IBasicRender {
        int[] dx = new int[]{0, 0, 0};
        int[] dy = new int[]{0, 0, 0};
        Color curColor = null;

        public KeySumZoneRender(Color color) {
            this.curColor = color;
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 7;
            this.dx[0] = x - offset;
            this.dx[1] = x;
            this.dx[2] = x;
            this.dy[0] = y;
            this.dy[1] = y;
            this.dy[2] = y + offset;
            graphics.setColor(this.curColor);
            graphics.fillPolygon(this.dx, this.dy, 3);
            x = bd.x;
            y = bd.y;
            graphics.setColor(cl);
        }
    }
}

