/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.online;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.excel.print.PrintManager;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.bos.ctrl.print.extend.MultiPrintJobManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.client.online.AbstractOnLineLoadListUI;
import com.kingdee.eas.fi.newrpt.online.FileObject;
import com.kingdee.eas.fi.newrpt.online.Resource;
import com.kingdee.eas.fi.newrpt.online.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OnLineLoadListUI
extends AbstractOnLineLoadListUI {
    private String resId;
    private String resVersion;
    private String displayTemplateType;

    public void onLoad() throws Exception {
        super.onLoad();
        String type = (String)this.getUIContext().get("type");
        this.displayTemplateType = (String)this.getUIContext().get("displayTemplateType");
        ResourceUtil resUtil = new ResourceUtil();
        ArrayList resList = resUtil.getResource(type);
        this.fillResTree(resList);
        this.init();
    }

    private void init() {
        this.tblMain.setVisible(true);
        this.tblMain.checkParsed(false);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnConfig.setEnabled(true);
        this.kDSelectAll.setEnabled(true);
        this.kDSelectNone.setEnabled(true);
    }

    private void fillResTree(ArrayList<Resource> resList) {
        this.treeList.setModel(this.getNtTypeGroupTreeModel(resList));
        this.treeList.setCollapsePathDisabled(false);
        this.treeList.setRootVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.setSelectionRow(0);
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath treePath = this.treeList.getSelectionPath();
        if (null == treePath) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        Resource resource = (Resource)treeNode.getUserObject();
        this.resId = resource.getId();
        this.resVersion = resource.getVersion();
        Resource resList = ResourceUtil.getResList(this.resId, null);
        this.fillFillData(resList);
    }

    private void fillFillData(Resource res) throws BOSException, EASBizException {
        if (null == res) {
            this.tblMain.removeRows();
            return;
        }
        ArrayList<FileObject> fileList = res.getFileList();
        this.tblMain.removeRows();
        int size = fileList.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            FileObject file = fileList.get(i);
            row.getCell("id").setValue((Object)file.getId());
            row.getCell("select").setValue((Object)false);
            if (file.getDownTemplate() != null) {
                row.getCell("number").setValue((Object)file.getDownTemplate().getNumber());
                row.getCell("name").setValue((Object)file.getDownTemplate().getName());
                row.getCell("preset").setValue((Object)file.getDownTemplate().isPreset());
            }
            row.getCell("uploadDate").setValue((Object)file.getUploadDate());
            row.getCell("desc").setValue((Object)file.getAliases());
            row.getCell("fileName").setValue((Object)file.getName());
            row.getCell("fileLength").setValue((Object)file.getLength());
            row.setUserObject((Object)file);
        }
        this.tblMain.getColumn("preset").getStyleAttributes().setLocked(true);
        if (fileList.size() > 0) {
            this.tblMain.getSelectManager().setActiveRowIndex(0);
        }
    }

    private TreeModel getNtTypeGroupTreeModel(ArrayList<Resource> resList) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        for (int i = 0; i < resList.size(); ++i) {
            Resource resource = resList.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)resource);
            root.add((MutableTreeNode)node);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        return model;
    }

    public void doPreviewDownTemplate() throws Exception {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        String fileName = (String)row.getCell("fileName").getValue();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!ResourceUtil.checkFileSuffix(fileType)) {
            MsgBox.showError((String)ResourceUtil.getResString("downtemplate.preview.surport.xml"));
            return;
        }
        if (!ResourceUtil.canCreateTempFile("C:" + File.separator + "temp.xml") && !ResourceUtil.canCreateTempFile("D:" + File.separator + "temp.xml")) {
            MsgBox.showError((String)ResourceUtil.getResString("createNewFile.error"));
            return;
        }
        Book book = ResourceUtil.generateBook(this.resId, this.resVersion, fileName);
        if (null == book) {
            MsgBox.showError((String)ResourceUtil.getResString("downtemplate.has.not.context"));
            return;
        }
        book.removeSheet("Config Table");
        book.removeSheet("Item Properties");
        SpreadContext spread = new SpreadContext(book);
        PrintManager printManager = spread.getPrintManager();
        printManager.getPrinter().setParentWindow((Component)((Object)this));
        ((TablePrintSetupModel)printManager.getPrinter().getPrintConfig().getModel()).setPrintContentType(1);
        printManager.getMultiPrintManager().clear();
        PrintBookTrans.loadFromBook((MultiPrintJobManager)printManager.getMultiPrintManager(), (Book)book);
        printManager.printPreview();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2 && e.getType() != 0) {
            this.doPreviewDownTemplate();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConfig_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfig_actionPerformed(e);
        if (!ResourceUtil.canCreateTempFile("C:" + File.separator + "temp.xml") && !ResourceUtil.canCreateTempFile("D:" + File.separator + "temp.xml")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource", (String)"createNewFile.error"));
            return;
        }
        IRow row = null;
        String fileName = null;
        int selectedRow = 0;
        int successNum = 0;
        StringBuffer detailedMsg = new StringBuffer();
        int option = this.getConfigOption();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            FileObject fileObject = (FileObject)row.getUserObject();
            Boolean selected = (Boolean)row.getCell("select").getValue();
            if (!selected.equals(Boolean.TRUE)) continue;
            ++selectedRow;
            fileName = (String)row.getCell("fileName").getValue();
            if (!StringUtil.isEmpty((String)fileName)) {
                String fileLabel = fileName + "\uff1a";
                String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (!ResourceUtil.checkFileSuffix(fileType)) {
                    detailedMsg.append(" ").append(fileLabel).append(ResourceUtil.getResString("downtemplate.surport.xml")).append(" \n");
                    continue;
                }
                if (fileObject.getDownTemplate() != null) {
                    String templateLabel = fileObject.getDownTemplate().getName() + "[" + fileObject.getDownTemplate().getNumber() + "]\uff1a";
                    String checkStr = ResourceUtil.checkDownTemplate(fileObject.getDownTemplate());
                    if ("success".equals(checkStr)) {
                        String resStr = ResourceUtil.restoreTemplateByFile(this.resId, this.resVersion, fileObject, option, this.displayTemplateType);
                        if ("success".equals(resStr)) {
                            ++successNum;
                            continue;
                        }
                        detailedMsg.append(" ").append(templateLabel).append(resStr).append(" \n");
                        continue;
                    }
                    detailedMsg.append(" ").append(templateLabel).append(checkStr).append(" \n");
                    continue;
                }
                detailedMsg.append(" ").append(fileLabel).append(ResourceUtil.getResString("downtemplate.has.not.configtable")).append(" \n");
                continue;
            }
            detailedMsg.append(" ").append(ResourceUtil.getResString("downtemplate.has.not.file")).append(" \n");
        }
        if (selectedRow == 0) {
            MsgBox.showInfo((String)ResourceUtil.getResString("downtemplate.choose.file"));
            return;
        }
        String succesMsg = MessageFormat.format(ResourceUtil.getResString("downtemplate.import.succes"), successNum);
        if (detailedMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)succesMsg, (String)detailedMsg.toString(), (int)1);
        } else {
            this.setMessageText(succesMsg);
            this.showMessage();
            this.destroyWindow();
        }
    }

    private int getConfigOption() {
        int option = 0;
        if (this.kDreportItem.isSelected() && this.kDFormula.isSelected()) {
            option = 3;
        } else if (this.kDreportItem.isSelected() && !this.kDFormula.isSelected()) {
            option = 1;
        } else if (!this.kDreportItem.isSelected() && this.kDFormula.isSelected()) {
            option = 2;
        }
        return option;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.FALSE);
    }
}

