/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.progress;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.WindowMessage;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

public class ProgressDialogHelper {
    private static Set<MonitorInfo> monitors = new HashSet<MonitorInfo>();

    public static ProgressDialogNew createProgressDialogNew(CoreUI owner, boolean model) {
        Window ance = null;
        if (owner != null) {
            ance = SwingUtilities.getWindowAncestor((Component)owner);
        }
        ProgressDialogNew dialog = null;
        if (ance == null) {
            dialog = new ProgressDialogNew();
        } else if (ance instanceof Dialog) {
            dialog = new ProgressDialogNew((Dialog)ance, model);
        } else if (ance instanceof Frame) {
            dialog = new ProgressDialogNew((Frame)ance, model);
        }
        if (dialog != null) {
            dialog.owner = owner;
            return dialog;
        }
        return new ProgressDialogNew();
    }

    public static void run(final IRunnableWithProgress runable, ProgressDialogNew dialogNew, final IProgressMonitor monitor, boolean canBackRun) {
        if (!canBackRun) {
            Thread runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    runable.run(monitor);
                }
            });
            runner.start();
            dialogNew.show();
        } else if (dialogNew.isSpecialShow()) {
            ProgressDialogHelper.runBack4New(runable, dialogNew, monitor);
        } else {
            ProgressDialogHelper.runBack(runable, dialogNew, monitor);
        }
    }

    private static void runBack(final IRunnableWithProgress runable, final ProgressDialogNew dialogNew, final IProgressMonitor monitor) {
        final MonitorInfo info = new MonitorInfo(dialogNew.getWindowMsgTitle() + ": " + dialogNew.getUiTitle(), null, (Object)dialogNew, false);
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (dialogNew.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            public void finished() {
                if (!this.stop) {
                    if (ProgressDialogHelper.isSameCompany(dialogNew)) {
                        new WindowMessage("250", "150", dialogNew.getWindowMsgTitle(), dialogNew.getUiTitle() + " " + dialogNew.getMsg(), info);
                        ThreadPool.destroyMonitor((MonitorInfo)info);
                        info.setTitle("\u3010" + dialogNew.getUiTitle() + "\u3011");
                        ThreadPool.addActionThread((MonitorInfo)info);
                    } else {
                        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
                        if (dialogNew.isShowing()) {
                            dialogNew.dispose();
                        }
                    }
                }
            }

            public void finishedLater() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                }
                try {
                    ProgressDialogHelper.hideWindow(dialogNew, false);
                    dialogNew.owner.onShow();
                }
                catch (Exception e) {
                    if (e instanceof NullPointerException) {
                        if (dialogNew.owner instanceof ReportDesignerUI) {
                            ReportDesignerUI ui = (ReportDesignerUI)dialogNew.owner;
                            boolean isNull = false;
                            if (ui.getSpreadManager().getSpreadContainer().getBook() == null) {
                                isNull = true;
                            } else {
                                Sheet sheet = ui.getSpreadManager().getSpreadContainer().getBook().getActiveSheet();
                                if (sheet == null) {
                                    isNull = true;
                                }
                            }
                            if (isNull) {
                                MsgBox.showError((Component)dialogNew.owner, (String)DesignerResource.getString("43_uiBookIsNull"));
                            }
                        }
                        if (!ProgressDialogHelper.isSameCompany(dialogNew)) {
                            MsgBox.showError((Component)dialogNew.owner, (String)DesignerResource.getString("BackCalculateError"));
                        }
                        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
                        dialogNew.dispose();
                    }
                    dialogNew.owner.handUIException((Throwable)e);
                }
            }
        };
        SwingWorker dataWorker = new SwingWorker(){

            public Object construct() {
                dialogNew.isLoading = true;
                if (ProgressDialogHelper.isSameCompany(dialogNew)) {
                    runable.run(monitor);
                }
                dialogNew.isLoading = false;
                return null;
            }

            public void finished() {
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                }
            }
        };
        dataWorker.start();
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (monitor instanceof ProgressDialogNew.ProgressMonitor && ((ProgressDialogNew.ProgressMonitor)monitor).isEnd()) {
                    return null;
                }
                if (ProgressDialogHelper.show(dialogNew)) {
                    ProgressDialogHelper.hideWindow(dialogNew, true);
                    info.setWorker(worker);
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
                return null;
            }
        };
        processBarWorker.start();
    }

    public static boolean addMonitor(MonitorInfo m) {
        return monitors.add(m);
    }

    public static boolean removeMonitor(MonitorInfo m) {
        return monitors.remove(m);
    }

    public static void destroyMonitorFromThreadPool(MonitorInfo m) {
        ThreadPool.destroyMonitor((MonitorInfo)m);
    }

    public static void destroyAllMonitorFromThreadPool() {
        if (monitors.size() > 0) {
            Iterator<MonitorInfo> it = monitors.iterator();
            while (it.hasNext()) {
                ProgressDialogHelper.destroyMonitorFromThreadPool(it.next());
            }
            monitors.clear();
        }
    }

    private static boolean isSameCompany(ProgressDialogNew dialogNew) {
        String currentCompanyNumber = SysContext.getSysContext().getCurrentOrgUnit().getNumber();
        String oldCompany = dialogNew.getCompanyNumber();
        if (oldCompany == null) {
            oldCompany = SysContext.getSysContext().getCurrentOrgUnit().getNumber();
        }
        return oldCompany.equals(currentCompanyNumber);
    }

    private static void runBack4New(final IRunnableWithProgress runable, final ProgressDialogNew dialogNew, final IProgressMonitor monitor) {
        final MonitorInfo info = new MonitorInfo(dialogNew.getWindowMsgTitle() + ": " + dialogNew.getUiTitle(), null, (Object)dialogNew, false);
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (dialogNew.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            public void finished() {
                if (!this.stop) {
                    if (ProgressDialogHelper.isSameCompany(dialogNew)) {
                        new WindowMessage("250", "150", dialogNew.getWindowMsgTitle(), dialogNew.getUiTitle() + " " + dialogNew.getMsg(), info);
                        ThreadPool.destroyMonitor((MonitorInfo)info);
                        info.setTitle("\u3010" + dialogNew.getUiTitle() + "\u3011");
                        ThreadPool.addActionThread((MonitorInfo)info);
                    } else {
                        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
                    }
                }
            }

            public void finishedLater() {
                ProgressDialogHelper.removeMonitor(info);
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                }
                try {
                    dialogNew.showParentWindow();
                }
                catch (Exception e) {
                    if (e instanceof NullPointerException) {
                        if (dialogNew.owner instanceof ReportDesignerUI) {
                            ReportDesignerUI ui = (ReportDesignerUI)dialogNew.owner;
                            boolean isNull = false;
                            if (ui.getSpreadManager().getSpreadContainer().getBook() == null) {
                                isNull = true;
                            } else {
                                Sheet sheet = ui.getSpreadManager().getSpreadContainer().getBook().getActiveSheet();
                                if (sheet == null) {
                                    isNull = true;
                                }
                            }
                            if (isNull) {
                                MsgBox.showError((Component)dialogNew.owner, (String)DesignerResource.getString("43_uiBookIsNull"));
                            }
                        }
                        if (!ProgressDialogHelper.isSameCompany(dialogNew)) {
                            MsgBox.showError((Component)dialogNew.owner, (String)DesignerResource.getString("BackCalculateError"));
                        }
                        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
                        dialogNew.dispose();
                    }
                    dialogNew.owner.handUIException((Throwable)e);
                }
            }
        };
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (ProgressDialogHelper.show(dialogNew)) {
                    System.out.println("========processBarWorker runback and add to ThreadPool========");
                    dialogNew.hideParentWindow();
                    info.setWorker(worker);
                    ThreadPool.addActionThread((MonitorInfo)info);
                    ProgressDialogHelper.addMonitor(info);
                }
                return null;
            }
        };
        processBarWorker.start();
        SwingWorker dataWorker = new SwingWorker(){

            public Object construct() {
                dialogNew.isLoading = true;
                System.out.println("==============data worker isLoading============");
                if (ProgressDialogHelper.isSameCompany(dialogNew)) {
                    runable.run(monitor);
                }
                System.out.println("==============data worker isLoaded============");
                dialogNew.isLoading = false;
                return null;
            }

            public void finished() {
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                    System.out.println("==============data worker dispose dialog============");
                }
            }
        };
        dataWorker.start();
    }

    private static boolean show(ProgressDialogNew dialogNew) {
        if (dialogNew != null) {
            dialogNew.show();
            return dialogNew.goBackRunning();
        }
        return false;
    }

    private static void hideWindow(ProgressDialogNew dialogNew, boolean hide) {
        if (hide) {
            dialogNew.owner.getUIWindow().hide();
        } else {
            dialogNew.owner.getUIWindow().show();
            dialogNew.owner.requestFocus();
        }
    }

    public static void setToScreenCenter(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static String formatTime(long time) {
        StringBuffer sb = new StringBuffer();
        sb.append(ProgressDialogHelper.formatNumber((time /= 1000L) / 60L / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time % 60L));
        return sb.toString();
    }

    private static String formatNumber(long t) {
        return t > 9L ? "" + t : "0" + t;
    }
}

