/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.AnalysisReportCollection;
import com.kingdee.eas.fi.newrpt.AnalysisReportFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportInfo;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisReportEditUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportListUI;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AnalysisReportEditUI
extends AbstractAnalysisReportEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisReportEditUI.class);
    private boolean isAnalysisRptOpened = true;
    private boolean isOk = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.toolBar.setEnabled(false);
        this.btOk.setEnabled(true);
        this.btCancel.setEnabled(true);
        this.editData = (AnalysisReportInfo)this.getUIContext().get("Object");
        this.isAnalysisRptOpened = (Boolean)this.getUIContext().get("isAnalysisRptOpened");
        this.txtName.setText(this.editData.getName());
        this.txtNumber.setText(this.editData.getNumber());
        this.describer.setText(this.editData.getDescribe());
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.txtName.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.describer.setEnabled(false);
            this.btOk.setEnabled(false);
            this.btCancel.setEnabled(false);
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        AnalysisReportCollection coll;
        if (!this.checkData()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNumber.getText()));
        view.setFilter(filter);
        if (this.editData != null && this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if ((coll = AnalysisReportFactory.getRemoteInstance().getAnalysisReportCollection(view)) != null && coll.size() > 0) {
            String message = MessageFormat.format(EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"91_numberRepeat"), coll.get(0).getNumber(), coll.get(0).getCompany().getName());
            MsgBox.showWarning((String)message);
            return;
        }
        this.editData.setName(this.txtName.getText());
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setDescribe(this.describer.getText());
        if (!this.isAnalysisRptOpened) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Object", (Object)this.editData);
            if (this.getUIContext().get("AnalysisReportListUI") instanceof AnalysisReportListUI) {
                uiContext.put((Object)"AnalysisReportListUI", this.getUIContext().get("AnalysisReportListUI"));
            }
            this.disposeUIWindow();
            ItemAnalysisHepler.getInstance().openAnalysisRpt(uiContext, this.oprtState);
        } else {
            this.disposeUIWindow();
        }
        this.isOk = true;
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisReportFactory.getRemoteInstance();
    }

    public void verifyData() throws Exception {
        this.checkData();
    }

    public boolean checkData() throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"699_TimeImportReportEditUI"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"698_TimeImportReportEditUI"));
            return false;
        }
        return true;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

