/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.AnalysisReportFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportInfo;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisReportListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportEditUI;
import com.kingdee.eas.fi.newrpt.client.util.CslRptLicenseUtils;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AnalysisReportListUI
extends AbstractAnalysisReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisReportListUI.class);
    private static final String CSL_CLASSPARAM = "CONS";
    private static final String EDIT = "EDIT";
    private static final String VIEW = "VIEW";
    private FilterInfo companyFilter = null;
    private boolean isMge = false;

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return AnalysisReportEditUI.class.getName();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(EDIT);
        AnalysisReportInfo info = new AnalysisReportInfo();
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        ItemAnalysisHepler.getInstance().showAnalysisEditUI(info, (Object)this, OprtState.ADDNEW, false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(EDIT);
        this.openRpt(OprtState.EDIT);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(VIEW);
        this.openRpt(OprtState.VIEW);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(VIEW);
        super.actionRefresh_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(EDIT);
        super.actionRemove_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        ICell cell;
        int[] selectedRow = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectedRow != null && selectedRow.length > 0 && (cell = this.tblMain.getRow(selectedRow[0]).getCell("creatorId")) != null && cell.getValue() != null) {
            boolean isEnable = cell.getValue().equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            this.btnEdit.setEnabled(isEnable);
            this.btnRemove.setEnabled(isEnable);
            this.menuItemEdit.setEnabled(isEnable);
            this.menuItemRemove.setEnabled(isEnable);
        }
        super.tblMain_tableClicked(e);
    }

    public void refresh() throws Exception {
        this.refresh(null);
    }

    private void openRpt(String OprtState2) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"AnalysisReportListUI", (Object)this);
        ItemAnalysisHepler.getInstance().openAnalysisRpt(uiContext, OprtState2);
    }

    public void onLoad() throws Exception {
        CslRptLicenseUtils.reSetLicenseModuleNameByMenuParam(this.getUIContext());
        this.checkPermission(VIEW);
        super.onLoad();
        if (this.companyFilter == null) {
            this.companyFilter = new FilterInfo();
            CslGradeManageUtil.getSelfDataPub(this.companyFilter, "company.id", null, null);
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(this.companyFilter);
        } else {
            this.mainQuery.getFilter().mergeFilter(this.companyFilter, "and");
        }
    }

    private void checkPermission(String action) {
        String perItem = this.getPermissionItem(action);
        if (perItem.length() == 0) {
            return;
        }
        boolean hasPermission = true;
        SysContext context = SysContext.getSysContext();
        try {
            IPermission permission = this.getPermission();
            context = SysContext.getSysContext();
            hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(context.getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(context.getCurrentOrgUnit().getId()), perItem);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (!hasPermission) {
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)perItem), context.getCurrentOrgUnit().getName()));
            this.abort();
        }
    }

    private String getPermissionItem(String action) {
        this.checkMenuPath();
        if (this.isMge && VIEW.equals(action)) {
            return "mg_itemAnalysisRpt_view";
        }
        if (this.isMge && !VIEW.equals(action)) {
            return "mg_itemAnalysisRpt_edit";
        }
        if (!this.isMge && VIEW.equals(action)) {
            return "itemAnalysisRpt_view";
        }
        if (!this.isMge && !VIEW.equals(action)) {
            return "itemAnalysisRpt_edit";
        }
        return "";
    }

    private void checkMenuPath() {
        if (!CSL_CLASSPARAM.equals(this.getUIContext().get(LicenseService.MODULENAME))) {
            this.isMge = true;
        }
    }

    private IPermission getPermission() throws BOSException {
        return PermissionFactory.getRemoteInstance();
    }

    protected void execQuery() {
        try {
            if (this.companyFilter == null) {
                this.companyFilter = new FilterInfo();
                CslGradeManageUtil.getSelfDataPub(this.companyFilter, "company.id", null, null);
            }
            if (this.mainQuery.getFilter() == null) {
                this.mainQuery.setFilter(this.companyFilter);
            } else {
                this.mainQuery.getFilter().mergeFilter(this.companyFilter, "and");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.execQuery();
    }

    public boolean destroyWindow() {
        CslRptLicenseUtils.reSetLicenseModuleNameByMenuParam(this.getUIContext());
        return super.destroyWindow();
    }
}

