/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewInfo;
import com.kingdee.eas.fi.newrpt.AnalysisRptTypeEnum;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisReportNewListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportNewEditUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.report.BenchmarkingOrgUnitEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AnalysisReportNewListUI
extends AbstractAnalysisReportNewListUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisReportNewListUI.class);
    private AnalysisRptTypeEnum analysisType = AnalysisRptTypeEnum.BENHMARKING;

    public void onLoad() throws Exception {
        String curAnalysisType = (String)this.getUIContext().get("UIClassParam");
        if (!StringUtils.isEmpty((String)curAnalysisType)) {
            this.analysisType = AnalysisRptTypeEnum.getEnum(curAnalysisType);
        }
        super.onLoad();
        this.initByAnalysisType();
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            this.btnStart.setEnabled(true);
            this.btnStart.setVisible(true);
        } else {
            this.btnStart.setVisible(false);
        }
        this.btnUpdate.setVisible(false);
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            this.btnUpdate.setVisible(true);
            this.btnUpdate.setEnabled(true);
            this.btnUpdate.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"101_AnalysisReportNewListUI"));
        }
        this.initLisence();
    }

    public void initLisence() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                String companyId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                int n = e.getLastRow();
                for (int i = e.getFirstRow(); i <= n; ++i) {
                    if (AnalysisReportNewListUI.this.tblMain.getRow(i).getCell("companyid") == null || companyId.equals(AnalysisReportNewListUI.this.tblMain.getRow(i).getCell("companyid").getValue())) continue;
                    AnalysisReportNewListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                String companyId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                if (e.getSelectBlock() != null && e.getSelectBlock().getBeginRow() >= 0 && AnalysisReportNewListUI.this.tblMain.getRow(e.getSelectBlock().getBeginRow()).getCell("companyid") != null) {
                    boolean endble = companyId.equals(AnalysisReportNewListUI.this.tblMain.getRow(e.getSelectBlock().getBeginRow()).getCell("companyid").getValue());
                    AnalysisReportNewListUI.this.btnEdit.setEnabled(endble);
                    AnalysisReportNewListUI.this.btnRemove.setEnabled(endble);
                }
            }
        });
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            AnalysisReportNewInfo info = AnalysisReportNewFactory.getRemoteInstance().getAnalysisReportNewInfo("select year,bhkOrgUnit.id where id='" + id + "'");
            AnalysisReportNewFactory.getRemoteInstance().startReport(info.getYear(), info.getBhkOrgUnit().getId().toString(), id);
            this.refresh();
        }
    }

    @Override
    public void actionDownTemplate_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"102_AnalysisReportNewListUI"));
    }

    private void initListence() throws Exception {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FilterInfo filter = AnalysisReportNewListUI.this.getMainQuery().getFilter();
                    if (filter == null) {
                        filter = new FilterInfo();
                        AnalysisReportNewListUI.this.getMainQuery().setFilter(filter);
                    }
                    for (int i = filter.getFilterItems().size() - 1; i >= 0; --i) {
                        if (!filter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("analysisRptType")) continue;
                        filter.getFilterItems().get(i).setCompareValue((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNITTEMPLATE.getValue());
                    }
                    AnalysisReportNewListUI.this.addTemplate.setVisible(true);
                    AnalysisReportNewListUI.this.addTemplate.setEnabled(true);
                    AnalysisReportNewListUI.this.refresh();
                }
                catch (Exception ex) {
                    logger.error((Object)"action error", (Throwable)ex);
                }
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(119, 3);
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        String keyName = "cslAnalysis";
        inputMap.put(keyStroke, keyName);
        actionMap.remove(keyName);
        actionMap.put(keyName, action);
    }

    @Override
    public void actionAddTemplate_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddNew(AnalysisReportNewEditUI.class.getName(), AnalysisRptTypeEnum.BENHMARKINGORGUNITTEMPLATE);
    }

    private void initByAnalysisType() {
        this.tblMain.getColumn("period").getStyleAttributes().setHided(true);
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            this.tblMain.getColumn("bhkOrgUnitName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("isStart").getStyleAttributes().setHided(false);
        }
        this.tblMain.getColumn("period").getStyleAttributes().setHided(true);
        if (!this.analysisType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS) && !this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            this.tblMain.getColumn("solution").getStyleAttributes().setHided(true);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisReportNewFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String uiName = AnalysisReportNewEditUI.class.getName();
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNITTEMPLATE)) {
            this.actionAddTemplate_actionPerformed(e);
            return;
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            uiName = BenchmarkingOrgUnitEditUI.class.getName();
        }
        this.actionAddNew(uiName, this.analysisType);
    }

    private void actionAddNew(String uiName, AnalysisRptTypeEnum analysisType) throws Exception {
        AnalysisReportNewInfo info = new AnalysisReportNewInfo();
        info.setAnalysisRptType(analysisType);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        if (analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            info.setIsStart(true);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Object", (Object)info);
        int winStyle = 95;
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.ADDNEW, winStyle &= 0xFFFFFFF4);
        w.show();
        if (w.getUIObject() instanceof BenchmarkingOrgUnitEditUI && ((BenchmarkingOrgUnitEditUI)w.getUIObject()).isOk() || w.getUIObject() instanceof AnalysisReportNewEditUI && ((AnalysisReportNewEditUI)w.getUIObject()).isOk()) {
            final IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AnalysisRptProcessNewUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    uiWindow1.show();
                }
            });
        }
    }

    protected String getEditUIName() {
        return AnalysisRptProcessNewUI.class.getName();
    }

    public void refresh() throws Exception {
        this.refresh(null);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (filter == null) {
            filter = new FilterInfo();
        }
        filter.getFilterItems().add(new FilterItemInfo("analysisRptType", (Object)this.analysisType.getValue(), CompareType.EQUALS));
        StringBuffer maskStr = new StringBuffer();
        maskStr.append("(").append(filter.getMaskString()).append(")").append(" and #").append(filter.getFilterItems().size() - 1);
        filter.setMaskString(maskStr.toString());
        try {
            CslGradeManageUtil.filteData(filter, "company.id", ((Object)((Object)this)).getClass().getName() + this.analysisType.getName(), null);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            logger.error((Object)"CslGradeManageUtil error.", (Throwable)e);
        }
        return filter;
    }

    public String getUITitle() {
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"103_AnalysisReportNewListUI");
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.SOCRETEMPLATE)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"104_AnalysisReportNewListUI");
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGTEMPLATE)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"105_AnalysisReportNewListUI");
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"106_AnalysisReportNewListUI");
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"107_AnalysisReportNewListUI");
        }
        if (this.analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNITTEMPLATE)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"108_AnalysisReportNewListUI");
        }
        return this.windowTitle;
    }
}

