/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.ItemFormulaInfo;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisRptItemsListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptItemsFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisRptItemsListUI
extends AbstractAnalysisRptItemsListUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisRptItemsListUI.class);
    private static final String TB_RPTITEMNUMBER = "rptItemNumber";
    private static final String TB_RPTITEMNAME = "rptItemName";
    private static final String TB_DATAELEMENT = "dataElement";
    private static final String TB_VALUETYPE = "valueType";
    private static final String TB_AMOUNT = "amount";
    private static final String TB_LASTAMOUNT = "lastAmount";
    private static final String TB_MONTHONMONTH = "monthOnMonth";
    private static final String TB_LASTYEARAMOUNT = "lastYearAmount";
    private static final String TB_YEARONYEAR = "yearOnYear";

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideComponent();
        this.formateNumberColumn();
        this.tableShowColumnBySelect();
        this.initTable();
    }

    private void formateNumberColumn() {
        this.tblMain.getColumn(TB_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LASTAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_MONTHONMONTH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LASTYEARAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_YEARONYEAR).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void hideComponent() {
        this.btnAddNew.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formateNumberColumn();
        this.tableShowColumnBySelect();
        this.initTable();
    }

    private void initTable() {
        List list = (List)this.getUIContext().get("result");
        for (int i = 0; i < list.size(); ++i) {
            this.tblMain.addRow(i);
            ItemFormulaInfo info = (ItemFormulaInfo)list.get(i);
            String itemNum = info.getItemNum();
            String itemName = info.getItemName();
            String deName = info.getDataElementName();
            String valueTypeName = info.getValueTypeName();
            BigDecimal amount = info.getAmount();
            String amountStr = CslRptUIUtil.groupBigDecimal((BigDecimal)amount);
            BigDecimal lastAmount = info.getLastAmount();
            String lastAmountStr = CslRptUIUtil.groupBigDecimal((BigDecimal)lastAmount);
            BigDecimal monthOnMonthRate = info.getMonthOnMonthRate();
            BigDecimal lastYearAmount = info.getLastYearAmount();
            String lastYearAmountStr = CslRptUIUtil.groupBigDecimal((BigDecimal)lastYearAmount);
            BigDecimal yearOnYearRate = info.getYearOnYearRate();
            this.tblMain.getRow(i).getCell(TB_RPTITEMNUMBER).setValue((Object)itemNum);
            this.tblMain.getRow(i).getCell(TB_RPTITEMNAME).setValue((Object)itemName);
            this.tblMain.getRow(i).getCell(TB_DATAELEMENT).setValue((Object)deName);
            this.tblMain.getRow(i).getCell(TB_VALUETYPE).setValue((Object)valueTypeName);
            this.tblMain.getRow(i).getCell(TB_AMOUNT).setValue((Object)amountStr);
            this.tblMain.getRow(i).getCell(TB_LASTAMOUNT).setValue((Object)lastAmountStr);
            this.tblMain.getRow(i).getCell(TB_MONTHONMONTH).setValue((Object)monthOnMonthRate);
            this.tblMain.getRow(i).getCell(TB_LASTYEARAMOUNT).setValue((Object)lastYearAmountStr);
            this.tblMain.getRow(i).getCell(TB_YEARONYEAR).setValue((Object)yearOnYearRate);
        }
    }

    private void tableShowColumnBySelect() {
        Map map = (Map)this.getUIContext().get("select");
        boolean amount = (Boolean)map.get(TB_AMOUNT);
        boolean lastAmount = (Boolean)map.get(TB_LASTAMOUNT);
        boolean monthOnMonth = (Boolean)map.get(TB_MONTHONMONTH);
        boolean lastYearAmount = (Boolean)map.get(TB_LASTYEARAMOUNT);
        boolean yearOnYear = (Boolean)map.get(TB_YEARONYEAR);
        if (!amount) {
            this.tblMain.getColumn(TB_AMOUNT).getStyleAttributes().setHided(true);
        }
        if (!lastAmount) {
            this.tblMain.getColumn(TB_LASTAMOUNT).getStyleAttributes().setHided(true);
        }
        if (!monthOnMonth) {
            this.tblMain.getColumn(TB_MONTHONMONTH).getStyleAttributes().setHided(true);
        }
        if (!lastYearAmount) {
            this.tblMain.getColumn(TB_LASTYEARAMOUNT).getStyleAttributes().setHided(true);
        }
        if (!yearOnYear) {
            this.tblMain.getColumn(TB_YEARONYEAR).getStyleAttributes().setHided(true);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return TB_RPTITEMNUMBER;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        Map<String, Boolean> map = this.getSelectChkValueMap();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isFromList", (Object)true);
        uiContext.put((Object)"select", map);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AnalysisRptItemsFilterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        AnalysisRptItemsFilterUI ui = (AnalysisRptItemsFilterUI)uiWindow.getUIObject();
        if (ui.isConfirm) {
            boolean amount = ui.amountChk.isSelected();
            boolean lastAmount = ui.lastAmountChk.isSelected();
            boolean monthOnMonth = ui.monthOnMonthChk.isSelected();
            boolean lastYearAmount = ui.lastYearAmountChk.isSelected();
            boolean yearOnYearAmount = ui.yearOnYearChk.isSelected();
            if (!amount) {
                this.tblMain.getColumn(TB_AMOUNT).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(TB_AMOUNT).getStyleAttributes().setHided(false);
            }
            if (!lastAmount) {
                this.tblMain.getColumn(TB_LASTAMOUNT).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(TB_LASTAMOUNT).getStyleAttributes().setHided(false);
            }
            if (!monthOnMonth) {
                this.tblMain.getColumn(TB_MONTHONMONTH).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(TB_MONTHONMONTH).getStyleAttributes().setHided(false);
            }
            if (!lastYearAmount) {
                this.tblMain.getColumn(TB_LASTYEARAMOUNT).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(TB_LASTYEARAMOUNT).getStyleAttributes().setHided(false);
            }
            if (!yearOnYearAmount) {
                this.tblMain.getColumn(TB_YEARONYEAR).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(TB_YEARONYEAR).getStyleAttributes().setHided(false);
            }
        }
    }

    private Map<String, Boolean> getSelectChkValueMap() {
        boolean amountisHide = this.tblMain.getColumn(TB_AMOUNT).getStyleAttributes().isHided();
        boolean lastAmountisHide = this.tblMain.getColumn(TB_LASTAMOUNT).getStyleAttributes().isHided();
        boolean monthOnMonthisHide = this.tblMain.getColumn(TB_MONTHONMONTH).getStyleAttributes().isHided();
        boolean lastYearAmountIsHide = this.tblMain.getColumn(TB_LASTYEARAMOUNT).getStyleAttributes().isHided();
        boolean yearOnYearIsHide = this.tblMain.getColumn(TB_YEARONYEAR).getStyleAttributes().isHided();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(TB_AMOUNT, amountisHide);
        map.put(TB_LASTAMOUNT, lastAmountisHide);
        map.put(TB_MONTHONMONTH, monthOnMonthisHide);
        map.put(TB_LASTYEARAMOUNT, lastYearAmountIsHide);
        map.put(TB_YEARONYEAR, yearOnYearIsHide);
        return map;
    }
}

