/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.fi.gr.dynamic.util.ExpireManager;
import com.kingdee.eas.fi.newrpt.AnalysisRptTypeEnum;
import com.kingdee.eas.fi.newrpt.util.AnalysisRptNewUtil;
import com.kingdee.eas.fi.newrpt.util.AnalysisTypeColIndex;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AnalysisRptProcessNewListener
extends ExpireManager
implements SheetChangeListener {
    private static Logger logger = Logger.getLogger(AnalysisRptProcessNewListener.class);
    private static boolean isListener = true;
    AnalysisRptTypeEnum analysisRptType = null;

    public AnalysisRptProcessNewListener(AnalysisRptTypeEnum analysisRptType) {
        this.analysisRptType = analysisRptType;
    }

    public void changed(SheetChangeEvent e) {
        if (!isListener) {
            return;
        }
        if (e.hasState(SheetChangeEvent.Changed_UndoRedo)) {
            return;
        }
        if (e.hasState(SheetChangeEvent.Changed_Delete) && (e.getSheet().getSelectionRange().isRowBlocks() || e.getSheet().getSelectionRange().isColBlocks())) {
            return;
        }
        if (e.hasState(SheetChangeEvent.Changed_Content)) {
            CellBlock cellBlock;
            Sheet sheet = e.getSheet();
            SortedCellBlockArray cells = e.getChangedBlocks();
            if (cells.size() == 1 && (cellBlock = cells.getBlock(0)).getRow() == cellBlock.getRow2() && cellBlock.getCol() == cellBlock.getCol2()) {
                this.calcDepsAndSetBackGround(sheet);
                return;
            }
            try {
                AnalysisRptNewUtil.autoSetBackGround(cells, sheet, this.analysisRptType);
            }
            catch (Exception ex) {
                logger.error((Object)"changed error", (Throwable)ex);
            }
        }
    }

    private void calcDepsAndSetBackGround(Sheet sheet) {
        try {
            Dependents deps = sheet.getBook().getDeps();
            sheet.getActiveCell().queue(deps, true);
            Field calcListField = deps.getClass().getDeclaredField("_calcList");
            NewRptUtil.makeAccessible(calcListField);
            List calcList = (List)calcListField.get(deps);
            ArrayList<Cell> depCells = new ArrayList<Cell>();
            if (calcList != null && !calcList.isEmpty()) {
                for (Object obj : calcList) {
                    if (obj == null || !(obj instanceof Cell) || ((Cell)obj).getSheet().getUserObjectValue("industryKey") == null) continue;
                    depCells.add((Cell)obj);
                }
            }
            deps.calc();
            if (!depCells.isEmpty()) {
                boolean isSocreAnalysis = this.analysisRptType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS);
                ArrayList<BigDecimal> socreValues = null;
                if (isSocreAnalysis) {
                    socreValues = new ArrayList<BigDecimal>();
                }
                AnalysisTypeColIndex analysisTypeColIndex = AnalysisRptNewUtil.getAnalysisTypeColIndexMap(sheet.getBook(), this.analysisRptType).get(((Cell)depCells.get(0)).getSheet().getSheetName());
                for (Cell curCell : depCells) {
                    AnalysisRptNewUtil.setCellBackGround(curCell.getSheet(), curCell, analysisTypeColIndex, socreValues, isSocreAnalysis);
                }
            }
            deps.clearCalcList();
        }
        catch (Exception ee) {
            logger.error((Object)"deps.calc() error", (Throwable)ee);
        }
    }

    public static boolean getisListener() {
        return isListener;
    }

    public static void setListener(boolean Listener) {
        isListener = Listener;
    }
}

