/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.AnalysisKeyIndexCollection;
import com.kingdee.eas.fi.newrpt.AnalysisKeyIndexFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewInfo;
import com.kingdee.eas.fi.newrpt.AnalysisRptTypeEnum;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.ShowErrorCellRender;
import com.kingdee.eas.fi.newrpt.client.designer.render.ShowFormulaCellRender;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisRptProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportNewEditUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportNewListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptMenuManager;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptNewProvider;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProcessNewListener;
import com.kingdee.eas.fi.newrpt.client.report.BenchmarkingOrgUnitEditUI;
import com.kingdee.eas.fi.newrpt.client.report.SetCellAnalysisTypeUI;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.report.AnalysisRptNewPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.AnalysisRptNewUtil;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisRptProcessNewUI
extends AbstractAnalysisRptProcessNewUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisRptProcessNewUI.class);
    private boolean isRuning = false;

    @Override
    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        SpreadManager.registerRenderProvider(new DefaultItemRenderProvider());
        SpreadManager.registerRenderProvider(new ShowErrorCellRender());
        SpreadManager.registerRenderProvider(new ShowFormulaCellRender());
        boolean isTemplate = this.getReportInfo() != null && this.getReportInfo().getAnalysisRptType() != null && (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGTEMPLATE) || this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCRETEMPLATE));
        this.menuItemSheetManager.setVisible(true);
        this.menuItemSheetManager.setEnabled(true);
        this.setAnalysisType.setVisible(isTemplate);
        this.autoSetIndex.setVisible(isTemplate);
        this.setAnalysisType.setEnabled(isTemplate);
        this.autoSetIndex.setEnabled(isTemplate);
        this.initByAnalysisType();
        this.kdReBuild.setVisible(false);
        BookProperties bookProperties = this.getBookProperties();
        ReportCalculateErrorProvider errorProvider = bookProperties.getErrorProvider();
        if (errorProvider == null) {
            errorProvider = new ReportCalculateErrorProvider();
        }
        errorProvider.setDealDiv0Error(true);
        errorProvider.setZeroDivDisplayAs("0");
        bookProperties.setErrorProvider(errorProvider);
        bookProperties.restoreToBook(this.getBook());
    }

    @Override
    protected void afterCalculate() {
        super.afterCalculate();
        try {
            AnalysisRptNewUtil.setBackGroundColor(this.getBook(), AnalysisRptNewUtil.getAnalysisTypeColIndexMap(this.getBook(), this.getReportInfo().getAnalysisRptType()), this.getReportInfo().getAnalysisRptType());
        }
        catch (Exception e) {
            logger.error((Object)"afterCalculate error", (Throwable)e);
        }
    }

    @Override
    public void onShow() {
        try {
            super.onShow();
            if (!this.isRuning && this.getReportInfo().getLastUpdateTime() == null) {
                this.isRuning = true;
                this.buildAnalysisRpt();
                this.getSpreadManager().getModifyManager().discardAllEdits();
            }
            this.getSpreadManager().getSpreadContainer().getBook().setActiveSheet(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionReBuildRpt_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.getSpreadManager().getSpreadContainer().getBook().getUserObjectValue("solution");
        this.buildAnalysisRpt();
    }

    private void initByAnalysisType() throws Exception {
        if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING) || this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            AnalysisRptProcessNewListener dy = new AnalysisRptProcessNewListener(this.getReportInfo().getAnalysisRptType());
            AnalysisRptProcessNewListener.setListener(true);
            this.getSpreadManager().addKDSBlockInvalidListener(dy);
        }
        if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT) && OprtState.ADDNEW.equals(this.oprtState)) {
            AnalysisRptNewUtil.initBenhmarkingOrgUnitData(this.getSpreadManager().getSpreadContainer().getBook(), this.getReportInfo().getYear());
            this.getSpreadManager().getSpreadContainer().repaint();
        }
    }

    private void init() throws Exception {
        this.setMenuStrategy(new AnalysisRptMenuManager());
        this.setBookProvider(new AnalysisRptNewProvider());
        this.setPropertyAdapter(new AnalysisRptNewPropertyAdapter());
        AnalysisReportNewInfo info = (AnalysisReportNewInfo)this.getUIContext().get("Object");
        if (info == null) {
            info = new AnalysisReportNewInfo();
        }
        if (info.getCompany() == null) {
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        this.getBookProvider().setEditValue((IObjectValue)info);
        this.setVariableProvider(new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables(sheetName, RptPeriodTypeEnum.YEARLY);
                if (!AnalysisRptProcessNewUI.this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
                    init.add(VariablesHelper.createReservedEntry("isCompany", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"109_AnalysisRptProcessNewUI"), sheetName, "", 1));
                    init.add(VariablesHelper.createReservedEntry("isAnalysis", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"110_AnalysisRptProcessNewUI"), sheetName, "", 1));
                    init.add(VariablesHelper.createReservedEntry("isBhmOrgUnitSheet", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"111_AnalysisRptProcessNewUI"), sheetName, "", 1));
                }
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.getSpreadManager().getSpreadContainer().getBook().setUserObject("solution", (Object)this.getReportInfo().getSolution());
        super.actionSave_actionPerformed(e);
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof AnalysisReportNewListUI) {
            ((AnalysisReportNewListUI)((Object)this.getUIContext().get("Owner"))).refresh();
        }
    }

    @Override
    public String getUITitle() {
        if (this.getReportInfo() != null && this.getReportInfo().getName() != null) {
            StringBuffer title = new StringBuffer();
            if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
                return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"112_AnalysisRptProcessNewUI") + this.getReportInfo().getName() + "]" + this.getReportInfo().getYear() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"113_AnalysisRptProcessNewUI") + this.getReportInfo().getPeriod() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"114_AnalysisRptProcessNewUI");
            }
            if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNITTEMPLATE)) {
                title.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"115_AnalysisRptProcessNewUI"));
            } else {
                if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCRETEMPLATE)) {
                    title.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"116_AnalysisRptProcessNewUI"));
                    return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"116_AnalysisRptProcessNewUI");
                }
                if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGTEMPLATE)) {
                    title.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"117_AnalysisRptProcessNewUI"));
                } else if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
                    title.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"118_AnalysisRptProcessNewUI"));
                } else if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
                    title.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"119_AnalysisRptProcessNewUI"));
                }
            }
            return title.append("\u2014\u2014").append(this.getReportInfo().getName()).append("[").append(this.getReportInfo().getNumber()).append("](").append(this.getReportInfo().getYear()).append(")").toString();
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"120_AnalysisRptProcessNewUI");
    }

    @Override
    public void actionReportVariables_actionPerformed(ActionEvent e) throws Exception {
        this.showAnalysisEditUI(this.getReportInfo(), (Object)this, this.oprtState, true);
        ((KDFrame)this.getUIWindow()).setTitle(this.getUITitle());
    }

    public AnalysisReportNewInfo getReportInfo() {
        return (AnalysisReportNewInfo)this.getBookProvider().getEditValue();
    }

    public boolean showAnalysisEditUI(AnalysisReportNewInfo info, Object owner, String OprtState2, boolean isAnalysisRptOpened) throws Exception {
        String id = info != null && info.getId() != null ? info.getId().toString() : null;
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"Object", (Object)info);
        if (owner instanceof AnalysisReportNewListUI) {
            uiContext.put((Object)"AnalysisReportNewListUI", owner);
        }
        int winStyle = 95;
        winStyle &= 0xFFFFFFF4;
        String uiName = AnalysisReportNewEditUI.class.getName();
        if (info.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKINGORGUNIT)) {
            uiName = BenchmarkingOrgUnitEditUI.class.getName();
        }
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState2, winStyle);
        w.show();
        return w.getUIObject() instanceof BenchmarkingOrgUnitEditUI && ((BenchmarkingOrgUnitEditUI)w.getUIObject()).isOk() || w.getUIObject() instanceof AnalysisReportNewEditUI && ((AnalysisReportNewEditUI)w.getUIObject()).isOk();
    }

    @Override
    public void actionSetAnalysisType_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Range", (Object)this.getSpreadManager().getSpreadContainer().getBook().getActiveCellRange());
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SetCellAnalysisTypeUI.class.getName(), (Map)uiContext);
        w.show();
    }

    private void buildAnalysisRpt() throws Exception {
        if (this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING) || this.getReportInfo().getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(this, true);
            try {
                progressDialog.run(false, true, new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"121_AnalysisRptProcessNewUI"), -1);
                        try {
                            AnalysisRptNewUtil.fillAndCalSheetByIndustryCompany(AnalysisRptProcessNewUI.this.getSpreadManager().getSpreadContainer().getBook(), AnalysisRptProcessNewUI.this.getReportInfo(), (AnalysisRptNewPropertyAdapter)AnalysisRptProcessNewUI.this.getReportAdapter());
                        }
                        catch (Exception e) {
                            logger.error((Object)"buildAnalysisRpt", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                            AnalysisRptProcessNewUI.this.getSpreadManager().getSpreadContainer().repaint();
                            AnalysisRptProcessNewUI.this.getSpreadManager().getModifyManager().setModified();
                        }
                    }
                }, progressDialog);
            }
            catch (Exception ex) {
                logger.error((Object)"actionBatchCalc_actionPerformed error", (Throwable)ex);
                throw ex;
            }
        }
    }

    @Override
    public void actionAutoSetIndex_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.getSpreadManager().getSpreadContainer().getBook();
        Range range = book.getSelectionRange();
        Sheet.ICellsIterator cellIter = book.getRangeCellsIterator(range, false, true);
        Cell cell = null;
        ItemFormula formula = null;
        HashMap<String, Cell> name_cell = new HashMap<String, Cell>();
        StringBuffer sb = new StringBuffer();
        while (cellIter.hasNext()) {
            cell = cellIter.next();
            if (cell == null || cell.getValue() == null) continue;
            name_cell.put(cell.getValue().toString(), cell);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(cell.getValue().toString()).append("'");
        }
        AnalysisKeyIndexCollection coll = AnalysisKeyIndexFactory.getRemoteInstance().getAnalysisKeyIndexCollection("select name,number,id where name in(" + sb.toString() + ")");
        for (int i = 0; i < coll.size(); ++i) {
            cell = (Cell)name_cell.get(coll.get(i).getName());
            formula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (formula == null) {
                formula = new ItemFormula();
                cell.setUserObject("ITEM", (Object)formula);
            }
            formula.putExt("analysisTypeKey", String.valueOf(2));
            formula.putExt("analysisKeyIndexNumber", coll.get(i).getNumber());
            formula.putExt("analysisKeyIndexId", coll.get(i).getId().toString());
        }
        coll.clear();
        name_cell.clear();
    }
}

