/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.frame.MvpViewController;
import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.AnalysisReportInfo;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.ShowErrorCellRender;
import com.kingdee.eas.fi.newrpt.client.designer.render.ShowFormulaCellRender;
import com.kingdee.eas.fi.newrpt.client.report.AbstractAnalysisRptProcessUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisReportListUI;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptMenuManager;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProvider;
import com.kingdee.eas.fi.newrpt.client.report.ItemAnalysisHandle;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.report.AnalysisBasePointParams;
import com.kingdee.eas.fi.newrpt.report.AnalysisRptPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.DmAnalysisHelper;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisCellObject;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.newrpt.report.MidTableAnalysisHelper;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AnalysisRptProcessUI
extends AbstractAnalysisRptProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisRptProcessUI.class);
    ItemAnalysisCellObject cellObject = new ItemAnalysisCellObject();
    private MouseListener mouseListener = null;

    @Override
    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        SpreadManager.registerRenderProvider(new DefaultItemRenderProvider());
        SpreadManager.registerRenderProvider(new ShowErrorCellRender());
        SpreadManager.registerRenderProvider(new ShowFormulaCellRender());
        this.getSpreadManager().getSpreadContainer().getUserObjectRegister().setUserObjectsProvider((Book.IUserObjectProvider)new UserObjectTrans(true));
        this.initBookListener();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        AnalysisReportInfo info = this.getReportInfo();
        if (info == null || StringUtils.isEmpty((String)info.getName()) || StringUtils.isEmpty((String)info.getNumber())) {
            info = new AnalysisReportInfo();
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            this.getBookProvider().setEditValue((IObjectValue)info);
            boolean isOk = ItemAnalysisHepler.getInstance().showAnalysisEditUI(info, (Object)this, this.oprtState, true);
            if (!isOk) {
                return;
            }
        }
        super.actionSave_actionPerformed(e);
        if (this.getUIContext().get("AnalysisReportListUI") != null && this.getUIContext().get("AnalysisReportListUI") instanceof AnalysisReportListUI) {
            ((AnalysisReportListUI)((Object)this.getUIContext().get("AnalysisReportListUI"))).refresh();
        }
    }

    @Override
    public void actionReportVariables_actionPerformed(ActionEvent e) throws Exception {
        ItemAnalysisHepler.getInstance().showAnalysisEditUI(this.getReportInfo(), (Object)this, this.oprtState, true);
    }

    @Override
    public void actionFixAnalysis_actionPerformed(ActionEvent e) throws Exception {
        ItemAnalysisHepler.getInstance().analysis(this.getBook(), this.getSpreadManager(), (Component)((Object)this), null, false);
    }

    @Override
    public void actionDynamicAnalysis_actionPerformed(ActionEvent e) throws Exception {
        ItemAnalysisHepler.getInstance().analysis(this.getBook(), this.getSpreadManager(), (Component)((Object)this), null, true);
    }

    @Override
    public void actionMidDataPerspectivity_actionPerformed(ActionEvent e) throws Exception {
        MidTableAnalysisHelper.getInstance().analysis(this.getBook(), this.getSpreadManager(), (Component)((Object)this), null, null, false);
    }

    @Override
    protected void beforeCalculate() {
        try {
            Sheet sheet = null;
            ItemAnalysisHandle handle = new ItemAnalysisHandle();
            for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
                sheet = this.getBook().getSheet(i);
                if (!sheet.isEnableCalculation()) continue;
                handle.refreshData(sheet);
            }
        }
        catch (Exception e) {
            logger.error((Object)"AnalysisRptProcessUI refreshData error.", (Throwable)e);
            this.handleException(e);
        }
    }

    private void init() throws Exception {
        this.setMenuStrategy(new AnalysisRptMenuManager());
        this.setBookProvider(new AnalysisRptProvider());
        this.setPropertyAdapter(new AnalysisRptPropertyAdapter());
        this.setVariableProvider(new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables(sheetName, RptPeriodTypeEnum.MONTHLY);
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
        AnalysisReportInfo info = (AnalysisReportInfo)this.getUIContext().get("Object");
        if (info == null) {
            info = new AnalysisReportInfo();
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        this.getBookProvider().setEditValue((IObjectValue)info);
    }

    @Override
    public String getUITitle() {
        if (this.getReportInfo() != null && this.getReportInfo().getName() != null && this.getReportInfo().getNumber() != null) {
            return this.resHelper.getString("this.title") + "\u2014\u2014" + this.getReportInfo().getName() + "[" + this.getReportInfo().getNumber() + "]";
        }
        return this.resHelper.getString("this.title");
    }

    public AnalysisReportInfo getReportInfo() {
        return (AnalysisReportInfo)this.getBookProvider().getEditValue();
    }

    private void initBookListener() {
        MouseListener mouseListener;
        this.menuItemFreeze.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MouseListener[] mouseListeners = AnalysisRptProcessUI.this.getSpreadManager().getSpreadContainer().getSpread().getActiveView().getMouseListeners();
                boolean hasNoMouseListener = true;
                for (int i = 0; i < mouseListeners.length; ++i) {
                    if (AnalysisRptProcessUI.this.mouseListener == null || AnalysisRptProcessUI.this.mouseListener != mouseListeners[i]) continue;
                    hasNoMouseListener = false;
                    break;
                }
                if (hasNoMouseListener && AnalysisRptProcessUI.this.mouseListener != null) {
                    AnalysisRptProcessUI.this.getSpreadManager().getSpreadContainer().getSpread().getActiveView().addMouseListener(AnalysisRptProcessUI.this.mouseListener);
                }
            }
        });
        this.menuItemCancelFreeze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Book book = AnalysisRptProcessUI.this.getSpreadManager().getSpreadContainer().getBook();
                Sheet curSheet = book.getActiveSheet();
                curSheet.removeUserObject("preColAndRowSplit");
            }
        });
        this.mouseListener = mouseListener = new MouseListener(){
            String expansAllChilds = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"118_expansAllChilds");
            String closeAllChilds = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"119_closeAllChilds");

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
                try {
                    AnalysisRptProcessUI.this.orgUnionClick(false);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }

            @Override
            public void mousePressed(MouseEvent paramMouseEvent) {
                try {
                    Book book = AnalysisRptProcessUI.this.getSpreadManager().getSpreadContainer().getBook();
                    Sheet curSheet = book.getActiveSheet();
                    Cell curCell = curSheet.getActiveCell();
                    ItemAnalysisCellObject curCellObject = DmAnalysisHelper.getInstance().getCellObject(curSheet, curCell.getRow(), curCell.getCol());
                    if (curCellObject != null && curCellObject.isUnion()) {
                        AnalysisRptProcessUI.this.expansAllChild.setVisible(true);
                        AnalysisRptProcessUI.this.expansAllChild.setEnabled(true);
                        AnalysisRptProcessUI.this.expansAllChild.setText(curCellObject.isOpen() ? this.closeAllChilds : this.expansAllChilds);
                    } else {
                        AnalysisRptProcessUI.this.expansAllChild.setVisible(false);
                        AnalysisRptProcessUI.this.expansAllChild.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    AnalysisRptProcessUI.this.expansAllChild.setVisible(false);
                    AnalysisRptProcessUI.this.expansAllChild.setEnabled(false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent paramMouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent paramMouseEvent) {
            }
        };
        this.getSpreadManager().getSpreadContainer().getSpread().getActiveView().addMouseListener(mouseListener);
    }

    @Override
    public void actionExpansAllChilds_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.orgUnionClick(true);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orgUnionClick(boolean isAllLevel) throws Exception {
        Book book = this.getSpreadManager().getSpreadContainer().getBook();
        try {
            book.getUndoManager().startGroup();
            book.getUndoManager().enable(false);
            book.setSkipListeners(true);
            Sheet curSheet = book.getActiveSheet();
            Cell curCell = curSheet.getActiveCell();
            KDSpread spread = this.getSpreadManager().getSpreadContainer().getSpread();
            MvpViewController viewController = spread.getViewController();
            boolean freezed = viewController.isFreezed();
            if (!freezed) {
                curSheet.removeUserObject("preColAndRowSplit");
            }
            if (curCell == null) {
                return;
            }
            ItemAnalysisCellObject curCellObject = DmAnalysisHelper.getInstance().getCellObject(curSheet, curCell.getRow(), curCell.getCol());
            if (curCellObject != null && curCellObject.isUnion()) {
                ArrayList basePointList;
                ViewSplitInfo vs = curSheet.getSheetOption().getViewSplitInfo();
                int colSplit = vs.getColSplit();
                int rowSplit = vs.getRowSplit();
                if (freezed) {
                    Object preColAndRowSplit = curSheet.getUserObjectValue("preColAndRowSplit");
                    if (preColAndRowSplit != null && !curCellObject.isOpen()) {
                        ArrayList preColAndRowSplitList = (ArrayList)preColAndRowSplit;
                        colSplit = (Integer)preColAndRowSplitList.get(0);
                        rowSplit = (Integer)preColAndRowSplitList.get(1);
                    }
                    viewController.unFreeze();
                }
                if ((basePointList = ItemAnalysisHepler.getInstance().getBasePointList(curSheet)) != null && !basePointList.isEmpty()) {
                    ArrayList<Integer> hideList = new ArrayList<Integer>();
                    ArrayList<Integer> showList = new ArrayList<Integer>();
                    Point basePoint = (Point)basePointList.get(0);
                    AnalysisBasePointParams params = ItemAnalysisHepler.getInstance().getParametersFromCell(curSheet.getCell(basePoint.y, basePoint.x, true));
                    List<String> colList = Arrays.asList(params.getAnalysisGuideParams().getCustomerParam("colItems").split(ItemAnalysisConstant.splitStr));
                    int colIndex = colList.indexOf(ItemAnalysisConstant.orgUnitKey);
                    boolean isRow = true;
                    if (colIndex >= 0) {
                        isRow = false;
                    }
                    int fixIndex = isRow ? curCell.getCol() : curCell.getRow();
                    int startIndex = isRow ? curCell.getRow() : curCell.getCol();
                    int endIndex = isRow ? basePoint.y + params.getRow_endOffSet() : basePoint.x + params.getCol_endOffSet();
                    this.showOrHideRowCol(curSheet, curCellObject.getKey(), fixIndex, startIndex, endIndex, isRow, !curCellObject.isOpen(), true, hideList, showList, isAllLevel);
                    ItemAnalysisHepler.getInstance().setShowOrHide(curSheet, hideList, 0, true, isRow);
                    ItemAnalysisHepler.getInstance().setShowOrHide(curSheet, showList, 0, false, isRow);
                    curCellObject.setOpen(!curCellObject.isOpen());
                    curCell.setUserObject(ItemAnalysisConstant.cellObjKey, (Object)curCellObject.toSerialString());
                    curCell.setValue(new Variant((Object)curCellObject.getDisplayName()));
                    this.handleUnionRowOrCol(curSheet, curCellObject.getKey(), curCellObject.isOpen(), fixIndex, isRow ? curCell.getRow() : curCell.getCol(), isRow);
                    hideList.clear();
                    showList.clear();
                    if (freezed && !curCellObject.isOpen() && curSheet.getUserObject("preColAndRowSplit") == null) {
                        ArrayList<Integer> preColAndRowSplit = new ArrayList<Integer>();
                        preColAndRowSplit.add(colSplit);
                        preColAndRowSplit.add(rowSplit);
                        curSheet.setUserObject("preColAndRowSplit", preColAndRowSplit);
                    }
                }
                if (freezed) {
                    Selection sel = curSheet.getSheetOption().getSelection();
                    sel.setActiveCell(rowSplit, colSplit);
                    viewController.freeze();
                    sel.setActiveCell(curCell.getRow(), curCell.getCol());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"orgUnionClick error", (Throwable)ex);
        }
        finally {
            book.setSkipListeners(false);
            book.getUndoManager().endGroup();
            book.getUndoManager().enable(true);
            this.getSpreadManager().getSpreadContainer().getSpread().repaint();
        }
    }

    public int showOrHideRowCol(Sheet sheet, String parentKey, int fixIndex, int startIndex, int endIndex, boolean isRow, boolean isOpen, boolean isParentOpen, List<Integer> hideList, List<Integer> showList, boolean isAllLevel) throws Exception {
        Cell curCell = null;
        String curParentKey = null;
        String curKey = null;
        ItemAnalysisCellObject curCellObject = null;
        int curEndIndex = endIndex;
        boolean success = false;
        for (int i = startIndex; i <= endIndex; ++i) {
            curCell = sheet.getCell(isRow ? i : fixIndex, isRow ? fixIndex : i, true);
            curCellObject = DmAnalysisHelper.getInstance().getCellObject(sheet, curCell.getRow(), curCell.getCol());
            if (curCellObject == null || curCellObject.getParentKey() == null) continue;
            curParentKey = curCellObject.getParentKey();
            if (curParentKey.equals(parentKey)) {
                if (curCellObject.isUnion()) {
                    curKey = curCellObject.getKey();
                    boolean bl = success = isOpen ? showList.add(i) : hideList.add(i);
                    if (isAllLevel) {
                        i = this.showOrHideRowCol(sheet, curKey, fixIndex, isRow ? curCell.getRow() : curCell.getCol(), endIndex, isRow, isOpen, isOpen, hideList, showList, isAllLevel);
                        curCellObject.setOpen(isOpen);
                        curCell.setUserObject(ItemAnalysisConstant.cellObjKey, (Object)curCellObject.toSerialString());
                        curCell.setValue(new Variant((Object)curCellObject.getDisplayName()));
                        continue;
                    }
                    if (isOpen) {
                        i = this.showOrHideRowCol(sheet, curKey, fixIndex, isRow ? curCell.getRow() : curCell.getCol(), endIndex, isRow, curCellObject.isOpen(), isOpen, hideList, showList, isAllLevel);
                        continue;
                    }
                    i = this.showOrHideRowCol(sheet, curKey, fixIndex, isRow ? curCell.getRow() : curCell.getCol(), endIndex, isRow, false, false, hideList, showList, isAllLevel);
                    continue;
                }
                success = isOpen ? showList.add(i) : hideList.add(i);
                continue;
            }
            if (curCellObject.getKey().equals(parentKey)) {
                boolean bl = success = isParentOpen ? showList.add(i) : hideList.add(i);
                if (!curCellObject.isUnion()) continue;
                curCellObject.setOpen(isOpen);
                curCell.setUserObject(ItemAnalysisConstant.cellObjKey, (Object)curCellObject.toSerialString());
                curCell.setValue(new Variant((Object)curCellObject.getDisplayName()));
                continue;
            }
            curEndIndex = i > startIndex ? i - 1 : i;
            break;
        }
        return curEndIndex;
    }

    private void handleUnionRowOrCol(Sheet sheet, String key, boolean isOpen, int fixIndex, int curIndex, boolean isRow) throws Exception {
        Cell curCell = null;
        ItemAnalysisCellObject curCellObject = null;
        int index = 0;
        int maxIndex = isRow ? sheet.getMaxRowIndex() : sheet.getMaxColIndex();
        String curKey = null;
        Integer[] integerArray = new Integer[]{-1, 1};
        int n = integerArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int step = integerArray[i];
            for (index = curIndex + step; index >= 0 && index <= maxIndex; index += step) {
                curCell = sheet.getCell(isRow ? index : fixIndex, isRow ? fixIndex : index, true);
                curCellObject = DmAnalysisHelper.getInstance().getCellObject(sheet, curCell.getRow(), curCell.getCol());
                if (curCellObject == null || !curCellObject.isUnion() || StringUtils.isEmpty((String)(curKey = curCellObject.getKey())) || !curKey.equals(key)) continue block0;
                curCellObject.setOpen(isOpen);
                curCell.setUserObject(ItemAnalysisConstant.cellObjKey, (Object)curCellObject.toSerialString());
                curCell.setValue(new Variant((Object)curCellObject.getDisplayName()));
            }
        }
    }

    @Override
    protected void initSpreadPopMenu() {
        PopMenuManager pop = this.getSpreadManager().getSpreadContainer().getPopMenuManager();
        pop.addGroupItem((Component)this.expansAllChild, 0, 0);
        Component[] rightMenus = this.menuRangeContext.getMenuComponents();
        for (int i = 0; i < rightMenus.length; ++i) {
            if (rightMenus[i].getName().equals(this.expansAllChild.getName())) continue;
            pop.addGroupItem(rightMenus[i], 1, -1);
        }
        if (this.rMenuSendMail.isVisible()) {
            pop.addGroupItem((Component)this.separator2, 3, -1);
            pop.addGroupItem((Component)this.rMenuSendMail, 3, -1);
            this.rMenuSendMail.add((JMenuItem)this.rMenuItemSendExcel);
            this.rMenuSendMail.add((JMenuItem)this.rMenuItemSendHtml);
        }
        if (this.rMenuPublishReport.isVisible()) {
            pop.addGroupItem((Component)this.rMenuPublishReport, 3, -1);
            this.rMenuPublishReport.add((JMenuItem)this.rMenuItemPublishAsExcel);
            this.rMenuPublishReport.add((JMenuItem)this.rMenuItemPublishAsHtml);
            this.rMenuPublishReport.add((JMenuItem)this.rMenuItemPublishAsLink);
        }
    }
}

