/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.ReportFieldCollection;
import com.kingdee.eas.csinterface.billmapping.ReportFieldFactory;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.SelectNumOrNameEnum;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.EipReportFieldEnum;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.client.report.AbstractEipRptDataGenReportFilterUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.fi.rpt.client.AcctCommonPromptDialog;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EipRptDataGenReportFilterUI
extends AbstractEipRptDataGenReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EipRptDataGenReportFilterUI.class);
    private final String TB_SELECTED = "selected";
    private final String TB_FIELD_INFO = "fieldInfo";
    private final String TB_SHOW_NAME_OR_NUM = "showNameOrNum";
    private final String TB_FILTER_START = "filterStart";
    private final String TB_FILTER_END = "filterEnd";
    private ReportFieldCollection reportFieldList = new ReportFieldCollection();
    private AsstActTypeCollection asstActTypeList = new AsstActTypeCollection();
    private CurrencyCollection currency = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadReportFieldsAndAsstActTypeData();
        this.currency = CslRptUIUtil.getCurrencyCollection();
        this.initSchemeF7();
        this.initListener();
    }

    protected void initListener() {
        this.showasstActCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EipRptDataGenReportFilterUI.this.setVisible();
            }
        });
        this.dataFieldTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                EipRptDataGenReportFilterUI.this.setFilterEnabled(e);
            }
        });
        this.companyFilter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EipRptDataGenReportFilterUI.this.initAccountEdit();
            }
        });
    }

    private void setFilterEnabled(KDTEditEvent e) {
        if (e.getColIndex() == this.dataFieldTable.getColumnIndex("selected")) {
            IRow row = this.dataFieldTable.getRow(e.getRowIndex());
            boolean enabled = (Boolean)e.getValue();
            ReportFieldInfo info = (ReportFieldInfo)row.getCell("fieldInfo").getValue();
            Locale locale = SysContext.getSysContext().getLocale();
            if (IntegrateSchemeHelper.Fields.fcompanynum.name().equals(info.getNumber().toLowerCase(locale))) {
                this.companyFilter.setEnabled(enabled);
            } else if (IntegrateSchemeHelper.Fields.fcurrencynum.name().equals(info.getNumber().toLowerCase(locale))) {
                this.currencyFilter.setEnabled(enabled);
            } else if (IntegrateSchemeHelper.Fields.faccountnum.name().equals(info.getNumber().toLowerCase(locale))) {
                this.accountStartFilter.setEnabled(enabled);
            } else if (IntegrateSchemeHelper.Fields.fbizdate.name().equals(info.getNumber().toLowerCase(locale))) {
                this.bizDateEndFilter.setEnabled(enabled);
                this.bizDateStartFilter.setEnabled(enabled);
            } else if (IntegrateSchemeHelper.Fields.fdataelement.name().equals(info.getNumber().toLowerCase(locale))) {
                this.dataElemantFilter.setEnabled(enabled);
            }
        }
    }

    private void setVisible() {
        Boolean flag = this.showasstActCheckBox.isSelected();
        this.asstActTable.setVisible(flag.booleanValue());
        this.asstActMoveUp.setVisible(flag.booleanValue());
        this.asstActMoveDown.setVisible(flag.booleanValue());
        this.asstActMoveTop.setVisible(flag.booleanValue());
        this.asstActMoveBottom.setVisible(flag.booleanValue());
        this.asstActAddAll.setVisible(flag.booleanValue());
        this.asstActRemoveAll.setVisible(flag.booleanValue());
    }

    private void initTable() throws Exception {
        this.setEditorFordataFieldTable();
        this.setEditorForAsstActTable();
    }

    private void parsedTable() {
        this.dataFieldTable.checkParsed();
        this.asstActTable.checkParsed();
    }

    private void setEditorFordataFieldTable() throws Exception {
        this.dataFieldTable.getColumn("fieldInfo").getStyleAttributes().setLocked(true);
        Locale locale = SysContext.getSysContext().getLocale();
        for (int i = 0; i < this.reportFieldList.size(); ++i) {
            IRow row = this.dataFieldTable.addRow();
            row.getCell("selected").setValue((Object)true);
            row.getCell("fieldInfo").setValue((Object)this.reportFieldList.get(i));
            ReportFieldInfo fieldInfo = this.reportFieldList.get(i);
            if (fieldInfo == null) continue;
            row.getCell("showNameOrNum").setValue((Object)SelectNumOrNameEnum.NAME);
            if (IntegrateSchemeHelper.Fields.fbizdate.name().equals(fieldInfo.getNumber().toLowerCase(locale))) {
                row.getCell("showNameOrNum").setValue((Object)"--");
                row.getCell("showNameOrNum").getStyleAttributes().setLocked(true);
                continue;
            }
            if (IntegrateSchemeHelper.Fields.fdataelement.name().equals(fieldInfo.getNumber().toLowerCase(locale))) {
                row.getCell("selected").getStyleAttributes().setLocked(true);
                continue;
            }
            if (IntegrateSchemeHelper.Fields.fvaluetype.name().equals(fieldInfo.getNumber().toLowerCase(locale))) {
                row.getCell("showNameOrNum").setValue((Object)SelectNumOrNameEnum.NUMBER);
                row.getCell("showNameOrNum").getStyleAttributes().setLocked(true);
                continue;
            }
            if (IntegrateSchemeHelper.Fields.ftxtvalue.name().equals(fieldInfo.getNumber().toLowerCase(locale)) || IntegrateSchemeHelper.Fields.famount.name().equals(fieldInfo.getNumber().toLowerCase(locale))) {
                row.getCell("showNameOrNum").setValue((Object)"--");
                row.getCell("showNameOrNum").getStyleAttributes().setLocked(true);
                continue;
            }
            if (IntegrateSchemeHelper.Fields.fcompanynum.name().equals(fieldInfo.getNumber().toLowerCase(locale))) {
                row.getCell("selected").getStyleAttributes().setLocked(true);
                continue;
            }
            if (!IntegrateSchemeHelper.Fields.faccountnum.name().equals(fieldInfo.getNumber().toLowerCase(locale))) continue;
            row.getCell("selected").getStyleAttributes().setLocked(true);
        }
    }

    private void initComboBoxEditor() {
        this.dataFieldTable.getColumn("showNameOrNum").setEditor(null);
        KDComboBox comboBoxName = new KDComboBox();
        comboBoxName.addItem((Object)SelectNumOrNameEnum.NAME);
        comboBoxName.addItem((Object)SelectNumOrNameEnum.NUMBER);
        comboBoxName.addItem((Object)SelectNumOrNameEnum.NAMEORNUMBER);
        this.dataFieldTable.getColumn("showNameOrNum").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBoxName));
    }

    private void initFilter() {
        this.initCompanyEditor();
        this.currencyFilter.addItems(this.currency.toArray());
        this.currencyFilter.addItem(null);
        this.initAccountEdit();
        this.initDataElementEditor();
    }

    private void setEditorForAsstActTable() throws Exception {
        this.asstActTable.getColumn("fieldInfo").getStyleAttributes().setLocked(true);
        for (int i = 0; i < this.asstActTypeList.size(); ++i) {
            IRow row = this.asstActTable.addRow();
            row.getCell("selected").setValue((Object)false);
            AsstActTypeInfo info = this.asstActTypeList.get(i);
            row.getCell("fieldInfo").setValue((Object)info);
            this.setAsstActF7(info, i);
        }
    }

    private void initDataElementEditor() {
        this.dataElemantFilter.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)new FetchTypeProvider(){

            public List getSelected() {
                return (List)EipRptDataGenReportFilterUI.this.dataElemantFilter.getData();
            }

            public String getCompanyId() {
                return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
        }, (IChooserLabelProvider)new FetchTypeLabelProvider(), (IUIObject)this));
    }

    private void initAccountEdit() {
        CompanyOrgUnitInfo company = this.getFIOrgUnitInfo(this.companyFilter.getValue());
        this.accountStartFilter.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, company));
        this.accountEndFilter.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, company));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        AccountPromptBox accountProm = (AccountPromptBox)this.accountStartFilter.getSelector();
        AccountTableInfo accountTableInfo = accountProm.getTableInfo();
        if (accountTableInfo != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
        } else {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        }
        filter.setMaskString("#0 and #1");
        this.accountStartFilter.setEditable(true);
        this.accountStartFilter.setEditFormat("$number$");
        this.accountStartFilter.setDisplayFormat("$number$ - $name$");
        this.accountStartFilter.setCommitFormat("$helpCode$;$number$");
        this.accountStartFilter.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.accountStartFilter.setEntityViewInfo(view);
        this.accountEndFilter.setEditable(true);
        this.accountEndFilter.setEditFormat("$number$");
        this.accountEndFilter.setDisplayFormat("$number$ - $name$");
        this.accountEndFilter.setCommitFormat("$helpCode$;$number$");
        this.accountEndFilter.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.accountEndFilter.setEntityViewInfo(view);
    }

    private CompanyOrgUnitInfo getFIOrgUnitInfo(Object value) {
        OrgUnitInfo[] orgUnitInfo = (OrgUnitInfo[])value;
        if (orgUnitInfo == null || orgUnitInfo.length > 1) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        try {
            return MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(orgUnitInfo[0], null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.handUIException(e);
            return null;
        }
    }

    private void initCompanyEditor() {
        NewCompanyF7 promptOrgCompany = CompanyF7Helper.getMultiOrgViewTypeUnitF7WithoutFilter((IUIObject)this, (OrgViewType[])new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.PROFITCENTER});
        promptOrgCompany.setMultiSelect(true);
        promptOrgCompany.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        promptOrgCompany.setShowAssistantOrg(true);
        promptOrgCompany.setCheckedAssistantOrgChkBox(true);
        this.companyFilter.setSelector((KDPromptSelector)promptOrgCompany);
        this.companyFilter.setRequired(false);
        this.companyFilter.setEditable(false);
        this.companyFilter.setHistoryRecordEnabled(false);
        this.companyFilter.setEditFormat("$number$");
        this.companyFilter.setDisplayFormat("$number$");
    }

    private void initSchemeF7() {
        this.eipGetDataSchemeF7.setQueryInfo("com.kingdee.eas.fi.newrpt.ReportMappingQuery");
        this.eipGetDataSchemeF7.setEditFormat("$billMappingName$");
        this.eipGetDataSchemeF7.setDisplayFormat("$billMappingName$");
        this.eipGetDataSchemeF7.setCommitFormat("$number$");
        this.eipGetDataSchemeF7.setEditable(false);
    }

    private void setLocalNameByNum(ReportFieldInfo info) {
        Locale locale = SysContext.getSysContext().getLocale();
        if ("fcompanynum".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.COMPANY.getAlias());
        } else if ("fcurrencynum".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.CURRENCY.getAlias());
        } else if ("faccountnum".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.ACCOUNT.getAlias());
        } else if ("fbizdate".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.BIZ_DATE.getAlias());
        } else if ("fdataelement".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.DATA_ELEMENT.getAlias());
        } else if ("fvaluetype".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.VALUE_TYPE.getAlias());
        } else if ("ftextvalue".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.TXT_VALUE.getAlias());
        } else if ("famount".equals(info.getNumber().toLowerCase(locale))) {
            info.setName(EipReportFieldEnum.AMOUNT.getAlias());
        }
    }

    private void loadReportFieldsAndAsstActTypeData() throws BOSException {
        ReportFieldCollection reportFields = ReportFieldFactory.getRemoteInstance().getReportFieldCollection();
        if (reportFields.size() == 0) {
            MsgBox.showConfirm2((String)CslRptUtil.getString((String)"eipReportColNoData"));
            SysUtil.abort();
        }
        if (reportFields != null) {
            Locale locale = SysContext.getSysContext().getLocale();
            for (int i = 0; i < reportFields.size(); ++i) {
                ReportFieldInfo info = reportFields.get(i);
                this.setLocalNameByNum(info);
                if (info.getNumber() == null || info.getNumber().toLowerCase(locale).startsWith("fasst") || IntegrateSchemeHelper.Fields.forgtype.name().equals(info.getNumber().toLowerCase(locale))) continue;
                this.reportFieldList.add(info);
            }
        }
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = DynamicTemplateUtility.getDefaultFilterForAsstActType(null);
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        viewInfo.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultQueryName"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        this.asstActTypeList = iAsstActType.getAsstActTypeCollection(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean confirmRemove(int top, KDTable table) {
        return table.getRow(top).getCell("fieldInfo").getValue() == null || MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getActiviTable(e);
        if (table.getSelectManager().get() == null) {
            return;
        }
        int top = table.getSelectManager().get().getTop();
        int bottom = table.getSelectManager().get().getBottom();
        if (top > 0) {
            table.addRow(bottom + 1, table.getRow(top - 1));
            table.removeRow(top - 1);
            table.getSelectManager().select(top - 1, 0, bottom - 1, table.getColumnCount() - 1);
            table.getLayoutManager().scrollRowToShow(top - 1);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getActiviTable(e);
        if (table.getSelectManager().get() == null) {
            return;
        }
        int top = table.getSelectManager().get().getTop();
        int bottom = table.getSelectManager().get().getBottom();
        if (bottom < table.getRowCount() - 1) {
            table.addRow(top, table.getRow(bottom + 1));
            table.getSelectManager().select(top + 1, 0, bottom + 1, table.getColumnCount() - 1);
            table.removeRow(bottom + 2);
            table.getLayoutManager().scrollRowToShow(top + 1);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getActiviTable(e);
        if (table.getSelectManager().get() == null) {
            return;
        }
        int rowIndex = table.getSelectManager().get().getTop();
        table.addRow(0, table.getRow(rowIndex));
        table.removeRow(rowIndex + 1);
        table.getSelectManager().select(0, 0, 0, table.getColumnCount() - 1);
        table.getLayoutManager().scrollRowToShow(0);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getActiviTable(e);
        if (table.getSelectManager().get() == null) {
            return;
        }
        int rowIndex = table.getSelectManager().get().getTop();
        table.addRow(table.getRowCount(), table.getRow(rowIndex));
        table.removeRow(rowIndex);
        int bottomIndex = table.getRowCount() - 1;
        table.getSelectManager().select(bottomIndex, 0, bottomIndex, table.getColumnCount() - 1);
        table.getLayoutManager().scrollRowToShow(bottomIndex);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.setTableSelect(e, false);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        this.setTableSelect(e, true);
    }

    private void setTableSelect(ActionEvent e, boolean selected) {
        KDTable table = this.getActiviTable(e);
        Locale locale = SysContext.getSysContext().getLocale();
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            if (!table.equals(this.asstActTable)) {
                ReportFieldInfo fieldInfo = (ReportFieldInfo)row.getCell("fieldInfo").getValue();
                if (IntegrateSchemeHelper.Fields.fdataelement.name().equals(fieldInfo.getNumber().toLowerCase(locale)) || IntegrateSchemeHelper.Fields.fcompanynum.name().equals(fieldInfo.getNumber().toLowerCase(locale)) || IntegrateSchemeHelper.Fields.faccountnum.name().equals(fieldInfo.getNumber().toLowerCase(locale))) continue;
                row.getCell("selected").setValue((Object)selected);
                this.currencyFilter.setEnabled(selected);
                this.bizDateEndFilter.setEnabled(selected);
                this.bizDateStartFilter.setEnabled(selected);
                continue;
            }
            row.getCell("selected").setValue((Object)selected);
        }
    }

    private KDTable getActiviTable(ActionEvent e) {
        Locale locale = SysContext.getSysContext().getLocale();
        String buttonName = ((KDWorkButton)e.getSource()).getName();
        if (buttonName.toLowerCase(locale).startsWith("asstact")) {
            return this.asstActTable;
        }
        return this.dataFieldTable;
    }

    private void setAsstActF7(AsstActTypeInfo asstActInfo, int rowIndex) throws Exception {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        String tableName = asstActInfo.getRealtionDataObject();
        if (tableName.equalsIgnoreCase("T_BD_CashFlowItem")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Customer")) {
            GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)this.ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery", "com.kingdee.eas.fi.rpt.app.F7CustomerQuery");
            gks.setNeedShowUnUsed(false);
            bizPromptBox.setSelector((KDPromptSelector)gks);
        } else if (tableName.equalsIgnoreCase("T_BD_Supplier")) {
            GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)this.ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
            gks.setQueryProperty("mobile", "and");
            gks.setNeedShowUnUsed(false);
            bizPromptBox.setSelector((KDPromptSelector)gks);
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7SupplierQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Material")) {
            GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7MaterialTreeListUI(), (Object)this.ui, null, "com.kingdee.eas.fi.rpt.app.F7MaterialQuery", "com.kingdee.eas.fi.rpt.app.F7MaterialQuery");
            gks.setQueryProperty("mobile", "and");
            gks.setNeedShowUnUsed(false);
            bizPromptBox.setSelector((KDPromptSelector)gks);
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7MaterialQuery");
        } else if (tableName.equalsIgnoreCase("T_BD_Person")) {
            String companyld = null;
            bizPromptBox.setSelector((KDPromptSelector)new AcctCommonPromptDialog(companyld));
            bizPromptBox.setQueryInfo(asstActInfo.getDefaultQueryName());
        } else if (tableName.equalsIgnoreCase("T_ORG_Company")) {
            NewCompanyF7 promptOrgCompany = CompanyF7Helper.getCompanyBizUnitF7((IUIObject)this);
            promptOrgCompany.setMultiSelect(false);
            promptOrgCompany.setNeedAddOrgRange(false);
            promptOrgCompany.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            promptOrgCompany.setShowAssistantOrg(true);
            promptOrgCompany.setCheckedAssistantOrgChkBox(true);
            bizPromptBox.setSelector((KDPromptSelector)promptOrgCompany);
        } else if (tableName.equalsIgnoreCase("T_BD_Project")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.fi.rpt.app.F7CustomerProjectQuery");
        } else {
            bizPromptBox.setQueryInfo(asstActInfo.getDefaultQueryName());
        }
        bizPromptBox.setEditFormat("$number$-$name$");
        bizPromptBox.setDisplayFormat("$number$-$name$");
        bizPromptBox.setCommitFormat("$number$-$name$");
        this.asstActTable.getCell(rowIndex, "filterStart").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
        this.asstActTable.getCell(rowIndex, "filterEnd").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
    }

    public void setCustomerParams(CustomerParams params) {
        this.clearUI();
        if (params != null) {
            try {
                String billMappingNum = params.getCustomerParam("billMapping");
                if (billMappingNum != null) {
                    this.eipGetDataSchemeF7.setValue((Object)BillMappingFactory.getRemoteInstance().getBillMappingInfo("select id,number,billMappingName where number ='" + billMappingNum + "'"));
                }
                this.showasstActCheckBox.setSelected(Boolean.parseBoolean(params.getCustomerParam("showAsstActItem")));
                int dataFieldTableRows = Integer.parseInt(params.getCustomerParam("dataFieldTableRows"));
                for (int i = 0; i < dataFieldTableRows; ++i) {
                    String nameNumStr;
                    IRow row = this.dataFieldTable.addRow();
                    row.getCell("selected").setValue((Object)Boolean.parseBoolean(params.getCustomerParam("dataFieldTable" + i + "selected")));
                    if (params.getCustomerParam("dataFieldTable" + i + "fieldInfo") != null) {
                        ReportFieldInfo reportFiledInfo = ReportFieldFactory.getRemoteInstance().getReportFieldInfo("select id,number,name where number ='" + params.getCustomerParam("dataFieldTable" + i + "fieldInfo") + "'");
                        row.getCell("fieldInfo").setValue((Object)reportFiledInfo);
                        this.setLocalNameByNum(reportFiledInfo);
                    }
                    if ("--".equals(nameNumStr = params.getCustomerParam("dataFieldTable" + i + "showNameOrNum"))) {
                        row.getCell("showNameOrNum").setValue((Object)nameNumStr);
                        continue;
                    }
                    if (nameNumStr == null) continue;
                    row.getCell("showNameOrNum").setValue((Object)SelectNumOrNameEnum.getEnum((int)Integer.parseInt(nameNumStr)));
                }
                int asstactTableRows = Integer.parseInt(params.getCustomerParam("asstActTableRows"));
                for (int j = 0; j < asstactTableRows; ++j) {
                    IRow row = this.asstActTable.addRow();
                    row.getCell("selected").setValue((Object)Boolean.parseBoolean(params.getCustomerParam("asstActTable" + j + "selected")));
                    String asstactNum = params.getCustomerParam("asstActTable" + j + "fieldInfo");
                    AsstActTypeInfo asstActInfo = (AsstActTypeInfo)AsstActTypeFactory.getRemoteInstance().getValue("select id,number,name,realtionDataObject,defaultQueryName where number ='" + asstactNum + "'");
                    row.getCell("fieldInfo").setValue((Object)asstActInfo);
                    row.getCell("filterStart").setValue((Object)params.getCustomerParam("asstActTable" + j + "filterStart"));
                    row.getCell("filterEnd").setValue((Object)params.getCustomerParam("asstActTable" + j + "filterEnd"));
                    this.setAsstActF7(asstActInfo, j);
                }
                this.setFilterToTable(params);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void setFilterToTable(CustomerParams params) throws EASBizException, BOSException {
        int i;
        this.bizDateEndFilter.setValue((Object)RPTDateUtil.stringToDate((String)params.getCustomerParam("dateEnd"), (String)"yyyy-MM-dd"));
        this.bizDateStartFilter.setValue((Object)RPTDateUtil.stringToDate((String)params.getCustomerParam("dateStart"), (String)"yyyy-MM-dd"));
        String oql = this.getOqlString(params.getCustomerParam("company"), "number");
        if (oql != null) {
            FullOrgUnitCollection orgCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(oql);
            OrgUnitInfo[] orgInfos = new OrgUnitInfo[orgCollection.size()];
            for (i = 0; i < orgInfos.length; ++i) {
                orgInfos[i] = orgCollection.get(i);
            }
            this.companyFilter.setData((Object)orgInfos);
        }
        for (int i2 = 0; i2 < this.currency.size(); ++i2) {
            if (!this.currency.get(i2).getNumber().equals(params.getCustomerParam("currency"))) continue;
            this.currencyFilter.setSelectedItem((Object)this.currency.get(i2));
        }
        oql = this.getOqlString(params.getCustomerParam("accountSrtatr"), "id");
        if (oql != null) {
            this.accountStartFilter.setValue((Object)AccountViewFactory.getRemoteInstance().getAccountViewInfo(oql));
        }
        if ((oql = this.getOqlString(params.getCustomerParam("accountEnd"), "id")) != null) {
            this.accountEndFilter.setValue((Object)AccountViewFactory.getRemoteInstance().getAccountViewInfo(oql));
        }
        if ((oql = this.getOqlString(params.getCustomerParam("dataElement"), "number")) != null) {
            DataElementCollection dataElementColletion = DataElementFactory.getRemoteInstance().getDataElementCollection(oql);
            ArrayList<DataElementInfo> infoList = new ArrayList<DataElementInfo>();
            for (i = 0; i < dataElementColletion.size(); ++i) {
                infoList.add(dataElementColletion.get(i));
            }
            this.dataElemantFilter.setData(infoList);
        }
    }

    private String getOqlString(String filterNums, String field) {
        StringBuffer oql = new StringBuffer("select id,number,name where ");
        oql.append(field);
        StringBuffer oqlFilter = new StringBuffer();
        if (filterNums != null) {
            String[] nums = filterNums.split(",");
            if (nums.length > 1) {
                oqlFilter.append(" in(");
                for (int i = 0; i < nums.length; ++i) {
                    oqlFilter.append("'").append(nums[i]).append("'");
                    if (i == nums.length - 1) continue;
                    oqlFilter.append(",");
                }
                oqlFilter.append(")");
            } else {
                oqlFilter.append(" = '").append(filterNums).append("'");
            }
        } else {
            return null;
        }
        return oql.append(oqlFilter).toString();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        BillMappingInfo billMappingInfo = this.getF7Value();
        if (billMappingInfo != null) {
            params.addCustomerParam("billMapping", billMappingInfo.getNumber());
        }
        params.addCustomerParam("showAsstActItem", String.valueOf(this.showasstActCheckBox.isSelected()));
        this.setTableValueToParam("dataFieldTable", params);
        this.setTableValueToParam("asstActTable", params);
        this.setFilterToParam(params);
        return params;
    }

    private void setFilterToParam(CustomerParams params) {
        params.addCustomerParam("company", this.getInStr(this.getCompanyNumStr()));
        params.addCustomerParam("currency", this.getCurrencyNumStr());
        if (this.getDataElementNumsStr() != null) {
            params.addCustomerParam("dataElement", this.getInStr(this.getDataElementNumsStr().toArray()));
        }
        if (this.accountStartFilter.getData() != null) {
            params.addCustomerParam("accountSrtatr", ((DataBaseInfo)this.accountStartFilter.getData()).getId().toString());
        }
        if (this.accountEndFilter.getData() != null) {
            params.addCustomerParam("accountEnd", ((DataBaseInfo)this.accountEndFilter.getData()).getId().toString());
        }
        if (this.bizDateStartFilter.getValue() != null) {
            params.addCustomerParam("dateStart", RPTDateUtil.formateDate((Date)((Date)this.bizDateStartFilter.getValue()), (String)"yyyy-MM-dd"));
        }
        if (this.bizDateEndFilter.getValue() != null) {
            params.addCustomerParam("dateEnd", RPTDateUtil.formateDate((Date)((Date)this.bizDateEndFilter.getValue()), (String)"yyyy-MM-dd"));
        }
    }

    public OrgUnitInfo[] getCompanyNumStr() {
        if (this.companyFilter.getData() == null) {
            return null;
        }
        return (OrgUnitInfo[])this.companyFilter.getData();
    }

    public String getCurrencyNumStr() {
        if (this.currencyFilter.getSelectedItem() == null) {
            return null;
        }
        return ((CurrencyInfo)this.currencyFilter.getSelectedItem()).getNumber();
    }

    public List<DataElementInfo> getDataElementNumsStr() {
        if (this.dataElemantFilter.getData() == null) {
            return null;
        }
        return (List)this.dataElemantFilter.getData();
    }

    public String getAccountSrtatrNumStr() {
        if (this.accountStartFilter.getData() == null) {
            return null;
        }
        return ((DataBaseInfo)this.accountStartFilter.getData()).getNumber();
    }

    public String getAccountEndNumStr() {
        if (this.accountEndFilter.getData() == null) {
            return null;
        }
        return ((DataBaseInfo)this.accountEndFilter.getData()).getNumber();
    }

    public Date getDateStart() {
        if (this.bizDateStartFilter.getValue() == null) {
            return null;
        }
        return (Date)this.bizDateStartFilter.getValue();
    }

    public Date getDateEnd() {
        if (this.bizDateEndFilter.getValue() == null) {
            return null;
        }
        return (Date)this.bizDateEndFilter.getValue();
    }

    private String getInStr(Object[] list) {
        String returnStr = "";
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            DataBaseInfo info = (DataBaseInfo)list[i];
            returnStr = returnStr + info.getNumber();
            if (i == list.length - 1) continue;
            returnStr = returnStr + ",";
        }
        return returnStr;
    }

    public KDTable getDataFieldTable() {
        return this.dataFieldTable;
    }

    public KDTable getAsstActTable() {
        return this.asstActTable;
    }

    public BillMappingInfo getF7Value() {
        BillMappingInfo info = null;
        if (this.eipGetDataSchemeF7.getValue() instanceof String) {
            String param = (String)this.eipGetDataSchemeF7.getValue();
            String oql = "select * where id='" + param + "' or number='" + param + "'";
            try {
                info = BillMappingFactory.getRemoteInstance().getBillMappingInfo(oql);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (info == null) {
                info = new BillMappingInfo();
                info.setId(BOSUuid.read((String)param));
            }
        } else {
            info = (BillMappingInfo)this.eipGetDataSchemeF7.getValue();
        }
        return info;
    }

    public boolean getShowAsstActItem() {
        return this.showasstActCheckBox.isSelected();
    }

    private void setTableValueToParam(String tableName, CustomerParams params) {
        KDTable table = tableName.equals("dataFieldTable") ? this.dataFieldTable : this.asstActTable;
        int rowCount = table.getRowCount();
        params.addCustomerParam(tableName + "Rows", String.valueOf(rowCount));
        String key = null;
        Object valueObject = null;
        for (int i = 0; i < rowCount; ++i) {
            key = tableName + i + "selected";
            valueObject = table.getCell(i, "selected").getValue();
            params.addCustomerParam(key, String.valueOf((Boolean)valueObject));
            key = tableName + i + "fieldInfo";
            valueObject = table.getCell(i, "fieldInfo").getValue();
            params.addCustomerParam(key, valueObject != null ? ((DataBaseInfo)table.getCell(i, "fieldInfo").getValue()).getNumber() : null);
            if ("dataFieldTable".equals(tableName)) {
                key = tableName + i + "showNameOrNum";
                valueObject = table.getCell(i, "showNameOrNum").getValue();
                if (valueObject == null) continue;
                params.addCustomerParam(key, "--".equals(valueObject) ? valueObject.toString() : String.valueOf(((SelectNumOrNameEnum)valueObject).getValue()));
                continue;
            }
            this.setAsstActTableFilterToParams(i, "filterStart", table, params);
            this.setAsstActTableFilterToParams(i, "filterEnd", table, params);
        }
    }

    private void setAsstActTableFilterToParams(int rowIndex, String filterColName, KDTable table, CustomerParams params) {
        String key = filterColName + rowIndex + "filterStart";
        Object valueObject = table.getCell(rowIndex, "filterStart").getValue();
        if (valueObject != null) {
            params.addCustomerParam(key + "Number", ((DataBaseInfo)valueObject).getNumber());
            params.addCustomerParam(key + "Id", ((DataBaseInfo)valueObject).getId().toString());
        }
    }

    private void setDataFieldTableFilterToParams(int rowIndex, String filterColName, KDTable table, CustomerParams params) {
        String key = "dataFieldTable" + rowIndex + filterColName;
        Object valueObject = table.getCell(rowIndex, filterColName).getValue();
        if (valueObject != null) {
            if (valueObject instanceof ValueTypeEnum) {
                params.addCustomerParam(key, String.valueOf(((ValueTypeEnum)valueObject).getValue()));
            } else if (valueObject instanceof String) {
                params.addCustomerParam(key, valueObject.toString());
            } else if (valueObject instanceof Date) {
                params.addCustomerParam(key, RPTDateUtil.formateDate((Date)((Date)valueObject), (String)"yyyy-MM-dd"));
            } else {
                params.addCustomerParam(key, ((DataBaseInfo)valueObject).getNumber());
            }
        }
    }

    public void clearUI() {
        this.eipGetDataSchemeF7.setData(null);
        this.companyFilter.setData(null);
        this.currencyFilter.setSelectedItem(null);
        this.dataElemantFilter.setData(null);
        this.bizDateEndFilter.setValue((Object)new Date());
        this.bizDateStartFilter.setValue((Object)new Date());
        this.accountStartFilter.setData(null);
        this.accountEndFilter.setData(null);
        this.dataFieldTable.removeRows();
        this.asstActTable.removeRows();
        this.parsedTable();
        this.initComboBoxEditor();
    }

    public void clear() {
        this.clearUI();
        try {
            this.initTable();
            this.initFilter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible();
    }

    public boolean verify() {
        boolean flag = true;
        if (this.eipGetDataSchemeF7.getData() == null) {
            flag = false;
            MsgBox.showError((String)CslRptUtil.getString((String)"billMappingNotNull"));
        }
        return flag;
    }
}

