/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DynamicItemFilterF7UI;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataEntryFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.client.CslViewUI;
import com.kingdee.eas.fi.gr.fast.util.ManageMergeOrgUnit;
import com.kingdee.eas.fi.newrpt.client.report.AbstractItemAnalysisFilterUI;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ItemAnalysisFilterUI
extends AbstractItemAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisFilterUI.class);
    private Sheet sheet = null;
    private CustomerParams customerParams = null;
    private boolean isDynamicAnalysis = false;
    private Date lastRptData = null;
    private CurrencyCollection currencyCol = null;
    private DynamicItemFilterF7UI dyItemF7UI = null;
    private KDPromptSelector orgSelector = null;
    private SchemeOrgViewF7 schemeOrgSelector = null;
    private boolean isHasDyitems = false;

    public void onLoad() throws Exception {
        try {
            ItemAnalysisFilterUI cmp = this;
            this.isFire = false;
            super.onLoad();
            this.initSchemePromp();
            if (this.currencyCol == null) {
                this.currencyCol = InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC();
                for (int i = 0; i < this.currencyCol.size(); ++i) {
                    this.currencyComboBox.addItem((Object)this.currencyCol.get(i));
                }
            }
            this.orgPromp.addDataChangeListener(new DataChangeListener((Component)((Object)cmp)){
                final /* synthetic */ Component val$cmp;
                {
                    this.val$cmp = component;
                }

                public void dataChanged(DataChangeEvent eventObj) {
                    if (ItemAnalysisFilterUI.this.isFire && !(ItemAnalysisFilterUI.this.orgPromp.getSelector() instanceof SchemeOrgViewF7) && ItemAnalysisFilterUI.this.orgPromp.getData() != null && ItemAnalysisFilterUI.this.orgPromp.getData() instanceof List && ItemAnalysisFilterUI.this.orgTreeCombo.getSelectedItem() != null && !ItemAnalysisFilterUI.this.isTree()) {
                        ItemAnalysisFilterUI.this.orgPromp.setData(null);
                        MsgBox.showError((Component)this.val$cmp, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"120_notOrgTree"));
                    }
                }
            });
            this.initDynItem();
            this.initSumByQuarter();
            this.initGradeManage();
        }
        finally {
            this.isFire = true;
        }
    }

    private boolean isTree() {
        OrgTreeInfo orgTree = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
        List orgs = (List)this.orgPromp.getData();
        StringBuffer ids = new StringBuffer();
        for (Object obj : orgs) {
            if (!(obj instanceof OrgUnitInfo)) continue;
            ids.append("'").append(((OrgUnitInfo)obj).getId().toString()).append("',");
        }
        if (ids.lastIndexOf(",") > 0) {
            ids.deleteCharAt(ids.lastIndexOf(","));
            try {
                int i;
                OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select longNumber,level,unit.isUnion where tree.id='" + orgTree.getId().toString() + "' and unit.id in (" + ids + ")");
                OrgStructureInfo topOrg = null;
                OrgStructureInfo curOrg = null;
                HashMap longNumberMap = new HashMap();
                for (i = 0; i < coll.size(); ++i) {
                    curOrg = coll.get(i);
                    if (curOrg.getUnit().isIsUnion() && (topOrg == null || topOrg.getLevel() > curOrg.getLevel())) {
                        topOrg = curOrg;
                    }
                    longNumberMap.put(curOrg.getLongNumber(), null);
                }
                if (topOrg != null) {
                    for (i = 0; i < coll.size(); ++i) {
                        curOrg = coll.get(i);
                        if (curOrg.equals((Object)topOrg) || longNumberMap.containsKey(curOrg.getLongNumber().substring(0, curOrg.getLongNumber().lastIndexOf("!")))) continue;
                        return false;
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"isTree", (Throwable)e);
            }
        }
        return true;
    }

    private void initGradeManage() {
        this.getUIContext().put("isNeedMultiDynRpt", "false");
        this.itemPromp.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)new ItemContentProvider(){

            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.itemPromp.getData();
            }

            public String getCompanyId() {
                return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
        }, (IChooserLabelProvider)new ItemLabelProvider(), (IUIObject)this));
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser((IChooserContentProvider)new FetchTypeProvider(){

            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.fetchTypePromp.getData();
            }

            public String getCompanyId() {
                return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
        }, (IChooserLabelProvider)new FetchTypeLabelProvider(), (IUIObject)this));
    }

    private void initSumByQuarter() throws Exception {
        this.sumByQuarter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ItemAnalysisFilterUI.this.onlyDisplayQuarter.setEnabled(ItemAnalysisFilterUI.this.sumByQuarter.isSelected());
                if (!ItemAnalysisFilterUI.this.sumByQuarter.isSelected()) {
                    ItemAnalysisFilterUI.this.onlyDisplayQuarter.setSelected(false);
                }
            }
        });
        if (!this.isDynamicAnalysis) {
            Rectangle rectangle7 = this.sumByQuarter.getBounds();
            rectangle7.y -= 30;
            Rectangle rectangle8 = this.onlyDisplayQuarter.getBounds();
            rectangle8.y -= 30;
            this.sumByQuarter.setBounds(rectangle7);
            this.onlyDisplayQuarter.setBounds(rectangle8);
            Rectangle rectangle9 = this.includeRecChk.getBounds();
            rectangle9.y -= 30;
            this.includeRecChk.setBounds(rectangle9);
        }
    }

    private void initDynItem() throws Exception {
        this.dyItem.setVisible(this.isDynamicAnalysis);
        if (!this.isDynamicAnalysis) {
            Rectangle rectangle7 = this.kDLabelContainer7.getBounds();
            rectangle7.y -= 30;
            Rectangle rectangle8 = this.kDLabelContainer8.getBounds();
            rectangle8.y -= 30;
            this.kDLabelContainer7.setBounds(rectangle7);
            this.kDLabelContainer8.setBounds(rectangle8);
        }
        IChooserContentProvider contentProvider = new IChooserContentProvider(){

            public List getSelected() {
                return ItemAnalysisFilterUI.this.getSelectedDyItem();
            }

            public int compare(Object obj1, Object obj2) {
                if (obj1 instanceof DynaItemInfo && obj2 instanceof DynaItemInfo) {
                    String number1 = ((DynaItemInfo)obj1).getDitemNumber();
                    String number2 = ((DynaItemInfo)obj2).getDitemNumber();
                    if (!StringUtils.isEmpty((String)number1) && !StringUtils.isEmpty((String)number2)) {
                        return number1.equals(number2) ? 0 : 1;
                    }
                    return 1;
                }
                return obj1.equals(obj2) ? 0 : 1;
            }

            public boolean enableFilter() {
                return true;
            }

            public List getContents() throws Exception {
                return ItemAnalysisFilterUI.this.getDyItems();
            }

            public boolean matchFilter(Object item, int column, String filterString) {
                if (item instanceof DynaItemInfo) {
                    String value = null;
                    switch (column) {
                        case 0: {
                            value = ((DynaItemInfo)item).getDitemNumber();
                            break;
                        }
                        case 1: {
                            value = ((DynaItemInfo)item).getDitemName();
                            break;
                        }
                    }
                    if (value != null && value.indexOf(filterString) >= 0) {
                        return true;
                    }
                }
                return false;
            }

            public void setContents(ArrayList contents) {
            }

            public boolean enableTemplateFilter() {
                return false;
            }
        };
        IChooserLabelProvider labelProvider = new IChooserLabelProvider(){
            private String[] header = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"80_RptDynaItemAnalysisFilterUI"), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"81_RptDynaItemAnalysisFilterUI")};

            public String getColumnText(Object obj, int i) {
                if (obj instanceof DynaItemInfo) {
                    switch (i) {
                        case 0: {
                            return ((DynaItemInfo)obj).getDitemNumber();
                        }
                        case 1: {
                            return ((DynaItemInfo)obj).getDitemName();
                        }
                    }
                } else {
                    return obj != null ? obj.toString() : null;
                }
                return null;
            }

            public String[] getHeaderText() {
                return this.header;
            }
        };
        SortableChooser chooser = new SortableChooser(contentProvider, labelProvider, (IUIObject)this);
        this.dyItemF7.setSelector((KDPromptSelector)chooser);
    }

    private List getDyItems() throws Exception {
        if (!this.isHasDyitems) {
            String orgIds = this.getInStr((List)this.orgPromp.getData(), "id");
            if (StringUtils.isEmpty((String)orgIds)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"51_ItemAnalysisFilterUI"));
                return null;
            }
            String items = this.getInStr((List)this.itemPromp.getData(), "number");
            if (StringUtils.isEmpty((String)items)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"52_ItemAnalysisFilterUI"));
                return null;
            }
            ArrayList<DynaItemInfo> dyItems = new ArrayList<DynaItemInfo>();
            int startYear = (Integer)this.startYearSpin.getValue();
            int endYear = (Integer)this.endYearSpin.getValue();
            int startPeriod = (Integer)this.startPeriodSpin.getValue();
            int endPeriod = (Integer)this.endPeriodSpin.getValue();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgIds", orgIds.toString());
            params.put("items", items);
            params.put("startYear", startYear);
            params.put("endYear", endYear);
            params.put("startPeriod", startPeriod);
            params.put("endPeriod", endPeriod);
            IObjectCollection coll = DynaItemDataEntryFactory.getRemoteInstance().getKeyNumberName(params);
            if (coll != null) {
                DynaItemInfo itemInfo = null;
                for (int i = 0; i < coll.size(); ++i) {
                    itemInfo = new DynaItemInfo(coll.getObject(i).getString("keyName"), coll.getObject(i).getString("keyNumber"));
                    dyItems.add(itemInfo);
                }
            }
            return dyItems;
        }
        return this.getSelectedDyItem();
    }

    private String getInStr(List list, String field) {
        if (list != null) {
            StringBuffer inStr = new StringBuffer();
            for (Object obj : list) {
                if (obj instanceof ManageMergeOrgUnit) {
                    if (((ManageMergeOrgUnit)obj).isFastMergeOrgUnit()) continue;
                    if (inStr.length() > 0) {
                        inStr.append(",");
                    }
                    inStr.append("'").append(((ManageMergeOrgUnit)obj).getCalOrgUnit().getFullOrgUnitInfo().get(field)).append("'");
                    continue;
                }
                if (inStr.length() > 0) {
                    inStr.append(",");
                }
                inStr.append("'").append(((CoreBaseInfo)obj).get(field)).append("'");
            }
            return inStr.toString();
        }
        return null;
    }

    private List getSelectedDyItem() {
        Object obj = this.dyItemF7.getData();
        if (obj instanceof String) {
            return Arrays.asList((Object[])((String)obj).split(","));
        }
        return (List)this.dyItemF7.getData();
    }

    private void initSchemePromp() {
        for (ChangeListener listener : this.schemePromp.getChangeListeners()) {
            this.schemePromp.removeChangeListener(listener);
        }
        this.schemePromp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ItemAnalysisFilterUI.this.schemePromp.getData() != null) {
                    CurrencyInfo selectCurrency;
                    boolean isFind = false;
                    for (int i = 0; i < ItemAnalysisFilterUI.this.orgTreeCombo.getItemCount(); ++i) {
                        if (!((FastMergeSoluInfo)ItemAnalysisFilterUI.this.schemePromp.getData()).getOrgBound().getNumber().equals(((OrgTreeInfo)ItemAnalysisFilterUI.this.orgTreeCombo.getItemAt(i)).getNumber())) continue;
                        ItemAnalysisFilterUI.this.orgTreeCombo.setSelectedIndex(i);
                        isFind = true;
                        break;
                    }
                    if (!isFind) {
                        ItemAnalysisFilterUI.this.orgTreeCombo.addItem((Object)((FastMergeSoluInfo)ItemAnalysisFilterUI.this.schemePromp.getData()).getOrgBound());
                        ItemAnalysisFilterUI.this.orgTreeCombo.setSelectedItem((Object)((FastMergeSoluInfo)ItemAnalysisFilterUI.this.schemePromp.getData()).getOrgBound());
                    }
                    if ((selectCurrency = ((FastMergeSoluInfo)ItemAnalysisFilterUI.this.schemePromp.getData()).getCurrency()) != null) {
                        for (int i = 0; i < ItemAnalysisFilterUI.this.currencyComboBox.getItemCount(); ++i) {
                            if (!((CurrencyInfo)ItemAnalysisFilterUI.this.currencyComboBox.getItemAt(i)).getNumber().equals(selectCurrency.getNumber())) continue;
                            ItemAnalysisFilterUI.this.currencyComboBox.setSelectedIndex(i);
                            break;
                        }
                    }
                    ItemAnalysisFilterUI.this.orgTreeCombo.setEnabled(false);
                    String schemePK = ((FastMergeSoluInfo)ItemAnalysisFilterUI.this.schemePromp.getData()).getId().toString();
                    if (!StringUtils.isEmpty((String)schemePK)) {
                        try {
                            if (ItemAnalysisFilterUI.this.orgSelector == null) {
                                ItemAnalysisFilterUI.this.orgSelector = ItemAnalysisFilterUI.this.orgPromp.getSelector();
                            }
                            if (ItemAnalysisFilterUI.this.schemeOrgSelector == null) {
                                ItemAnalysisFilterUI.this.schemeOrgSelector = new SchemeOrgViewF7();
                            }
                            ItemAnalysisFilterUI.this.schemeOrgSelector.setSchemeId(schemePK);
                            ItemAnalysisFilterUI.this.orgPromp.setSelector((KDPromptSelector)ItemAnalysisFilterUI.this.schemeOrgSelector);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"CslViewUI error", (Throwable)ex);
                            SysUtil.abort();
                        }
                    }
                } else {
                    ItemAnalysisFilterUI.this.orgTreeCombo.setEnabled(true);
                    ItemAnalysisFilterUI.this.orgPromp.setData(null);
                    ItemAnalysisFilterUI.this.orgPromp.setSelector(ItemAnalysisFilterUI.this.orgSelector);
                }
            }
        });
        this.orgTreeCombo.setEnabled(true);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = super.getCustomerParams();
        params.addCustomerParam("CURRENCY_ID", ((CurrencyInfo)this.currencyComboBox.getSelectedItem()).getId().toString());
        params.addCustomerParam("CURRENCY_NUMBER", ((CurrencyInfo)this.currencyComboBox.getSelectedItem()).getNumber());
        if (this.isDynamicAnalysis) {
            params.addCustomerParam("DYITEM", this.getDyItemData());
        }
        params.putInt(ItemAnalysisConstant.sumByQuarterKey, this.sumByQuarter.getSelected());
        params.putInt(ItemAnalysisConstant.onlyDisplayQuarterKey, this.onlyDisplayQuarter.getSelected());
        params.addCustomerParam("isHasDyitems", this.isHasDyitems ? "1" : "0");
        params.putBoolean("incluedUnReceivedData", this.includeRecChk.isSelected());
        return params;
    }

    public void setCustomerParams(CustomerParams params) {
        super.setCustomerParams(params);
        String currencyId = params.getCustomerParam("CURRENCY_ID");
        if (currencyId != null) {
            for (int i = 0; i < this.currencyComboBox.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.currencyComboBox.getItemAt(i)).getId().toString().equals(currencyId)) continue;
                this.currencyComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.isHasDyitems = StringUtils.isEmpty((String)params.getCustomerParam("isHasDyitems")) ? true : params.getCustomerParam("isHasDyitems").equals("1");
        String selectDyItems = params.getCustomerParam("DYITEM");
        if (selectDyItems != null) {
            String split1 = ",,";
            String split2 = ";;";
            if (selectDyItems.indexOf(split1) < 0 && selectDyItems.indexOf(",") > 0) {
                split1 = ",";
                split2 = ";";
            }
            String[] numberNames = selectDyItems.split(split1);
            ArrayList<DynaItemInfo> selectDyItemList = new ArrayList<DynaItemInfo>();
            DynaItemInfo info = null;
            for (String numberName : numberNames) {
                String[] str = numberName.split(split2);
                info = str.length < 2 ? new DynaItemInfo(" ", str[0]) : new DynaItemInfo(str[1], str[0]);
                selectDyItemList.add(info);
            }
            this.dyItemF7.setData(selectDyItemList);
        }
        this.sumByQuarter.setSelected(params.getInt(ItemAnalysisConstant.sumByQuarterKey) == 32);
        this.onlyDisplayQuarter.setSelected(params.getInt(ItemAnalysisConstant.onlyDisplayQuarterKey) == 32);
        this.includeRecChk.setSelected(params.getBoolean("incluedUnReceivedData"));
    }

    protected String getOrgsStr(List orgList) {
        String str = ItemAnalysisHepler.getInstance().solutOrgs2Str(orgList);
        if (!StringUtils.isEmpty((String)str)) {
            return str;
        }
        return super.getOrgsStr(orgList);
    }

    protected List getOrgList(String orgStrs) throws Exception {
        List<ManageMergeOrgUnit> orgList = ItemAnalysisHepler.getInstance().str2SolutOrg(orgStrs);
        if (orgList != null && !orgList.isEmpty()) {
            return orgList;
        }
        if (this.schemePromp.getData() != null) {
            return null;
        }
        return super.getOrgList(orgStrs);
    }

    private String getDyItemData() {
        List dyItems = this.getSelectedDyItem();
        return ItemAnalysisHepler.getInstance().getDyItemData(dyItems);
    }

    protected void initOrgTreeCombo() throws EASBizException, BOSException {
        if (this.isFire) {
            OrgTreeInfo selectOrgTree = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
            List rptYearAndPeriodAndDate = RPTDateUtil.getRptYearAndPeriodAndDate((int)this.endYearSpin.getIntegerVlaue(), (int)this.endPeriodSpin.getIntegerVlaue(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem()));
            Date rptDate = (Date)rptYearAndPeriodAndDate.get(rptYearAndPeriodAndDate.size() - 1);
            if (this.lastRptData == null || !this.lastRptData.equals(rptDate)) {
                OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)rptDate);
                this.orgTreeCombo.removeAllItems();
                this.orgTreeCombo.addItems(otc.toArray());
                otc.clear();
            }
            if (selectOrgTree != null && selectOrgTree.getId() != null) {
                for (int i = 0; i < this.orgTreeCombo.getItemCount(); ++i) {
                    if (!((OrgTreeInfo)this.orgTreeCombo.getItemAt(i)).getId().toString().equals(selectOrgTree.getId().toString())) continue;
                    this.orgTreeCombo.setSelectedIndex(i);
                    break;
                }
            }
            this.lastRptData = rptDate;
        }
    }

    public boolean verify() {
        if (this.orgTreeCombo.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"50_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.orgPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"51_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.itemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"52_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"53_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.currencyComboBox.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"54_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.dataTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"55_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.isDynamicAnalysis && this.dyItemF7.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"84_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        int startYear = (Integer)this.startYearSpin.getValue();
        int endYear = (Integer)this.endYearSpin.getValue();
        int startPeriod = (Integer)this.startPeriodSpin.getValue();
        int endPeriod = (Integer)this.endPeriodSpin.getValue();
        if (startYear == endYear && endPeriod < startPeriod || endYear < startYear) {
            MsgBox.showError((Component)((Object)this), (String)RptBiUtil.getString((String)"endPeriodLessStart"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        if (this.isDynamicAnalysis) {
            this.dyItemF7.setData(null);
            this.isHasDyitems = false;
        }
        this.sumByQuarter.setSelected(false);
        this.onlyDisplayQuarter.setSelected(false);
        if (this.customerParams != null) {
            this.setCustomerParams(this.customerParams);
        }
    }

    public String getPanelName() {
        return this.getUITitle();
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setInitCustomerParams(CustomerParams params) {
        this.customerParams = params;
    }

    public boolean isDynamicAnalysis() {
        return this.isDynamicAnalysis;
    }

    public void setDynamicAnalysis(boolean isDynamicAnalysis) {
        this.isDynamicAnalysis = isDynamicAnalysis;
    }

    public class SchemeOrgViewF7
    implements KDPromptSelector {
        private String schemeId = null;
        private UIContext context = new UIContext((Object)this);
        private IUIWindow uiWindow;

        public String getSchemeId() {
            return this.schemeId;
        }

        public void setSchemeId(String schemeId) {
            this.schemeId = schemeId;
        }

        public Object getData() {
            if (!((CslViewUI)this.uiWindow.getUIObject()).isCancel()) {
                List curData = ((CslViewUI)this.uiWindow.getUIObject()).getSelectObjects();
                return curData.isEmpty() ? null : curData;
            }
            return ItemAnalysisFilterUI.this.orgPromp.getData();
        }

        public boolean isCanceled() {
            return false;
        }

        public void show() {
            this.context.put((Object)"selectManageMergeViewObject", ItemAnalysisFilterUI.this.orgPromp.getData());
            this.context.put((Object)"solutionId", (Object)this.schemeId);
            try {
                this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CslViewUI.class.getName(), (Map)this.context, null, OprtState.EDIT);
                this.uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)"SchemeOrgViewF7 show error.", (Throwable)e);
                SysUtil.abort();
            }
        }
    }
}

