/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.report.AbstractItemAnalysisGuideUI;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ItemAnalysisGuideUI
extends AbstractItemAnalysisGuideUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisGuideUI.class);
    protected List<String> itemsForSelect = new ArrayList<String>();
    protected List<String> rowItems = new ArrayList<String>();
    protected List<String> colItems = new ArrayList<String>();
    protected Map<String, String> itemsMap = new HashMap<String, String>();
    private int selectIndex = -1;
    private int count = 0;
    private boolean isMouseDragged = false;
    private SpreadManager spreadManager;
    private Sheet sheet;
    private CustomerParams customerParams = null;
    private boolean isFromReport = false;
    private boolean isDynamicAnalysis = false;

    protected void initList() {
        if (this.itemsMap.isEmpty()) {
            this.itemsMap.put(ItemAnalysisConstant.orgUnitKey, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"15_ReportQueryPanel"));
            this.itemsMap.put(ItemAnalysisConstant.itemKey, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"84_rptitem"));
            this.itemsMap.put(ItemAnalysisConstant.dataElementKey, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"82_dataElement"));
            this.itemsMap.put(ItemAnalysisConstant.periodKey, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"kDLabelContainer3.boundLabelText"));
            this.itemsMap.put(ItemAnalysisConstant.AdjustType, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"106_adjust"));
        }
        if (this.isDynamicAnalysis) {
            this.itemsMap.put(ItemAnalysisConstant.dyItemKey, " " + EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"83_dyItem"));
        }
        this.rowItems.add(ItemAnalysisConstant.orgUnitKey);
        if (this.isDynamicAnalysis) {
            this.rowItems.add(ItemAnalysisConstant.dyItemKey);
            this.colItems.add(ItemAnalysisConstant.itemKey);
        } else {
            this.colItems.add(ItemAnalysisConstant.itemKey);
        }
        this.colItems.add(ItemAnalysisConstant.dataElementKey);
        this.itemsForSelect.add(ItemAnalysisConstant.periodKey);
        this.itemsForSelect.add(ItemAnalysisConstant.AdjustType);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initList();
        this.viewTable.setEditable(false);
        this.ItemForSelectList.setAllowAutoToolTipText(true);
        this.initSelectedRange();
        this.initItemForSelectList();
        this.refreshKdTable();
        this.cslCheckBox.setSelected(true);
    }

    private void initSelectedRange() {
        RangeSelector rangeChooser = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.startRange.setBoundEditor((JComponent)rangeChooser);
        if (this.sheet != null) {
            if (this.isFromReport) {
                ((KDTextField)rangeChooser.getComponent(0)).setText(this.sheet.getRange(0, 0).getName());
            } else {
                ((KDTextField)rangeChooser.getComponent(0)).setText(this.sheet.getSelectionRange().getName());
            }
        }
        this.applyBtn.setVisible(false);
        this.applyBtn.setEnabled(false);
        RangeSelector rangeChooser2 = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.selectedRange.setBoundEditor((JComponent)rangeChooser2);
        if (this.sheet != null) {
            ((KDTextField)rangeChooser2.getComponent(0)).setText(this.sheet.getSelectionRange().getName());
        }
        this.selectedRange.setEnabled(this.isFromReport);
        this.selectedRange.setVisible(this.isFromReport);
    }

    protected void initItemForSelectList() {
        this.initListListener();
        this.refreshKdList(this.ItemForSelectList);
        this.refreshKdList(this.rowList);
        this.refreshKdList(this.colList);
    }

    protected void refreshKdList(KDList kdList) {
        kdList.removeAllElements();
        List curItems = this.getArrayListByKdList(kdList);
        for (Object number : curItems) {
            kdList.addElement((Object)this.itemsMap.get(number));
        }
    }

    protected void refreshKdTable() {
        int j;
        int i;
        int mergeBlockSize;
        if (!this.colItems.isEmpty()) {
            int colCount = (int)Math.pow(2.0, this.colItems.size() - 1);
            this.viewTable.removeHeadRows();
            this.viewTable.removeColumns();
            this.viewTable.addColumns(colCount);
            this.viewTable.addHeadRows(this.colItems.size());
            IRow iRow = null;
            mergeBlockSize = 1;
            for (i = this.colItems.size() - 1; i >= 0; --i) {
                mergeBlockSize = (int)Math.pow(2.0, this.colItems.size() - (i + 1));
                iRow = this.viewTable.getHeadRow(i);
                for (j = 0; j < colCount; ++j) {
                    iRow.getCell(j).setValue((Object)this.itemsMap.get(this.colItems.get(i)));
                    if (mergeBlockSize > 1 && (j + 1) % mergeBlockSize == 0) {
                        this.viewTable.getHeadMergeManager().mergeBlock(i, j - mergeBlockSize + 1, i, j);
                    }
                    if (i != 0) continue;
                    this.viewTable.getColumn(j).setWidth(65);
                }
            }
        }
        if (!this.rowItems.isEmpty()) {
            if (this.colItems.isEmpty()) {
                this.viewTable.removeHeadRows();
                this.viewTable.removeColumns();
            }
            int rowCount = (int)Math.pow(2.0, this.rowItems.size() - 1);
            this.viewTable.addRows(rowCount);
            for (int i2 = 0; i2 < this.rowItems.size(); ++i2) {
                IColumn iCol = this.viewTable.addColumn(i2);
                iCol.setWidth(65);
            }
            mergeBlockSize = 1;
            for (i = this.rowItems.size() - 1; i >= 0; --i) {
                mergeBlockSize = (int)Math.pow(2.0, this.rowItems.size() - (i + 1));
                for (j = 0; j < rowCount; ++j) {
                    this.viewTable.getCell(j, i).setValue((Object)this.itemsMap.get(this.rowItems.get(i)));
                    if (mergeBlockSize <= 1 || (j + 1) % mergeBlockSize != 0) continue;
                    this.viewTable.getMergeManager().mergeBlock(j - mergeBlockSize + 1, i, j, i);
                }
            }
        }
        if (!this.colItems.isEmpty() && !this.rowItems.isEmpty()) {
            this.viewTable.getHeadMergeManager().mergeBlock(0, 0, this.colItems.size() - 1, this.rowItems.size() - 1);
        }
    }

    private void initListListener() {
        MouseMotionListener listener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ItemAnalysisGuideUI.this.isMouseDragged = true;
                if (ItemAnalysisGuideUI.this.count == 0) {
                    KDList kdList = (KDList)e.getSource();
                    ItemAnalysisGuideUI.this.selectIndex = kdList.getSelectedIndex();
                }
                ItemAnalysisGuideUI.this.count++;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                ItemAnalysisGuideUI.this.isMouseDragged = false;
                ItemAnalysisGuideUI.this.count = 0;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ItemAnalysisGuideUI.this.isMouseDragged) {
                    KDList kdList = (KDList)e.getSource();
                    int toX = e.getX() + kdList.getX();
                    int toY = e.getY() + kdList.getY();
                    ItemAnalysisGuideUI.this.moveItem(kdList, toX, toY);
                    ItemAnalysisGuideUI.this.refreshKdTable();
                }
                ItemAnalysisGuideUI.this.isMouseDragged = false;
                ItemAnalysisGuideUI.this.count = 0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        };
        this.ItemForSelectList.addMouseMotionListener(listener);
        this.ItemForSelectList.addMouseListener(mouseListener);
        this.rowList.addMouseMotionListener(listener);
        this.rowList.addMouseListener(mouseListener);
        this.colList.addMouseMotionListener(listener);
        this.colList.addMouseListener(mouseListener);
        this.sumCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ItemAnalysisGuideUI.this.kDRdFromSumRpt.setEnabled(ItemAnalysisGuideUI.this.sumCheckBox.isSelected());
                if (!ItemAnalysisGuideUI.this.sumCheckBox.isSelected()) {
                    ItemAnalysisGuideUI.this.kDRdFromSumRpt.setSelected(false);
                }
            }
        });
    }

    private void moveItem(KDList sourceKdList, int toX, int toY) {
        for (KDList targetKdList : new KDList[]{this.ItemForSelectList, this.rowList, this.colList}) {
            if (!this.isContain(targetKdList, toX, toY)) continue;
            if (sourceKdList == targetKdList) {
                this.chandeRow(targetKdList, toY);
                continue;
            }
            int index = this.findTargetIndex(targetKdList, toY);
            List targetList = this.getArrayListByKdList(targetKdList);
            List sourceList = this.getArrayListByKdList(sourceKdList);
            this.checkCanMove(sourceList.get(this.selectIndex), sourceKdList, targetKdList);
            targetList.add(index, sourceList.get(this.selectIndex));
            sourceList.remove(this.selectIndex);
            this.refreshKdList(sourceKdList);
            this.refreshKdList(targetKdList);
        }
    }

    protected void checkCanMove(Object itemKey, KDList sourceKdList, KDList targetKdList) {
    }

    private void chandeRow(KDList kdList, int toY) {
        int chandeIndex;
        Rectangle cellBounds = kdList.getCellBounds(this.selectIndex, this.selectIndex);
        if ((kdList.getY() + cellBounds.y + cellBounds.height < toY || kdList.getY() + cellBounds.y > toY) && (chandeIndex = this.findChandeIndex(kdList, cellBounds, toY)) >= 0) {
            List curItems = this.getArrayListByKdList(kdList);
            Object tmpValue = curItems.get(chandeIndex);
            curItems.set(chandeIndex, curItems.get(this.selectIndex));
            curItems.set(this.selectIndex, tmpValue);
            this.refreshKdList(kdList);
        }
    }

    private int findTargetIndex(KDList targetKdList, int toY) {
        if (targetKdList.getElementCount() <= 0) {
            return 0;
        }
        Rectangle cellBounds = targetKdList.getCellBounds(0, 0);
        int index = (int)Math.ceil(((double)toY - (cellBounds.getY() + (double)targetKdList.getY())) / cellBounds.getHeight()) - 1;
        if (index > targetKdList.getElementCount()) {
            index = targetKdList.getElementCount();
        }
        return index;
    }

    private boolean isContain(KDList kdList, int toX, int toY) {
        return kdList.getX() <= toX && kdList.getY() <= toY && kdList.getX() + kdList.getWidth() >= toX && kdList.getY() + kdList.getHeight() >= toY;
    }

    private int findChandeIndex(KDList kdList, Rectangle cellBounds, int toY) {
        if (toY > kdList.getY() + cellBounds.y + cellBounds.height) {
            int offset = (int)Math.ceil((double)(toY - (kdList.getY() + cellBounds.y + cellBounds.height)) / (double)cellBounds.height);
            return this.selectIndex + offset;
        }
        int offset = (int)Math.ceil((double)(kdList.getY() + cellBounds.y - toY) / (double)cellBounds.height);
        return this.selectIndex - offset;
    }

    private List getArrayListByKdList(KDList kdList) {
        if (kdList.getName().equals("ItemForSelectList")) {
            return this.itemsForSelect;
        }
        if (kdList.getName().equals("rowList")) {
            return this.rowItems;
        }
        if (kdList.getName().equals("colList")) {
            return this.colItems;
        }
        return null;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        params.addCustomerParam("itemsForSelect", CslRptUtil.list2String(this.itemsForSelect, (String)ItemAnalysisConstant.splitStr));
        params.addCustomerParam("rowItems", CslRptUtil.list2String(this.rowItems, (String)ItemAnalysisConstant.splitStr));
        params.addCustomerParam("colItems", CslRptUtil.list2String(this.colItems, (String)ItemAnalysisConstant.splitStr));
        params.putInt("sumCheckBox", this.sumCheckBox.getSelected());
        params.putInt("elimCheckBox", this.elimCheckBox.getSelected());
        params.putInt("cslCheckBox", this.cslCheckBox.getSelected());
        params.putBoolean(ItemAnalysisConstant.isSumValueFromSumRpt, this.kDRdFromSumRpt.isSelected());
        params.addCustomerParam("startRange", ((KDTextField)this.startRange.getBoundEditor().getComponent(0)).getText());
        if (this.isFromReport) {
            params.addCustomerParam("selectedRange", ((KDTextField)this.selectedRange.getBoundEditor().getComponent(0)).getText());
        }
        return params;
    }

    private void setSelectList(String selectStrValue, List selectList, Map<String, String> existMap) {
        selectList.clear();
        if (!StringUtils.isEmpty((String)selectStrValue)) {
            List rowList = Arrays.asList((Object[])selectStrValue.split(ItemAnalysisConstant.splitStr));
            for (Object str : rowList) {
                existMap.remove((String)str);
            }
            selectList.addAll(rowList);
        }
    }

    public void setCustomerParams(CustomerParams params) {
        if (params != null) {
            HashMap<String, String> tmpKey = new HashMap<String, String>();
            tmpKey.putAll(this.itemsMap);
            String rowItemsStr = params.getCustomerParam("rowItems");
            this.setSelectList(rowItemsStr, this.rowItems, tmpKey);
            String colItemsStr = params.getCustomerParam("colItems");
            this.setSelectList(colItemsStr, this.colItems, tmpKey);
            String itemsForSelectStr = params.getCustomerParam("itemsForSelect");
            this.setSelectList(itemsForSelectStr, this.itemsForSelect, tmpKey);
            if (!tmpKey.isEmpty()) {
                if (!this.isDynamicAnalysis) {
                    tmpKey.remove(ItemAnalysisConstant.dyItemKey);
                }
                this.itemsForSelect.addAll(tmpKey.keySet());
                tmpKey.clear();
            }
            this.sumCheckBox.setSelected(params.getInt("sumCheckBox"));
            this.elimCheckBox.setSelected(params.getInt("elimCheckBox"));
            this.cslCheckBox.setSelected(params.getInt("cslCheckBox"));
            if (this.sumCheckBox.isSelected()) {
                this.kDRdFromSumRpt.setSelected(params.getBoolean(ItemAnalysisConstant.isSumValueFromSumRpt));
            }
            this.refreshKdList(this.ItemForSelectList);
            this.refreshKdList(this.rowList);
            this.refreshKdList(this.colList);
            this.refreshKdTable();
            if (this.isFromReport && !StringUtils.isEmpty((String)params.getCustomerParam("selectedRange"))) {
                ((KDTextField)this.selectedRange.getBoundEditor().getComponent(0)).setText(params.getCustomerParam("selectedRange"));
            }
        }
    }

    public boolean verify() {
        String notEmpty = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"84_isNotEmpty");
        if (this.rowItems.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.kDLabel3.getText() + notEmpty));
            return false;
        }
        if (this.colItems.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.kDLabel2.getText() + notEmpty));
            return false;
        }
        String startRangeStr = ((KDTextField)this.startRange.getBoundEditor().getComponent(0)).getText();
        if (StringUtils.isEmpty((String)startRangeStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.startRange.getBoundLabelText() + notEmpty));
            return false;
        }
        String selectedRangeStr = ((KDTextField)this.selectedRange.getBoundEditor().getComponent(0)).getText();
        if (this.isFromReport && StringUtils.isEmpty((String)selectedRangeStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.selectedRange.getBoundLabelText() + notEmpty));
            return false;
        }
        if (!(this.sumCheckBox.isSelected() || this.elimCheckBox.isSelected() || this.cslCheckBox.isSelected())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"95_mustSelectOne"));
            return false;
        }
        return true;
    }

    public void clear() {
        this.itemsForSelect.clear();
        this.rowItems.clear();
        this.colItems.clear();
        this.initList();
        this.refreshKdList(this.ItemForSelectList);
        this.refreshKdList(this.rowList);
        this.refreshKdList(this.colList);
        this.refreshKdTable();
        this.sumCheckBox.setSelected(false);
        this.elimCheckBox.setSelected(false);
        this.cslCheckBox.setSelected(true);
        if (this.customerParams != null) {
            this.setCustomerParams(this.customerParams);
        }
    }

    public String getPanelName() {
        return this.getUITitle();
    }

    public void setSpreadManager(SpreadManager spreadManager) {
        this.spreadManager = spreadManager;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setInitCustomerParams(CustomerParams params) {
        this.customerParams = params;
    }

    public boolean isDynamicAnalysis() {
        return this.isDynamicAnalysis;
    }

    public void setDynamicAnalysis(boolean isDynamicAnalysis) {
        this.isDynamicAnalysis = isDynamicAnalysis;
    }

    public boolean isFromReport() {
        return this.isFromReport;
    }

    public void setFromReport(boolean isFromReport) {
        this.isFromReport = isFromReport;
    }
}

