/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.ManageMergeOrgUnit;
import com.kingdee.eas.fi.newrpt.AnalysisReportFactory;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.report.AbstractMidTableAnalysisFilterUI;
import com.kingdee.eas.fi.newrpt.report.AnalysisBasePointParams;
import com.kingdee.eas.fi.newrpt.report.DmAnalysisHelper;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisCellObject;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.rpt.batch.iref.AcctItemAsstTranslator;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemInfo;
import com.kingdee.eas.fi.rpt.excelformula.util.AreaReference;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemAnalysisHandle {
    private Map<String, List<ItemAnalysisCellObject>> headDataMap = new HashMap<String, List<ItemAnalysisCellObject>>();
    private List colKeyList = null;
    private List rowKeyList = null;
    private List<List<ItemAnalysisCellObject>> headRowDatas = new ArrayList<List<ItemAnalysisCellObject>>();
    private List<List<ItemAnalysisCellObject>> headColDatas = new ArrayList<List<ItemAnalysisCellObject>>();
    private Sheet sheet = null;
    private AnalysisBasePointParams basePointParams = null;
    private Point basePoint = null;
    private List<String> selectSourceType = new ArrayList<String>();
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private CustomerParams guideUIParams = null;
    private CustomerParams filterParams = null;
    private boolean isDynamicAnalysis = false;
    private boolean isSumByQuarter = false;
    private boolean isOnlyDisplayQuarter = false;
    private SpreadManager spreadManager = null;
    private boolean isSupport13Period = CslRptUtil.isSupport13Period(null);
    private Map<String, String> orgChild_parentMap = new HashMap<String, String>();
    private String orgTreeNumber = null;
    private int pageSize = 50;
    private DmAnalysisHelper dmAnalysisHelper = null;

    public void init(SpreadManager spreadManager, Sheet sheet, CustomerParams guideUIParams, CustomerParams filterParams, boolean isDynamicAnalysis) throws Exception {
        this.sheet = sheet;
        this.guideUIParams = guideUIParams;
        this.filterParams = filterParams;
        this.isDynamicAnalysis = isDynamicAnalysis;
        this.spreadManager = spreadManager;
    }

    public void analysisHandle() throws Exception {
        try {
            if (this.filterParams.getBoolean("isMidTableAnalysis")) {
                this.analysisMidTableHandle();
            } else {
                this.analysisItemHandle();
            }
        }
        finally {
            this.clearCollection();
        }
    }

    protected void analysisItemHandle() throws Exception {
        if (this.initParams(this.guideUIParams, this.filterParams, true)) {
            this.dmAnalysisHelper = new DmAnalysisHelper();
            this.dmAnalysisHelper.fillHead(this.headRowDatas, this.headColDatas, this.sheet, this.basePoint);
            this.saveBasePoint();
            this.fillAnalysisDatas();
            this.dmAnalysisHelper.autoSetColWidth(this.spreadManager, this.sheet, this.basePoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData(Sheet sheet) throws Exception {
        this.sheet = sheet;
        ArrayList basePointList = ItemAnalysisHepler.getInstance().getBasePointList(sheet);
        if (basePointList != null) {
            for (int i = basePointList.size() - 1; i >= 0; --i) {
                try {
                    this.basePoint = (Point)basePointList.get(i);
                    this.basePointParams = ItemAnalysisHepler.getInstance().getParametersFromCell(sheet.getCell(this.basePoint.y, this.basePoint.x, true));
                    this.isDynamicAnalysis = this.basePointParams.isDynamicAnalysis();
                    this.guideUIParams = this.basePointParams.getAnalysisGuideParams();
                    this.filterParams = this.basePointParams.getAnalysisFilterParams();
                    if (this.basePointParams.isMidTableAnalysis()) {
                        if (!this.initMidTableAnalysisParams(this.guideUIParams, this.filterParams, false)) continue;
                        this.fillMidTableAnalysisDatas(false);
                        continue;
                    }
                    if (!this.initParams(this.guideUIParams, this.filterParams, false)) continue;
                    this.fillAnalysisDatas();
                    continue;
                }
                finally {
                    this.clearCollection();
                }
            }
        }
    }

    private void saveBasePoint() {
        AnalysisBasePointParams basePointParams = ItemAnalysisHepler.getInstance().getParametersFromCell(this.sheet.getCell(this.basePoint.y, this.basePoint.x, true));
        if (basePointParams == null) {
            basePointParams = new AnalysisBasePointParams();
        }
        basePointParams.setAnalysisFilterParams(this.filterParams);
        basePointParams.setAnalysisGuideParams(this.guideUIParams);
        basePointParams.setDynamicAnalysis(this.isDynamicAnalysis);
        Range range = this.sheet.getRange(this.basePoint.y, this.basePoint.x);
        ItemAnalysisHepler.getInstance().saveBasePointParametersToCell(range, basePointParams);
    }

    private boolean initHeadDatas(CustomerParams guideUIParams, CustomerParams filterParams, boolean isInitBasePoint) throws Exception {
        String selectCell;
        AreaReference ar;
        CellReference[] cells;
        this.isSumByQuarter = filterParams.getInt(ItemAnalysisConstant.sumByQuarterKey) == 32;
        this.isOnlyDisplayQuarter = filterParams.getInt(ItemAnalysisConstant.onlyDisplayQuarterKey) == 32;
        this.colKeyList = Arrays.asList(guideUIParams.getCustomerParam("colItems").split(ItemAnalysisConstant.splitStr));
        this.rowKeyList = Arrays.asList(guideUIParams.getCustomerParam("rowItems").split(ItemAnalysisConstant.splitStr));
        if (guideUIParams.getInt("cslCheckBox") == 32) {
            this.selectSourceType.add(ItemAnalysisConstant.cslType);
        }
        if (guideUIParams.getInt("elimCheckBox") == 32) {
            this.selectSourceType.add(ItemAnalysisConstant.elimType);
        }
        if (guideUIParams.getInt("sumCheckBox") == 32) {
            this.selectSourceType.add(ItemAnalysisConstant.sumType);
        }
        if (!this.initHeadMap(filterParams)) {
            return false;
        }
        if (isInitBasePoint && (cells = (ar = new AreaReference(selectCell = guideUIParams.getCustomerParam("startRange"))).getCells()) != null && cells.length > 0) {
            this.basePoint = new Point(cells[0].getCol(), cells[0].getRow());
        }
        this.initRowColHeadData(this.headColDatas, this.colKeyList);
        this.initRowColHeadData(this.headRowDatas, this.rowKeyList);
        return true;
    }

    private boolean initParams(CustomerParams guideUIParams, CustomerParams filterParams, boolean isInitBasePoint) throws Exception {
        boolean result = true;
        result = this.initHeadDatas(guideUIParams, filterParams, isInitBasePoint);
        if (!result) {
            return result;
        }
        this.paramMap.put(ItemAnalysisConstant.colKeys, this.colKeyList);
        this.paramMap.put(ItemAnalysisConstant.rowKeys, this.rowKeyList);
        this.paramMap.put(ItemAnalysisConstant.orgTreeNumber, this.orgTreeNumber);
        if (!StringUtils.isEmpty((String)filterParams.getCustomerParam("SCHEME_ID"))) {
            this.paramMap.put(ItemAnalysisConstant.schemeId, filterParams.getCustomerParam("SCHEME_ID"));
        }
        this.paramMap.put(ItemAnalysisConstant.filterData, this.headDataMap);
        this.paramMap.put(ItemAnalysisConstant.sourceType, this.selectSourceType);
        this.paramMap.put(ItemAnalysisConstant.currency, filterParams.getCustomerParam("CURRENCY_ID"));
        this.paramMap.put(ItemAnalysisConstant.isDynamicAnalysis, this.isDynamicAnalysis);
        this.paramMap.put(ItemAnalysisConstant.sumByQuarterKey, this.isSumByQuarter);
        this.paramMap.put(ItemAnalysisConstant.onlyDisplayQuarterKey, this.isOnlyDisplayQuarter);
        this.paramMap.put(ItemAnalysisConstant.startYearPeriodKey, Integer.parseInt(filterParams.getCustomerParam("START_YEAR")) + ItemAnalysisConstant.splitStr + Integer.parseInt(filterParams.getCustomerParam("START_PERIOD")));
        this.paramMap.put(ItemAnalysisConstant.endYearPeriodKey, Integer.parseInt(filterParams.getCustomerParam("END_YEAR")) + ItemAnalysisConstant.splitStr + Integer.parseInt(filterParams.getCustomerParam("END_PERIOD")));
        this.initOrgRelationsMap(this.headDataMap.get(ItemAnalysisConstant.orgUnitKey), !StringUtils.isEmpty((String)filterParams.getCustomerParam("SCHEME_ID")));
        this.paramMap.put(ItemAnalysisConstant.orgRelationsKey, this.orgChild_parentMap);
        this.paramMap.put(ItemAnalysisConstant.incluedUnReceivedDataKey, filterParams.getBoolean("incluedUnReceivedData"));
        this.paramMap.put(ItemAnalysisConstant.isSumValueFromSumRpt, guideUIParams.getBoolean(ItemAnalysisConstant.isSumValueFromSumRpt));
        this.initReportVariables();
        return result;
    }

    private void initReportVariables() throws Exception {
        String currencyNumber = this.filterParams.getCustomerParam("CURRENCY_NUMBER");
        if (StringUtils.isEmpty((String)currencyNumber)) {
            String currencyId = this.filterParams.getCustomerParam("CURRENCY_ID");
            currencyNumber = CurrencyFactory.getRemoteInstance().getDataBaseInfo("select number where id='" + currencyId + "'").getNumber();
        }
        ReportVariables v = ReportVariables.loadFromBook((Book)this.sheet.getBook());
        v.get("Currency", this.sheet.getSheetName()).setValue(currencyNumber);
        v.get("StartPeriod", this.sheet.getSheetName()).setValue(this.filterParams.getCustomerParam("START_PERIOD"));
        v.get("EndPeriod", this.sheet.getSheetName()).setValue(this.filterParams.getCustomerParam("END_PERIOD"));
        v.get("StartYear", this.sheet.getSheetName()).setValue(this.filterParams.getCustomerParam("START_YEAR"));
        v.get("EndYear", this.sheet.getSheetName()).setValue(this.filterParams.getCustomerParam("END_YEAR"));
    }

    private void initRowColHeadData(List<List<ItemAnalysisCellObject>> datas, List keys) {
        datas.clear();
        String key = null;
        for (Object curKey : keys) {
            key = ((String)curKey).trim();
            if (key.isEmpty()) continue;
            datas.add(this.headDataMap.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAnalysisDatas() throws Exception {
        if (!this.paramMap.isEmpty()) {
            try {
                String solutId;
                if (this.dmAnalysisHelper == null) {
                    this.dmAnalysisHelper = new DmAnalysisHelper();
                }
                this.dmAnalysisHelper.initItemAnalysisParams(true);
                this.dmAnalysisHelper.InitBatchFill(this.sheet, this.basePoint);
                List<ItemAnalysisCellObject> orgUnitList = this.headDataMap.get(ItemAnalysisConstant.orgUnitKey);
                int batchCount = this.dmAnalysisHelper.getBatchCount();
                int curPageSize = orgUnitList.size() / batchCount;
                if (curPageSize > 0) {
                    this.pageSize = curPageSize;
                }
                if (!StringUtils.isEmpty((String)(solutId = (String)this.paramMap.get(ItemAnalysisConstant.schemeId)))) {
                    HashMap keyMap = new HashMap();
                    HashMap<String, ArrayList<ItemAnalysisCellObject>> keyGroupMap = new HashMap<String, ArrayList<ItemAnalysisCellObject>>();
                    ArrayList<ItemAnalysisCellObject> curCellObjectList = null;
                    ItemAnalysisCellObject orgUnitCellObj = null;
                    for (int i = orgUnitList.size() - 1; i >= 0; --i) {
                        orgUnitCellObj = orgUnitList.get(i);
                        if (keyMap.containsKey(orgUnitCellObj.getKey())) continue;
                        keyMap.put(orgUnitCellObj.getKey(), null);
                        curCellObjectList = (ArrayList<ItemAnalysisCellObject>)keyGroupMap.get(orgUnitCellObj.getExKey());
                        if (curCellObjectList == null) {
                            curCellObjectList = new ArrayList<ItemAnalysisCellObject>();
                            keyGroupMap.put(orgUnitCellObj.getExKey(), curCellObjectList);
                        }
                        curCellObjectList.add(orgUnitCellObj);
                    }
                    keyMap.clear();
                    ReportCalcGroupKey reportCalcGroupKey = null;
                    String tmpSolutId = null;
                    String orgTreeNumber = this.orgTreeNumber;
                    for (String exKey : keyGroupMap.keySet()) {
                        reportCalcGroupKey = ReportCalcGroupKey.parse2ReportCalcGroupKey((String)exKey);
                        tmpSolutId = null;
                        if (reportCalcGroupKey != null) {
                            if (reportCalcGroupKey.getSourceSoluInfo() != null && reportCalcGroupKey.getSourceSoluInfo().getId() != null) {
                                tmpSolutId = reportCalcGroupKey.getSourceSoluInfo().getId().toString();
                            }
                            if (reportCalcGroupKey.getOrgTree() != null && reportCalcGroupKey.getOrgTree().getNumber() != null) {
                                orgTreeNumber = reportCalcGroupKey.getOrgTree().getNumber();
                            }
                        }
                        this.paramMap.put(ItemAnalysisConstant.schemeId, tmpSolutId);
                        this.paramMap.put(ItemAnalysisConstant.orgTreeNumber, orgTreeNumber);
                        this.paramMap.put(ItemAnalysisConstant.orgGroupKey, exKey);
                        this.fillAnaylsisDatas((List)keyGroupMap.get(exKey));
                    }
                    keyGroupMap.clear();
                } else {
                    this.fillAnaylsisDatas(orgUnitList);
                }
            }
            finally {
                this.clearCollection();
            }
        }
    }

    private void fillAnaylsisDatas(List<ItemAnalysisCellObject> orgUnitList) throws Exception {
        if (orgUnitList.size() > this.pageSize) {
            ArrayList<ItemAnalysisCellObject> curOrgUnitList = new ArrayList<ItemAnalysisCellObject>();
            for (ItemAnalysisCellObject orgUnitCellObj : orgUnitList) {
                curOrgUnitList.add(orgUnitCellObj);
                if (curOrgUnitList.size() < this.pageSize) continue;
                this.headDataMap.put(ItemAnalysisConstant.orgUnitKey, curOrgUnitList);
                Map analysisDatas = AnalysisReportFactory.getRemoteInstance().getAnalysisDatas(this.paramMap);
                this.dmAnalysisHelper.batchFillDatas(analysisDatas);
                curOrgUnitList.clear();
            }
            orgUnitList = curOrgUnitList;
        }
        if (orgUnitList.size() > 0) {
            this.headDataMap.put(ItemAnalysisConstant.orgUnitKey, orgUnitList);
            Map analysisDatas = AnalysisReportFactory.getRemoteInstance().getAnalysisDatas(this.paramMap);
            this.dmAnalysisHelper.batchFillDatas(analysisDatas);
        }
    }

    private ItemAnalysisCellObject getCellObject(int row, int col) throws Exception {
        CellBlock cellBlock = this.sheet.getMergeBlock(row, col);
        String objectStr = null;
        objectStr = cellBlock == null ? (String)this.sheet.getCell(row, col, true).getUserObjectValue(ItemAnalysisConstant.cellObjKey) : (String)this.sheet.getCell(cellBlock.getRow(), cellBlock.getCol(), true).getUserObjectValue(ItemAnalysisConstant.cellObjKey);
        ItemAnalysisCellObject cellObj = new ItemAnalysisCellObject();
        cellObj.fromSerialString(objectStr);
        return cellObj;
    }

    private void clearCollection() {
        for (List<ItemAnalysisCellObject> list : this.headDataMap.values()) {
            list.clear();
        }
        this.headDataMap.clear();
        this.paramMap.clear();
        this.selectSourceType.clear();
        this.orgChild_parentMap.clear();
        this.headColDatas.clear();
        this.headRowDatas.clear();
    }

    private void initOrgRelationsMap(List<ItemAnalysisCellObject> orgUnitList, boolean isFromManage) {
        for (ItemAnalysisCellObject orgUnit : orgUnitList) {
            if (orgUnit == null || StringUtils.isEmpty((String)orgUnit.getParentKey()) || (!isFromManage || orgUnit.isUnion()) && isFromManage) continue;
            this.orgChild_parentMap.put(orgUnit.getKey(), orgUnit.getParentKey());
        }
    }

    private boolean initHeadMap(CustomerParams filterParams) throws Exception {
        String orgTreeId = filterParams.getCustomerParam("ORG_TREE_ID");
        String orgStrs = filterParams.getCustomerParam("ORGS");
        List<ItemAnalysisCellObject> orgUnitCellObjectList = null;
        List<ManageMergeOrgUnit> manageMergeOrgUnits = ItemAnalysisHepler.getInstance().str2SolutOrg(orgStrs);
        if (manageMergeOrgUnits != null && !manageMergeOrgUnits.isEmpty()) {
            String solutId = filterParams.getCustomerParam("SCHEME_ID");
            OrgTreeInfo orgTreeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select id,number where id='" + orgTreeId + "'");
            FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo("select isSupportGroupReport,isContainUnRecive where id='" + solutId + "'");
            boolean isSupportGroup = soluInfo.isIsSupportGroupReport();
            this.paramMap.put(ItemAnalysisConstant.containUnReceiveKey, soluInfo.isIsContainUnRecive());
            orgUnitCellObjectList = ItemAnalysisHepler.getInstance().getOrgUnitList(manageMergeOrgUnits, this.selectSourceType, orgTreeInfo.getNumber(), solutId, isSupportGroup);
            if (isSupportGroup) {
                this.orgTreeNumber = orgTreeInfo.getNumber();
            }
        } else {
            OrgStructureCollection orgStructureColl = ItemAnalysisHepler.getInstance().getOrgStructureList(orgStrs, orgTreeId);
            if (orgStructureColl == null || orgStructureColl.size() <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"98_orgunitNotInOrgtree"));
                return false;
            }
            this.orgTreeNumber = orgStructureColl.get(0).getTree().getNumber();
            orgUnitCellObjectList = ItemAnalysisHepler.getInstance().getOrgUnitList(orgStructureColl, this.selectSourceType);
            orgStructureColl.clear();
        }
        this.headDataMap.put(ItemAnalysisConstant.orgUnitKey, orgUnitCellObjectList);
        String dataElementStr = filterParams.getCustomerParam("FETCH_TYPE");
        this.headDataMap.put(ItemAnalysisConstant.dataElementKey, ItemAnalysisHepler.getInstance().getDataElementList(dataElementStr));
        int endYear = Integer.parseInt(filterParams.getCustomerParam("END_YEAR"));
        int endPeriod = Integer.parseInt(filterParams.getCustomerParam("END_PERIOD"));
        int startYear = Integer.parseInt(filterParams.getCustomerParam("START_YEAR"));
        int startPeriod = Integer.parseInt(filterParams.getCustomerParam("START_PERIOD"));
        this.headDataMap.put(ItemAnalysisConstant.periodKey, ItemAnalysisHepler.getInstance().getYearPeriodList(startYear, endYear, startPeriod, endPeriod, this.isSumByQuarter, this.isOnlyDisplayQuarter, this.isSupport13Period));
        this.paramMap.put(ItemAnalysisConstant.startYearPeriodKey, startYear + ItemAnalysisConstant.splitStr + startPeriod);
        this.paramMap.put(ItemAnalysisConstant.endYearPeriodKey, endYear + ItemAnalysisConstant.splitStr + endPeriod);
        String itemNumbers = filterParams.getCustomerParam("ITEMS");
        this.headDataMap.put(ItemAnalysisConstant.itemKey, ItemAnalysisHepler.getInstance().getItemList(itemNumbers));
        this.headDataMap.put(ItemAnalysisConstant.AdjustType, ItemAnalysisHepler.getInstance().getAdjustTypeList());
        String dyItems = filterParams.getCustomerParam("DYITEM");
        if (!StringUtils.isEmpty((String)dyItems)) {
            ArrayList<ItemAnalysisCellObject> dyItemList = new ArrayList<ItemAnalysisCellObject>();
            String split1 = ",,";
            String split2 = ";;";
            if (dyItems.indexOf(split1) < 0 && dyItems.indexOf(",") > 0) {
                split1 = ",";
                split2 = ";";
            }
            String[] numberNames = dyItems.split(split1);
            ItemAnalysisCellObject info = null;
            for (String numberName : numberNames) {
                String[] str = numberName.split(split2);
                info = new ItemAnalysisCellObject();
                info.setKey(str[0]);
                info.setDisplayName(str[1]);
                dyItemList.add(info);
            }
            this.headDataMap.put(ItemAnalysisConstant.dyItemKey, dyItemList);
        }
        return true;
    }

    protected void analysisMidTableHandle() throws Exception {
        if (this.initMidTableAnalysisParams(this.guideUIParams, this.filterParams, true)) {
            this.fillMidTableAnalysisDatas(true);
        }
    }

    private boolean initMidTableAnalysisParams(CustomerParams guideUIParams, CustomerParams filterParams, boolean isInitBasePoint) throws Exception {
        String selectCell;
        AreaReference ar;
        CellReference[] cells;
        this.colKeyList = Arrays.asList(guideUIParams.getCustomerParam("colItems").split(ItemAnalysisConstant.splitStr));
        this.rowKeyList = Arrays.asList(guideUIParams.getCustomerParam("rowItems").split(ItemAnalysisConstant.splitStr));
        if (isInitBasePoint && (cells = (ar = new AreaReference(selectCell = guideUIParams.getCustomerParam("startRange"))).getCells()) != null && cells.length > 0) {
            this.basePoint = new Point(cells[0].getCol(), cells[0].getRow());
        }
        this.initMidTableHeadMap(filterParams);
        this.paramMap.putAll(filterParams.getCustomerParamsHashMap());
        ArrayList demensionList = new ArrayList();
        demensionList.addAll(this.rowKeyList);
        demensionList.addAll(this.colKeyList);
        this.paramMap.put("demensionList", demensionList);
        return true;
    }

    private void initMidTableHeadMap(CustomerParams filterParams) throws Exception {
        this.headDataMap.put(ItemAnalysisConstant.orgUnitKey, this.constructureOrgUnitDemension(filterParams));
        this.headDataMap.put(ItemAnalysisConstant.dataElementKey, this.constructureDataElementDemension(filterParams));
        this.headDataMap.put(ItemAnalysisConstant.periodKey, this.constructureDateDemension(filterParams));
    }

    private void fillMidTableAnalysisDatas(boolean needRebuildHead) throws Exception {
        if (!this.paramMap.isEmpty()) {
            this.paramMap.put("needRebuildHead", needRebuildHead);
            Map analysisDatas = AnalysisReportFactory.getRemoteInstance().getMidTabAnalysisDatas(this.paramMap);
            if (needRebuildHead) {
                this.constructureDemensionFromDB(analysisDatas);
                this.constructureRowColHeadData();
                DmAnalysisHelper.getInstance().fillHead(this.headRowDatas, this.headColDatas, this.sheet, this.basePoint);
                this.saveBasePoint();
            }
            DmAnalysisHelper.getInstance().fillData(this.sheet, this.basePoint, analysisDatas);
        }
    }

    private void constructureRowColHeadData() {
        this.initRowColHeadData(this.headColDatas, this.colKeyList);
        this.initRowColHeadData(this.headRowDatas, this.rowKeyList);
    }

    private void constructureDemensionFromDB(Map analysisDatas) {
        this.fillBackHeadDataMap(analysisDatas, this.rowKeyList);
        this.fillBackHeadDataMap(analysisDatas, this.colKeyList);
    }

    private void fillBackHeadDataMap(Map analysisDatas, List demensions) {
        for (Object demension : demensions) {
            if (!analysisDatas.containsKey(demension) || analysisDatas.get(demension) == null) continue;
            this.headDataMap.put(demension.toString(), (List)analysisDatas.get(demension));
            analysisDatas.remove(demension);
        }
    }

    private List<ItemAnalysisCellObject> constructureOrgUnitDemension(CustomerParams filterParams) throws BOSException {
        String companyNums = filterParams.getCustomerParam("companyNum");
        companyNums = CslRptUtil.list2String(Arrays.asList(companyNums.split(";")), (String)",", (boolean)true);
        OrgUnitCollection orgColl = FullOrgUnitFactory.getRemoteInstance().getOrgUnitCollection("select name,number where number in(" + companyNums + ") order by number");
        if (orgColl == null || orgColl.size() == 0) {
            return new ArrayList<ItemAnalysisCellObject>(0);
        }
        ArrayList<ItemAnalysisCellObject> orgCellObjList = new ArrayList<ItemAnalysisCellObject>(orgColl.size());
        int size = orgColl.size();
        for (int i = 0; i < size; ++i) {
            ItemAnalysisCellObject itemCell = new ItemAnalysisCellObject(orgColl.get(i).getNumber(), orgColl.get(i).getName(), 99);
            orgCellObjList.add(itemCell);
        }
        return orgCellObjList;
    }

    private List<ItemAnalysisCellObject> constructureDataElementDemension(CustomerParams filterParams) {
        String dataElement = filterParams.getCustomerParam("dataElement");
        DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((String)dataElement);
        return this.toCellObjectList(new ItemAnalysisCellObject(dataElementInfo.getNumber(), dataElementInfo.getName()));
    }

    private List<ItemAnalysisCellObject> constructureAsstTypeDemension(CustomerParams filterParams) throws Exception {
        String asstType = filterParams.getCustomerParam("asstType");
        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(null);
        translator.translate(asstType, null);
        ArrayList<ItemAnalysisCellObject> orgCellObjList = new ArrayList<ItemAnalysisCellObject>();
        int asstIndex = 1;
        while (translator.hasNext()) {
            AsstItemInfo itemInfo = (AsstItemInfo)translator.next();
            orgCellObjList.add(new ItemAnalysisCellObject("asstType" + asstIndex, itemInfo.getAsstType().getName()));
        }
        return orgCellObjList;
    }

    private List<ItemAnalysisCellObject> constructureAccountViewDemension(CustomerParams filterParams) {
        return this.toCellObjectList(new ItemAnalysisCellObject("account", EASResource.getString((String)AbstractMidTableAnalysisFilterUI.class.getName(), (String)"lblAccountView.boundLabelText"), 99));
    }

    private List<ItemAnalysisCellObject> constructureDateDemension(CustomerParams filterParams) {
        ArrayList<ItemAnalysisCellObject> cellObjList = new ArrayList<ItemAnalysisCellObject>();
        String startDateStr = filterParams.getCustomerParam("startDate");
        String endDateStr = filterParams.getCustomerParam("endDate");
        Date startDate = RPTDateUtil.stringToDate((String)startDateStr, (String)"yyyy-MM-dd");
        Date endDate = RPTDateUtil.stringToDate((String)endDateStr, (String)"yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        while (endDate.compareTo(startDate) >= 0) {
            String formatDate = RPTDateUtil.formateDate((Date)c.getTime(), (String)"yyyy-MM-dd");
            ItemAnalysisCellObject itemObj = new ItemAnalysisCellObject(formatDate, formatDate, 99);
            cellObjList.add(itemObj);
            c.add(5, 1);
            startDate = c.getTime();
        }
        return cellObjList;
    }

    private List<ItemAnalysisCellObject> toCellObjectList(ItemAnalysisCellObject ... cellObjs) {
        return Arrays.asList(cellObjs);
    }
}

