/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.client.report.AbstractMidTableAnalysisFilterUI;
import com.kingdee.eas.fi.newrpt.client.report.IRefleshListener;
import com.kingdee.eas.fi.newrpt.client.report.MidTableAcctItemSelectorAnalysisUI;
import com.kingdee.eas.fi.newrpt.client.report.MidTableAsstItemSelectorUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.batch.iref.AcctItemAsstTranslator;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemTypeCache;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import com.kingdee.eas.fi.rpt.client.IItemObject;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MidTableAnalysisFilterUI
extends AbstractMidTableAnalysisFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MidTableAnalysisFilterUI.class);
    private Sheet sheet = null;
    private CustomerParams customerParams = null;
    private boolean isDynamicAnalysis = false;
    private boolean isLoaded = false;
    private IRefleshListener refreshListener;
    private String preAsstType;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIComponent();
        this.isLoaded = true;
    }

    private void initUIComponent() throws Exception {
        this.cmbOrgType.addItems((Object[])new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.PROFITCENTER});
        this.cmbOrgType.setEnabled(false);
        NewCompanyF7 f7Selector = CompanyF7Helper.getCommonCompanyF7ByOrgType((IUIObject)this);
        f7Selector.setMultiSelect(false);
        this.f7Company.setSelector((KDPromptSelector)f7Selector);
        this.f7Company.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((NewCompanyF7)MidTableAnalysisFilterUI.this.f7Company.getSelector()).getComboTypeSelectedItem() != null) {
                    MidTableAnalysisFilterUI.this.cmbOrgType.setSelectedItem((Object)((NewCompanyF7)MidTableAnalysisFilterUI.this.f7Company.getSelector()).getComboTypeSelectedItem());
                }
                MidTableAnalysisFilterUI.this.loadAsstTypeData();
            }
        });
        this.cmbCurrency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC()));
        this.f7DataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.f7DataElement.setCommitFormat("$number$");
        this.f7DataElement.setDisplayFormat("$name$");
        this.f7DataElement.setEditFormat("$number$");
        this.cmbValueType.addItems((Object[])new ValueTypeEnum[]{ValueTypeEnum.MONEY, ValueTypeEnum.TXT});
        this.cmbValueType.setEnabled(false);
        this.f7AccountView.setSelector((KDPromptSelector)new MidTableAcctItemSelectorAnalysisUI());
        this.f7AccountView.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ((MidTableAcctItemSelectorAnalysisUI)MidTableAnalysisFilterUI.this.f7AccountView.getSelector()).setCompanyOrgUnitInfo(MidTableAnalysisFilterUI.this.getFIOrgUnitInfo());
                ((MidTableAcctItemSelectorAnalysisUI)MidTableAnalysisFilterUI.this.f7AccountView.getSelector()).setF7Value(MidTableAnalysisFilterUI.this.f7AccountView.getValue());
            }
        });
        this.startDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MidTableAnalysisFilterUI.this.fireDateChangeListener(eventObj);
            }
        });
        this.endDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MidTableAnalysisFilterUI.this.fireDateChangeListener(eventObj);
            }
        });
        this.cmbAsstType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MidTableAnalysisFilterUI.this.f7AsstItem.setValue(null);
                    if (MidTableAnalysisFilterUI.this.refreshListener != null) {
                        String asstType = ((IItemObject)MidTableAnalysisFilterUI.this.cmbAsstType.getSelectedItem()).getNumber();
                        if (StringUtils.isEmpty((String)asstType) || asstType.equals(MidTableAnalysisFilterUI.this.preAsstType)) {
                            return;
                        }
                        MidTableAnalysisFilterUI.this.preAsstType = asstType;
                        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(null);
                        try {
                            translator.translate(asstType, null);
                        }
                        catch (Exception e1) {
                            MidTableAnalysisFilterUI.this.handUIException(e1);
                        }
                        MidTableAnalysisFilterUI.this.refreshListener.reflesh((ITranslator)translator);
                    }
                }
            }
        });
        this.f7AsstItem.setSelector((KDPromptSelector)new MidTableAsstItemSelectorUI());
        this.f7AsstItem.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MidTableAsstItemSelectorUI selector = (MidTableAsstItemSelectorUI)MidTableAnalysisFilterUI.this.f7AsstItem.getSelector();
                selector.setCompanyOrgUnitInfo(MidTableAnalysisFilterUI.this.getFIOrgUnitInfo());
                selector.setF7Value(MidTableAnalysisFilterUI.this.f7AsstItem.getValue());
                selector.setAsstItemTypeVal(MidTableAnalysisFilterUI.this.getAsstItemType());
            }
        });
    }

    private void fireDateChangeListener(DataChangeEvent eventObj) {
        Object old = eventObj.getOldValue();
        Object newV = eventObj.getNewValue();
        if (old == null && newV == null || newV == null || newV != null && old != null && newV.equals(old)) {
            return;
        }
        this.loadAsstTypeData();
    }

    private void loadAsstTypeData() {
        if (!this.isLoaded) {
            return;
        }
        try {
            List items = AsstItemTypeCache.getInstance().getAsstItemTypeList(this.generateCacheKey());
            if (items != null && items.size() > 0) {
                this.cmbAsstType.removeAllItems();
                this.cmbAsstType.addItems(items.toArray());
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_HappenErrorBecauseGetAsstType"), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    private String getAsstItemType() {
        Object obj = this.cmbAsstType.getSelectedItem();
        if (obj != null) {
            return ((IItemObject)obj).getNumber();
        }
        return null;
    }

    private CompanyOrgUnitInfo getFIOrgUnitInfo() {
        if (this.f7Company.getValue() == null) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        try {
            return MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)this.f7Company.getValue(), null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.handUIException(e);
            return null;
        }
    }

    private String getOrgUnitNum() {
        if (this.f7Company.getValue() == null) {
            return SysContext.getSysContext().getCurrentOrgUnit().getNumber();
        }
        return ((OrgUnitInfo)this.f7Company.getValue()).getNumber();
    }

    private AsstItemTypeCache.CacheKey generateCacheKey() {
        return new AsstItemTypeCache.CacheKey((Date)this.startDate.getValue(), (Date)this.endDate.getValue(), this.getOrgUnitNum(), OrgType.getEnum((int)((OrgViewType)this.cmbOrgType.getSelectedItem()).getValue()));
    }

    public boolean verify() {
        if (this.f7Company.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"51_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.f7DataElement.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"53_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.cmbCurrency.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"54_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.cmbValueType.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"55_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.startDate.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"581_OneTime"));
            return false;
        }
        if (this.endDate.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"368_CslRptArchiveUI"));
            return false;
        }
        if (this.f7AccountView.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_AcctIsNull"));
            return false;
        }
        if (this.cmbAsstType.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_AsstTypeCantBeNull"));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = super.getCustomerParams();
        params.addCustomerParam("companyNum", this.getOrgUnitNum());
        params.addCustomerParam("currencyNum", this.getCurrencyNum());
        params.addCustomerParam("startDate", RPTDateUtil.formateDate((Date)((Date)this.startDate.getValue()), (String)"yyyy-MM-dd"));
        params.addCustomerParam("endDate", RPTDateUtil.formateDate((Date)((Date)this.endDate.getValue()), (String)"yyyy-MM-dd"));
        params.addCustomerParam("dataElement", this.getDataElementNum());
        params.addCustomerParam("valueType", "" + ((ValueTypeEnum)this.cmbValueType.getSelectedItem()).getValue());
        params.addCustomerParam("account", this.f7AccountView.getText());
        params.addCustomerParam("asstType", this.getAsstType());
        params.addCustomerParam("asstItems", this.f7AsstItem.getText());
        params.addCustomerParam("orgType", "" + ((OrgViewType)this.cmbOrgType.getSelectedItem()).getValue());
        params.addCustomerParam("isMidTableAnalysis", Boolean.TRUE.toString());
        return params;
    }

    public void setCustomerParams(CustomerParams params) {
        super.setCustomerParams(params);
        this.initUI(params);
    }

    public void clear() {
        super.clear();
        this.f7AccountView.setData(null);
        this.f7AsstItem.setData(null);
        this.f7DataElement.setData(null);
        if (this.customerParams != null) {
            this.setCustomerParams(this.customerParams);
        }
    }

    private void initUI(CustomerParams params) {
        String paramVal = params.getCustomerParam("companyNum");
        if (this.isNotNull(paramVal)) {
            try {
                this.f7Company.setValue((Object)FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select id,number,name where number ='" + paramVal + "'"));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("currencyNum"))) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.cmbCurrency.getItemAt(i)).getNumber().equals(paramVal)) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("startDate"))) {
            this.startDate.setValue((Object)RPTDateUtil.stringToDate((String)paramVal, (String)"yyyy-MM-dd"));
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("endDate"))) {
            this.endDate.setValue((Object)RPTDateUtil.stringToDate((String)paramVal, (String)"yyyy-MM-dd"));
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("dataElement"))) {
            this.f7DataElement.setValue((Object)DataElementProvider.getDataElementInfo((String)paramVal));
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("valueType"))) {
            this.cmbValueType.setSelectedItem((Object)ValueTypeEnum.getEnum((int)Integer.parseInt(paramVal)));
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("account"))) {
            this.f7AccountView.setValue((Object)paramVal);
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("asstType"))) {
            for (int i = 0; i < this.cmbAsstType.getItemCount(); ++i) {
                if (!paramVal.equals(((IItemObject)this.cmbAsstType.getItemAt(i)).getNumber())) continue;
                this.cmbAsstType.setSelectedIndex(i);
                break;
            }
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("asstItems"))) {
            this.f7AsstItem.setValue((Object)paramVal);
        }
        if (this.isNotNull(paramVal = params.getCustomerParam("orgType"))) {
            this.cmbOrgType.setSelectedItem((Object)OrgViewType.getEnum((int)Integer.parseInt(paramVal)));
        }
    }

    private boolean isNotNull(String paramVal) {
        return !StringUtils.isEmpty((String)paramVal);
    }

    private String getCurrencyNum() {
        Object obj = this.cmbCurrency.getSelectedItem();
        return this.getNumOfValue(obj);
    }

    private String getDataElementNum() {
        Object obj = this.f7DataElement.getValue();
        return this.getNumOfValue(obj);
    }

    private String getAsstType() {
        Object obj = this.cmbAsstType.getSelectedItem();
        if (obj == null) {
            return null;
        }
        return ((IItemObject)obj).getNumber();
    }

    private String getNumOfValue(Object obj) {
        if (obj == null) {
            return null;
        }
        return ((IObjectValue)obj).getString("number");
    }

    public String getPanelName() {
        return this.getUITitle();
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setInitCustomerParams(CustomerParams params) {
        this.customerParams = params;
    }

    public boolean isDynamicAnalysis() {
        return this.isDynamicAnalysis;
    }

    public void setDynamicAnalysis(boolean isDynamicAnalysis) {
        this.isDynamicAnalysis = isDynamicAnalysis;
    }

    public void setRefreshListener(IRefleshListener refreshListener) {
        this.refreshListener = refreshListener;
    }
}

