/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.report;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.AnalysisOrgUnitCollection;
import com.kingdee.eas.fi.newrpt.AnalysisOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.AnalysisSolutionForBmkFactory;
import com.kingdee.eas.fi.newrpt.AnalysisSolutionForBmkInfo;
import com.kingdee.eas.fi.newrpt.BenchmarkingOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.IndustryInfo;
import com.kingdee.eas.fi.newrpt.IndustryOrgUnitMappingCollection;
import com.kingdee.eas.fi.newrpt.IndustryOrgUnitMappingFactory;
import com.kingdee.eas.fi.newrpt.IndustryRangeEnum;
import com.kingdee.eas.fi.newrpt.client.report.AbstractOrgUnitBenhmarkingEditUI;
import com.kingdee.eas.fi.newrpt.util.AnalysisRptNewUtil;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgUnitBenhmarkingEditUI
extends AbstractOrgUnitBenhmarkingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitBenhmarkingEditUI.class);
    private MnsUnionF7 f7 = null;
    private List<FullOrgUnitInfo> simpleOrgUnits = new ArrayList<FullOrgUnitInfo>();
    private List<FullOrgUnitInfo> complexOrgUnits = new ArrayList<FullOrgUnitInfo>();
    private String simpleOrgTreeNumber = null;
    private String complexOrgTreeNumber = null;
    Set selectOrgIdSet = new HashSet();

    public void onLoad() throws Exception {
        super.onLoad();
        this.bhmkOrgUnit.setCommitFormat("$name$");
        this.bhmkOrgUnit.setDisplayFormat("$name$");
        this.bhmkOrgUnit.setEditFormat("$name$");
        this.bhmkOrgUnit.setEditable(false);
        this.prmtIndustry.setEditFormat("$name$");
        this.prmtIndustry.setDisplayFormat("$name$");
        if (this.f7 == null) {
            this.f7 = new MnsUnionF7((IUIObject)this);
            this.f7.setShowAssistantOrg(true);
            this.f7.setCheckedAssistantOrgChkBox(true);
            this.f7.setEnableCurOrgTreeRootNode(true);
            this.f7.setMultiSelect(true);
            this.f7.setSelectMode(3);
            this.f7.setCascadingSelection(false);
            this.f7.setCheckedOrgIDs(this.selectOrgIdSet);
            this.f7.setUnChangeableOrgIDs(this.selectOrgIdSet);
            OrgTreeCollection orgTreeColl = CslRptUIUtil.getOrgTreeCollection((Date)Calendar.getInstance().getTime());
            this.f7.setCurrOrgTree(orgTreeColl.get(0));
            this.f7.setOrgTreeColl(orgTreeColl);
        }
        this.analysisOrgUnit.setSelector((KDPromptSelector)this.f7);
        this.analysisOrgUnit.setEditable(false);
        this.btnAdd.setEnabled(true);
        this.analysisOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (OrgUnitBenhmarkingEditUI.this.analysisOrgUnit.getValue() != null) {
                    if (OrgUnitBenhmarkingEditUI.this.analysisOrgUnit.getValue() instanceof Object[]) {
                        OrgUnitBenhmarkingEditUI.this.simpleOrgUnits.clear();
                        try {
                            OrgUnitBenhmarkingEditUI.this.putListToOrgUnitList((List<FullOrgUnitInfo>)OrgUnitBenhmarkingEditUI.this.simpleOrgUnits, OrgUnitBenhmarkingEditUI.this.getFullOrgUnitColl((Object[])OrgUnitBenhmarkingEditUI.this.analysisOrgUnit.getValue()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        OrgUnitBenhmarkingEditUI.this.analysisOrgUnit.setData((Object)AnalysisRptNewUtil.getDisplayAnalysisOrg(OrgUnitBenhmarkingEditUI.this.simpleOrgUnits, OrgUnitBenhmarkingEditUI.this.complexOrgUnits));
                        OrgUnitBenhmarkingEditUI.this.setIndustry();
                        OrgUnitBenhmarkingEditUI.this.simpleOrgTreeNumber = OrgUnitBenhmarkingEditUI.this.f7.getSelectedTree().getNumber();
                    }
                } else {
                    OrgUnitBenhmarkingEditUI.this.simpleOrgUnits.clear();
                    OrgUnitBenhmarkingEditUI.this.complexOrgUnits.clear();
                    OrgUnitBenhmarkingEditUI.this.simpleOrgTreeNumber = null;
                    OrgUnitBenhmarkingEditUI.this.complexOrgTreeNumber = null;
                }
                OrgUnitBenhmarkingEditUI.this.selectOrgIdSet.clear();
            }
        });
        if (this.editData.getId() != null) {
            ArrayList<String> solutionIds = new ArrayList<String>();
            solutionIds.add(this.editData.getId().toString());
            Map<String, List<AnalysisOrgUnitInfo>[]> solutionOrgs = AnalysisRptNewUtil.getSolutionAnalysisOrgUnitMap(solutionIds);
            if (solutionOrgs != null) {
                List<AnalysisOrgUnitInfo>[] solutionOrgList = solutionOrgs.get(this.editData.getId().toString());
                if (solutionOrgList[0] != null && solutionOrgList[0].size() > 0 && solutionOrgList[0].get(0) != null) {
                    this.simpleOrgTreeNumber = solutionOrgList[0].get(0).getOrgTreeNumber();
                }
                if (solutionOrgList[0] != null && solutionOrgList[0].size() > 1 && solutionOrgList[0].get(1) != null) {
                    this.complexOrgTreeNumber = solutionOrgList[0].get(1).getOrgTreeNumber();
                }
                this.putListToOrgUnitList(this.simpleOrgUnits, solutionOrgList[0]);
                this.putListToOrgUnitList(this.complexOrgUnits, solutionOrgList[1]);
                this.analysisOrgUnit.setData((Object)AnalysisRptNewUtil.getDisplayAnalysisOrg(this.simpleOrgUnits, this.complexOrgUnits));
            }
        }
        this.bhmkOrgUnit.setHistoryRecordEnabled(false);
        this.analysisOrgUnit.setHistoryRecordEnabled(false);
        this.prmtIndustry.setHistoryRecordEnabled(false);
    }

    private void setIndustry() {
        FullOrgUnitInfo orgUnit = null;
        if (!this.simpleOrgUnits.isEmpty()) {
            orgUnit = this.simpleOrgUnits.get(0);
        }
        if (orgUnit == null && !this.complexOrgUnits.isEmpty()) {
            orgUnit = this.complexOrgUnits.get(0);
        }
        if (orgUnit != null) {
            try {
                IndustryOrgUnitMappingCollection coll = IndustryOrgUnitMappingFactory.getRemoteInstance().getIndustryOrgUnitMappingCollection("select industryRange,industry.number,industry.name,industry.id where orgUnit.id='" + orgUnit.getId().toString() + "'");
                if (coll != null && !coll.isEmpty()) {
                    this.comboIndustryRange.setSelectedItem((Object)coll.get(0).getIndustryRange());
                    this.prmtIndustry.setData((Object)coll.get(0).getIndustry());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        AnalysisOrgUnitCollection sampleOrgUnitColl;
        if (this.editData == null) {
            this.editData = new AnalysisSolutionForBmkInfo();
        }
        this.editData.setName(this.txtName.getText());
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setIndustry((IndustryInfo)this.prmtIndustry.getData());
        if (this.bhmkOrgUnit.getData() instanceof Object[]) {
            this.editData.setBenhmarkingOrgUnit(this.getDisplayBenhmarkingOrg((Object[])this.bhmkOrgUnit.getData()));
        } else {
            this.editData.setBenhmarkingOrgUnit((String)this.bhmkOrgUnit.getData());
        }
        this.editData.setIndustryRange((IndustryRangeEnum)((Object)this.comboIndustryRange.getSelectedItem()));
        this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit().castToFullOrgUnitInfo());
        this.editData.setAnalysisOrgUnitStr((String)this.analysisOrgUnit.getData());
        AnalysisOrgUnitInfo info = null;
        if (!this.simpleOrgUnits.isEmpty()) {
            sampleOrgUnitColl = new AnalysisOrgUnitCollection();
            for (FullOrgUnitInfo org : this.simpleOrgUnits) {
                info = new AnalysisOrgUnitInfo();
                info.setOrgUnit(org);
                info.setOrgUnitType(1);
                info.setOrgTreeNumber(this.simpleOrgTreeNumber);
                sampleOrgUnitColl.add(info);
            }
            this.editData.put("sampleOrgUnits", (Object)sampleOrgUnitColl);
        }
        if (!this.complexOrgUnits.isEmpty()) {
            sampleOrgUnitColl = new AnalysisOrgUnitCollection();
            for (FullOrgUnitInfo org : this.complexOrgUnits) {
                info = new AnalysisOrgUnitInfo();
                info.setOrgUnit(org);
                info.setOrgUnitType(2);
                info.setOrgTreeNumber(this.complexOrgTreeNumber);
                sampleOrgUnitColl.add(info);
            }
            this.editData.put("complexOrgUnits", (Object)sampleOrgUnitColl);
        }
        return super.runSubmit();
    }

    private String getDisplayBenhmarkingOrg(Object[] datas) {
        StringBuffer sb = new StringBuffer();
        for (Object obj : datas) {
            sb.append(((BenchmarkingOrgUnitInfo)obj).getName()).append(";");
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected IObjectValue createNewData() {
        return new AnalysisSolutionForBmkInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisSolutionForBmkFactory.getRemoteInstance();
    }

    @Override
    public void actionAddComplexCompany_actionPerformed(ActionEvent e) throws Exception {
        this.f7.show();
        if (!this.f7.isCanceled()) {
            this.complexOrgUnits.clear();
            this.putListToOrgUnitList(this.complexOrgUnits, this.getFullOrgUnitColl((Object[])this.f7.getData()));
            this.complexOrgTreeNumber = this.f7.getSelectedTree().getNumber();
            this.analysisOrgUnit.setData((Object)AnalysisRptNewUtil.getDisplayAnalysisOrg(this.simpleOrgUnits, this.complexOrgUnits));
            this.selectOrgIdSet.clear();
            this.setIndustry();
        }
    }

    private FullOrgUnitCollection getFullOrgUnitColl(Object[] orgUnits) throws Exception {
        StringBuffer ids = new StringBuffer();
        for (Object obj : orgUnits) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(((FullOrgUnitInfo)obj).getId().toString()).append("'");
        }
        return FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,simpleName,number,isGrouping where id in(" + ids + ")");
    }

    private void putListToOrgUnitList(List<FullOrgUnitInfo> targList, FullOrgUnitCollection srcArr) {
        for (int i = 0; i < srcArr.size(); ++i) {
            targList.add(srcArr.get(i));
        }
    }

    private void putListToOrgUnitList(List<FullOrgUnitInfo> targList, List<AnalysisOrgUnitInfo> srcArr) {
        if (srcArr != null) {
            for (int i = 0; i < srcArr.size(); ++i) {
                targList.add(srcArr.get(i).getOrgUnit());
            }
        }
    }
}

