/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataCatcherListener;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.CommitAndDispenseUtils;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIConstant;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractAdjustWorktableUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.CopyHisDataWorkTableUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.OrgTreeBuilder;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractRptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class AdjustWorktableUI
extends AbstractAdjustWorktableUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustWorktableUI.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String reSourceClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private KDTreeNode treeNodeRoot = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"AdjustWorkTable_rootNodeName"));
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IAdjustMode iAdjustMode = null;
    private OrgTreeBuilder builder;
    private OrgUnitInfo tblMainSelectOrgUnit = null;
    private Set orgBoundIDSet = null;
    private OrgTreeCollection orgTreeColl = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private boolean isFirstInitOrgBound = true;

    public void actionQuery_actionPerformed(ActionEvent e) {
    }

    protected void initOrgTreeListener() {
        this.OrgTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                try {
                    AdjustWorktableUI.this.synchroUnitInfo2Context();
                    AdjustWorktableUI.this.initOrgBound((Date)AdjustWorktableUI.this.dpDate.getValue());
                    AdjustWorktableUI.this.refreshList();
                }
                catch (Exception e) {
                    AdjustWorktableUI.this.handUIException(e);
                }
                AdjustWorktableUI.this.existDyItemEntries = null;
                new Thread(){

                    @Override
                    public void run() {
                        AdjustWorktableUI.this.initExistDyItemEntries();
                    }
                }.start();
            }
        });
    }

    private void initOrgBoundListener() {
        this.cmbOrgBound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AdjustWorktableUI.this.initCSLContext();
                OrgTreeInfo orgBound = null;
                try {
                    IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
                    orgBound = AdjustWorktableUI.this.getCSLContext().getCurOrgBound();
                    if (orgBound != null) {
                        if ((orgBound = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgBound.getId().toString()))).isIsForBudget()) {
                            AdjustWorktableUI.this.actionImportForBudget.setEnabled(true);
                            AdjustWorktableUI.this.setImportAndSynOperatePorperty(false);
                        } else {
                            AdjustWorktableUI.this.actionImportForBudget.setEnabled(false);
                            AdjustWorktableUI.this.setImportAndSynOperatePorperty(true);
                        }
                    } else {
                        AdjustWorktableUI.this.actionImportForBudget.setEnabled(false);
                        AdjustWorktableUI.this.setImportAndSynOperatePorperty(false);
                    }
                    AdjustWorktableUI.this.refreshList();
                }
                catch (Exception e1) {
                    logger.error((Object)"initOrgBoundListener", (Throwable)e1);
                }
            }
        });
    }

    private void synchroUnitInfo2Context() throws Exception {
        OrgUnitInfo orgUnitInfo = this.getSelectNodeOrgUnitInfo(null);
        this.getWktbContext().setOrgUnitInfo(orgUnitInfo);
    }

    private OrgUnitInfo getSelectNodeOrgUnitInfo(KDTreeNode node) throws Exception {
        if (!this.isLoaded) {
            return this.getWktbContext().getOrgUnitInfo();
        }
        KDTreeNode copy = this.getOrgNode(node);
        if (copy == null) {
            return null;
        }
        return ((OrgNodeUserDefineInfo)copy.getUserObject()).getOrgUnitInfo();
    }

    private KDTreeNode getOrgNode(KDTreeNode node) {
        KDTreeNode copy = node;
        if (node == null && this.builder != null) {
            copy = this.builder.getSelectedTreeNode();
        }
        while (!(copy == null || copy != null && copy.getUserObject() instanceof OrgNodeUserDefineInfo)) {
            copy = (KDTreeNode)copy.getParent();
        }
        return copy;
    }

    protected void initHeadControl() throws Exception {
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.setImportAndSynOperatePorperty(false);
        this.initOrgTree();
        this.initSelfListener();
        this.refreshList();
    }

    private void initSelfListener() {
        this.cmbPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AdjustWorktableUI.this.cmbPeriodType.getSelectedIndex() <= 1) {
                    AdjustWorktableUI.this.spCurYear.setEnabled(false);
                    AdjustWorktableUI.this.spCurPeriod.setEnabled(false);
                    AdjustWorktableUI.this.dpDate.setEnabled(true);
                    AdjustWorktableUI.this.dpDate.setRequired(true);
                } else {
                    AdjustWorktableUI.this.spCurYear.setEnabled(true);
                    AdjustWorktableUI.this.spCurPeriod.setEnabled(true);
                    AdjustWorktableUI.this.spCurYear.setRequired(true);
                    AdjustWorktableUI.this.spCurPeriod.setRequired(true);
                    AdjustWorktableUI.this.dpDate.setEnabled(false);
                }
                AdjustWorktableUI.this.setSpinnerMinMaxVal();
            }
        });
        this.spCurYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdjustWorktableUI.this.initDatePick(false);
            }
        });
        this.spCurPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdjustWorktableUI.this.initDatePick(false);
            }
        });
        this.dpDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AdjustWorktableUI.this.initSpinnerVal(false);
            }
        });
        this.initOrgBoundListener();
    }

    private void initDatePick(boolean fireListener) {
        int period = this.spCurPeriod.getIntegerVlaue();
        this.dpDate.setValue((Object)RPTDateUtil.getPeriodLastDate((int)this.spCurYear.getIntegerVlaue(), (int)period, (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())), fireListener);
        try {
            this.initOrgBound((Date)this.dpDate.getValue());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void initSpinnerVal(boolean fireListener) {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        Date date = (Date)this.dpDate.getValue();
        int[] yearperiod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)periodTypeEnum);
        this.spCurYear.setValue((Object)yearperiod[0], fireListener);
        this.spCurPeriod.setValue((Object)yearperiod[1], fireListener);
        try {
            this.initOrgBound((Date)this.dpDate.getValue());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void setSpinnerMinMaxVal() {
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.spCurPeriod, (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem(), this.spCurYear.getIntegerVlaue(), true, true);
        this.initSpinnerVal(false);
        this.initDatePick(false);
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    protected void initOrgTree() throws Exception {
        this.builder = new OrgTreeBuilder(this.OrgTree, this.treeNodeRoot, this.getWktbContext().getMapOfOrgTreeBuilder(false));
        this.builder.initOrgTree();
        if (this.builder.getOrgIDSets() == null || this.builder.getOrgIDSets().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(RptNewUIConstant.getResource("NoAnyPermisionInOrg"), SysContext.getSysContext().getUserName()));
            this.abort();
        }
        this.getBizUnitOrgNodeMap(this.builder);
        this.builder.buildOrgTree();
        this.builder.selectedOrgNodeByGivenCompany();
        this.OrgTree.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }

    private void getBizUnitOrgNodeMap(OrgTreeBuilder builder) throws BOSException {
        Map<String, OrgNodeUserDefineInfo> OrgNodeMap = builder.getOrgNodeMap();
        ArrayList<String> IDList = new ArrayList<String>();
        for (Map.Entry<String, OrgNodeUserDefineInfo> entry : OrgNodeMap.entrySet()) {
            IDList.add(entry.getKey());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        HashSet IDSet = new HashSet(IDList);
        filter.getFilterItems().add(new FilterItemInfo("id", IDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selector);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        ArrayList<String> newIDList = new ArrayList<String>();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            newIDList.add(companyOrgUnitCollection.get(i).getId().toString());
        }
        ArrayList oldIDList = new ArrayList(IDList);
        oldIDList.removeAll(newIDList);
        if (oldIDList != null && !oldIDList.isEmpty()) {
            for (Object value : oldIDList) {
                OrgNodeMap.remove(value);
            }
            builder.setOrgNodeMap(OrgNodeMap);
        }
    }

    public MetaDataPK initQueryBudget() {
        return (MetaDataPK)this.mainQueryPK;
    }

    private void init() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cmbPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.cmbPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        String Date2 = this.sdf.format(CslRptUIUtil.getLastPeriodDate(null));
        this.dpDate.setValue((Object)this.sdf.parse(Date2), false);
        this.dpDate.setSupportedEmpty(false);
        CslRptUIUtil.setSpineRange((KDSpinner)this.spCurYear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        int[] yearPeriod = RPTDateUtil.getPeriod((Date)((Date)this.dpDate.getValue()), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()));
        this.spCurYear.setValue((Object)yearPeriod[0], false);
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.spCurPeriod, (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem(), this.spCurYear.getIntegerVlaue(), true, true);
        this.spCurPeriod.setValue((Object)yearPeriod[1], false);
        this.cmbCurrency.addItem((Object)this.selectAll);
        this.cmbCurrency.setSelectedIndex(0);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = this.getCurrencyCollection();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cmbCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.cmbAdjustMode.addItem((Object)this.selectAll);
        this.cmbAdjustMode.setSelectedIndex(0);
        AdjustModeCollection adjustModeCollection = this.getAdjustModeCollection();
        if (adjustModeCollection != null && adjustModeCollection.size() > 0) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.cmbAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
        }
        this.cmbAuditedStatus.addItem((Object)this.selectAll);
        this.cmbAuditedStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter(this.bizPrmtItemFrom, null);
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter(this.bizPrmtItemTo, null);
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitFrom.setRemoveingZeroInDispaly(false);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtDebitTo.setRemoveingZeroInDispaly(false);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditFrom.setRemoveingZeroInDispaly(false);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtCreditTo.setRemoveingZeroInDispaly(false);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setSupportedEmpty(true);
    }

    private void initOrgBound(Date date) throws BOSException, EASBizException {
        if (this.treeNodeRoot.getChildCount() == 0) {
            this.cmbOrgBound.removeAllItems();
            return;
        }
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)date);
        if (otc == null) {
            return;
        }
        ArrayList<String> orgTreeIDList = new ArrayList<String>();
        OrgTreeInfo info = null;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo currentOrgUnitInfo = this.getWktbContext().getOrgUnitInfo();
        ArrayList<Object> orgUnitList = new ArrayList<IObjectPK>();
        if (currentOrgUnitInfo != null) {
            orgUnitList.add(CslRptUtil.getPK((IObjectValue)currentOrgUnitInfo));
        } else {
            orgUnitList = new ArrayList<String>(this.builder.getOrgIDSets());
        }
        block0: for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (info.isIsHide() || info.getLayerType() == OrgViewType.PROFITCENTER || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
            Map fullOrgUnitIDmap = PermissionFactory.getRemoteInstance().getUnionUnits(CslRptUtil.getPK((IObjectValue)user), CslRptUtil.getPK((IObjectValue)info));
            FullOrgUnitCollection fullOrgUnitInfoCollection = this.getOrgUnitByTreeAndUnit(orgUnitList, info.getId().toString());
            if (fullOrgUnitInfoCollection == null) continue;
            for (int j = 0; j < fullOrgUnitInfoCollection.size(); ++j) {
                if (!fullOrgUnitIDmap.containsKey(fullOrgUnitInfoCollection.get(j).getId().toString())) continue;
                orgTreeIDList.add(info.getId().toString());
                continue block0;
            }
        }
        this.cmbOrgBound.removeAllItems();
        if (!orgTreeIDList.isEmpty()) {
            this.orgTreeColl = this.getOrgTreeCollectionByCompanyPK(orgUnitList, orgTreeIDList);
            if (this.orgTreeColl != null && this.orgTreeColl.size() != 0) {
                OrgTreeInfo nullInfo = new OrgTreeInfo();
                this.cmbOrgBound.addItem((Object)nullInfo);
                this.cmbOrgBound.setSelectedItem((Object)nullInfo);
                this.orgBoundIDSet = new HashSet();
                for (int i = 0; i < this.orgTreeColl.size(); ++i) {
                    this.orgBoundIDSet.add(this.orgTreeColl.get(i).getId().toString());
                }
                this.cmbOrgBound.addItems(this.orgTreeColl.toArray());
            }
        }
        if (this.cmbOrgBound.getItemCount() == 2) {
            this.cmbOrgBound.setSelectedIndex(1);
        }
        if (this.isFirstInitOrgBound) {
            this.initCSLContext();
        }
        this.isFirstInitOrgBound = false;
    }

    protected void initWorkButton2() {
        this.btnLocate.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.pmptOrgUnit.setEditable(false);
        this.btnQueryData.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    private FullOrgUnitCollection getOrgUnitByTreeAndUnit(ArrayList orgUnitList, String treeId) {
        try {
            String permFilterSql = this.getUnionSQLByCompanyPKAndTreePK(orgUnitList, (IObjectPK)new ObjectStringPK(treeId));
            FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number where id in (" + permFilterSql + ")");
            if (coll == null) {
                return null;
            }
            return coll;
        }
        catch (BOSException e) {
            logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId), (Throwable)e);
            return null;
        }
    }

    private String getUnionSQLByCompanyPKAndTreePK(ArrayList orgUnitList, IObjectPK treeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT unit.fid ").append("FROM T_ORG_BASEUNIT unit ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.funitid = unit.fid ").append("WHERE unit.fisunion = 1 and structure.FID in").append("(SELECT FPARENTID FROM T_ORG_Structure where FunitId in(").append(CslRptUtil.collection2String((Collection)orgUnitList, (String)",", (boolean)true)).append(")").append(" AND FTreeId = '").append(treeID).append("')");
        return sql.toString();
    }

    protected CurrencyCollection getCurrencyCollection() {
        CurrencyCollection currencyCollection = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyCollection = iCurrency.getCurrencyCollection(this.getEntityViewInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return currencyCollection;
    }

    private OrgTreeCollection getOrgTreeCollectionByCompanyPK(ArrayList orgUnitList, ArrayList orgTreeIDList) throws BOSException {
        String permFilterSql = this.getOrgTreeSQLByCompanyPK(orgUnitList, orgTreeIDList);
        OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,status,startDate,endDate,number where id in (" + permFilterSql + ")");
        return coll;
    }

    private String getOrgTreeSQLByCompanyPK(ArrayList orgUnitList, ArrayList orgTreeIDList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tree.fid ").append("FROM T_ORG_Tree tree ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.FTreeId =tree.fid ").append("WHERE structure.FunitId in (").append(CslRptUtil.collection2String((Collection)orgUnitList, (String)",", (boolean)true)).append(")").append(" and tree.FTYPE=8 ").append("and tree.fid in (").append(CslRptUtil.collection2String((Collection)orgTreeIDList, (String)",", (boolean)true)).append(")");
        return sql.toString();
    }

    private EntityViewInfo getEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        return viewInfo;
    }

    protected AdjustModeCollection getAdjustModeCollection() {
        AdjustModeCollection adjustModeCollection = null;
        try {
            CslGradeManageUtil.filterAdjustModeGradeManage(null, this.getEntityViewInfo(), null);
            IAdjustMode iAdjustMode = AdjustModeFactory.getRemoteInstance();
            adjustModeCollection = iAdjustMode.getAdjustModeCollection(this.getEntityViewInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return adjustModeCollection;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getSelectOrgUnit() != null) {
            return new ObjectUuidPK(this.getSelectOrgUnit().getId().toString());
        }
        if (this.tblMain.getRowCount() != 0 && this.tblMain.getSelectManager().size() != 0) {
            Map map = null;
            try {
                map = this.getOrgBoundAndOrgUnit();
            }
            catch (BOSException | EASBizException e) {
                this.handUIException(e);
            }
            this.tblMainSelectOrgUnit = (OrgUnitInfo)map.get("orgUnit");
            return new ObjectUuidPK(((OrgUnitInfo)map.get("orgUnit")).getId().toString());
        }
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }

    protected void initCSLContext() {
        CSLContext cslContext = new CSLContext();
        if (this.cmbOrgBound.getItemCount() > 1 && this.cmbOrgBound.getSelectedIndex() != 0) {
            cslContext.setCurOrgBound((OrgTreeInfo)this.cmbOrgBound.getSelectedItem());
            if (this.getSelectOrgUnit() != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.getSelectOrgUnit().getId().toString());
                FullOrgUnitCollection coll = this.getOrgUnitByTreeAndUnit(list, ((OrgTreeInfo)this.cmbOrgBound.getSelectedItem()).getId().toString());
                if (coll != null && coll.size() > 0) {
                    cslContext.setCurOrgGroup((OrgUnitInfo)coll.get(0));
                }
            }
        }
        cslContext.setCurRptYear(((Integer)this.spCurYear.getValue()).intValue());
        cslContext.setCurRptPeriod(((Integer)this.spCurPeriod.getValue()).intValue());
        cslContext.setCurRptPeriodType((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        try {
            cslContext.setCurReportDate((Date)this.dpDate.getValue());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        cslContext.setQueryBudget(false);
        cslContext.setCurDataCollect(DataCollectConstant.getActualDC());
        this.cslCtx = cslContext;
    }

    protected void cslParamsPutOrgBoundAndOrgBoundGroup(Map cslParams, ICSLContext context) {
    }

    protected void setActionAdjustDyItem(int row) {
        if (this.cmbOrgBound.getSelectedIndex() == 0 && this.cmbOrgBound.getItemCount() < 1 || this.treeNodeRoot.getChildCount() == 0) {
            return;
        }
        super.setActionAdjustDyItem(row);
    }

    protected void getAdjustDynamicItem(ICSLContext context) throws BOSException, EASBizException {
        Iterator iterator = null;
        if (this.getCSLContext().getCurOrgBound() != null && this.getCSLContext().getCurOrgBound().getId() != null) {
            HashSet<String> IDSet = new HashSet<String>();
            IDSet.add(this.getCSLContext().getCurOrgBound().getId().toString());
            iterator = IDSet.iterator();
        } else if (this.orgBoundIDSet != null && this.orgBoundIDSet.size() != 0) {
            iterator = this.orgBoundIDSet.iterator();
        } else {
            this.abort();
        }
        while (iterator.hasNext()) {
            String orgBoundID = (String)iterator.next();
            this.cslParams.put("KEY_CUR_ORGBOUND_ID", orgBoundID);
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("cslParams", this.cslParams);
            params.put("AdjustWorktableUI", "AdjustWorktableUI");
            params.put("ISQUERYBUDGET", context.isQueryBudget());
            this.zipDataForRPC = AdjustFactory.getRemoteInstance().getDataZipForRPC(params);
            List list = (List)this.zipDataForRPC.get("adjustDynamicItem");
            if (this.existDyItemEntries == null) {
                this.existDyItemEntries = list;
                continue;
            }
            this.existDyItemEntries.addAll(list);
        }
    }

    protected AbstractRptWktbContext getWktbContext() {
        try {
            return WktbContextFactory.getInstance().getAdjustContext(this.getWktbOrgType());
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    protected OrgType getWktbOrgType() {
        return OrgType.Company;
    }

    public void refreshList() throws Exception {
        this.getFilter();
        super.refreshList();
    }

    protected FullOrgUnitInfo getSelectOrgUnit() {
        OrgUnitInfo orgUnit = this.getWktbContext().getOrgUnitInfo();
        if (orgUnit != null) {
            return orgUnit.castToFullOrgUnitInfo();
        }
        return null;
    }

    protected void setFilterByOrgUnit() {
        Object compareValue = null;
        CompareType compareType = null;
        FullOrgUnitInfo orgUnit = this.getSelectOrgUnit();
        if (orgUnit != null) {
            compareValue = orgUnit.getId().toString();
            compareType = CompareType.EQUALS;
        } else if (this.treeNodeRoot.getChildCount() != 0) {
            compareValue = this.builder.getOrgIDSets();
            compareType = CompareType.INCLUDE;
        } else {
            compareValue = null;
            compareType = CompareType.IS;
        }
        boolean hasItem = false;
        FilterItemInfo itemInfo = null;
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            return;
        }
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"ORGUNIT.ID".equals(item.getPropertyName())) continue;
            item.setCompareValue(compareValue);
            item.setCompareType(compareType);
            hasItem = true;
            break;
        }
        if (!hasItem) {
            itemInfo = new FilterItemInfo("ORGUNIT.ID", compareValue, compareType);
            filter.getFilterItems().add(itemInfo);
            String maskString = filter.getMaskString();
            maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
            filter.setMaskString(maskString);
        }
        this.getMainQuery().setFilter(filter);
    }

    private void getFilter() {
        String summary;
        String auditor;
        FilterItemInfo filterItemOrgBound;
        FilterInfo filterInfo = this.getMainQuery().getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        } else {
            filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("periodType", (Object)new Integer(((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()).getValue()), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("year", (Object)new Integer(this.spCurYear.getIntegerVlaue()), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("period", (Object)new Integer(this.spCurPeriod.getIntegerVlaue()), CompareType.EQUALS);
        String dataCollectNumber = "ACTUALDATA";
        FilterItemInfo filterItem3 = new FilterItemInfo("dataCollect.number", (Object)dataCollectNumber, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem3);
        sbFormula.append(" and #" + formulaIndex++);
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterItemSourceCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemSourceCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cmbCurrency.getSelectedItem() != null && !this.cmbCurrency.getSelectedItem().equals(this.selectAll)) {
            FilterItemInfo filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cmbAdjustMode.getSelectedItem() != null && !this.cmbAdjustMode.getSelectedItem().equals(this.selectAll)) {
            String adjustModeId = ((AdjustModeInfo)this.cmbAdjustMode.getSelectedItem()).getId().toString();
            FilterItemInfo filterItemAdjustMode = new FilterItemInfo("adjustMode.id", (Object)adjustModeId, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemAdjustMode);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cmbAuditedStatus.getSelectedItem() != null && !this.cmbAuditedStatus.getSelectedItem().equals(this.selectAll)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CheckedStatus", (Object)new Integer(this.cmbAuditedStatus.getSelectedIndex())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cmbOrgBound.getItemCount() > 1 && this.cmbOrgBound.getSelectedIndex() != 0) {
            filterItemOrgBound = new FilterItemInfo("orgBound.id", (Object)((OrgTreeInfo)this.cmbOrgBound.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemOrgBound);
            sbFormula.append("  and  #" + formulaIndex++);
        } else if (this.cmbOrgBound.getItemCount() < 1) {
            filterItemOrgBound = new FilterItemInfo("orgBound.id", null, CompareType.IS);
            filterInfo.getFilterItems().add(filterItemOrgBound);
            sbFormula.append("  and  #" + formulaIndex++);
        } else if (this.cmbOrgBound.getSelectedIndex() == 0) {
            filterItemOrgBound = new FilterItemInfo("orgBound.id", (Object)this.orgBoundIDSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemOrgBound);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        String creator = this.txtCreator.getText().trim();
        if (!StringUtils.isEmpty((String)creator)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("creator.name", (Object)creator));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(auditor = this.txtAuditor.getText().trim()))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("auditor.name", (Object)auditor));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(summary = this.txtSummary.getText().trim()))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.summary", (Object)("%" + summary + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        filterInfo.setMaskString(sbFormula.toString());
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("sortNumber"));
        coll.add(new SorterItemInfo("number"));
        coll.add(new SorterItemInfo("orgBound.name"));
        coll.add(new SorterItemInfo("entries.seq"));
        coll.add(new SorterItemInfo("id"));
        this.getMainQuery().setSorter(coll);
        this.getMainQuery().setFilter(filterInfo);
    }

    protected void btnQueryData_actionPerformed(ActionEvent e) throws Exception {
        this.initCSLContext();
        this.existDyItemEntries = null;
        this.refreshList();
        new Thread(){

            @Override
            public void run() {
                AdjustWorktableUI.this.initExistDyItemEntries();
            }
        }.start();
    }

    protected void initMegeType() throws Exception {
    }

    protected void updateCslCtxFilter() throws BOSException {
    }

    protected void initAdjustUI() throws Exception {
        this.actionImportData.setVisible(true);
        this.actionImportData.setEnabled(true);
        this.actionExportData.setVisible(true);
        this.actionExportData.setEnabled(true);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.newrpt.client.rptnewui.AdjustWorktableEditUI";
    }

    public boolean destroyWindow() {
        try {
            this.getWktbContext().clear();
        }
        catch (Exception e) {
            logger.debug((Object)e.getCause());
        }
        return super.destroyWindow();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        this.initCSLContext();
        uiContext.put((Object)"cslCtx", (Object)this.getCSLContext());
        uiContext.put((Object)"OrgTreeCollection", (Object)this.orgTreeColl);
        uiContext.put((Object)"isFromAdjustWorktableUI", (Object)true);
        uiContext.put((Object)"tblMainSelectOrgUnit", (Object)this.tblMainSelectOrgUnit);
        if (this.cmbOrgBound.getSelectedIndex() == 0 && this.cmbOrgBound.getItemCount() > 2) {
            uiContext.put((Object)"OrgBroungIsNull", (Object)true);
        }
        try {
            if (this.cslCtx.getCurOrgBound() != null && this.cslCtx.getCurOrgBound().getId() != null) {
                uiContext.put((Object)"orgBound", (Object)this.cslCtx.getCurOrgBound());
            } else if (this.cmbOrgBound.getItemCount() == 2) {
                uiContext.put((Object)"orgBound", this.cmbOrgBound.getItemAt(1));
            } else {
                uiContext.put((Object)"orgBound", null);
            }
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.getWktbContext().getOrgUnitInfo() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"NoSelectOrgUnit"));
            SysUtil.abort();
        }
        if (this.cmbOrgBound.getItemCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"NoOrgBound").replaceAll("\\{0\\}", this.getWktbContext().getOrgUnitInfo().getName()));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionImportRecord_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionImportRecord_actionPerformed(e);
    }

    public void setImportRecordUIContext(UIContext uiContext) {
        uiContext.put((Object)"AdjustWorkTableImportRecord", (Object)true);
    }

    public void actionCopyHisData_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        UIContext uiContext = super.initUIContext();
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CopyHisDataWorkTableUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        CopyHisDataWorkTableUI copyHisDataWorkTableUI = (CopyHisDataWorkTableUI)curUIWindow.getUIObject();
        copyHisDataWorkTableUI.bindDataListener((DataCatcherListener)this);
        curUIWindow.show();
    }

    protected void setUIContext(UIContext uiContext) {
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"OrgUnit", (Object)this.getSelectOrgUnit());
        uiContext.put((Object)"isFromAdjustWorkTableUI", (Object)true);
        uiContext.put((Object)"AdjustWorkTableCtx", (Object)this.getCSLContext());
    }

    public void actionCopyFixed_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionCopyFixed_actionPerformed(e);
    }

    private void checkOrgBoundAndOrgUnit() throws BOSException {
        this.initCSLContext();
        if (this.getCSLContext().getCurOrgGroup() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"NoSelectOrgBoundOROrgUnit"));
            SysUtil.abort();
        }
    }

    public void putUIContext(UIContext uiContext) {
        uiContext.put((Object)"OrgUnit", (Object)this.getSelectOrgUnit());
        super.putUIContext(uiContext);
    }

    public void actionTemplateBatchImport_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionTemplateBatchImport_actionPerformed(e);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        CommitAndDispenseUtils.addCommitToParentDataCenterButton((KDToolBar)this.toolBar, (ListUI)this, (CommitAndDispenseUtils.HandleType)CommitAndDispenseUtils.HandleType.adjust);
    }

    private Map getOrgBoundAndOrgUnit() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgBound"));
        sic.add(new SelectorItemInfo("orgUnit"));
        IAdjust iAdjust = AdjustFactory.getRemoteInstance();
        AdjustInfo info = iAdjust.getAdjustInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgBound", info.getOrgBound());
        map.put("orgUnit", info.getOrgUnit());
        return map;
    }

    public void actionOpenControlUI_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionOpenControlUI_actionPerformed(e);
    }

    public void actionViewAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionViewAdjust_actionPerformed(e);
    }

    public void actionSubImportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionImportData_actionPerformed(e);
    }

    public void copyFixedInitOrgTree() throws Exception {
    }

    public void actionAdjustDyItem_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionAdjustDyItem_actionPerformed(e);
    }

    protected UIContext getDynamicUIContext() throws BOSException {
        UIContext uiContext = super.getDynamicUIContext();
        uiContext.put((Object)"isFromAdjustWorkTableUI", (Object)this.cslCtx);
        return uiContext;
    }

    public void actionConvtAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionConvtAdjust_actionPerformed(e);
    }

    public void setViewUIContext(UIContext uiContext) {
        uiContext.put((Object)"isFromAdjustWorkSelectOrg", (Object)this.getSelectOrgUnit());
        uiContext.put((Object)"isFromAdjustWorkTableUI", (Object)true);
    }

    public void actionSynBasicScopeData_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgBoundAndOrgUnit();
        super.actionSynBasicScopeData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        Object obj;
        ArrayList prarm = super.getImportParam();
        if (prarm != null && !prarm.isEmpty() && (obj = prarm.get(0)) != null && obj instanceof DatataskParameter) {
            ((DatataskParameter)obj).putContextParam((Object)"isByCompany", (Object)true);
        }
        return prarm;
    }
}

