/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.newrpt.RptNewUIHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractBatchAddReportUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ReportWorktableUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BatchAddReportUI
extends AbstractBatchAddReportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BatchAddReportUI.class);
    private List<TemplateInfo> allTemplates = null;
    private boolean isLoaded = false;
    PeriodCollection periodCollection;
    TreeMap<Integer, List<Integer>> yearMap = new TreeMap();
    Map<String, String> grpIDsMap = new HashMap<String, String>();
    private OrgType orgType;
    private boolean isSupport13Period = false;
    private boolean isCtrlPress = false;
    String[] templateView = new String[]{"select", "templateType", "number", "name", "versionNumber", "hasCurReport"};
    private String preSortColumnKey = "";
    private String preSortType = "";
    private String msg = "";

    public BatchAddReportUI() throws Exception {
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        this.initSelfListener();
    }

    protected void initSelfListener() {
        this.kDTable2.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)BatchAddReportUI.this.kDTable2);
                for (int i = 0; i < selectRows.length; ++i) {
                    PropertyContainer p = (PropertyContainer)BatchAddReportUI.this.kDTable2.getRow(selectRows[i]).getUserObject();
                    p.put("select", BatchAddReportUI.this.kDTable2.getRow(selectRows[i]).getCell("select").getValue());
                }
            }
        });
        this.kDTable2.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                PropertyContainer p = (PropertyContainer)BatchAddReportUI.this.kDTable2.getRow(e.getRowIndex()).getUserObject();
                p.put("select", e.getValue());
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.kDTable2.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 0) {
                    BatchAddReportUI.this.refTemplatesView(BatchAddReportUI.this.templateView[e.getColIndex()], true);
                } else if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 1 && BatchAddReportUI.this.isCtrlPress) {
                    IRow row = BatchAddReportUI.this.kDTable2.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell("select").getValue();
                    row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
                    PropertyContainer p = (PropertyContainer)BatchAddReportUI.this.kDTable2.getRow(e.getRowIndex()).getUserObject();
                    p.put("select", (Object)(!isSelect ? 1 : 0));
                    BatchAddReportUI.this.kDTable2.checkParsed();
                }
            }
        });
        this.cmbPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && BatchAddReportUI.this.isLoaded) {
                    BatchAddReportUI.this.updateYearAndPeriod(true);
                    try {
                        BatchAddReportUI.this.loadTemplate();
                    }
                    catch (Exception e1) {
                        BatchAddReportUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.kdDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchAddReportUI.this.initSpinnerVal(true);
                BatchAddReportUI.this.initDatePick(true);
            }
        });
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!BatchAddReportUI.this.isLoaded) {
                    return;
                }
                BatchAddReportUI.this.initDatePick(false);
                if (BatchAddReportUI.this.isLoaded) {
                    try {
                        BatchAddReportUI.this.loadTemplate();
                    }
                    catch (Exception e1) {
                        BatchAddReportUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.spnPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!BatchAddReportUI.this.isLoaded) {
                    return;
                }
                BatchAddReportUI.this.initDatePick(false);
                if (BatchAddReportUI.this.isLoaded) {
                    try {
                        BatchAddReportUI.this.loadTemplate();
                    }
                    catch (Exception e1) {
                        BatchAddReportUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.cmbCyrrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && BatchAddReportUI.this.isLoaded) {
                    BatchAddReportUI.this.refleshReportOnTemplate();
                }
            }
        });
    }

    private void refleshReportOnTemplate() {
        if (this.grpIDsMap.size() <= 0) {
            return;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        int[] yp = this.getYearAndPeriod();
        String currencyID = ((CurrencyInfo)this.cmbCyrrency.getSelectedItem()).getId().toString();
        try {
            ReportCollection rptCol = RptNewUIUtil.getReportCollByTmplGroupID(null, null, new HashSet<String>(this.grpIDsMap.values()), periodType, yp[0], yp[1], this.getCompanyID(), currencyID);
            RptNewUIUtil.setReportTag2Template(rptCol, this.convert2TemplateCollect(this.allTemplates), this.grpIDsMap);
            this.refTemplatesView(null, false);
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private TemplateCollection convert2TemplateCollect(List<TemplateInfo> templates) {
        TemplateCollection tmplCol = new TemplateCollection();
        Iterator<TemplateInfo> it = templates.iterator();
        while (it.hasNext()) {
            tmplCol.add(it.next());
        }
        return tmplCol;
    }

    private void collectGrpIDs() throws BOSException {
        this.grpIDsMap = RptNewUIUtil.collectGrpIDsMap(null, this.convert2TemplateCollect(this.allTemplates), true);
    }

    private String getCompanyID() {
        try {
            return WktbContextFactory.getInstance().getRptContext(this.orgType).getOrgUnitInfo().getId().toString();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    private void updateYearAndPeriod(boolean needInitDatePick) {
        this.setEnabled();
        this.initSpinnerVal(false);
        if (needInitDatePick) {
            this.initDatePick(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeSel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnDeSel.setEnabled(true);
        this.btnOK.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgType = RptNewUIUtil.getOrgTypeOnContext(this.getUIContext());
        this.kDTable2.checkParsed();
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchAddReportUI.this.destroyWindow();
            }
        });
        for (int i = 0; i < this.kDTable2.getColumnCount(); ++i) {
            IColumn column = this.kDTable2.getColumn(i);
            if (column.getKey().equalsIgnoreCase("select")) continue;
            column.getStyleAttributes().setLocked(true);
        }
        this.loadEnumToCbx(RptPeriodTypeEnum.iterator(), this.cmbPeriodType);
        this.cmbPeriodType.setSelectedIndex(2);
        this.initPeriodCpm();
        this.initCurrencyCmb();
        this.loadTemplate();
        this.isLoaded = true;
        this.kDTable2.getSelectManager().setSelectMode(10);
        CslRptUIUtil.addTableSelectedListener((KDTable)this.kDTable2, (String)"select");
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        this.initTableEvent();
    }

    private void initTableEvent() {
        this.kDTable2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    BatchAddReportUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BatchAddReportUI.this.isCtrlPress) {
                    BatchAddReportUI.this.isCtrlPress = false;
                }
            }
        });
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initPeriodCpm() throws EASBizException, BOSException {
        this.periodCollection = InitDataFacadaFactory.getRemoteInstance().getFiscal((IObjectPK)new ObjectUuidPK(RptNewUIUtil.getDelegateCompany(this.orgType, this.getCompanyID()).getId()));
        this.yearMap.clear();
        if (this.periodCollection != null && this.periodCollection.size() > 0) {
            for (int i = 0; i < this.periodCollection.size(); ++i) {
                Integer year = this.periodCollection.get(i).getPeriodYear();
                Integer period = this.periodCollection.get(i).getPeriodNumber();
                List<Integer> periodVec = this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        }
        int[] yearPeriod = this.getCurrentPeriod();
        if (!this.isLoaded) {
            this.spnYear.setValue((Object)yearPeriod[0]);
            this.spnPeriod.setValue((Object)yearPeriod[1]);
            this.kdDate.setValue((Object)RPTDateUtil.getPeriodLastDate((int)yearPeriod[0], (int)yearPeriod[1], (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())), false);
        }
        this.setEnabled();
        Integer[] years = this.getYearScope();
        yearPeriod[0] = yearPeriod[0] > years[1] ? years[1] : (yearPeriod[0] < years[0] ? years[0] : yearPeriod[0]);
        this.spnYear.setModel((SpinnerModel)this.getSpinnerNumberModel(yearPeriod[0], years[0], years[1], 1));
        this.setSpinnerMinMaxVal(yearPeriod);
    }

    private int[] getCurrentPeriod() {
        try {
            int year = WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryYear();
            int period = WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriod();
            RptPeriodTypeEnum periodType = WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryPeriodType();
            if (periodType != null) {
                this.cmbPeriodType.setSelectedItem((Object)periodType);
            }
            if (year <= 0 || period <= 0) {
                return this.getCurrentSysPeriod();
            }
            return new int[]{year, period};
        }
        catch (Exception e) {
            return this.getCurrentSysPeriod();
        }
    }

    private int[] getCurrentSysPeriod() {
        return RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()));
    }

    private void initCurrencyCmb() throws BOSException, EASBizException {
        IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
        CurrencyCollection initCurrencyCollection = iInitDataFacada.getCurrencyNoGLC();
        if (initCurrencyCollection != null && initCurrencyCollection.size() > 0) {
            this.cmbCyrrency.addItems(initCurrencyCollection.toArray());
        }
        CurrencyInfo currCurrency = null;
        try {
            currCurrency = WktbContextFactory.getInstance().getRptContext(this.orgType).getQueryCurrencyInfo();
        }
        catch (Exception e) {
            currCurrency = RptNewUIUtil.getCompanyBasicCurrency(this.orgType, this.getCompanyID());
        }
        if (currCurrency != null) {
            int itemCount = this.cmbCyrrency.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object item = this.cmbCyrrency.getItemAt(i);
                if (item == null || !(item instanceof CurrencyInfo) || ((CurrencyInfo)item).getNumber() == null || !((CurrencyInfo)item).getNumber().equals(currCurrency.getNumber())) continue;
                this.cmbCyrrency.setSelectedIndex(i);
                break;
            }
        }
    }

    private void loadEnumToCbx(Iterator it, KDComboBox cb) {
        int i = 0;
        while (it.hasNext()) {
            cb.insertItemAt(it.next(), i);
            ++i;
        }
        cb.setSelectedIndex(0);
    }

    private void refTemplatesView(String sortKey, boolean isNewSortType) {
        this.kDTable2.removeRows();
        if (this.allTemplates == null) {
            return;
        }
        if (sortKey != null) {
            TmplCpt cpt = new TmplCpt(sortKey);
            if (!isNewSortType) {
                cpt.resetPreSortInfo();
            }
            Collections.sort(this.allTemplates, cpt);
            cpt.setPreSortInfo();
        }
        boolean canSelect = false;
        for (int i = 0; i < this.allTemplates.size(); ++i) {
            IRow row = this.kDTable2.addRow();
            row.setUserObject((Object)this.allTemplates.get(i));
            canSelect = (Boolean)this.allTemplates.get(i).get("select");
            row.getCell("select").setEditor((ICellEditor)new EditorFactory.BooleanEditor());
            row.getCell("select").setValue((Object)canSelect);
            RptTmpTypeEnum templateType = this.allTemplates.get(i).getTemplateType();
            if (templateType == RptTmpTypeEnum.GROUPCOMMREPORT) {
                templateType = RptTmpTypeEnum.GROUPREPORT;
            } else if (templateType == RptTmpTypeEnum.DYNAMICNORMALREPORT) {
                templateType = RptTmpTypeEnum.RPTDYNAMICREPORT;
            }
            row.getCell("type").setValue((Object)templateType);
            row.getCell("number").setValue((Object)this.allTemplates.get(i).getNumber());
            row.getCell("name").setValue((Object)this.allTemplates.get(i).getName());
            row.getCell("ver").setValue((Object)this.allTemplates.get(i).getVersionNumber());
            if (this.allTemplates.get(i).get("hasReport") == null) continue;
            Integer val = (Integer)this.allTemplates.get(i).get("hasReport");
            if (1 == val) {
                row.getCell("hasCurReport").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.yes"));
                row.getStyleAttributes().setBackground(Color.YELLOW);
                continue;
            }
            row.getCell("hasCurReport").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.no"));
        }
    }

    public void loadTemplate() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        EntityViewInfo commonView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBatchReport", (Object)"true"));
        commonView.setFilter(filter);
        params.put("commonView", commonView);
        ArrayList<RptTmpTypeEnum> templateType = new ArrayList<RptTmpTypeEnum>();
        templateType.add(RptTmpTypeEnum.COMMONREPORT);
        params.put("periodType", (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        params.put("tempTypeList", templateType);
        params.put("isAudited", Boolean.TRUE);
        params.put("isRemovePublished", Boolean.TRUE);
        params.put("companyPK", WktbContextFactory.getInstance().getRptContext(this.orgType).getOrgUnitInfo().getId().toString());
        params.put("currency", ((CurrencyInfo)this.cmbCyrrency.getSelectedItem()).getId().toString());
        params.put("year", this.spnYear.getValue());
        params.put("period", this.spnPeriod.getValue());
        if (this.getUIContext().containsKey("schemeid")) {
            params.put("schemeId", (String)this.getUIContext().get("schemeid"));
        }
        params.put("orgType", this.orgType);
        this.allTemplates = this.covt2List(RptNewUIHandleFacadeFactory.getRemoteInstance().getCompanyTemplate(params));
        this.collectGrpIDs();
        this.refTemplatesView(this.templateView[1], false);
    }

    private List covt2List(TemplateCollection tmplCol) {
        if (tmplCol == null) {
            return new ArrayList(0);
        }
        return Arrays.asList(tmplCol.toArray());
    }

    private void setEnabled() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType) || RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.kDLabelContainer8.setEnabled(false);
            this.kDLabelContainer3.setEnabled(false);
            this.kDLabelContainer2.setEnabled(true);
        } else {
            this.kDLabelContainer8.setEnabled(true);
            this.kDLabelContainer3.setEnabled(true);
            this.kDLabelContainer2.setEnabled(false);
        }
    }

    private void initSpinnerVal(boolean fireListener) {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        int[] yearperiod = this.getYearAndPeriod();
        this.spnYear.setValue((Object)yearperiod[0], fireListener);
        this.spnPeriod.setValue((Object)yearperiod[1], fireListener);
        this.setSpinnerMinMaxVal(yearperiod);
    }

    private void setSpinnerMinMaxVal(int[] yearperiod) {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, this.getMaxPeriod(yearperiod[0]), 1));
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 4, 1));
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 2, 1));
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 1, 1));
        } else if (RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 53, 1));
        } else if (RptPeriodTypeEnum.DAILY.equals((Object)periodType)) {
            this.spnPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 366, 1));
        }
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private int getMaxPeriod(Integer year) {
        int lenght = this.yearMap.get(year).size();
        int maxPeriod = this.yearMap.get(year).get(lenght - 1);
        return maxPeriod < 13 && this.isSupport13Period ? 13 : maxPeriod;
    }

    private Integer[] getYearScope() {
        Object[] array = this.yearMap.keySet().toArray();
        if (array == null || array.length == 0) {
            return new Integer[]{0, 0};
        }
        Arrays.sort(array);
        return new Integer[]{(Integer)array[0], (Integer)array[array.length - 1]};
    }

    private int[] getYearAndPeriod() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeE != null) {
            Date date = (Date)this.kdDate.getValue();
            if (date != null) {
                return RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeE);
            }
            return null;
        }
        return null;
    }

    private void initDatePick(boolean fireListener) {
        int period = this.spnPeriod.getIntegerVlaue();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()))) {
            period = period >= 13 ? 12 : period;
        }
        this.kdDate.setValue((Object)RPTDateUtil.getPeriodLastDate((int)this.spnYear.getIntegerVlaue(), (int)period, (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())), fireListener);
    }

    private void addDatePickedLst() {
        this.kdDate.getEditor().setDataChangeListenerFired(true);
    }

    @Override
    public void actionDeSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeSelect_actionPerformed(e);
        this.setTableSelect(false, this.kDTable2);
        for (int i = 0; i < this.kDTable2.getRowCount(); ++i) {
            IRow row = this.kDTable2.getRow(i);
            PropertyContainer p = (PropertyContainer)row.getUserObject();
            p.put("select", row.getCell("select").getValue());
        }
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        Object uiobj;
        super.actionNew_actionPerformed(e);
        final HashSet<String> templateIdSet = new HashSet<String>();
        for (int i = 0; i < this.allTemplates.size(); ++i) {
            if (!((Boolean)this.allTemplates.get(i).get("select")).booleanValue()) continue;
            templateIdSet.add(this.allTemplates.get(i).getId().toString());
        }
        if (templateIdSet.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"0_BatchAddReportUI"));
            this.abort();
        }
        final int[] yearAndPeriod = new int[]{this.spnYear.getIntegerVlaue(), this.spnPeriod.getIntegerVlaue()};
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), true);
        dialog.run(false, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                try {
                    monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"1_BatchAddReportUI"));
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"2_BatchAddReportUI"));
                    String sa = ReportFactory.getRemoteInstance().batchAddNewReport(templateIdSet, BatchAddReportUI.this.getCompanyID(), ((CurrencyInfo)BatchAddReportUI.this.cmbCyrrency.getSelectedItem()).getId().toString(), new Object[]{BatchAddReportUI.this.orgType}, yearAndPeriod);
                    BatchAddReportUI.this.setCreateReportMsg(sa);
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"3_BatchAddReportUI"));
                }
                catch (Exception e) {
                    BatchAddReportUI.this.handUIExceptionAndAbort(e);
                }
                finally {
                    monitor.done();
                }
            }
        });
        if (!StringUtils.isEmpty((String)this.msg)) {
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"Title", (Object)RptUtil.getResourceSince51((String)"RESULT"));
            uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)this.msg);
        }
        if ((uiobj = this.getUIContext().get("parent")) != null && uiobj instanceof ReportWorktableUI) {
            try {
                ((ReportWorktableUI)uiobj).actionQueryRptData_actionPerformed(null);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage());
            }
        }
        this.disposeUIWindow();
    }

    private void setCreateReportMsg(String msg1) {
        this.msg = msg1;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.setTableSelect(true, this.kDTable2);
        for (int i = 0; i < this.kDTable2.getRowCount(); ++i) {
            IRow row = this.kDTable2.getRow(i);
            PropertyContainer p = (PropertyContainer)row.getUserObject();
            p.put("select", row.getCell("select").getValue());
        }
    }

    private void setTableSelect(boolean b, KDTable t) {
        for (int i = 0; i < t.getRowCount(); ++i) {
            t.getRow(i).getCell("select").setValue((Object)new Boolean(b));
        }
    }

    @Override
    public void actionDisplayAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay((KDTable)this.kDTable2, (String)"select", (KDWorkButton)this.btnDisplay);
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.kDTable2.getColumnIndex("number");
            int colIndex2 = this.kDTable2.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate((KDTable)this.kDTable2, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    class TmplCpt
    implements Comparator<TemplateInfo> {
        private String _sortKey;

        public TmplCpt(String sortKey) {
            this._sortKey = sortKey;
        }

        @Override
        public int compare(TemplateInfo arg0, TemplateInfo arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null && arg1 != null) {
                return -1;
            }
            if (arg0 != null && arg1 == null) {
                return 1;
            }
            if (BatchAddReportUI.this.templateView[1].equals(this._sortKey)) {
                return this.returnRelVal(this.sortByType(arg0, arg1));
            }
            if (BatchAddReportUI.this.templateView[2].equals(this._sortKey)) {
                return this.returnRelVal(this.sortByNumber(arg0, arg1));
            }
            if (BatchAddReportUI.this.templateView[3].equals(this._sortKey)) {
                return this.returnRelVal(this.sortByName(arg0, arg1));
            }
            if (BatchAddReportUI.this.templateView[4].equals(this._sortKey)) {
                return this.returnRelVal(this.sortByVersion(arg0, arg1));
            }
            if (BatchAddReportUI.this.templateView[5].equals(this._sortKey)) {
                return this.returnRelVal(this.sortByHasReport(arg0, arg1));
            }
            return -1;
        }

        public void setPreSortInfo() {
            BatchAddReportUI.this.preSortColumnKey = this._sortKey;
            BatchAddReportUI.this.preSortType = this.currSortType();
        }

        public void resetPreSortInfo() {
            BatchAddReportUI.this.preSortColumnKey = "";
            BatchAddReportUI.this.preSortType = "";
        }

        private int returnRelVal(int compVal) {
            if ("asc".equals(this.currSortType())) {
                return compVal;
            }
            return -compVal;
        }

        private String currSortType() {
            if (this._sortKey.equals(BatchAddReportUI.this.preSortColumnKey)) {
                return "asc".equals(BatchAddReportUI.this.preSortType) ? "dsc" : "asc";
            }
            return "asc";
        }

        private int sortByName(TemplateInfo arg0, TemplateInfo arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }

        private int sortByNumber(TemplateInfo arg0, TemplateInfo arg1) {
            return arg0.getNumber().compareTo(arg1.getNumber());
        }

        private int sortByType(TemplateInfo arg0, TemplateInfo arg1) {
            int val = arg0.getTemplateType().compareTo((Object)arg1.getTemplateType());
            if (val == 0) {
                return val + this.sortByNumber(arg0, arg1);
            }
            return val;
        }

        private int sortByVersion(TemplateInfo arg0, TemplateInfo arg1) {
            return arg0.getVersionNumber().compareTo(arg1.getVersionNumber());
        }

        private int sortByHasReport(TemplateInfo arg0, TemplateInfo arg1) {
            return (Integer)arg0.get("hasReport") - (Integer)arg1.get("hasReport");
        }
    }
}

