/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateFactory;
import com.kingdee.eas.fi.newrpt.CslCustomerExChangeRateTabFactory;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractCslCustomerExChangeRateTabListUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.CslCustomerExChangeRateTabEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class CslCustomerExChangeRateTabListUI
extends AbstractCslCustomerExChangeRateTabListUI {
    private static final Logger logger = CoreUIObject.getLogger(CslCustomerExChangeRateTabListUI.class);
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String DEFAULTNUM = "001";
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();

    public CslCustomerExChangeRateTabListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                CslCustomerExChangeRateTabListUI.this.fillTable(e);
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreator.id").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeBtnSateByCreateCompany();
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreator.id").getValue().toString().equals(this.company.getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.changeBtnStateOnload();
        this.addSeletedChangedListener();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    CslCustomerExChangeRateTabListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    CslCustomerExChangeRateTabListUI.this.handUIException(exc);
                }
            }
        });
    }

    private void changeBtnStateOnload() {
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.menuItemQueryScheme.setVisible(false);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getUpSqlPub(filterInfo, "trackRecordCreator.id");
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    protected String getEditUIName() {
        return CslCustomerExChangeRateTabEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslCustomerExChangeRateTabFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeRm();
        super.actionRemove_actionPerformed(e);
    }

    private void checkBeforeRm() throws BOSException, EASBizException {
        this.defaultTblCannotRm();
        this.rateTblExistRate();
    }

    private void rateTblExistRate() throws BOSException, EASBizException {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        String rateID = this.tblMain.getRow(selectRow).getCell(ID).getValue().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("rateTabID", (Object)rateID, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (UserDefinedRateFactory.getRemoteInstance().exists(filter)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"115_rateTblExist");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    private void defaultTblCannotRm() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (this.tblMain.getRow(selectRow).getCell(NUMBER).getValue().toString().equals(DEFAULTNUM)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"107_cussRateTblDefualNumNotRvm");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }
}

