/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.uiframe.client.GlassPane;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.RptNewUIHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractHelpGuide;
import com.kingdee.eas.fi.newrpt.client.rptnewui.GuideMessageInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.GuideMessageManage;
import com.kingdee.eas.fi.newrpt.client.rptnewui.NonRulePanel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class HelpGuide
extends AbstractHelpGuide {
    private static final long serialVersionUID = 1L;
    private GuideMessageManage manage = new GuideMessageManage();
    private CoreUI owner;
    private GlassPane glassPane = new GlassPane();
    private NonRulePanel nonRulePanel;
    private String guideTopic;

    private HelpGuide() {
        this.createNonRulePanel();
        this.setOpaque();
        this.initListener();
    }

    private HelpGuide(CoreUI ui) {
        this();
        this.owner = ui;
    }

    private HelpGuide(CoreUI ui, String topic) {
        this(ui);
        this.guideTopic = topic;
        if (!StringUtils.isEmpty((String)this.guideTopic)) {
            this.guideLabel.setText(this.guideTopic);
        }
    }

    private void setOpaque() {
        this.guideLabel.setOpaque(false);
        this.knownLabel.setOpaque(false);
        this.msgPane.setOpaque(false);
        this.upLabel.setOpaque(false);
        this.nextLabel.setOpaque(false);
    }

    public void registerGuide(GuideMessageInfo guide) {
        this.manage.registerGuide(guide);
        this.setState();
    }

    private void initListener() {
        this.knownLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpGuide.this.close();
            }
        });
        this.upLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((Component)e.getSource()).isEnabled()) {
                    HelpGuide.this.showMsgOnPane(false);
                }
            }
        });
        this.nextLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((Component)e.getSource()).isEnabled()) {
                    HelpGuide.this.showMsgOnPane(true);
                }
            }
        });
        this.registerKeyAction();
        this.knownLabel.addMouseListener((MouseListener)new MouseMoveOnAdapter());
        this.upLabel.addMouseListener((MouseListener)new MouseMoveOnAdapter());
        this.nextLabel.addMouseListener((MouseListener)new MouseMoveOnAdapter());
    }

    private void registerKeyAction() {
        InputMap inputMap = this.nonRulePanel.getInputMap(2);
        ActionMap actionMap = this.nonRulePanel.getActionMap();
        if (inputMap != null && actionMap != null) {
            this.registerEscKeyAction(inputMap, actionMap);
            this.registerUpKeyAction(inputMap, actionMap);
            this.registerDownKeyAction(inputMap, actionMap);
        }
    }

    private void registerEscKeyAction(InputMap inputMap, ActionMap actionMap) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "esc");
        actionMap.remove("esc");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpGuide.this.close();
            }
        };
        actionMap.put("esc", action);
    }

    private void registerUpKeyAction(InputMap inputMap, ActionMap actionMap) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, "up");
        actionMap.remove("up");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelpGuide.this.upLabel.isEnabled()) {
                    HelpGuide.this.showMsgOnPane(false);
                }
            }
        };
        actionMap.put("up", action);
    }

    private void registerDownKeyAction(InputMap inputMap, ActionMap actionMap) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, "down");
        actionMap.remove("down");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelpGuide.this.nextLabel.isEnabled()) {
                    HelpGuide.this.showMsgOnPane(true);
                }
            }
        };
        actionMap.put("down", action);
    }

    private void close() {
        this.manage.clear();
        this.glassPane.setVisible(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    RptNewUIHandleFacadeFactory.getRemoteInstance().saveGuide(HelpGuide.this.owner.getUIWindow().getUIObject().getClass().getName());
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void createNonRulePanel() {
        this.nonRulePanel = new NonRulePanel();
        this.nonRulePanel.setSize(this.getWidth() + 10, this.getHeight() + 17);
        this.nonRulePanel.setBackgroundColor(new Color(255, 255, 255));
        this.nonRulePanel.setBorderColor(Color.decode("#0066CC"));
        this.nonRulePanel.addComponent((Component)((Object)this));
    }

    private void showMsgOnPane(boolean isNext) {
        this.msgPane.setText(isNext ? this.manage.nextGuide().getShowMessage() : this.manage.preGuide().getShowMessage());
        this.titleLabel.setText(this.manage.getCurrGuide().getTitle());
        this.setState();
        this.adjustNonRulePanel();
        this.setBackground(new Color(255, 255, 255));
        this.nonRulePanel.requestFocus();
    }

    private void adjustNonRulePanel() {
        this.nonRulePanel.setTargRec(this.manage.getCurrGuide().getRectangle());
        this.nonRulePanel.setPolygonAlignment(this.manage.getCurrGuide().getPolygonAlignment());
        this.nonRulePanel.calculatePlace();
    }

    private void setState() {
        this.nextLabel.setEnabled(this.manage.hasNext());
        this.upLabel.setEnabled(this.manage.hasPre());
    }

    public void onShow() {
        if (!this.manage.hasGuide()) {
            throw new RuntimeException("please init Guide Card Info!");
        }
        Window ance = SwingUtilities.getWindowAncestor((Component)this.owner);
        if (this.owner != null && ance instanceof JFrame) {
            ((JFrame)ance).setGlassPane((Component)this.glassPane);
            this.glassPane.setBigBackground(Color.BLACK);
            this.glassPane.addComponent((Component)((Object)this.nonRulePanel));
            this.glassPane.setSize(ance.getWidth(), ance.getHeight());
            this.glassPane.setVisible(true);
            this.glassPane.setOpaque(false);
            this.showMsgOnPane(true);
            this.setBackground(new Color(255, 255, 255));
            this.glassPane.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        HelpGuide.this.glassPane.setVisible(false);
                    }
                }
            });
        }
    }

    public static HelpGuide getInstance(CoreUI ui) {
        return new HelpGuide(ui);
    }

    public static HelpGuide getInstance(CoreUI ui, String topic) {
        return new HelpGuide(ui, topic);
    }

    class MouseMoveOnAdapter
    extends MouseAdapter {
        MouseMoveOnAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component label = (Component)e.getSource();
            label.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component label = (Component)e.getSource();
            label.setCursor(new Cursor(0));
        }
    }
}

