/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueCollection;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueFactory;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueInfo;
import com.kingdee.eas.fi.newrpt.IndexGroupEnum;
import com.kingdee.eas.fi.newrpt.IndustryInfo;
import com.kingdee.eas.fi.newrpt.IndustryRangeEnum;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractIndustryIndexValueListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndustryIndexValueListUI
extends AbstractIndustryIndexValueListUI {
    private static final Logger logger = CoreUIObject.getLogger(IndustryIndexValueListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.scale.addItems(IndustryRangeEnum.getEnumList().toArray());
        this.setYaerComboBoxItem();
        this.setF7Query();
        this.valueTable.checkParsed();
        this.valueTable.getStyleAttributes().setLocked(true);
        this.fillTableByFilter();
    }

    private AnalysisIndexEvalValueCollection getAnalysisIndexEvalValue(String industryId, int industryRange, int year) throws BOSException {
        StringBuffer oql = new StringBuffer("select keyIndex.id,keyIndex.indexGroup,keyIndex.name,keyIndex.unit,excellentValue,goodValue,averageValue,fairValue,poorValue ");
        oql.append(" where industryRange=").append(industryRange).append(" and year=").append(year);
        if (industryId != null && industryId.length() > 0) {
            oql.append(" and  industry.id='").append(industryId).append("'");
        }
        oql.append(" order by keyIndex.indexGroup ");
        logger.error((Object)("IndustryIndexValueListUI get data oql is : " + oql));
        return AnalysisIndexEvalValueFactory.getRemoteInstance().getAnalysisIndexEvalValueCollection(oql.toString());
    }

    private void fillTable(AnalysisIndexEvalValueCollection coll) {
        if (coll == null) {
            return;
        }
        this.valueTable.removeRows(false);
        for (int i = 0; i < coll.size(); ++i) {
            AnalysisIndexEvalValueInfo info = coll.get(i);
            IRow row = this.valueTable.addRow();
            row.getCell("indexGroup").setValue((Object)info.getKeyIndex().getIndexGroup());
            row.getCell("index").setValue((Object)info.getKeyIndex().getName());
            row.getCell("favorable").setValue((Object)info.getGoodValue().setScale(1, 4));
            row.getCell("excellent").setValue((Object)info.getExcellentValue().setScale(1, 4));
            row.getCell("average").setValue((Object)info.getAverageValue().setScale(1, 4));
            row.getCell("lower").setValue((Object)info.getFairValue().setScale(1, 4));
            row.getCell("poor").setValue((Object)info.getPoorValue().setScale(1, 4));
        }
        this.valueTable.getColumn("index").setWidth(200);
        IndustryIndexValueListUI.mergeCheckBox(this.valueTable, "indexGroup", this.valueTable.getColumn("indexGroup").getColumnIndex(), this.valueTable.getColumn("indexGroup").getColumnIndex());
    }

    public static void mergeCheckBox(KDTable tblMain, String columnName, int left, int right) {
        if (tblMain == null) {
            return;
        }
        int size = tblMain.getRowCount();
        int top = 0;
        int bottom = 0;
        KDTMergeManager mm = tblMain.getMergeManager();
        String previousdId = "";
        for (int i = 0; i < size; ++i) {
            IRow row = tblMain.getRow(i);
            if (row == null || row.getCell(columnName) == null) continue;
            String tempId = ((IndexGroupEnum)((Object)row.getCell(columnName).getValue())).getAlias();
            if (previousdId.equals("")) {
                previousdId = tempId;
            }
            if (tempId.equalsIgnoreCase(previousdId) || i == 0 || top == bottom) {
                ++bottom;
            } else {
                mm.mergeBlock(top, left, bottom - 1, right, 4);
                top = bottom++;
                previousdId = tempId;
            }
            if (i != size - 1) continue;
            mm.mergeBlock(top, left, bottom - 1, right, 4);
        }
    }

    private void setF7Query() {
        this.industryF7.setQueryInfo("com.kingdee.eas.fi.newrpt.IndustryQuery");
        this.industryF7.setEditFormat("$number$");
        this.industryF7.setDisplayFormat("$name$");
        this.industryF7.setEditable(false);
        this.industryF7.setCommitFormat("$id$");
    }

    private void setYaerComboBoxItem() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int count = year - 1949 + 1;
        Object[] item = new Integer[count];
        for (int i = 0; i < item.length; ++i) {
            item[i] = year - i;
        }
        this.year.addItems(item);
        this.year.setSelectedItem((Object)new Integer(year));
    }

    @Override
    public void actionLoadIndex_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = factory.create("com.kingdee.eas.fi.newrpt.client.rptnewui.IndexLoadUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void fillTableByFilter() throws BOSException {
        String industryId = null;
        if (this.industryF7.getData() != null) {
            industryId = ((IndustryInfo)this.industryF7.getData()).getId().toString();
        }
        int industryRange = ((IndustryRangeEnum)((Object)this.scale.getSelectedItem())).getValue();
        int year = (Integer)this.year.getSelectedItem();
        this.fillTable(this.getAnalysisIndexEvalValue(industryId, industryRange, year));
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.industryF7.getData() == null) {
            MsgBox.showConfirm2((String)CslRptUtil.getString((String)"industryIsNull"));
            SysUtil.abort();
        }
        this.fillTableByFilter();
    }
}

