/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KDTableSortHelper {
    private KDTable tblMain;
    private Map<String, SortField> sortFields = new HashMap<String, SortField>();
    private final String _defaultSortStr;
    private String querySortStr;
    private KDTSortManager sm = null;

    public KDTableSortHelper(KDTable tbl, String defaultSortStr) {
        this.tblMain = tbl;
        this._defaultSortStr = defaultSortStr;
        this.querySortStr = defaultSortStr;
        this.initSortFields();
        this.sm = new KDTSortManager(this.tblMain);
    }

    private void initSortFields() {
        KDTColumns columns = this.tblMain.getColumns();
        if (columns == null) {
            return;
        }
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn column = columns.getColumn(i);
            if (column == null) continue;
            this.sortFields.put(column.getKey(), new SortField(column.getKey()));
        }
    }

    public void reSet() {
        Iterator<SortField> it = this.sortFields.values().iterator();
        while (it.hasNext()) {
            it.next().reSet();
        }
        this.querySortStr = this._defaultSortStr;
        this.sm.clear();
    }

    public void handleSort(int colIndex) {
        String columnKey = this.tblMain.getColumnKey(colIndex);
        if (this.sortFields.containsKey(columnKey)) {
            SortField sortField = this.sortFields.get(columnKey);
            sortField.nextSort();
            this.sm.sort(colIndex, sortField._sortType);
            if (this._defaultSortStr.contains(columnKey)) {
                this.fillSortCondition(columnKey, sortField);
            } else {
                this.combineSortStr(sortField.getSortStr());
            }
        }
    }

    private void fillSortCondition(String columnKey, SortField sortField) {
        String[] checkStrs = this._defaultSortStr.split(",");
        this.querySortStr = "";
        for (int i = 0; i < checkStrs.length; ++i) {
            if (checkStrs[i].contains(columnKey)) {
                checkStrs[i] = sortField.getSortStr();
            }
            this.querySortStr = i == checkStrs.length - 1 ? this.querySortStr + checkStrs[i] : this.querySortStr + checkStrs[i] + ",";
        }
    }

    private void combineSortStr(String newColumnKey) {
        String newColumnName = newColumnKey.trim().split(" ")[0];
        if (this._defaultSortStr != null && this._defaultSortStr.contains(newColumnName)) {
            String[] _defaultSortStrs = this._defaultSortStr.split(",");
            this.querySortStr = newColumnKey + ",";
            String columnKey = null;
            for (int i = 0; i < _defaultSortStrs.length; ++i) {
                columnKey = _defaultSortStrs[i];
                if (columnKey.contains(newColumnName)) continue;
                this.querySortStr = this.querySortStr + _defaultSortStrs[i] + ",";
            }
            this.querySortStr = this.querySortStr.substring(0, this.querySortStr.length() - 1);
        } else {
            this.querySortStr = newColumnKey + "," + this._defaultSortStr;
        }
    }

    public String getQuerySortStr() {
        return this.querySortStr;
    }

    class SortField {
        protected String _columnKey;
        protected int _sortType = 0;

        protected SortField(String columnKey) {
            this._columnKey = columnKey;
        }

        protected SortField(String columnKey, int sortType) {
            this(columnKey);
            this._sortType = sortType;
        }

        protected void reSet() {
            this._sortType = 0;
        }

        protected int nextSort() {
            if (this._sortType == 0) {
                this._sortType = 1;
                return 1;
            }
            this._sortType = 0;
            return 0;
        }

        protected String getSortStr() {
            if (this._sortType == 0) {
                return this._columnKey + " asc";
            }
            return this._columnKey + " desc";
        }
    }
}

