/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractQueryMultiPeriodReportUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ReportWorktableUI;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class QueryMultiPeriodReportUI
extends AbstractQueryMultiPeriodReportUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryMultiPeriodReportUI.class);

    public QueryMultiPeriodReportUI() throws Exception {
        this.btnCurrentYear.setSelected(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        List reportids = this.getReportIds();
        this.disposeUIWindow();
        if (reportids != null && reportids.size() > 0) {
            ReportWorktableUI ui = new ReportWorktableUI();
            ui.openReport(reportids, true);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"ThereAreNotReportsInCondition"));
            this.abort();
        }
    }

    private List getReportIds() throws BOSException {
        ArrayList<String> reportids = new ArrayList<String>();
        String companyid = (String)this.getUIContext().get("companyid");
        String currency = (String)this.getUIContext().get("currency");
        boolean isSupport13Period = (Boolean)this.getUIContext().get("isSupport13Period");
        Set tmplIds = this.getTemplateIds();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        SorterItemCollection sortor = new SorterItemCollection();
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyid, CompareType.EQUALS));
        sbFormula.append(" #" + formulaIndex++);
        filter.getFilterItems().add(new FilterItemInfo("template", (Object)tmplIds, CompareType.INCLUDE));
        sbFormula.append(" and #" + formulaIndex++);
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currency, CompareType.EQUALS));
        sbFormula.append(" and #" + formulaIndex++);
        Integer yearStr = (Integer)this.getUIContext().get("year");
        Integer periodStr = (Integer)this.getUIContext().get("period");
        int year = yearStr;
        int period = periodStr;
        if (this.btnCurrentYear.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)1, CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
        } else if (this.btnLastPeriod.isSelected() || this.btnTheSamePeriodOfLastYear.isSelected()) {
            List times;
            int lastYear = 0;
            int lastPeriod = 0;
            if (this.btnLastPeriod.isSelected()) {
                times = RPTDate13Util.getRptYearAndPeriodAndDate((int)year, (int)period, (int)3, (int)0, (int)-1, (boolean)isSupport13Period);
                lastYear = (Integer)times.get(0);
                lastPeriod = (Integer)times.get(1);
                if (isSupport13Period && period == 1) {
                    HashSet<Integer> set = new HashSet<Integer>();
                    set.add(12);
                    set.add(lastPeriod);
                    filter.getFilterItems().add(new FilterItemInfo("year", (Object)lastYear, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("period", set, CompareType.INCLUDE));
                    sbFormula.append(" and ((#" + formulaIndex++ + " and #" + formulaIndex++ + ")");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("year", (Object)lastYear, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("period", (Object)lastPeriod, CompareType.EQUALS));
                    sbFormula.append(" and ((#" + formulaIndex++ + " and #" + formulaIndex++ + ")");
                }
            } else {
                times = RPTDate13Util.getRptYearAndPeriodAndDate((int)year, (int)period, (int)3, (int)-1, (int)0, (boolean)isSupport13Period);
                lastYear = (Integer)times.get(0);
                lastPeriod = (Integer)times.get(1);
                filter.getFilterItems().add(new FilterItemInfo("year", (Object)lastYear, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)lastPeriod, CompareType.EQUALS));
                sbFormula.append(" and ((#" + formulaIndex++ + " and #" + formulaIndex++ + ")");
            }
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
            sbFormula.append(" or (#" + formulaIndex++ + " and #" + formulaIndex++ + "))");
        }
        filter.getFilterItems().add(new FilterItemInfo("isSupportGroup", (Object)1, CompareType.EQUALS));
        sbFormula.append(" and #" + formulaIndex++ + "");
        filter.setMaskString(sbFormula.toString());
        selector.add(new SelectorItemInfo("id"));
        sortor.add(new SorterItemInfo("year"));
        sortor.add(new SorterItemInfo("period"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sortor);
        ReportCollection reportColl = ReportFactory.getRemoteInstance().getReportCollection(view);
        for (ReportInfo info : reportColl) {
            reportids.add(info.getId().toString());
        }
        return reportids;
    }

    private Set getTemplateIds() throws BOSException {
        HashSet<String> tmplIds = new HashSet<String>();
        String tmplNumber = (String)this.getUIContext().get("tmplNumber");
        String sourceType = (String)this.getUIContext().get("tmplSourceType");
        TemplateCollection tmplColl = TemplateFactory.getRemoteInstance().getTemplateCollection("select id where number = '" + tmplNumber + "' and auditedStatus = " + 2 + " and templateType in (" + sourceType + ")");
        for (TemplateInfo info : tmplColl) {
            tmplIds.add(info.getId().toString());
        }
        return tmplIds;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }
}

