/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.AbstractReportQueryPanel;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ReportQueryPanelForSingleExtract;
import com.kingdee.eas.fi.newrpt.client.rptnewui.RptReportProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.ReportCondition;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.TmplNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.TmplQueryDataCache;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.MockLoadRptProcessUIThread;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.NotKnowNode;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.OrgTreeBuilder;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractRptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WebWktbContextFactory;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReportType;
import com.kingdee.eas.fi.rpt.IRptTypeRela;
import com.kingdee.eas.fi.rpt.IRptTypeStd;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeRelaFactory;
import com.kingdee.eas.fi.rpt.RptTypeStdFactory;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateTypeCollection;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.client.GroupTreecomponent;
import com.kingdee.eas.fi.rpt.client.PublicTemplateManager;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReportQueryPanel
extends AbstractReportQueryPanel {
    private static final long serialVersionUID = 1L;
    TreeMap<Integer, List<Integer>> yearMap = new TreeMap();
    private KDTreeNode tmplTreeNodeRoot = new KDTreeNode((Object)ReportTypeEnum.TEMPLATE);
    private KDTreeNode orgTreeNoderoot = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"15_ReportQueryPanel"));
    private ArrayList<RptTmpTypeEnum> tempTypeList = null;
    private ArrayList<RptTmpTypeEnum> tempCommTypeList = null;
    private String permissionContidion = null;
    private boolean usingDiscretePermission;
    private TemplateTypeCollection tempTypeCollection = null;
    private GroupTreecomponent groupTreeComponent = null;
    private DisplayTemplateTypeEnum groupTempType = DisplayTemplateTypeEnum.GROUP;
    private TmplQueryDataCache cache = new TmplQueryDataCache();
    private Object[] selectedPathObject = null;
    private DefaultTreeModel tmplTreeModel;
    private ReportCondition LastRptCondition = null;
    protected List<Object> versionTypeList = Arrays.asList(new Integer(1));
    private boolean isLoaded = false;
    private ChangeListener[] spnyearChgLstn;
    private ChangeListener[] spnperiodChgLstn;
    IInitDataFacada iInitDataFacada;
    protected OrgType orgType;
    PeriodCollection periodCollection = null;
    private boolean isSupport13Period = false;
    private boolean isOpenFromWeb = false;
    private CurrencyCollection initCurrencyCollection;
    private int[] preYearAndPeriod = new int[]{0, 0};
    private IReportType iReportType;
    private IRptTypeStd iRptTypeStd;
    private IRptTypeRela iRptTypeRela;
    private ITemplate iTemplate;

    public ReportQueryPanel(CoreUI ui, OrgType orgType) throws Exception {
        this(ui, orgType, CslRptUtil.isSupport13Period(null), false);
    }

    public ReportQueryPanel(CoreUI ui, OrgType orgType, boolean isOpenFromWeb) throws Exception {
        this(ui, orgType, CslRptUtil.isSupport13Period(null), isOpenFromWeb);
    }

    public ReportQueryPanel(CoreUI ui, OrgType orgType, boolean isSupport13Period, boolean isOpenFromWeb) throws Exception {
        super(ui);
        this.initUsedSpecialPermission();
        this.init(orgType, isSupport13Period, isOpenFromWeb);
    }

    public ReportQueryPanel(CoreUI ui, OrgType orgType, boolean isSupport13Period, boolean usingDiscretePermission, CurrencyCollection initCurrencyCollection, TemplateTypeCollection tempTypeCollection, boolean isOpenFromWeb) throws Exception {
        super(ui);
        this.usingDiscretePermission = usingDiscretePermission;
        this.initCurrencyCollection = initCurrencyCollection;
        this.tempTypeCollection = tempTypeCollection;
        this.init(orgType, isSupport13Period, isOpenFromWeb);
    }

    public void init(OrgType orgType, boolean isSupport13Period, boolean isOpenFromWeb) throws Exception {
        this.isSupport13Period = isSupport13Period;
        this.orgType = orgType;
        this.isOpenFromWeb = isOpenFromWeb;
        this.orgTreeNoderoot.setVirtual(true);
        this.initListener();
        this.collectChangeListener();
        this.initTemplateTypeList();
        this.setFormulaCalcContext();
        this.onLoad();
        this.isLoaded = true;
        this.setTreeViewTitle();
    }

    public ReportQueryPanel(CoreUI ui) throws Exception {
        this(ui, OrgType.Company);
    }

    protected void setFormulaCalcContext() {
    }

    protected AbstractRptWktbContext getWktabContext() {
        try {
            return this.isOpenFromWeb ? WebWktbContextFactory.getInstance().getRptContext(this.orgType) : WktbContextFactory.getInstance().getRptContext(this.orgType);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void collectChangeListener() {
        this.spnyearChgLstn = this.spnyear.getChangeListeners();
        this.spnperiodChgLstn = this.spnperiod.getChangeListeners();
    }

    private void removeSpnYearChgLst() {
        if (this.spnyearChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnyearChgLstn.length; ++i) {
            this.spnyear.removeChangeListener(this.spnyearChgLstn[i]);
        }
    }

    private void removeSpnPeriodChgLst() {
        if (this.spnperiodChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnperiodChgLstn.length; ++i) {
            this.spnperiod.removeChangeListener(this.spnperiodChgLstn[i]);
        }
    }

    private void removeDatePickedLst() {
        this.datepicker.getEditor().setDataChangeListenerFired(false);
    }

    private void addSpnYearChgLst() {
        if (this.spnyearChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnyearChgLstn.length; ++i) {
            this.spnyear.addChangeListener(this.spnyearChgLstn[i]);
        }
    }

    private void addSpnPeriodChgLst() {
        if (this.spnperiodChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnperiodChgLstn.length; ++i) {
            this.spnperiod.addChangeListener(this.spnperiodChgLstn[i]);
        }
    }

    private void addDatePickedLst() {
        this.datepicker.getEditor().setDataChangeListenerFired(true);
    }

    private void setTreeViewTitle() {
        if (!this.isLoaded) {
            return;
        }
        if (this.getSelectedOrgNode().isVirtual()) {
            this.tmplTreeView.setTitle("");
        } else {
            String companyName = ((OrgNodeUserDefineInfo)this.getSelectedOrgNode().getUserObject()).getName();
            this.tmplTreeView.setTitle(companyName);
            this.orgTreeView.setTitle(companyName);
        }
    }

    protected void initTemplateTypeList() {
        this.tempTypeList = new ArrayList();
        this.tempTypeList.add(RptTmpTypeEnum.COMMONREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.GROUPCOMMREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.RPTDYNAMICREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
        this.tempTypeList.add(RptTmpTypeEnum.COMMONPUBLICTEMPLATE);
        this.tempCommTypeList = new ArrayList();
        this.tempCommTypeList.add(RptTmpTypeEnum.COMMONREPORT);
    }

    protected void initUsedSpecialPermission() throws Exception {
        this.usingDiscretePermission = this.isDiscretePermItem("2D527D45");
    }

    protected void initSpecialPermission() throws Exception {
        if (!RptNewUIUtil.isFiOrgType(this.orgType)) {
            return;
        }
        if (this.usingDiscretePermission) {
            String orgPK = this.getSelectedNodeCompanyId();
            if (StringUtils.isEmpty((String)orgPK)) {
                this.permissionContidion = null;
                return;
            }
            this.permissionContidion = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgPK), "rpt_template_view");
            this.permissionContidion = "in (" + this.permissionContidion + ")";
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.tmplTreeView.getTree().setShowPopMenuDefaultItem(true);
        this.tmplTreeView.getTree().addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                event.getMenu().show((Component)event.getSource(), 0, 0);
                return true;
            }
        });
    }

    protected void initListener() {
        this.orgTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    if (e.getNewLeadSelectionPath() == null || (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent() == null || ((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).isVirtual()) {
                        ReportQueryPanel.this.orgTree.setSelectionPath(e.getOldLeadSelectionPath());
                        return;
                    }
                    if (ReportQueryPanel.this.isLoaded) {
                        ReportQueryPanel.this.initSelfUI();
                    }
                    ReportQueryPanel.this.refreshTmplTree(true);
                    ReportQueryPanel.this.setTreeViewTitle();
                }
                catch (Exception e1) {
                    ReportQueryPanel.this.handleException(e1);
                }
            }
        });
        this.orgTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !ReportQueryPanel.this.getSelectedOrgNode().isVirtual()) {
                    ReportQueryPanel.this.tabTree.setSelectedIndex(1);
                }
            }
        });
        this.tmplTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                KDTreeNode node = (KDTreeNode)event.getPath().getLastPathComponent();
                ReportQueryPanel.this.tmplTree.setSelectionPath(event.getPath());
                if (node.getUserObject() == ReportTypeEnum.GROUPDISPENSETEMPLATE || ReportQueryPanel.this.getSelectedTmplTreeNode().getUserObject() instanceof TemplateTypeInfo) {
                    try {
                        ReportQueryPanel.this.loadGroupTmpl(node, ReportQueryPanel.this.combinePathKey(event.getPath()), ReportQueryPanel.this.isRemovedChildren(node));
                    }
                    catch (Exception e) {
                        ReportQueryPanel.this.handleException(e);
                    }
                } else if (node.getUserObject() instanceof UserDefineTemplateTypeNode) {
                    try {
                        ReportQueryPanel.this.loadSelfTmpl(node, ReportQueryPanel.this.combinePathKey(event.getPath()), ReportQueryPanel.this.isRemovedChildren(node));
                    }
                    catch (Exception e) {
                        ReportQueryPanel.this.handleException(e);
                    }
                }
                if (node.isLeaf()) {
                    node.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                }
            }
        });
        this.tmplTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (ReportQueryPanel.this.getSelectedTmplTreeNode().getUserObject() instanceof TmplNodeUserDefineInfo) {
                        ReportQueryPanel.this.openReport();
                    } else {
                        if (!ReportQueryPanel.this.getSelectedTmplTreeNode().isLeaf()) {
                            return;
                        }
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"16_ReportQueryPanel"));
                        SysUtil.abort();
                    }
                }
            }
        });
        this.cmbPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ReportQueryPanel.this.isLoaded) {
                    ReportQueryPanel.this.updateYearAndPeriod();
                    try {
                        ReportQueryPanel.this.refreshTmplTree(false);
                    }
                    catch (Exception e1) {
                        ReportQueryPanel.this.handleException(e1);
                    }
                }
            }
        });
        this.datepicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ReportQueryPanel.this.updateYearAndPeriod();
                ReportQueryPanel.this.loadReport2AllTmplNode();
            }
        });
        this.spnyear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ReportQueryPanel.this.isLoaded) {
                    return;
                }
                ReportQueryPanel.this.removeSpnPeriodChgLst();
                ReportQueryPanel.this.removeDatePickedLst();
                ReportQueryPanel.this.initSpnPeriod();
                ReportQueryPanel.this.initDatePick();
                ReportQueryPanel.this.addSpnPeriodChgLst();
                ReportQueryPanel.this.addDatePickedLst();
                ReportQueryPanel.this.loadReport2AllTmplNode();
            }
        });
        this.spnperiod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ReportQueryPanel.this.isLoaded) {
                    return;
                }
                ReportQueryPanel.this.initDatePick();
                ReportQueryPanel.this.addDatePickedLst();
                ReportQueryPanel.this.loadReport2AllTmplNode();
            }
        });
        this.cmbcurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportQueryPanel.this.loadReport2AllTmplNode();
            }
        });
    }

    private boolean isRemovedChildren(KDTreeNode node) {
        boolean isRemovedChildren = ((KDTreeNode)node.getFirstChild()).getUserObject() instanceof NotKnowNode;
        return isRemovedChildren;
    }

    private String combinePathKey(TreePath path) {
        StringBuffer key = new StringBuffer();
        if (path != null) {
            this.selectedPathObject = this.getSelectedTmplTreeNode().getUserObjectPath();
            for (int i = 0; i < this.selectedPathObject.length; ++i) {
                if (this.selectedPathObject[i] instanceof ReportTypeEnum) {
                    key.append(this.wrappedKey(((ReportTypeEnum)this.selectedPathObject[i]).getAlias()));
                    continue;
                }
                if (this.selectedPathObject[i] instanceof TemplateTypeInfo) {
                    key.append(this.wrappedKey(((TemplateTypeInfo)this.selectedPathObject[i]).getName()));
                    continue;
                }
                if (this.selectedPathObject[i] instanceof UserDefineTemplateTypeNode) {
                    key.append(this.wrappedKey(((UserDefineTemplateTypeNode)this.selectedPathObject[i])._nodeName));
                    continue;
                }
                key.append("notKnown");
            }
        }
        return key.toString();
    }

    private String wrappedKey(String key) {
        return "[" + key + "]";
    }

    protected void onLoad() throws Exception {
        this.tmplTreeModel = (DefaultTreeModel)this.tmplTree.getModel();
        try {
            this.initSelfUI();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initOrgTree();
        this.tabTree.setSelectedIndex(1);
        this.orgTree.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }

    private void initSpinnerVal() {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        int[] yearperiod = this.getYearAndPeriod();
        if (yearperiod != null) {
            this.spnyear.setValue((Object)yearperiod[0]);
            this.spnperiod.setValue((Object)yearperiod[1]);
            this.setSpinnerMinMaxVal(yearperiod);
        }
    }

    private void initDatePick() {
        int period = this.spnperiod.getIntegerVlaue();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.getSelectedPeriodType())) {
            period = period >= 13 ? 12 : period;
        }
        this.datepicker.setValue((Object)RPTDateUtil.getPeriodLastDate((int)this.spnyear.getIntegerVlaue(), (int)period, (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())));
    }

    private void initSpnPeriod() {
        int year = this.spnyear.getIntegerVlaue();
        this.setSpinnerMinMaxVal(new int[]{year, this.spnperiod.getIntegerVlaue()});
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        if (initValue < minimum || initValue > maximum) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"46_RptReportProcessNewUI"));
            SysUtil.abort();
        }
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private int getMaxPeriod(Integer year) {
        int lenght = this.yearMap.get(year).size();
        int maxPeriod = this.yearMap.get(year).get(lenght - 1);
        return maxPeriod < 13 && this.isSupport13Period ? 13 : maxPeriod;
    }

    protected void initSelfUI() throws Exception {
        if (this.isLoaded) {
            this.preYearAndPeriod[0] = this.spnyear.getIntegerVlaue();
            this.preYearAndPeriod[1] = this.spnperiod.getIntegerVlaue();
        }
        if (!this.isLoaded) {
            this.initOnlyOne();
        }
        CurrencyInfo currCurrency = null;
        currCurrency = this.isLoaded ? RptNewUIUtil.getCompanyBasicCurrency(this.orgType, this.getSelectedNodeCompanyId()) : this.getWktabContext().getQueryCurrencyInfo();
        this.selectedCurrency(currCurrency);
        if (this.isLoaded) {
            this.periodCollection = this.iInitDataFacada.getFiscal((IObjectPK)new ObjectUuidPK(RptNewUIUtil.getDelegateCompany(this.orgType, this.getSelectedNodeCompanyId()).getId()));
        } else {
            CompanyOrgUnitInfo delegateCompany = RptNewUIUtil.getDelegateCompany(this.orgType, this.getWktabContext().getOrgUnitInfo().getId().toString());
            if (!MockLoadRptProcessUIThread.isMocked && delegateCompany == null) {
                delegateCompany = RptNewUIUtil.getDelegateCompany(OrgType.ProfitCenter, this.getWktabContext().getOrgUnitInfo().getId().toString());
            }
            this.periodCollection = this.iInitDataFacada.getFiscal((IObjectPK)new ObjectUuidPK(delegateCompany.getId()));
        }
        if (this.periodCollection != null && this.periodCollection.size() > 0) {
            for (int i = 0; i < this.periodCollection.size(); ++i) {
                Integer year = this.periodCollection.get(i).getPeriodYear();
                Integer period = this.periodCollection.get(i).getPeriodNumber();
                List<Integer> periodVec = this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        }
        int[] yearPeriod = this.getCurrentPeriod();
        if (this.yearMap.size() > 0) {
            this.spnyear.setValue((Object)yearPeriod[0]);
            this.spnperiod.setValue((Object)yearPeriod[1]);
            this.datepicker.setValue((Object)RPTDateUtil.getPeriodLastDate((int)yearPeriod[0], (int)yearPeriod[1], (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())));
        }
        this.setComponentVisable();
        this.setSpinnerMinMaxVal(yearPeriod);
        if (this.isOpenFromWeb) {
            this.cmbPeriodType.setEnabled(false);
        }
    }

    private void initOnlyOne() throws BOSException {
        this.cmbPeriodType.removeAllItems();
        this.cmbPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        RptPeriodTypeEnum defaultPeriodType = this.getRptPeriodTypeFromContext() == null ? RptPeriodTypeEnum.MONTHLY : this.getRptPeriodTypeFromContext();
        this.cmbPeriodType.setSelectedItem((Object)defaultPeriodType);
        if (this.iInitDataFacada == null) {
            this.iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
        }
        if (this.initCurrencyCollection == null || this.initCurrencyCollection.isEmpty()) {
            this.initCurrencyCollection = this.iInitDataFacada.getCurrencyNoGLC();
        }
        this.cmbcurrency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)this.initCurrencyCollection));
    }

    private void selectedCurrency(CurrencyInfo currCurrency) {
        if (currCurrency != null) {
            String currencyID = currCurrency.getId().toString();
            int size = this.initCurrencyCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!this.initCurrencyCollection.get(i).getId().toString().equals(currencyID)) continue;
                this.setSelectCurrency(this.initCurrencyCollection.get(i));
                break;
            }
        }
    }

    private int[] getCurrentPeriod() throws EASBizException, BOSException {
        int[] yearperiod;
        if (!this.isLoaded && (yearperiod = this.getYearPeriodFromContext()) != null) {
            return yearperiod;
        }
        boolean isTrue = this.preYearAndPeriod == null ? false : this.preYearAndPeriod[0] > 0 && this.preYearAndPeriod[1] > 0;
        return isTrue ? this.preYearAndPeriod : RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()));
    }

    private int[] getYearPeriodFromContext() {
        try {
            int year = this.getWktabContext().getQueryYear();
            int period = this.getWktabContext().getQueryPeriod();
            if (year <= 0 || period <= 0) {
                return null;
            }
            return new int[]{year, period};
        }
        catch (Exception e) {
            return null;
        }
    }

    private RptPeriodTypeEnum getRptPeriodTypeFromContext() {
        try {
            return this.getWktabContext().getQueryPeriodType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setComponentVisable() {
        RptPeriodTypeEnum periodType = this.getSelectedPeriodType();
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType) || RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.kDLabelContainer2.setVisible(true);
            this.kDLabelContainer3.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
            this.kDLabelContainer5.setVisible(false);
        } else {
            this.kDLabelContainer2.setVisible(false);
            this.kDLabelContainer3.setVisible(true);
            this.kDLabelContainer4.setVisible(true);
            this.kDLabelContainer5.setVisible(true);
        }
    }

    private void setSpinnerMinMaxVal(int[] yearperiod) {
        RptPeriodTypeEnum periodType = this.getSelectedPeriodType();
        Integer[] years = this.getYearScope();
        yearperiod[0] = yearperiod[0] > years[1] ? years[1] : yearperiod[0];
        this.spnyear.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[0], years[0], years[1], 1));
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, this.getMaxPeriod(yearperiod[0]), 1));
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 4, 1));
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 2, 1));
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 1, 1));
        } else if (RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 53, 1));
        } else if (RptPeriodTypeEnum.DAILY.equals((Object)periodType)) {
            this.spnperiod.setModel((SpinnerModel)this.getSpinnerNumberModel(yearperiod[1], 1, 366, 1));
        }
    }

    private Integer[] getYearScope() {
        Object[] array = this.yearMap.keySet().toArray();
        if (array == null || array.length == 0) {
            return new Integer[]{0, 0};
        }
        Arrays.sort(array);
        return new Integer[]{(Integer)array[0], (Integer)array[array.length - 1]};
    }

    private RptPeriodTypeEnum getSelectedPeriodType() {
        return (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
    }

    private void setSelectCurrency(CurrencyInfo currency) {
        if (currency != null && currency.getNumber() != null) {
            int itemCount = this.cmbcurrency.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object item = this.cmbcurrency.getItemAt(i);
                if (item == null || !(item instanceof CurrencyInfo) || ((CurrencyInfo)item).getNumber() == null || !((CurrencyInfo)item).getNumber().equals(currency.getNumber())) continue;
                this.cmbcurrency.setSelectedIndex(i);
                break;
            }
        }
    }

    private void refreshTmplTree(boolean forceClear) throws BOSException, Exception {
        if (forceClear) {
            if (this.isOpenFromWeb) {
                this.cache.setCache(this.getWktabContext().getTmplNodes(this.getSelectedNodeCompanyId()));
            } else {
                this.cache.clearCache();
            }
        }
        KDTreeNode selectedNode = (KDTreeNode)this.orgTree.getLastSelectedPathComponent();
        this.tmplTreeNodeRoot.removeAllChildren();
        this.tmplTreeModel.reload();
        if (selectedNode == null || selectedNode.isVirtual()) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tmplTree.getModel();
        model.setRoot((TreeNode)this.tmplTreeNodeRoot);
        if (this.isOpenFromWeb) {
            KDTreeNode currencyLeafNode = new KDTreeNode((Object)ReportTypeEnum.GROUPDISPENSETEMPLATE);
            this.tmplTreeNodeRoot.add((MutableTreeNode)currencyLeafNode);
        } else {
            if (this.tempTypeList == null || this.tempTypeList.contains(RptTmpTypeEnum.GROUPCOMMREPORT)) {
                this.addGroupDispenseTemplate();
            }
            this.addSelfMadeNode();
        }
        this.addVirtual4TemplateTypeNode();
        if (this.isOpenFromWeb) {
            this.tmplTree.expandRow(0);
            this.tmplTree.expandRow(1);
        } else {
            this.tmplTree.expandRow(0);
        }
    }

    protected void addSelfMadeNode() {
        KDTreeNode selfnode = new KDTreeNode((Object)new UserDefineTemplateTypeNode(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"17_ReportQueryPanel"), 1));
        selfnode.setAllowsChildren(true);
        this.tmplTreeNodeRoot.add((MutableTreeNode)selfnode);
    }

    private void loadSelfTmpl(KDTreeNode node, String cacheKey, boolean isRemovedChildren) throws BOSException, Exception {
        if (this.cache.hasCache(cacheKey)) {
            if (!this.isSameTmplPeriodType(node)) {
                this.loadCacheData2TemplNode(node, cacheKey, isRemovedChildren);
            }
            return;
        }
        this.initSpecialPermission();
        IRowSet rowSet = this.getCommonTmplData(null);
        this.cacheQueryData(cacheKey, rowSet);
        rowSet = this.getpublicTmplData();
        this.cacheQueryData(cacheKey, rowSet);
        this.loadCacheData2TemplNode(node, cacheKey, isRemovedChildren);
        this.cache.loadReport2TmplNode(cacheKey, this.getReportCondition());
    }

    private IRowSet getCommonTmplData(ArrayList<String> reportTypeIDs) throws BOSException, Exception {
        ArrayList<RptTmpTypeEnum> tempTypeLst = new ArrayList<RptTmpTypeEnum>(this.tempCommTypeList);
        tempTypeLst.add((RptTmpTypeEnum)this.orgType);
        return this.getTemplateBizInterface().getTreeData(reportTypeIDs, false, true, tempTypeLst, this.getSelectedNodeCompanyId(), true, null, this.permissionContidion, null);
    }

    private void loadGroupTmpl(KDTreeNode node, String cacheKey, boolean isRemovedChildren) throws BOSException, Exception {
        if (this.cache.hasCache(cacheKey)) {
            if (!this.isSameTmplPeriodType(node)) {
                this.loadCacheData2TemplNode(node, cacheKey, isRemovedChildren);
            }
            this.loadReport2AllTmplNode();
            if (this.isOpenFromWeb) {
                this.cache.loadReport2TmplNode(cacheKey, this.getReportCondition());
            }
            return;
        }
        IRowSet rowset = null;
        String displayTemplateid = node.getUserObject() instanceof TemplateTypeInfo ? ((TemplateTypeInfo)node.getUserObject()).getId().toString() : null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)displayTemplateid)) {
            HashSet<String> dispIDs = new HashSet<String>(1);
            dispIDs.add(displayTemplateid);
            filter.getFilterItems().add(new FilterItemInfo("displayTemplateType.id", dispIDs, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFromNewRptUI", (Object)new Boolean(true)));
        view.setFilter(filter);
        ArrayList<OrgType> lst = new ArrayList<OrgType>(1);
        lst.add(this.orgType);
        if (this instanceof ReportQueryPanelForSingleExtract) {
            ReportCollection reportColl = this.getSingExtractData();
            this.cacheQueryData(cacheKey, reportColl);
            this.loadCacheData2TemplNode(node, cacheKey, isRemovedChildren);
            this.cache.loadReport2TmplNode(cacheKey, reportColl);
        } else {
            rowset = this.getTemplateBizInterface().getTreeDispenseData(this.getSelectedNodeCompanyId(), true, false, false, lst, view);
            this.cacheQueryData(cacheKey, rowset);
            this.loadCacheData2TemplNode(node, cacheKey, isRemovedChildren);
            this.cache.loadReport2TmplNode(cacheKey, this.getReportCondition());
        }
    }

    protected ReportCollection getSingExtractData() throws SQLException, BOSException {
        return null;
    }

    private IRowSet getpublicTmplData() throws EASBizException, BOSException {
        PublicTemplateManager specialTemplate = new PublicTemplateManager(null);
        String currenctCompanyid = this.getSelectedNodeCompanyId();
        boolean isShowUnPublished = true;
        boolean isShowUnaudit = false;
        ArrayList<Object> versionType = new ArrayList<Object>(this.versionTypeList);
        versionType.add(this.orgType);
        return specialTemplate.getTemplateDataRowSet(currenctCompanyid, versionType, isShowUnPublished, isShowUnaudit, null);
    }

    private boolean isSameTmplPeriodType(KDTreeNode parent) {
        KDTreeNode firstChild = (KDTreeNode)parent.getFirstChild();
        if (firstChild != null && firstChild.getUserObject() instanceof TmplNodeUserDefineInfo) {
            TmplNodeUserDefineInfo userNode = (TmplNodeUserDefineInfo)firstChild.getUserObject();
            if (((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()).equals((Object)userNode.getPeriodType())) {
                return true;
            }
        }
        return false;
    }

    private void cacheQueryData(String cacheKey, IRowSet rowSet) throws SQLException {
        this.cache.cacheQueryData(cacheKey, rowSet);
    }

    private void cacheQueryData(String cacheKey, ReportCollection rowSet) throws SQLException {
        this.cache.cacheQueryData(cacheKey, rowSet);
    }

    private void loadCacheData2TemplNode(KDTreeNode node, String cacheKey, boolean isRemovedChildren) {
        List<TmplNodeUserDefineInfo> lst = this.cache.getDataFromCache(cacheKey, (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        this.appenedLst2Node(node, lst, isRemovedChildren);
    }

    private void loadReport2AllTmplNode() {
        if (this.isLoaded && !((KDTreeNode)this.orgTree.getLastSelectedPathComponent()).isVirtual()) {
            try {
                if (!this.isSameCondition()) {
                    this.cache.loadReport2AllTmplNode(this.getReportCondition());
                    this.LastRptCondition = this.getReportCondition();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.tmplTree.repaint();
        }
    }

    protected void getTmplTreeExpansionNode(Set<KDTreeNode> nodeSet, KDTreeNode node) {
        Enumeration children = node.children();
        while (children != null && children.hasMoreElements()) {
            KDTreeNode tmp = (KDTreeNode)children.nextElement();
            if (this.tmplTree.isExpanded(new TreePath(tmp.getPath())) && this.tmplTreeNodeRoot != node) {
                nodeSet.add(tmp);
            }
            this.getTmplTreeExpansionNode(nodeSet, tmp);
        }
    }

    private void appenedLst2Node(KDTreeNode parent, List<TmplNodeUserDefineInfo> lst, boolean isRemovedChildren) {
        if (isRemovedChildren) {
            parent.removeAllChildren();
        }
        if (lst != null && lst.size() > 0) {
            for (int i = lst.size() - 1; i >= 0; --i) {
                TmplNodeUserDefineInfo info = lst.get(i);
                KDTreeNode newChild = new KDTreeNode((Object)info);
                info.setNode(newChild);
                this.tmplTreeModel.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)parent, 0);
            }
        }
        this.tmplTreeModel.reload((TreeNode)parent);
    }

    private void openReport() {
        this.getRptReportProcessUI().openReport();
    }

    private RptReportProcessNewUI getRptReportProcessUI() {
        return (RptReportProcessNewUI)this.rptEditUI;
    }

    public TmplNodeUserDefineInfo getSelectedTmplNodeInfo() {
        Object userObj = this.getSelectedTmplTreeNode().getUserObject();
        return userObj instanceof TmplNodeUserDefineInfo ? (TmplNodeUserDefineInfo)this.getSelectedTmplTreeNode().getUserObject() : null;
    }

    public KDTreeNode getSelectedTmplTreeNode() {
        KDTreeNode selectedTreeNode = (KDTreeNode)this.tmplTree.getLastSelectedPathComponent();
        if (selectedTreeNode == null) {
            selectedTreeNode = new KDTreeNode((Object)new Integer(1));
        }
        return selectedTreeNode;
    }

    private void addVirtual4TemplateTypeNode() {
        KDTreeNode[] leafNodeArray = this.getIsLeafOfTree();
        if (leafNodeArray == null) {
            return;
        }
        NotKnowNode notKnowNode = NotKnowNode.newOne();
        for (int k = 0; k < leafNodeArray.length; ++k) {
            leafNodeArray[k].add((MutableTreeNode)new KDTreeNode((Object)notKnowNode));
        }
    }

    private void initOrgTree() throws Exception {
        OrgTreeBuilder builder = new OrgTreeBuilder(this.orgTree, this.orgTreeNoderoot, this.getOrgData());
        builder.initOrgTree();
        builder.buildOrgTree();
        builder.selectedOrgNodeByGivenCompany(this.getWktabContext().getOrgUnitInfo());
        this.orgTreeNoderoot.setTextColor(new Color(77, 77, 77));
        this.orgTreeNoderoot.setCheckBoxEnabled(false);
        this.orgTreeNoderoot.setCheckBoxVisible(false);
    }

    protected Map<String, OrgNodeUserDefineInfo> getOrgData() throws Exception {
        return this.getWktabContext().getMapOfOrgTreeBuilder(false);
    }

    private void updateYearAndPeriod() {
        this.removeSpnYearChgLst();
        this.removeSpnPeriodChgLst();
        this.removeDatePickedLst();
        this.setComponentVisable();
        this.initSpinnerVal();
        this.initDatePick();
        this.addSpnPeriodChgLst();
        this.addSpnYearChgLst();
        this.addDatePickedLst();
    }

    private int[] getYearAndPeriod() {
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeE != null) {
            Date date = (Date)this.datepicker.getValue();
            if (date != null) {
                return RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeE);
            }
            return null;
        }
        return null;
    }

    protected void handleException(Exception e) {
        this.rptEditUI.handUIException((Throwable)e);
        SysUtil.abort();
    }

    private boolean isDiscretePermItem(String bostype) {
        try {
            return InitDataFacadaFactory.getRemoteInstance().isDiscretePermItem(bostype);
        }
        catch (BOSException e) {
            return false;
        }
    }

    private KDTreeNode[] getIsLeafOfTree() {
        KDTreeNode leafNode;
        int leafNodeCount = this.tmplTreeNodeRoot.getLeafCount();
        int leafNodeChild = this.tmplTreeNodeRoot.getChildCount();
        if (leafNodeCount == 1 && leafNodeChild == 0) {
            return null;
        }
        KDTreeNode[] leafNodeArray = new KDTreeNode[leafNodeCount];
        leafNodeArray[0] = leafNode = (KDTreeNode)this.tmplTreeNodeRoot.getFirstLeaf();
        for (int i = 1; i < leafNodeCount; ++i) {
            leafNodeArray[i] = leafNode = (KDTreeNode)leafNode.getNextLeaf();
        }
        return leafNodeArray;
    }

    public void addGroupDispenseTemplate() throws Exception {
        KDTreeNode currencyLeafNode = new KDTreeNode((Object)ReportTypeEnum.GROUPDISPENSETEMPLATE);
        this.tmplTreeNodeRoot.add((MutableTreeNode)currencyLeafNode);
        this.addGroupSubTempClass(currencyLeafNode);
    }

    protected void addGroupSubTempClass(KDTreeNode currencyLeafNode) throws Exception, BOSException {
        if (this.tempTypeCollection == null) {
            this.groupTreeComponent = new GroupTreecomponent(null, this.groupTempType);
            this.tempTypeCollection = this.groupTreeComponent.getTemplateTypeCollection();
            this.groupTreeComponent.setTemplateTypes(this.tempTypeCollection);
        }
        if (this.groupTreeComponent == null) {
            this.groupTreeComponent = new GroupTreecomponent(null, this.groupTempType);
            this.groupTreeComponent.setTemplateTypes(this.tempTypeCollection);
        }
        if (this.tempTypeCollection != null && this.tempTypeCollection.size() > 0) {
            Map map = this.groupTreeComponent.indexByParent(this.tempTypeCollection, currencyLeafNode.toString());
            for (int j = 0; j < this.tempTypeCollection.size(); ++j) {
                TemplateTypeInfo type = this.tempTypeCollection.get(j);
                if (type.getParent() != null) continue;
                currencyLeafNode.add((MutableTreeNode)this.groupTreeComponent.addNode(type, map));
            }
        }
    }

    protected String getSelectedNodeCompanyId() {
        KDTreeNode orgnode = this.getSelectedOrgNode();
        if (orgnode == null) {
            return "";
        }
        if (orgnode.getUserObject() instanceof OrgNodeUserDefineInfo) {
            OrgNodeUserDefineInfo orgnodeUserDefineInfo = (OrgNodeUserDefineInfo)orgnode.getUserObject();
            return orgnodeUserDefineInfo.getOrgPK();
        }
        return "";
    }

    private KDTreeNode getSelectedOrgNode() {
        return (KDTreeNode)this.orgTree.getLastSelectedPathComponent();
    }

    public boolean isTemplateNode() {
        return this.getSelectedTmplTreeNode().getUserObject() instanceof TmplNodeUserDefineInfo;
    }

    public ReportCondition getReportCondition() throws Exception {
        ReportCondition condition = new ReportCondition();
        OrgNodeUserDefineInfo userdefine = (OrgNodeUserDefineInfo)this.getSelectedOrgNode().getUserObject();
        condition.setPeriodType((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        condition.setYear(this.spnyear.getIntegerVlaue());
        condition.setPeriod(this.spnperiod.getIntegerVlaue());
        condition.setCurrency((CurrencyInfo)this.cmbcurrency.getSelectedItem());
        condition.setOrgNodeInfo(userdefine);
        condition.setTmplNodeInfo(this.getSelectedTmplNodeInfo());
        return condition;
    }

    private boolean isSameCondition() throws Exception {
        if (this.LastRptCondition == null) {
            return false;
        }
        ReportCondition currRptCondition = this.getReportCondition();
        boolean result = currRptCondition.getOrgNodeInfo().getOrgPK().equals(this.LastRptCondition.getOrgNodeInfo().getOrgPK());
        result = result && currRptCondition.getYear() == this.LastRptCondition.getYear();
        result = result && currRptCondition.getPeriod() == this.LastRptCondition.getPeriod();
        result = result && currRptCondition.getPeriodType().equals((Object)this.LastRptCondition.getPeriodType());
        result = result && currRptCondition.getCurrency().getId().toString().equals(this.LastRptCondition.getCurrency().getId().toString());
        return result;
    }

    public OrgNodeUserDefineInfo findOrgNodeInfo(String orgPK) {
        KDTreeNode orgNode = this.findOrgNode(orgPK);
        if (orgNode != null) {
            return (OrgNodeUserDefineInfo)orgNode.getUserObject();
        }
        return null;
    }

    private KDTreeNode findOrgNode(String orgPK) {
        if (orgPK == null) {
            return null;
        }
        Enumeration enumt = this.orgTreeNoderoot.children();
        KDTreeNode childrenNode = null;
        boolean isFound = false;
        while (enumt.hasMoreElements()) {
            childrenNode = (KDTreeNode)enumt.nextElement();
            OrgNodeUserDefineInfo defineInfo = (OrgNodeUserDefineInfo)childrenNode.getUserObject();
            if (!orgPK.equals(defineInfo.getOrgPK())) continue;
            isFound = true;
            break;
        }
        return isFound ? childrenNode : null;
    }

    public void changeTmplNodeColor(ReportInfo reportinfo) throws Exception {
        Object tmplNodeObj = this.getSelectedTmplTreeNode().getUserObject();
        String reportKey = RptNewUIUtil.combineReportKey(reportinfo);
        if (tmplNodeObj instanceof TmplNodeUserDefineInfo && reportKey.equals(RptNewUIUtil.combineRptCondtionKey(this.getReportCondition()))) {
            ((TmplNodeUserDefineInfo)tmplNodeObj).setReportID(reportinfo.getId().toString());
            return;
        }
        this.findAndFillTmplNodeColor(reportinfo);
    }

    private void findAndFillTmplNodeColor(ReportInfo reportinfo) throws Exception {
        KDTreeNode[] nodes = this.getIsLeafOfTree();
        ReportCondition condition = this.getReportCondition();
        String reportKey = RptNewUIUtil.combineReportKey(reportinfo);
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i].getUserObject() instanceof TmplNodeUserDefineInfo)) continue;
            TmplNodeUserDefineInfo userDefineInfo = (TmplNodeUserDefineInfo)nodes[i].getUserObject();
            condition.setTmplNodeInfo(userDefineInfo);
            if (!reportKey.equals(RptNewUIUtil.combineRptCondtionKey(condition))) continue;
            userDefineInfo.setReportID(reportinfo.getId().toString());
        }
    }

    protected IReportType getTypeBizInterface() throws Exception {
        if (this.iReportType == null) {
            this.iReportType = ReportTypeFactory.getRemoteInstance();
        }
        return this.iReportType;
    }

    protected IRptTypeStd getTypeStdBizeInterface() throws Exception {
        if (this.iRptTypeStd == null) {
            this.iRptTypeStd = RptTypeStdFactory.getRemoteInstance();
        }
        return this.iRptTypeStd;
    }

    protected IRptTypeRela getRptTypeRelaBizeInterface() throws Exception {
        if (this.iRptTypeRela == null) {
            this.iRptTypeRela = RptTypeRelaFactory.getRemoteInstance();
        }
        return this.iRptTypeRela;
    }

    protected ITemplate getTemplateBizInterface() throws Exception {
        if (this.iTemplate == null) {
            this.iTemplate = TemplateFactory.getRemoteInstance();
        }
        return this.iTemplate;
    }

    static class UserDefineTemplateTypeNode {
        public static final int TYPE_SELF = 1;
        String _nodeName;
        int _type;

        UserDefineTemplateTypeNode(String nodeName, int type) {
            this._nodeName = nodeName;
            this._type = type;
        }

        public String toString() {
            return this._nodeName;
        }
    }
}

