/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.CheckMessageInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;

public class ShowEditorPanelExtUI
extends ShowEditorPanelUI {
    private static final long serialVersionUID = 1L;
    private Map<String, CheckMessageInfo> msgMap;

    public void onLoad() throws Exception {
        super.onLoad();
        this.msgMap = (Map)this.getUIContext().get("msgMap");
        new Thread(new Runnable(){

            @Override
            public void run() {
                ShowEditorPanelExtUI.this.handleCheckMsg();
            }
        }).start();
    }

    protected void handleHyperlinkUpdate(boolean isCslId, boolean isReportSystem, HyperlinkEvent e, String id, Object processUI, Book curBook) {
        block7: {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String reportid = e.getDescription();
                if (reportid != null && this.msgMap != null && this.msgMap.containsKey(reportid)) {
                    CheckMessageInfo msgInfo = this.msgMap.get(reportid);
                    JEditorPane editor = (JEditorPane)e.getSource();
                    HTMLDocument doc = (HTMLDocument)editor.getDocument();
                    try {
                        if (msgInfo.isExtend()) {
                            doc.remove(e.getSourceElement().getEndOffset(), msgInfo.getLen());
                            msgInfo.setExtend(false);
                            break block7;
                        }
                        doc.insertAfterEnd(e.getSourceElement(), "<br>" + msgInfo.getChckMsg());
                        msgInfo.setExtend(true);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                } else {
                    super.handleHyperlinkUpdate(isCslId, isReportSystem, e, id, processUI, curBook);
                }
            }
        }
    }

    private void handleCheckMsg() {
        if (this.msgMap == null || this.msgMap.size() <= 0) {
            return;
        }
        JEditorPane robotEditor = new JEditorPane();
        robotEditor.setContentType("text/html");
        robotEditor.setEditable(false);
        for (CheckMessageInfo msgInfo : this.msgMap.values()) {
            if (StringUtils.isEmpty((String)msgInfo.getChckMsg())) continue;
            robotEditor.setText(msgInfo.getChckMsg());
            msgInfo.setLen(robotEditor.getDocument().getLength());
        }
        robotEditor = null;
    }
}

